

;*************************************************************
;*							     *
;*     INTEST - (C) 1982 MORROW DESIGNS			     *
;*              MORROW INTERRUPT TEST FOR 8259 ON MULT I/O   *
;*              AND WUNDERBUS I/O.  PRINTS A "." EVERTIME    *
;*              CLOCK GENERATES AN INTERRUPT (2048 PER SEC.) *
;*              AND TERMINATES WHEN ANY CHARACTER IS ON      *
;*              THE CONSOLE IS PRESSED. THESE RELY ON THE    *
;*              CP/M BDOS CALLS THROUGH LOCATION 5.          *
;*                                                           *
;*              WB I/O MUST HAVE SWITCH 7C:  1,2,4,5 - ON    *
;*                                           3,6,7,8 - OFF   *
;*                                                           *          
;*                               SWITCH 10A  1,3     - ON    *
;*                                           OTHERS  - OFF   *
;*                                                           *
;*                               JUMPER J2   A - B           *
;*                                                           *
;*                               JUMPER J3   INSTALLED       *    
;*							     *
;*               MULT I/O MUST HAVE:                         *
;*                               SWITCH 2D:  1        - OFF  *
;*                                           2-8      - ON   *
;*                                                           *
;*                               SWITCH 7B: 1,2,4,5   - ON   *
;*                                          3,6,7,8   - OFF  *
;*                                                           *
;*                               SWITCH 10B: 5,6      - ON   *
;*                                           OTHERS   - OFF  *     
;*                                                           *
;*                               JUMPER J4 - INSTALLED       *
;*                                                           *
;*                               JUMPER J5 - B TO PINT       *
;*                                                           *
;*                               JUMPER J6 - NOT INSTALLED   *
;*                                                           *
;*                 MEMORY MUST BE SET FOR EXTENDED ADDRESS!  *
;*							     *
;* MULT I/O NOTES:					     *
;*                 THE MULT I/O BOARD SHOULD HAVE EITHER A   *
;*                 MULTX-B OR MULTX-C FPLA AT LOCATION 9A.   *
;*                 IT SHOULD ALSO HAVE A JUMPER WIRE BETWEEN *
;* 		   PIN 2 OF IC AT LOCATION 13B AND PIN 4 OF  *
;*                 IC AT LOCATION 14C.  IN ADDITION 14C PIN  *
;*                 4 MUST BE REMOVED FROM THE SOCKET.        *
;*							     *
;*  WB I/O NOTES:  THE WB I/O BOARD SHOULD BE AT REVISION 2. *
;*                       (ECN # 4  6/3/1982)		     *
;*                                                           *
;*  BJG - 821115                                             *               
;*************************************************************

	ORG     0100H
	
BASE	EQU	048H

SELECT	EQU 	BASE + 7
CLOCK   EQU 	BASE + 2
ICW1	EQU	BASE + 4
ICW2    EQU     BASE + 5
ICW4    EQU     BASE + 5
OCW1    EQU     BASE + 5
OCW2    EQU     BASE + 4
BDOS    EQU	0005H
WARM    EQU     0000H
GROUP1  EQU	0009H		;WITH INTERRUPT ENABLE FOR MULTIO
GROUP0	EQU	0008H		;WITH INTERRUPT ENABLE FOR MULTIO


INIT:	LXI SP,200H
	DI
	MVI A,1			;GROUP 1 WITH INTERRUPTS OFF
	OUT SELECT		;SELECT GROUP 1
        MVI A,02H
	OUT BASE + 1		;TURN ON TRANSMITTER EMPTY INTERRUPT
	MVI A,38H
	OUT 0
	MVI A,0
	OUT SELECT			;SELECT GROUP 0

;*******************************************************************
;*			   					   *
;* INITIALIZE THE PIC FOR SINGLE PIC, 4 BYTE INCREMENT CALLS,      *
;* LEVEL TRIGGER MODE, BUFFERED MODE, MASTER, NO AEOI, 8080 MODE.  *
;* CALLS BEGIN AT 140H FOR IR0 AND END AT 15CH FOR IR7 (CLOCK TP). *
;*                                                                 *
;*******************************************************************

	MVI A,05FH		;LOW CALL ADDRESS / MODE FOR PIC
	OUT ICW1
	MVI A,01		;HIGH BYTE OF CALL ADDRESS (0120H)
        OUT ICW2
	MVI A,0CH		;8080 MODE, MASTER
	OUT ICW4
	MVI A,0f7H
	OUT OCW1		;MASK ALL BUT UART A  INTERRUPTS
	MVI A,GROUP0			
	OUT SELECT		;MULT I/O ENABLE INTERRUPT BIT
	MVI C,020H		;FIRST CHARACTER
	EI

LOOP:   JMP LOOP

STORE:  DW 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 
		

SERVE:  CALL OUTPUT		;CLEAR CLOCK INTERRUPT
	MVI A,GROUP0
	OUT SELECT
	MVI A,20H
	OUT OCW2		;SEND THE PIC AN EOI
	EI
	RET

OUTPUT: MVI A,GROUP1
	OUT SELECT		;SELECT UART 1

	MOV A,C			;GET CHAR
	OUT BASE		;TRANSMIT TO TERMINAL
	INR A
	CPI 07Fh		;LAST ASCII CHAR?
	CZ  SETC
	MOV C,A			;SAVE CHAR
	RET

SETC:	MVI A,020H		;INITIALIZE TO A "SPACE"
	RET

	END

