; LAST UPDATED ON:	11 JUN 83
; REASON FOR UPDATE:	Clean up file header, complete documentation.	   aep
;
; ORIGINATION DATE:	27 MAY 83
;
; AUTHOR:	Proteus Engineering Inc.				   aep
;		Pasadena, CA   91101
;
; PROGRAM NAME:	DSBLINTR.ASM	-- Disables extraneous interrupts that may
;		be generated by unitialized 8259's on the System Support I
;		board.  This problem is particularly annoying when attempting
;		to use DDT or SID, both of which enable interrupts in the CPU
;		when the "G" command is executed.
;
;	==========================	Copyright 1983, CompuPro Corporation,
;	||			||	A division of Godbout Electronics.
;	||     DSBLINTR.ASM	||	Oakland Airport,	Oakland, CA
;	||			||
;	==========================
;
;	This product is a copyright program product of CompuPro and is
;	supplied for use with the CompuPro Computer Systems.
;
; PURPOSE:	This program will initialize the master and slave Priority
;		Interrupt Controllers (8259) into a benign state.  In this
;		state, they will not generate an interrupt to the CPU even
;		if the VI0 - VI7 priority interrupt lines are activated.
;
; CONSTANTS:
;
SLAVE	EQU	0	;No interrupt vector code for slave PIC
MASTER	EQU	0	;No interrupt vector code for master PIC
;
; LIBRARY CONSTANTS:
    MACLIB  COMPUPRO	;Disk and Serial/Parallel interface constants
    MACLIB  ASCII	;Mnemonics for common ASCII, other special characters
    MACLIB  CPMDISK	;CP/M disk defaults, CBIOS offsets, BDOS functions
    MACLIB  ACTIVE	;Flags directing construction for the various
			;CompuPro products to "customize" the BIOS
;
; PROGRAM:
    ASEG		;Used RMAC to assemble this code module.
	ORG	TPA	;Base of Temporary Program Area
;
; Initialize Slave 8259A Interrupt Controller.
	LXI	H,SLAVE		;Get address of Slave interrupt base
	MOV	A,L
	ANI	111$00000b	;Make sure only 3 address bits used
	ORI	000$11101b	;Level trigger, 4 byte inverval, cascade mode
	OUT	SS1SP0		;ICW1
	MOV	A,H		;High address of Slave interrupt base
	OUT	SS1SP1		;ICW2
	MVI	A,00000$111b	;Slave ID is interrupt 7
	OUT	SS1SP1		;ICW3
	MVI	A,000$00000b	;Non-buffered, normal EOI, 8085
	OUT	SS1SP1		;ICW4
	MVI	A,0FFh		;Slave PIC initial Active Interrupt Mask
	OUT	SS1SP1		;OCW1
	MVI	A,EOI		;Clear controller of any pending interrupts
	OUT	SS1SP0		;OCW2
	MVI	A,SETPRI+6	;Set CRT transmit to lowest priority
	OUT	SS1SP0		;OCW2
	MVI	A,READISR	;Set up to read interrupt service register
	OUT	SS1SP0		;OCW3
	MVI	A,SMMOFF	;Special mask mode off
	OUT	SS1SP0		;OCW3
;
; Initialize Master 8259A Interrupt Controller.
	LXI	H,MASTER	;Get address of Master interrupt base
	MOV	A,L
	ANI	111$00000b	;Make sure only 3 address bits used
	ORI	000$11101b	;Level trigger, 4 byte inverval, cascade mode
	OUT	SS1MP0		;ICW1
	MOV	A,H		;High address of Master interrupt base
	OUT	SS1MP1		;ICW2
	MVI	A,1000$0000b	;Only interrupt 7 is a slave
	OUT	SS1MP1		;ICW3
	MVI	A,000$10000b	;Fully nested, non-buffered, normal EOI, 8085
	OUT	SS1MP1		;ICW4
	MVI	A,0FFh		;Master PIC initial Active Interrupt Mask
	OUT	SS1MP1		;OCW1
	MVI	A,EOI		;Clear controller of any pending interrupts
	OUT	SS1MP0		;OCW2
	MVI	A,READISR	;Set up to read interrupt service register
	OUT	SS1MP0		;OCW3
	MVI	A,SMMOFF	;Special mask mode off
	OUT	SS1MP0		;OCW3
	MVI	C,WBOOTX	;Warm boot back to CP/M
	JMP	BDOS		;thru the BDOS
;
	END
