	page
STEPMS:	VFD	4\SRT,4\0	;Step rate **** fixed location ****
bauds:	db	7		;relative port for I/O 3 console
	db	0eeh		;mode register 1
	db	07eh		;mode register 2- baud rate
	db	027h		;command register 
	db	4		;relative port for I/O 3 list
	db	0eeh		;mode register 1
	db	07eh		;mode register 2- baud rate
	db	027h		;command register 
	db	5		;relative port for I/O 3 UL1
	db	0eeh		;mode register 1
	db	07eh		;mode register 2- baud rate
	db	027h		;command register 
;	
;	Extended bank addresses.

CXADR:	EQU	00h		;CP/M Bank
BXADR:	EQU	00h		;BIOS Bank


;	Dual processor Swap port

swapp	equ	0fdh

;	Disk Input / Output port assignments.

FDPORT	EQU	0C0h		;Base port address for Controller
FDCS	EQU	FDPORT		;Status register
FDCD	EQU	FDPORT+1	;Data register
DMA	EQU	FDPORT+2	;Dma address (when write)
INTS	EQU	FDPORT+2	;Status Register (when read)
SER	EQU	FDPORT+3	;Serial port

;	Controller function definitions

F.SPEC	=	03	;Specify
F.DSTS	=	04	;Drive status
F.WRT	=	05	;Write data
F.RDAT	=	06	;Read data
F.RECA	=	07	;recalibrate
F.RSTS	=	08	;Read status
F.DRID	=	10	;Read ID
F.SEEK	=	15	;Seek


;	Disk drive constants

STEPR:	=	8		;Shugart SA 800
SRT:	=	16-STEPR	;Controller value
HUT:	=	240/16		;Head unload = 240 ms
HLT:	=	35		;Head load = 35 ms
ND:	=	0b		;Set DMA mode
	space	4,10
;		   7    6    5    4    3    2    1    0
;		+----+----+----+----+----+----+----+----+
;	ST0	|    IC   | SE | EC | NR | HD |    US   |
;		+----+----+----+----+----+----+----+----+
;	ST1	| EN |    | DE | OR |    | ND | NW | MA |
;		+----+----+----+----+----+----+----+----+
;	ST2	|    | CM | DD | WC | SH | SN | BC | MD |
;		+----+----+----+----+----+----+----+----+
;	ST3	| FT | WP | RY | T0 | TS | HD |    US   |
;		+----+----+----+----+----+----+----+----+
;
;	IC - Interrupt code.
;		00 - Normal termination by TC signal.
;		01 - Abnormal termination.
;		10 - Invalid command.
;		11 - Abnormal termination (READY dropped).
;
;	SE - Seek end, inticates end of seek.
;
;	EC - Equipment Check.
;
;	NR - Not ready.
;
;	HD - State of the head select.
;
;	US - State of the unit select.
;
;
;	EN - End of Cylinder, Read EOT sector.
;
;	DE - CRC error in ID or data fields.
;
;	OR - Over run.
;
;	ND - No Data.
;
;	NW - Not writable (write protect detected)
;
;	MA - Missing address mark.
;
;
;	CM - Control Mark (deleted data address mark).
;
;	DD - CRC error in data field.
;
;	WC - Wrong cylinder.
;
;	SH - Scan equal hit.
;
;	SN - Scan not satisfied.
;
;	BC - Bad cylinder.
;
;	MD - Missing data mark.
;
;
;	FT - Fault.
;
;	WP - Write protect signal.
;
;	RY - Ready.
;
;	T0 - Track zero.
;
;	TS - Two sided disk is inserted.
	space	4,10
	page


;	Sector Translation Tables.

XTABLE:	DW	XLTS		;Single 128
	DW	XLTD1		;Double 256
	DW	XLTD2		;Double 512
	DW	XLTD3		;Double 1024

XLTS:	DB	0,6,12,18,24,4,10,16,22,2,8,14,20
	DB	1,7,13,19,25,5,11,17,23,3,9,15,21

XLTD1:	DB	 0, 1,18,19,36,37, 2, 3,20,21,38,39
	DB	 4, 5,22,23,40,41, 6, 7,24,25,42,43
	DB	 8, 9,26,27,44,45,10,11,28,29,46,47
	DB	12,13,30,31,48,49,14,15,32,33,50,51
	DB	16,17,34,35

XLTD2:	DB	 0, 1, 2, 3,16,17,18,19
	DB	32,33,34,35,48,49,50,51
	DB	 4, 5, 6, 7,20,21,22,23
	DB	36,37,38,39,52,53,54,55
	DB	 8, 9,10,11,24,25,26,27
	DB	40,41,42,43,56,57,58,59
	DB	12,13,14,15,28,29,30,31
	DB	44,45,46,47

XLTD3:	DB	 0, 1, 2, 3, 4, 5, 6, 7
	DB	24,25,26,27,28,29,30,31
	DB	48,49,50,51,52,53,54,55
	DB	 8, 9,10,11,12,13,14,15
	DB	32,33,34,35,36,37,38,39
	DB	56,57,58,59,60,61,62,63
	DB	16,17,18,19,20,21,22,23
	DB	40,41,42,43,44,45,46,47


;	Disk selection masks.
;		A   B   C   D   E   F   G   H
DSKMSK:	DB	00H,00h,01h,02h,03h,00h,00h,00h,00h,00h
;		I   J   K   L   M   N   O   P
	page
;	Control Blocks for disk drives

DPBASE:
	DPHGEN  MEMTYP,0,DIRBUF,DPBMEM+1	;Drive A:

	DPHGEN	DSKS1,XLTS,DIRBUF,DPBS1+1	;Drive B:

	DPHGEN	DSKS1,XLTS,DIRBUF,DPBS1+1	;Drive C:

	DPHGEN	DSKS1,XLTS,DIRBUF,DPBS1+1	;Drive D:

	DPHGEN	DSKS1,XLTS,DIRBUF,DPBS1+1	;Drive E:

	space	4,10
;	Disk type definition blocks for each particular mode.

DPBS1:		;Single density, single sided.

	DPBGEN	DSKS1,26,3,7,0,S1DSM,64,1100000000000000b,2


DPBS2:		;Single density, double sided.

	DPBGEN	DSKS2,26,4,15,1,S2DSM,128,1100000000000000b,2*2


DPBD1:		;Double density, single sided.

	DPBGEN	DSKD1,2*26,4,15,0,D1DSM,128,1100000000000000b,2


DPBD2:		;Double density, double sided.

	DPBGEN	DSKD2,2*26,4,15,0,D2DSM,256,1111000000000000b,2*2


DPBD3:		;Double density, single sided.

	DPBGEN	DSKD3,4*15,4,15,0,D3DSM,128,1100000000000000b,2


DPBD4:		;Double density, double sided.

	DPBGEN	DSKD4,4*15,4,15,0,D4DSM,256,1111000000000000b,2*2


DPBD5:		;Double density, single sided.

	DPBGEN	DSKD5,8*8,4,15,0,D5DSM,128,1100000000000000b,2


DPBD6:		;Double density, double sided.

	DPBGEN	DSKD6,8*8,4,15,0,D6DSM,256,1111000000000000b,2*2


DPBMEM:
	DPBGEN	MEMTYP,14,4,15,0,MEMDSM,128,1100_0000_0000_0000B,0

