	page
;	C O N S O L   S T A T U S
;
;	This routine samples the Console status and returns the
;	following values in the A register.
;
;	EXIT	A = 0 (zero), means no character
;		currently ready to read.
;
;		A = FFh (255), means character
;		currently ready to read.

CONST:	IN	GBP0+GBSTAT	;Input from port
	ANI	GBDAV		;Mask data available
	RZ			;If data not available
	ORI	0FFh
	RET
	space	4,10
;	C O N S O L   I N P U T
;
;	Read the next character into the A register, clearing
;	the high order bit.  If no character currently ready to
;	read then wait for a character to arrive before returning.
:
;	EXIT	A = character read from terminal.

CONIN:	IN	GBP0+GBSTAT
	ANI	GBDAV
	JZ	CONIN		;If data not available
	IN	GBP0+GBDATA
	ANI	7Fh
	RET
	space	4,10
;	C O N S O L   O U T P U T
;
;	Send a character to the console.  If the console
;	is not ready to receive a character wait until
;	the console is ready.
;
;	ENTRY	C = ASCII character to output to console.

CONOUT:	IN	GBP0+GBSTAT
	ANI	GBTBMT
	JZ	CONOUT		;If transmit buffer not empty
	MOV	A,C
	OUT	GBP0+GBDATA
	RET
