	page
;	B o o t   C P / M   f r o m   d i s k.
;
;	The CBOOT entry point gets control from the cold start
;	loader and is responsible for the basic system initial-
;	ization.  This includes outputting a sign-on message and
;	initializing the following page zero locations:
;
;	   0,1,2: Set to the warmstart jump vector.
;	       3: Set to the initial IOBYTE value.
;	       4: Default and logged on drive.
;	   5,6,7: Set to a jump to BDOS.
;	      40: (Set by BOOT) Board switch options.
;
;	If BANG is true (DISK1 bit serial latch is to be
;	supported), then board switch option 1 means to
;	use the BitBanger for console I/O.
;	Register C must contain the selected drive, which is
;	zero to select the A drive.  The exit address is to
;	the CCP routine.
;
;
;	The WBOOT entry point gets control when a warm start
;	occurs, a ^C from the console, a jump to BDOS (function
;	0), or a jump to location zero.  The WBOOT routine reads
;	the CCP and BDOS from the appropriate disk sectors.
;	WBOOT must also re-initialize locations 0,1,2 and 5,6,7.
;	The WBOOT routines exits with the C register set to the
;	appropriate drive selection value.  The exit address
;	is to the CCP routine.
;
;
;	Disk layout Definition.
;	Cylinder 0   Head 0
;	  0 thru 3	Boot program
;	  4 thru 26	Reserved for CBIOS
;
;	256 byte sectors -- Cylinder 1  Head 0:
;	  0 thru 7	CCP
;	  8 thru 21	BDOS
;	 22 thru 26	**Reserved for CP/M expansion**
;
;	512 byte sectors -- Cylinder 1  Head 0:
;	  0 thru 3	CCP
;	  4 thru 11	BDOS
;	 12 thru 15	**Reserved for CP/M expansion**
;
;	1024 byte sectors -- Cylinder 1  Head 0:
;	  0 thru 1	CCP
;	  2 thru 5,7	BDOS
;	  6		**Reserved for CP/M expansion**

CBOOT:	LXI	SP,DBUF
	LD	A,OPTS
.b	IF	BANG
	CPI	1
	JNZ	CBOOT4		;if BitBanger not selected
	LDK HL,KONST	! STO HL,J.CST+1
	LDK HL,KONIN	! STO HL,J.CIN+1
	LDK HL,KONOUT	! STO HL,J.COUT+1
	CALL	BAUD		;get terminal speed
	JMP	CBOOTX
CBOOT4:
.b	ENDIF
.s	IF	SYSSUP
	CPI	2
	JNZ	CBOOT5		;If System support not selected
	LDK HL,sCONST	! STO HL,J.CST+1
	LDK HL,sCONIN	! STO HL,J.CIN+1
	LDK HL,sCONOUT	! STO HL,J.COUT+1
	CALL	sTINIT		;Initialize System Support
	JMP	CBOOTX
CBOOT5:
.s	ENDIF
.i3	IF	INTER3
	CPI	3
	JNZ	CBOOT6		;If Interfacer 3 not selected
	LDK HL,I3CONST	! STO HL,J.CST+1
	LDK HL,I3CONIN	! STO HL,J.CIN+1
	LDK HL,I3CONOUT	! STO HL,J.COUT+1
	CALL	I3INIT		;Initialize Interfacer 3
;	JMP	CBOOTX
CBOOT6:
.i3	ENDIF

CBOOTX:	LXI	H,SIGNON
	CALL	PRINT		;Output Banner
	XRA	A
	STA	CDISK		;Force A drive
	STA	IOBYTE		;Clear I/O byte

WBOOT:				;Warm boot
	LXI	SP,DBUF
	CALL	BCPM		;Boot CP/M
	JNZ	WBOOT		;If error

	LDK	BC,DBUF		;Set default data transfer address
	CALL	SETDMA
	MVI	A,0C3h		;Store jumps in low memory
	STA	0
	STA	5
	LXI	H,BIOS+3
	SHLD	1
	LXI	H,BDOS
	SHLD	6
	LDA	CDISK
	MOV	C,A
	JMP	CCP		;Go to CPM

SIGNON:
	DB	CR,LF,LF
	DB	'CompuPro Systems '
	DB	CR,LF,MSIZE/10+'0',MSIZE mod 10 + '0'
	DB	'K CP/M ',VERS/10+'0','.',VERS mod 10 + '0'
	DB	CBIOSV+'@',CR,LF,0
	space	4,10
;	Boot CPM from disk
;
;	Exit	A = 0, load sucessful.
;		Z bit = 1, load successful.

BCPM:	CALL	HOME		;Force buffer flush
	LDK	C,'A'-'A'	;Select Disk 'A'
	LDK	DE,0		;Force disk type determination
	CALL	SELDSK
	MOV	A,L
	ORA	H
	JZ	BCPME		;If drive not selected
	LDA	SEKTYP		;Get disk type
	RAR			;Remove sided bit
	DCR	A
	JM	BCPME		;If invalid boot type

	MOV	C,A
	LDK	HL,BSECT	;Boot sector table
	DAD	B
	LD	A,[hl]		;Get number of sectors
	STO	A,NUMSEC
	LDK	HL,CCP		;Set buffer address
	STO	HL,DMAADR
	LDK	A,CXADR		;Set extended address
	STO	A,DMAADE
	LD	A,SEKTYP
	AND	1b		;Mask sided bit
	ADD	A,1
	LDK	H,0
	MOV	L,A
	STO	HL,SEKTRK	;Set track
	LDK	A,0		;Set boot sector
	STO	A,SAVSEC

	CALL	SETACT		;Move SEK to ACT
	LDK	A,F.RDAT+040h	;Read data
	CALL	FINAL
	JNZ	BCPME		;If read erros
	LDK	A,1
	STO	A,NUMSEC
	LDA	SEKTYP
	CMP	DSKD5
	JC	BCPM1		;If not 1024 byte
	LDK	HL,CCP+5*1024-512
	SHLD	BUFADR
	LDK	A,7
	STA	ACTSEC
	LDK	A,F.RDAT+040h	;Read data
	JMP	FINAL

BCPM1:	XRA	A		;Clear error indicator
	RET

BCPME:	LDK	BC,500
	CALL	DELAY		;Delay 500 milli-seconds
	ORI	1		;Set error indicator
	RET

BSECT:	DB	22*256/256	;double 256 byte sectors
	DB	22*256/512	;double 512 byte sectors
	DB	22*256/1024	;double 1024 byte sectors
	IF	HARD
	DB	22*256/256	;SA 1000 hard disk
	DB	22*256/512	;Memorex 8 inch
	ENDIF
