;*******************************************************
;*                                                     *
;*    Micro Decision remote terminal program           *
;*                 (bjg 3/15/83)                       *
;*                                                     *
;*******************************************************

	  ORG	0100H

CDATA     EQU  0FCH           ;uDECISION CONSOLE PORT
CSTAT     EQU  0FDH           ;uDECISION CONSOLE STATUS
RXRDY     EQU  02H            ;UART DATA RECEIVED
TXRDY     EQU  01H            ;UART TRANSMITTER BUFFER EMPTY
AUXDATA   EQU  0FEH           ;uDECISION AUXILLIARY PORT
AUXSTAT   EQU  0FFH           ;uDECISION AUXILLIARY STATUS
CPM       EQU  05
WARM      EQU  0

CLEAR     EQU  01AH           ;CLEAR SCREEN CHARACTER
ACR       EQU  0DH            ;ASCII CARRIAGE RETURN
ALF       EQU  0AH            ;ASCII LINE FEED
ESCAPE    EQU  01BH


        LXI  	SP, 01000H

BLANK:  MVI  	C,02           ;CALL CPM AND CLEAR SCREEN
        MVI  	E,CLEAR
        CALL 	CPM
	

; SEND MICRONIX 'CRLF' TO GET BACK A PROMPT

INIT:	MVI	C,ACR
	CALL	AUXOUT
	MVI	C,ALF
	CALL	AUXOUT

;********************************************************
;*							*
;*    THE FOLLOWING IS THE MAIN LOOP OF THE PROGRAM     *
;*							*
;********************************************************

MAIN:	CALL	AUXIN
	JZ	MAIN1
	MOV	C,A
	CALL	CONOUT

MAIN1:  CALL	CONIN
	JZ	MAIN
	MOV	C,A
	CALL	AUXOUT



;********************************************************
;*							*
;*  		SUBROUTINES CALLED BY MAIN		*
;*							*
;********************************************************



; LEAVE ROUTINE WITH '00' IN 'A' IF NO CHARACTER RECEIVED
; OTHERWISE THE RECEIVED CHARACTER IS IN 'A'

AUXIN:  IN   	AUXSTAT        ;GET UART STATUS
        ANI  	RXRDY
        RZ
        IN	AUXDATA
        RET
	


; ENTER ROUTINE WITH CHARACTER TO SEND IN 'C'

AUXOUT: IN   	AUXSTAT        ;GET UART STATUS
        ANI  	TXRDY          ;CHECK FOR EMPTY TRANSMITTER
        JZ   	AUXOUT
        MOV     A,C
        OUT  	AUXDATA          ;SEND CHARACTER
        RET
	

; LEAVE ROUTINE WITH '0' IN 'A' IF NO CHARACTER RECEIVED
; OR WITH CHARACTER IN 'A' IF ONE RECEIVED.  IF 'ESC' DETECTED
; GO BACK TO CPM.

CONIN:  IN   	CSTAT		;CHECK FOR CONSOLE CHARACTER
	ANI	RXRDY
	RZ			;RETURN IF NONE
	IN	CDATA		;READ IT
	CPI	ESCAPE		;CHECK FOR ESCAPE
	JZ	WARM		;RETURN TO CPM
	RET			


; ENTER ROUTINE WITH CHARACTER TO SEND IN 'C'

CONOUT: IN	CSTAT		;CHECK CONSOLE OUTPUT BUFFER
	ANI	TXRDY
	JZ	CONOUT		;LOOP 'TILL EMPTY
	MOV	A,C
	OUT	CDATA
	RET

	END

