


          ORG 100H


;	PORT MAP (OFFSET FROM BASE)

BASE	  EQU	50H

STATUS    EQU   BASE			;PRIMARY STATUS PORT (READ)
CNTRL     EQU   BASE			;CLOCK & ENABLE PORT
COMND     EQU   BASE + 1               	;DISK COMMAND PORT (WRITE)
STAT2	  EQU	BASE + 1		;SECONDARY STATUS (READ)
FNCTN     EQU   BASE + 2		;DRIVE/HEAD SELECT POR (WRITE)
CMPLT	  EQU   BASE + 2		;SEEK DONE CLEAR (READ)
DATA	  EQU	BASE + 3		;DISK DATA PORT (READ/WRITE)

;	DISK COMMAND CONSTANTS

HEADER	  EQU	8			;SET MEMORY POINTER TO HEADER
DSKDAT	  EQU	0		        ;SET MEMORY POINTER TO DATA

;	LOCAL VARIABLES

COUNT	EQU	21			;M10,M20 SECTOR COUNT
POINTER EQU	300H

INIT:   MVI 	A,0F4H			;TRK 0, HD 0, NO STEP
	OUT	CNTRL
	MVI	A,07			;ENABLE CONTROLLER
	OUT	CNTRL			;- CHOOSE DISK CLOCK
	LXI	H,3000H			;MEMORY SAVE AREA
	SHLD	POINTER

; CLEAR HEADER RAM AREA WITH A BACKGROUND OF 0FFH

CLEAR:  MVI	A,HEADER					
	LXI	H,200H			;512 BYTES DATA
	OUT	COMND			;POINT TO HEADER BUFFER
CLEAR1:	MVI	A,0FFH
	OUT	DATA
	DCX	H
	MOV	A,L
	ORA	H
	JNZ	CLEAR1
CLEAR2:	MVI	A,8
	OUT	COMND			;RESET THE HEADER POINTER
	MVI	B,COUNT
 

;  ROUTINE WAITS FOR FALLING EDGE OF INDEX

INDX0: 	IN	STATUS
	ANI	40H			;WAIT FOR INDEX LOW  
	JNZ	INDX0			
INDX1:	IN	STATUS			;WAIT FOR INDEX LOW
	ANI	40H
	JZ	INDX1	
INDX2:  IN	STATUS
	ANI	40H			
	JNZ	INDX2			;INDEX JUST WENT LOW

DOIT:   MVI	A,03			;READ HEADER COMMAND
	OUT	COMND
WAIT:	IN	STATUS
	ANI	02
	JZ	WAIT
	

;WRITE HEADER TO MEMORY FOR EXAMINATION

STORE:  LHLD	POINTER
	MVI 	A,8
	OUT	COMND			;POINT TO START OF HEADER
	MVI	C,10H			;COUNT
SLOOP:	IN	DATA
	MOV	M,A			;STORE IT
	INX	H			;BUMP POINTER
	DCR	C
	JNZ	SLOOP
	SHLD	POINTER			;SAVE POINTER FOR LATER
	DCR	B
	JNZ	DOIT			;READ THEM ALL

GETSTA: MVI	C,0BH
	CALL	005H
	CPI	00H			;CHECK KEYBOARD
	JZ	INIT


SERVE:  MVI	C,01
	CALL	005			;CLEAR UART BUFFER

	HLT
	JMP	INIT			;TRAP TO MONITOR / PC=INIT


	END
