;********************************************************
;*  Centronics printing test routine.			*
;*  11/12/82  BJG					*
;********************************************************

	ORG 100H


BASE	EQU	48H
GROUP	EQU	BASE + 7
CLOCK	EQU	BASE + 2
STROBE	EQU	BASE 
DATA	EQU	BASE + 1 
STATUS  EQU	BASE
BUSY	EQU	20H		;PRINTER BUSY FLAG

	LXI SP,200H	

; MULT I/O PRINTER RESTORE SUBROUTINE (VIA GROUP PORT)

MRESTR:	MVI A,0H
	OUT GROUP
	MVI A,0C0H
	OUT STROBE		;TURN DATA STROBE OFF
	MVI A,30H
	OUT GROUP		;TURN RESTORE ON
	MVI A,20H		;TURN RESTORE OFF
	OUT GROUP

;  WB I/O PRINTER RESTORE ROUTINE 	

WRESTR: MVI A,0FFH
	OUT 48H			;TURN STROBES OFF
	MVI A,0C0H
	OUT CLOCK		;TURN ON DRIVERS
	MVI A,07FH		;SEND RESTORE
	OUT STROBE
	MVI A,0FFH
	OUT STROBE	

 	MVI C,20H		;1ST DISPLAYABLE CHARACTER

INIT:   MVI B,80		;CHARACTER COUNTER
	CALL CRLF
MAIN:	CALL RANGE
	CALL PRINT
	CALL CONST
	MVI A,20H
	OUT GROUP
	INR C
	DCR B
	JNZ MAIN
	JMP INIT
	

; SEND PRINTER A CARRIAGE RETURN & LINE FEED

CRLF:	PUSH B
	MVI C,0AH		;LINE FEED
	CALL PRINT
	MVI C,0DH		;CARRIAGE RETURN
	CALL PRINT
	POP B
	RET

; MAKE SURE CHARACTER IS DISPLAYABLE

RANGE:	MOV A,C			;GET PRINT CHARACTER
	CPI 07FH		;LAST PRINTABLE CHARACTER
	RNZ
	MVI C,20H
	RET


;  ENTER ROUTINE WITH CHARACTER TO PRINT IN "C"

PRINT:	IN STATUS		;CHECK IF PRINTER READY
	ANI BUSY
	JZ PRINT		;LOOP TILL READY

MCHECK: IN 049H			;READ MOTHERBOARD SWITCH
	CPI 0FFH		;FF MEANS MULT I/O
	JZ PMULT

	MOV A,C
	OUT DATA		;DATA VALID
	MVI A,0BFH		;STROBE LOW
	OUT STROBE
	XTHL			;STALL 10 uS
	XTHL			
	MVI A,0FFH		;STROBE HIGH	
	OUT STROBE
	RET

PMULT:  MOV A,C
	OUT STROBE
	MVI A,0BFH		;STROBE LOW
	OUT DATA
	XTHL			;STALL 10 uS
	XTHL			
	MVI A,0FFH		;STROBE HIGH	
	OUT DATA
	RET


; CHECK FOR KEY PRESSED

CONST: 	PUSH B
	MVI C,0BH		;CONSOLE STATUS CALL
	CALL 5			;BDOS ENTRY			
	CPI 0
	JNZ 0			;WARM BOOT
	POP B
	RET

		 
	END
