	PAGE	0
;Ver 2.3 - On E command check for duplicate labels 
;	FVD
;Ver 2.2a - Fixed missing CR after DW in L cmd
;	Frans Van Duinen,  24 Jul 82
	ORG	0100H
BELL	EQU 7
CR	EQU 0DH
LF	EQU 0AH
;
BDOS	EQU	05H
CTLTBL	EQU	1F00H
FCB	EQU	5CH
FCBNR	EQU	7CH
FCBTYPE	EQU	65H
RECLEN	EQU	80H
SYMTAB	EQU	CTLTBL+600H
	JMP	START
	JMP	GETCMD	;This is an easy entry point for a 'dirty' restart.
START:	CALL	BGN
	DB	'ZZSOURCE with ZILOG MNEMONICS by Dave Barker',CR,LF
	DB	'    -from RESOURCE by Ward Christensen',CR,LF
	DB	'Version 2.3 (25 Jul 82)',CR,LF
	DB	'$Copyright 1980, 1981, 1982'
; PRINT THE BUFFER STARTING AT DE.
BGN:	POP	D
	MVI	C,9
	CALL	BDOS
	LXI	SP,OLDST
	CALL	PSTRNG
	DB	CR,LF,'Memory open to ',0
	LHLD	6
	DCX	H
	CALL	PVALUE	;print the beginning of BDOS (not CCP)
	CALL	CRLF
	CALL	CRLF
CLEAN:	CALL	INIT
GETCMD:	XRA	A
	STA	WRTENAB
	STA	HUSH
	STA	REPLSW
	STA	XCPTR
	STA	XCPTR+1
	LXI	SP,OLDST
;
;GO GET SOME INPUT.
;
	CALL	PROMPT
PRCEDE:	LXI	H,INBUF+2	;See the .DOC file for command description
	MOV	A,M
	CPI	CR
	JZ	GETCMD
	CPI	';'
	JZ	CMNT
	CPI	'A'
	JZ	ASCASM
	CPI	'B'
	JZ	BLDASM
	CPI	'C'
	JZ	CTL
	CPI	'D'
	JZ	DUMP
	CPI	'E'
	JZ	ENTER
	CPI	'F'
	JZ	FIND
	CPI	'K'
	JZ	KILL
	CPI	'L'
	JZ	LIST
	CPI	'O'
	JZ	SETOS
	CPI	'P'
	JZ	PROLOG
	CPI	'Q'
	JZ	QUIET
	CPI	'R'
	JZ	READ
	CPI	'S'
	JZ	SAVE
	CPI	'U'
	JZ	UAREA
	CPI	'X'
	JZ	PURGE
	CPI	'Z'
	JZ	CLOSE
	CPI	'?'
	JZ	STAT
WHAT:	XRA	A
	STA	WRTENAB
	STA	HUSH
	CALL	PSTRNG
	DB	'?',CR,LF,0
	JMP	GETCMD
PURGE:	CALL	PSTRNG
	DB	'Y/N purge all symbols & '
	DB	'CTL?',0
	CALL	PROMPT
	LDA	INBUF+2
	CPI	'Y'
	JZ	CLEAN
	CPI	'N'
	JZ	GETCMD
	JMP	PURGE
PROLOG:	LXI	H,INBUF+3
	MOV	A,M
	CPI	CR
	JZ	WHAT
	CALL	CNVRT
	CPI	' '
	JZ	PRLG0
	CPI	','
	JNZ	WHAT
PRLG0:	INX	H
	PUSH	D
	PUSH	H
	MVI	A,1
	STA	WRTENAB
	CALL	PSTG
	DB	9,'ORG',9,0
	POP	H
	POP	D
	MOV	A,D
	CALL	PASHEX
	MOV	A,E
	CALL	PHEX
	MVI	A,'H'
	CALL	TYPE
	CALL	CRLF
	PUSH	D
	CALL	CNVRT
	CPI	CR
	JNZ	WHAT
;...POP THE START VALUE.
	POP	B
	LXI	H,SYMTAB
PRLG1:	INX	H
	INX	H
	MOV	A,M
	ORA	A
	JZ	GETCMD
	DCX	H
	DCX	H
	MOV	A,M
	SUB	C
	INX	H
	MOV	A,M
	SBB	B
;...JUMP IF THE SYMBOL IS SMALLER THAN THE START VALUE.
	JC	GENEQU
	DCX	H
	MOV	A,M
	SUB	E
	INX	H
	MOV	A,M
	SBB	D
;...JUMP IF THE SYMBOL IS WITHIN LIMITS.
	JC	WITHIN
GENEQU:	PUSH	H
	PUSH	B
	INX	H
	MOV	B,M
	PUSH	H
	INX	H
	MOV	A,M
	DCX	H
	CPI	'A'
;...IF FIRST LETTER NOT ALPHA, DON'T GENERATE 'EQU'.
	JC	PRLG3
;...IF SYMBOL CONTAINS '+' OR '-', DON'T GEN. 'EQU'.
PRLG2:	INX	H
	MOV	A,M
	CPI	'+'
	JZ	PRLG3
	CPI	'-'
	JZ	PRLG3
	DCR	B
	JNZ	PRLG2
	POP	H
	MOV	B,M
	MVI	A,1
	STA	WRTENAB
LOOPB:	INX	H
	MOV	A,M
	CALL	TYPE
	DCR	B
	JNZ	LOOPB
	CALL	PSTG
	DAD	B
	MOV	B,L
	MOV	D,C
	MOV	D,L
	DAD	B
	NOP
	POP	B
	POP	H
	MOV	A,M
	ORA	A
	CNZ	PASHEX
	DCX	H
	MOV	A,M
	CALL	PHEX
	MVI	A,'H'
	CALL	TYPE
	CALL	CRLF
	XRA	A
	STA	WRTENAB
	INX	H
WITHIN:	INX	H
	MOV	A,M
	CALL	SKIP
	INX	H
	CALL	BRKCHK
	JMP	PRLG1
PRLG3:	POP	H
	POP	B
	POP	H
	JMP	WITHIN
;DO IN THE QUIET MODE.
QUIET:	MVI	A,1
	STA	HUSH
	LXI	D,INBUF+2
	LXI	H,INBUF+3
SHFTBF:	MOV	A,M
	STAX	D
	INX	H
	INX	D
	CPI	CR
	JNZ	SHFTBF
	JMP	PRCEDE
	DB	'Congratulations, you found '
	DB	'the patch area!'
;
;DUMP THE MEMORY...
;
DUMP:	LHLD	DMPTR
	PUSH	H
	XCHG
	LHLD	DMPSET
;...CALCULATE THE LENGTH OF A DEFAULT DUMP.
	DAD	D
	SHLD	DMPLEN
	POP	D
	LXI	H,INBUF+3
	MOV	A,M
	CPI	CR
	JZ	CNTDMP
	CPI	'S'
	JZ	DMPSYM
	CPI	'='
	JZ	DUMP5
	CPI	','
	JZ	DUMP1
DUMP0:	CALL	CNVRT
	PUSH	H
	LHLD	DMPSET
	DAD	D
	SHLD	DMPLEN
	POP	H
DUMP1:	CPI	CR
	JZ	DUMP3
	CPI	' '
	JZ	DUMP2
	CPI	','
	JNZ	WHAT
DUMP2:	INX	H
	PUSH	D
	CALL	CNVRT
	XCHG
	SHLD	DMPLEN
	POP	D
DUMP3:	LHLD	OFFSET
	PUSH	H
	DAD	D
	SHLD	DMPTR
	LHLD	DMPLEN
	POP	D
	DAD	D
	SHLD	DMPLEN
	CPI	CR
	JNZ	WHAT
CNTDMP:	LHLD	DMPTR
DUMP4:	CALL	BRKCHK
	PUSH	H
	CALL	TWOS
	CALL	PVALUE
	POP	H
	PUSH	H
	CALL	SPACE
;...DUMP THE HEX FIRST.
DMPLN:	MOV	A,M
	CALL	PHEX
	INX	H
	MOV	A,L
	ANI	3
	CZ	SPACE
	MOV	A,L
	ANI	7
	CZ	SPACE
	MOV	A,L
	ANI	0FH
	JNZ	DMPLN
	CALL	TYPSTR
	POP	H
;...THEN DUMP THE ASCII.
DMPASC:	MOV	A,M
	CPI	' '
	JC	PERIOD
	CPI	7FH
	JC	CHRCTR
PERIOD:	MVI	A,'.'
CHRCTR:	CALL	TYPE
	INX	H
	MOV	A,L
	ANI	0FH
	JZ	LCMPLT
	ANI	7
	CZ	SPACE
	JMP	DMPASC
;...TIDY UP THE LINE.
LCMPLT:	CALL	TYPSTR
	CALL	CRLF
	SHLD	DMPTR
	LDA	DMPLEN
	SUB	L
	LDA	DMPLEN+1
	SBB	H
	JNC	DUMP4
	JMP	GETCMD
DUMP5:	INX	H
	CALL	CNVRT
	INX	H
	DCX	D
	XCHG
	SHLD	DMPSET
	XCHG
	CPI	','
	JZ	DUMP0
	CPI	' '
	JZ	DUMP0
	CPI	CR
	JZ	GETCMD
	JMP	WHAT
;...DUMP THE SYMBOL TABLE.
DMPSYM:	LXI	H,INBUF+4
	MOV	A,M
	CPI	'.'
	JNZ	FRMBGN
	CALL	LNGTH
	CALL	PLCSYM
	JNC	FRMSYM
	LHLD	SYMRKR
	JMP	FRMSYM
FRMBGN:	LXI	H,SYMTAB
FRMSYM:	MOV	E,M
	INX	H
	MOV	D,M
	INX	H
	MOV	A,M
;...EXIT ON A NULL LENGTH.
	ORA	A
	JZ	GETCMD
	XCHG
	CALL	PVALUE
	XCHG
;...GET THE SYMBOL LENGTH.
	MOV	B,M
	INX	H
;...PRINT THE SYMBOL.
SPIT:	MOV	A,M
	CALL	TYPE
	INX	H
	DCR	B
	JNZ	SPIT
	CALL	CRLF
	CALL	BRKCHK
	JMP	FRMSYM
;----------------------------------------------------------------
;   PRINT THE VALUE OF THE OFFSET.
PRNTOS:	LHLD	OFFSET
	CALL	PVALUE
	CALL	CRLF
	JMP	GETCMD
SETOS:	LXI	H,INBUF+3	;FORMAT: P c/r
	MOV	A,M		;.. or   Pxxxx c/r
	CPI	CR
	JZ	PRNTOS
	CALL	CNVRT
	CPI	CR
	JNZ	WHAT
	XCHG
	SHLD	OFFSET
	JMP	GETCMD
;----------------------------------------------------------------
;   SET UP THE FILE CONTROL BLOCK.
SETFCB:	LDA	FOPEN
	ORA	A
	JNZ	CANT
	STA	FCB
	STA	68H
	LXI	H,INBUF+3
	LDA	INBUF+4
	CPI	' '
	JZ	WHAT
	CPI	':'
	JNZ	SMDRV
	LDA	INBUF+3
	SUI	'@'
	STA	FCB
	INX	H
	INX	H
SMDRV:	LXI	D,FCB+1
	MVI	B,8
	CALL	SLIDE
	MVI	B,3
	CALL	SLIDE
	RET
SLIDE:	MOV	A,M
	CPI	CR
	JZ	BLANK
	INX	H
	CPI	'.'
	JZ	BLANK
	STAX	D
	INX	D
	DCR	B
	JNZ	SLIDE
;... AFTER 8 CHARACTERS IN THE FILENAME.
AFTR8:	MOV	A,M
	CPI	CR
	RZ
	CPI	'.'
	INX	H
	RZ
	JMP	AFTR8
;...BLANK FILL FOR THE REMAINDER OF THE NAME.
BLANK:	MVI	A,' '
	STAX	D
	INX	D
	DCR	B
	JNZ	BLANK
	RET
ASCASM:	MVI	A,1
	STA	ASCBLD
	XRA	A
	STA	BUILD
	JMP	LIST1
BLDASM:	MVI	A,1
	STA	BUILD
	JMP	LIST1
;----------------------------------------------------------------
;DISASSEMBLE WITH THE 'L' OPTION.
;
LIST:	XRA	A
	STA	BUILD
	STA	ASCBLD
LIST1:	XRA	A
	STA	WRTENAB
	LDA	EFLNCT
	STA	EFLNCT+1
	STA	CNTENAB
	LXI	H,INBUF+3
	MOV	A,M
	CPI	CR
	JZ	TENL
	CPI	','
	JZ	LIST3
	CPI	' '
	JZ	LIST3
	CPI	'='
	JZ	NWLNCT
LIST2:	CALL	CNVRT
	XCHG
	SHLD	PC
	XCHG
	CPI	CR
	JZ	TENL
	CPI	' '
	JZ	LIST3
	CPI	','
	JNZ	WHAT
LIST3:	INX	H
	CALL	CNVRT
	XCHG
	SHLD	ENDLST
	XRA	A
	STA	CNTENAB
TENL:	CALL	BRKCHK
	LDA	CNTENAB
	ORA	A
	JZ	CONTL
	LDA	EFLNCT+1
	DCR	A
	JM	GETCMD
	JMP	FLAGCK
;   COMPARE ENDLST WITH PC.
CONTL:	LHLD	ENDLST
	LDA	PC
	SUB	L
	LDA	PC+1
	SBB	H
	JNC	GETCMD
FLAGCK:	LDA	ASCBLD
	ORA	A
	JZ	MOREL
	LHLD	PC
	XCHG
	LHLD	OFFSET
	DAD	D
;...H,L ARE THE BIASED ADDRESS.
	MVI	B,8
;...SEE IF THIS CAN BE A STRING.
LOOP8:	MOV	A,M
	CALL	ISITASC
	JC	MOREL
	INX	H
	DCR	B
	JNZ	LOOP8
;   FOLLOW THROUGH THIS ASCII STRING.
FOLLOW:	MOV	A,M
	CALL	ISITASC
	INX	H
	JNC	FOLLOW
	DCX	H
	CALL	TWOS
	XCHG
;...D,E ARE THE PC FOR NEXT 'I' CTL-FORMAT.
	PUSH	D
	LHLD	PC
	XCHG
	MVI	A,'B'
	CALL	FITCTL0
	POP	D
	MVI	A,'I'
	CALL	FITCTL0
;...FIRST LOOK FOR ANY COMMENTS AT THIS ADDRESS.
MOREL:	LHLD	COMST
	MOV	A,H
	ORA	L
	JZ	NCMT
	LHLD	PC
	XCHG
	CALL	COMCHK
	JC	NCMT
	INX	H
	INX	H
	MOV	B,M
	INX	H	;THE FIRST CHARACTER
	MOV	A,M
	CPI	';'	; A ';' COMMENT IS LISTED AFTER THE OPCODE
	DCX	H
	JNZ	MOREL1
	SHLD	XCPTR	;SAVE THE COMMENT ADDRESS
	JMP	NCMT
;THIS ROUTINE WILL
;  PRINT COMMENTS
;    LIKE THIS.
NWLN:	STC
NWLN0:	MVI	A,1
	STA	WRTENAB
	CC	SEMI
	XRA	A
	ORA	B
	RZ
CNTCMT:	INX	H
	MOV	A,M
	CPI	5CH
	JNZ	NTBKSL
	CALL	CRLF
	DCR	B
	JMP	NWLN
NTBKSL:	CALL	TYPE
	DCR	B
	JNZ	CNTCMT
	RET
MOREL1:	CPI	'*'	; A '*' COMMENT REPLACES THE ENTIRE LINE
	JNZ	MOREL2
	SHLD	RPLPTR
	JMP	NCMT
MOREL2:	CALL	NWLN
	CALL	CRLF
;   NOW PROCESS THE BYTE.
NCMT:	LHLD	PC
	XCHG
	CALL	SCHCTL
;....DCX TO LAST CTL ENTRY.
	DCX	H
	JC	RDCTL
;....INX TO NEW CTL ENTRY.
	INX	H
	INX	H
	INX	H
RDCTL:	MOV	A,M
	CPI	'I'
	JZ	ICTL
	CPI	'E'
	JZ	CLOSE
	PUSH	PSW
	INX	H
	MOV	E,M
	INX	H
	MOV	D,M
;   PUSH THE ADDRESS OF THE NEXT CONTROL ENTRY.
	PUSH	D
	LHLD	PC
	XCHG
	CALL	HSYM
	POP	H
	SHLD	NXTCTL
	XCHG
	XRA	A
	STA	WRTENAB
	POP	PSW
	CPI	'S'
	JZ	DSMODE
	CPI	'B'
	JZ	BMODE
	CPI	'W'
	JZ	WMODE
	CALL	TYPE
	CALL	PSTRNG
	DB	': INVALID CTL ENTRY',CR
	DB	LF,0
	JMP	GETCMD
; EXECUTE HERE IF THE 'I' CTL IS IN EFFECT.
ICTL:	CALL	DASM
;>>>> DON'T UNDERSTAND WHY THE NEXT 2 INSTRUCTIONS.
	XRA	A
	STA	WRTENAB
	JMP	TENL
NWLNCT:	INX	H
	CALL	CNVRT
	MOV	A,E
	ORA	A
	JZ	WHAT
	STA	EFLNCT
	sta	eflnct+1
	MOV	A,M
	INX	H
	CPI	','
	JZ	LIST2
	CPI	' '
	JZ	LIST2
	CPI	CR
	JZ	GETCMD
	JMP	WHAT
;  D,E CONTAIN NEXT CTL ADDRESS.
DSMODE:	PUSH	D
	LDA	PC
	CMA
	MOV	L,A
	LDA	PC+1
	CMA
	MOV	H,A
	INX	H
;  H,L NOW CONTAIN THE LENGTH OF THE SPACE DEFINED.
	DAD	D
	MVI	A,1
	STA	WRTENAB
	CALL	PSTG
	DB	'DS',9,0
	MOV	A,H
	CALL	PASHEX
	MOV	A,L
	CALL	PHEX
	MVI	A,'H'
	CALL	TYPE
	CALL	CRLF
	POP	H
	SHLD	PC
	JMP	TENL
;THE W-MODE, LOOK FOR LABELS.
WMODE:	MVI	A,1
	STA	WRTENAB
	CALL	PSTG
	MOV	B,H
	MOV	D,A
	DAD	B
	NOP
	LHLD	PC
	XCHG
	LHLD	OFFSET
	DAD	D
	MOV	E,M
	INX	H
	MOV	D,M
	CALL	PRNTDE
	LHLD	PC
	INX	H
	INX	H
	SHLD	PC
;Ver 2.2a, del	JMP	TENL
STPLN:	CALL	CRLF
	JMP	TENL
;BUIOD ASCII STRINGS LONGER THAN 8 CHARACTERS.
BMODE:	XRA	A
	STA	BLNGTH
	INR	A
	STA	WRTENAB
	CALL	PSTG
	DB	'DB',9,0
MOREB:	LHLD	PC
	XCHG
	LHLD	OFFSET
	DAD	D
	MOV	A,M
	CPI	LF
	JC	LTLF
	CPI	' '
	JC	LTSPC
	CPI	7FH
	JC	LTRUB
LTSPC:	CALL	PASHEX
	MVI	A,'H'
	CALL	TYPE
	LDA	BLNGTH
	ADI	2
	STA	BLNGTH
	JMP	MVUP
LTLF:	ORI	'0'
	CALL	TYPE
MVUP:	INX	H
	XCHG
	LHLD	PC
	INX	H
	SHLD	PC
	XCHG
;...HAS THE NEXT CONTROL POINT BEEN REACHED?
CNXCTL:	LDA	NXTCTL
	CMP	E
	JNZ	TRYSYM
	LDA	NXTCTL+1
	CMP	D
	JZ	QTB
; TRY FOR A SYMBOL
TRYSYM:	LHLD	PC
	XCHG
	CALL	SYMSCH
;  JUMP IF THERE IS A SYMBOL.
	JNC	STPLN
	LDA	BLNGTH
	ADI	2
	STA	BLNGTH
	CPI	19H
;  JUMP IF ASCII STRING IS TOO LONG.
	JNC	STPLN
	MVI	A,','
	CALL	TYPE
	JMP	MOREB
;...LESS THAN A RUBOUT.
LTRUB:	MVI	A,''''
	CALL	TYPE
	LDA	BLNGTH
	INR	A
	STA	BLNGTH
	MOV	A,M
;...PUT SOME MORE ASCII ONTO THE STRING.
MORASC:	CALL	TYPE
	MOV	A,M
	CPI	''''
;...IF IT'S A QUOTE, DOUBLE IT.
	CZ	TYPE
	INX	H
	XCHG
	LHLD	PC
	INX	H
	SHLD	PC
	XCHG
	LDA	NXTCTL
	CMP	E
	JNZ	YET
	LDA	NXTCTL+1
	CMP	D
	JZ	FNLQT
YET:	PUSH	H
	LHLD	PC
	XCHG
	CALL	SYMSCH
;...JUMP IF THERE IS A SYMBOL.
	POP	H
	JNC	FNLQT
	LDA	BLNGTH
	INR	A
;...KEEP THE LINES LESS THAN 19H LONG.
	STA	BLNGTH
	CPI	'#'
	JNC	LASTQT
	CPI	19H
	JC	STILL
;...OVER 17H CHARACTERS HAVE BEEN TYPED.
	DCX	H
	MOV	A,M
	INX	H
	CPI	' '
	JZ	FNLQT
STILL:	MOV	A,M
	CPI	' '
	JC	LASTQT
	CPI	7FH
	JC	MORASC
;...PRINT A TRAILING QUOTE.
LASTQT:	MVI	A,''''
	CALL	TYPE
	JMP	CNXCTL
FNLQT:	MVI	A,''''
	CALL	TYPE
QTB:	CALL	CRLF
	JMP	TENL
;STATISTIC SPILL...
STAT:	CALL	PSTRNG
	DB	'SYMTBL=',0
	LXI	H,SYMTAB
	CALL	PVALUE
	LHLD	SYMEND
	CALL	PVALUE
	CALL	CRLF
	CALL	PSTRNG
	DB	'PC    =',0
	LHLD	PC
	CALL	PVALUE
	CALL	CRLF
	CALL	PSTRNG
	DB	'OFFSET=',0
	LHLD	OFFSET
	CALL	PVALUE
	CALL	CRLF
	LHLD	COMST
	MOV	A,H
	ORA	L
	JZ	CTLSTT
	CALL	PSTRNG
	DB	'COMNTS=',0
	LHLD	COMST
	CALL	PVALUE
	LHLD	COMEND
	CALL	PVALUE
	CALL	CRLF
CTLSTT:	CALL	CTLST
	CALL	CMNTST
	JMP	GETCMD
CTLST:	CALL	PSTRNG		;PRINT THE START AND END OF CONTROL TABLE
	DB	'CTLTBL=',0
	LXI	H,CTLTBL
	CALL	PVALUE
;...FIND THE END OF THE CTLTBL (FF,FF)
FNDEND:	MOV	A,M
	INX	H
	ANA	M
	INX	H
	INX	H
	INR	A
	JNZ	FNDEND
	DCX	H
	DCX	H
	DCX	H
	CALL	PVALUE
	JMP	CRLF
CMNTST:	CALL	PSTRNG		;PRINT THE STATUS OF SYMBOL COMMENTS
	DB	'SYMBOL COMMENTS: O',0
	LDA	XCSW
	ORA	A
	MVI	A,'N'
	JNZ	CMTST1
	MVI	A,'F'
	CALL	TYPE
CMTST1:	CALL	TYPE
	JMP	CRLF
;FIND THE OCCURRENCE OF ADDRESSES...
FIND:	LXI	H,INBUF+3
	MOV	A,M
	CPI	CR
	JZ	PREVF
	CALL	CNVRT
	XCHG
	SHLD	FNDADD
	LHLD	OFFSET
	SHLD	FNDPC
	XCHG
	CPI	CR
	JZ	PREVF
	CPI	' '
	JZ	FIND0
	CPI	','
	JNZ	WHAT
FIND0:	INX	H
	CALL	CNVRT
	CPI	CR
	JNZ	WHAT
	LHLD	OFFSET
	DAD	D
	SHLD	FNDPC
;...CONTINUE THE PREVIOUS 'F' COMMAND.
PREVF:	LHLD	FNDADD
	XCHG
NYET:	CALL	BRKCHK
	LHLD	FNDPC
	MOV	A,M
	INX	H
	SHLD	FNDPC
	CMP	E
	JNZ	NYET
	MOV	A,M
	CMP	D
	JNZ	NYET
	PUSH	H
	PUSH	D
	CALL	TWOS
	DCX	H
	CALL	PVALUE
	POP	D
	POP	H
	CALL	SPACE
	JMP	NYET
;...TAKE 2'S COMPLEMENT OF OFFSET AND ADD TO H & L.
TWOS:	LDA	OFFSET
	CMA
	MOV	E,A
	LDA	OFFSET+1
	CMA
	MOV	D,A
	INX	D
	DAD	D
	RET
;...CLOSE THE FILE.
CLOSE:	CALL	HSYM
	MVI	A,1
	STA	WRTENAB
	CALL	PSTG
	DB	'END',CR,LF,0
	XRA	A
	STA	WRTENAB
	LDA	FOPEN
	ORA	A
	JZ	GETCMD
	MVI	A,1AH
	CALL	WRTFILE
	CALL	NXTRCRD
	XRA	A
	STA	FOPEN
	CALL	PSTRNG
	DB	'++ASM FILE CLOSED++',CR
	DB	LF,0
	JMP	GETCMD
;----------------------------------------------------------------
;   READ A FILE.
READ:	CALL	SETFCB
	LDA	FOPEN
	ORA	A
	JNZ	CANT
	lxi	h,fcbtype
	lxi	d,tpall
	mvi	c,3
	call	chkstg
	jnz	notall
	lxi	h,tpdoc	;fill in just the FCB type
	call	fixtyp
	call	pstrng
	db	CR,LF
	db	'Reading .DOC file...',CR,LF,0
	call	docrd
	lxi	h,tpsym
	call	fixtyp
	call	pstrng
	db	'Reading .SYM file...',CR,LF,0
	call	symrd
	lxi	h,tpctl
	call	fixtyp
	call	pstrng
	db	'Reading .CTL file...',CR,LF,CR,0
	jmp	isctl
fixtyp:	lxi	d,fcbtype
	mvi	b,3
	xra	a
	sta	fcb+0ch	;zero the extent byte
	jmp	slide
notall:	LXI	H,FCBTYPE
	LXI	D,TPSYM
	MVI	C,3
	CALL	CHKSTG
	JNZ	NOTSYM
	call	symrd
	JMP	STAT
NOTSYM:	LXI	H,FCBTYPE
	LXI	D,TPCOM
	MVI	C,3
	CALL	CHKSTG
	JNZ	NOTCOM
;...THE TYPE IS COM.
	CALL	RDOPEN
	LHLD	OFFSET
	MOV	A,H
;>>>> NOTE: The following compare allows 600H for the symbol table
	CPI	(symtab+600H) shr 8
	JC	OSERR
	LXI	D,0100H
;   SET DMA ADDRESS TO OFFSET PLUS 100H.
	DAD	D
SETDMA:	PUSH	H
;SET THE DMA ADDRESS.
	XCHG
	MVI	C,1AH
	CALL	BDOS
	LXI	D,FCB
;READ A RECORD.
	MVI	C,14H
	CALL	BDOS
	ORA	A
	JNZ	RDCMPLT
	POP	H
	LXI	D,RECLEN
	DAD	D
	JMP	SETDMA
RDCMPLT:	POP	H
	CALL	PVALUE
	CALL	TWOS
	CALL	PVALUE
	CALL	CRLF
;..RESET THE DMA ADDRESS TO 80H.
	LXI	D,RECLEN
	MVI	C,1AH
	CALL	BDOS
	JMP	GETCMD
;THE READ IS NOT A .SYM OR A .COM FILE.
NOTCOM:	LXI	H,FCBTYPE
	LXI	D,TPCTL
	MVI	C,3
	CALL	CHKSTG
	JNZ	NOTCTL
	JMP	ISCTL
NOTCTL:	LXI	H,FCBTYPE
	LXI	D,TPDOC
	MVI	C,3
	CALL	CHKSTG
	JNZ	WHAT
	call	docrd
	JMP	STAT
OSERR:	CALL	PSTRNG
	DB	'++NO, THAT WOULD OVERLAY '
	DB	'THE DISASSEMBLER',CR,LF
	DB	'BECAUSE OFFSET IS TOO SMALL: '
	DB	0
	JMP	PRNTOS
;   IT'S A READ OF THE SYMBOL TABLE.
symrd:	LXI	H,SYMTAB
	CALL	READFILE
	SHLD	SYMEND
	INX	H
	INX	H
;   STORE A NULL LENGTH.
	MVI	M,0
	RET
docrd:	CALL	AREACK
	LHLD	COMST
	CALL	READFILE
	SHLD	COMEND
	MVI	M,0FFH
	INX	H
	MVI	M,0FFH
	RET
;---JUMP ON C/R.
READFILE:	CALL	RDOPEN
RDFL1:	CALL	READMA
	CPI	1AH
;---RETURN IF AN EOF HAS BEEN REACHED.
	RZ
	CPI	9
;---JUMP ON TAB.
	JZ	RDFL1
	CPI	CR
	JZ	RDFL1
	CPI	LF
;---JUMP ON L/F
	JZ	RDFL1
	CALL	NUM1
;---STASH THE ADDRESS.
	MOV	M,E
	INX	H
	MOV	M,D
	INX	H
	PUSH	H
	INX	H
	MVI	B,0
SYMLUP:	CALL	READMA
	CPI	9
;---JUMP ON L/F OR C/R.
	JZ	SYMTERM
	CPI	CR
	JZ	SYMTERM
	MOV	M,A
	INX	H
	INR	B
	JMP	SYMLUP
;---STORE THE LENGTH AND GO FOR ANOTHER.
SYMTERM:	XTHL
	MOV	M,B
	POP	H
	JMP	RDFL1
NUM1:	LXI	D,0
LUP1:	CPI	' '
	RZ
	CPI	1AH
	JZ	ERROR1
	CPI	':'
	JC	NUMER1
	SUI	7
NUMER1:	SUI	'0'
	XCHG
	DAD	H
	DAD	H
	DAD	H
	DAD	H
	ADD	L
	MOV	L,A
	XCHG
	CALL	READMA
	CPI	1AH
	JZ	ERROR1
	JMP	LUP1
;SAVE THE .ASM FILE...
SAVE:	CALL	SETFCB
	LDA	FOPEN
	ORA	A
	JNZ	CANT
	LXI	H,FCBTYPE
	LXI	D,TPALL
	MVI	C,3
	CALL	CHKSTG
	JNZ	NTALL
	lxi	h,tpdoc
	call	fixtyp
	call	pstrng
	db	CR,LF
	db	'Saving .DOC file...',CR,LF,0
	call	docsv
	lxi	h,tpsym
	call	fixtyp
	call	pstrng
	db	'Saving .SYM file...',CR,LF,0
	call	symsv
	lxi	h,tpctl
	call	fixtyp
	call	pstrng
	db	'Saving .CTL file...',CR,LF,0
	jmp	svctl
NTALL:	LXI	H,FCBTYPE
	LXI	D,TPSYM
	MVI	C,3
	CALL	CHKSTG
	JNZ	NTSYM
	call	symsv
	jmp	getcmd
;------------------------------------------------
symsv:	LXI	H,SYMTAB
;SAVE THE SYMBOL TABLE.
SVFL:	CALL	OPEN
LUP2:	MOV	E,M
	INX	H
	MOV	D,M
	INX	H
	MOV	A,M
	INX	H
	MOV	B,A
	ORA	A
	JZ	WRTEOF
	CALL	EXPND
	MVI	A,' '
	CALL	WRTFILE
WRTSYM:	MOV	A,M
	CALL	WRTFILE
	INX	H
	DCR	B
	JNZ	WRTSYM
	MVI	A,CR
	CALL	WRTFILE
	MVI	A,LF
	CALL	WRTFILE
	JMP	LUP2
;  WRITE AN EOF.
WRTEOF:	MVI	A,1AH
	CALL	WRTFILE
	CALL	NXTRCRD
	ret
;EXPAND AN ADDRESS TO ASCII AND SAVE.
EXPND:	MOV	A,D
	CALL	HINIB
	CALL	WRTFILE
	MOV	A,D
	CALL	LONIB
	CALL	WRTFILE
	MOV	A,E
	CALL	HINIB
	CALL	WRTFILE
	MOV	A,E
	CALL	LONIB
	JMP	WRTFILE
;------------------------------------------------------
NTSYM:	LXI	H,FCBTYPE
	LXI	D,TPCTL
	MVI	C,3
	CALL	CHKSTG
	JZ	SVCTL
	LXI	H,FCBTYPE
	LXI	D,TPDOC
	MVI	C,3
	CALL	CHKSTG
	JZ	SVDOC
	LXI	H,FCBTYPE
	LXI	D,TPASM
	MVI	C,3
	CALL	CHKSTG
	JNZ	WHAT
	MVI	A,1
	STA	FOPEN
	XRA	A
	STA	WRTENAB
	CALL	OPEN
	CALL	PSTRNG
	DB	'++WRITING .ASM ENABLED'
	DB	CR,LF,'USE Z COMMAND OR '
	DB	'E CONTROL TO CLOSE FILE++'
	DB	CR,LF,0
	JMP	GETCMD
;SAVE THE COMMENT TABLE.
SVDOC:	call	docsv
	jmp	getcmd	
docsv:	CALL	AREACK
	LHLD	COMEND
	INX	H
	INX	H
	MVI	M,0
	LHLD	COMST
	JMP	SVFL
CANT:	CALL	PSTRNG
	DB	'++NO FILE ACCESSES PERMITTED '
	DB	'UNTIL .ASM CLOSED',CR,LF
	DB	0
	JMP	GETCMD
ERROR1:	CALL	PSTRNG
	DB	'++UNEXPECTED EOF',CR,LF
	DB	0
	JMP	GETCMD
;
;CONTROL TABLE ENTRIES ARE MADE HERE.
;
CTL:	LXI	H,INBUF+3
	MOV	A,M
	CPI	CR
	JZ	CDUMP1
	CALL	CNVRT
	CPI	CR
	JZ	CDUMP
	CPI	' '
	JZ	CTL0
	CPI	','
	JNZ	WHAT
CTL0:	INX	H
	MOV	A,M
	CALL	FITCTL
	JMP	GETCMD
FITCTL0:	PUSH	H
	PUSH	D
	PUSH	PSW
	CALL	SCHCTL
	DCX	H
	JC	FITCTL1
	INX	H
	INX	H
	INX	H
FITCTL1: POP	PSW
	POP	D
	CMP	M
	POP	H
	RZ
;...FIT A NEW ENTRY INTO THE CONTROL TABLE.
FITCTL:	STA	OPCTP
	CALL	SCHCTL
	JC	PLACE
	LDA	OPCTP
	CPI	'I'
	JZ	RNCTL
	CPI	'W'
	JZ	RNCTL
	CPI	'B'
	JZ	RNCTL
	CPI	'S'
	JZ	RNCTL
	CPI	'E'
	JZ	RNCTL
	CPI	'K'
	JNZ	WHAT
	XCHG
	LXI	H,3
	DAD	D
	XCHG
;...DELETE AN ENTRY FROM THE CONTROL TABLE.
CMPCT:	MOV	A,M
	INX	H
	ANA	M
	DCX	H
	INR	A
	JZ	PNTHLL
	MVI	B,3
CMPCT0:	LDAX	D
	MOV	M,A
	INX	D
	INX	H
	DCR	B
	JNZ	CMPCT0
	JMP	CMPCT
PNTHLL:	DCX	H
	DCX	H
	DCX	H
	CALL	CTLST
	JMP	GETCMD
;PLACE AN ENTRY INTO THE CONTROL TABLE.
PLACE:	LDA	OPCTP
	CPI	'K'
	JZ	WHAT
	CPI	'E'
	JZ	LGLCTL
	CPI	'B'
	JZ	LGLCTL
	CPI	'W'
	JZ	LGLCTL
	CPI	'I'
	JZ	LGLCTL
	CPI	'S'
	JNZ	WHAT
LGLCTL:	PUSH	D
	PUSH	H
	LXI	H,CTLTBL
;  LOOP TO THE END OF THE TABLE.
LP2END:	MOV	A,M
	INX	H
	ANA	M
	INX	H
	INX	H
	INR	A
	JNZ	LP2END
	INX	H
	INX	H
	INX	H
	XCHG
	LXI	H,0FFFDH
	DAD	D
	POP	B
;EXPAND THE TABLE BY 3 PLACES
;  UNTIL THE PROPER PLACE IS REACHED.
EXPTBL:	DCX	H
	DCX	D
	MOV	A,M
	STAX	D
	MOV	A,E
	CMP	C
	JNZ	EXPTBL
	MOV	A,D
	CMP	B
	JNZ	EXPTBL
	MOV	H,B
	MOV	L,C
	POP	D
	MOV	M,E
	INX	H
	MOV	M,D
	INX	H
	LDA	OPCTP
	MOV	M,A
	RET
;READ A NEW CONTROL MODE.
RNCTL:	INX	H
	INX	H
	MOV	M,A
	RET
;SEARCH CTL TBL FOR AN ENTRY FOR (DE).
;  MATCH:C=0,Z=1
SCHCTL:	LXI	H,CTLTBL
;...IN NO MATCH THEN C=1.
SMORE:	MOV	A,M
	INX	H
	ANA	M
	DCX	H
	INR	A
	STC
;RETURN IF FFFFH IS AN ADDRESS IN THE TABLE.
	RZ
	INX	H
	MOV	A,D
	CMP	M
	DCX	H
;RETURN FOR NO ENTRY.
	RC
	JNZ	NXTRY
	MOV	A,E
	CMP	M
	RZ
	RC
;MOVE TO THE NEXT TABLE ENTRY.
NXTRY:	INX	H
	INX	H
	INX	H
	JMP	SMORE
;DUMP CONTROL TABLE FROM ADDRESS IN DE.
CDUMP:	CALL	SCHCTL
	JMP	CDUMP2
CDUMP1:	LXI	H,CTLTBL
CDUMP2:	CALL	BRKCHK
	MOV	E,M
	INX	H
	MOV	D,M
	INX	H
	MOV	A,D
	ANA	E
	INR	A
	JNZ	MOREDMP
	CALL	CTLST
	JMP	GETCMD
MOREDMP:	PUSH	D
	PUSH	H
	CALL	SYMSCH
	JC	AHEAD
;   PRINT A SYMBOL WHILE WE'RE HERE.
PRNTSYM:	MOV	A,M
	CALL	TYPE
	INX	H
	DCR	B
	JNZ	PRNTSYM
	MVI	A,':'
	CALL	TYPE
	CALL	CRLF
AHEAD:	POP	H
	POP	D
	CALL	SPACE
	CALL	SPACE
	XCHG
;   PRINT THE ENTRY ADDRESS.
	CALL	PVALUE
	MVI	A,','
	CALL	TYPE
	XCHG
	MOV	A,M
;    PRINT THE ENTRY LETTER.
	CALL	TYPE
	CALL	CRLF
	INX	H
	JMP	CDUMP2
;SAVE THE CONTROL TABLE.
SVCTL:	CALL	OPEN
	LXI	H,CTLTBL
SVCTL1:	MOV	E,M
	INX	H
	MOV	D,M
	INX	H
	MOV	A,D
	ANA	E
	INR	A
	JZ	CTLSVED
	CALL	EXPND
	MVI	A,','
	CALL	WRTFILE
	MOV	A,M
	CALL	WRTFILE
	MVI	A,CR
	CALL	WRTFILE
	MVI	A,LF
	CALL	WRTFILE
	INX	H
	JMP	SVCTL1
;  THE CONTROL TABLE HAS BEEN SAVED.
CTLSVED:	MVI	A,1AH
	CALL	WRTFILE
	CALL	NXTRCRD
	JMP	GETCMD
;----------------------------------------------------------------
ISCTL:	CALL	RDOPEN
	LXI	H,CTLTBL
LUP:	CALL	READMA
	LXI	D,0
;...LOOP UNTIL A ',' INDICATES THE END OF ADDRESS.
NUMLUP:	CPI	1AH
	JZ	TERMF
	CPI	','
	JZ	STRDE
	CPI	':'
	JC	NUM
	SUI	7
NUM:	SUI	'0'
	XCHG
	DAD	H
	DAD	H
	DAD	H
	DAD	H
	ADD	L
	MOV	L,A
	XCHG
	CALL	READMA
	JMP	NUMLUP
;...STORE THE ADDRESS ACCUMULATED IN DE.
STRDE:	MOV	M,E
	INX	H
	MOV	M,D
	INX	H
	CALL	READMA
;...STORE THE CONTROL LETTER.
	MOV	M,A
	INX	H
	JMP	LUP
TERMF:	MVI	M,0FFH
	INX	H
	MVI	M,0FFH
	JMP	STAT
;----------------------------------------------------------------
;COMMENT ROUTINE.  IT ADDS
;   OR LISTS COMMENTS.
CMNT:	CALL	AREACK
	LXI	H,INBUF+3
	MOV	A,M
	CPI	CR
	JZ	LSTCMT
	CPI	'O'		;LOOK FOR 'ON/OFF' SWITCH
	JNZ	CMNT1
	INX	H
	MOV	A,M		;SECOND CHARACTER OF THE COMMENT
	SBI	'F'		;CREATE A 0 FOR 'OFF'
	JZ	CMNT2
	CPI	'N'-'F'		;LOOK FOR AN 'N' (FOR 'ON')
	JNZ	WHAT
CMNT2:	STA	XCSW
	JMP	GETCMD
CMNT1:	CALL	CNVRT
	INX	H
	CPI	CR
	JZ	ONECMT
	CPI	' '
	JZ	CMNT0
	CPI	','
	JNZ	WHAT
;...SAVE THE INPUT BUFFER POINTER.
CMNT0:	PUSH	H
	CALL	COMCHK
	JC	ADDCMT
	CALL	DELCMT
;...SEE IF THERE IS TEXT TO ADD.
ADDCMT:	POP	H
	PUSH	H
	MOV	A,M
	CPI	CR
	JZ	GETCMD
	LHLD	COMEND
	MOV	M,E
	INX	H
	MOV	M,D
	INX	H
;...RECOVER THE INPUT BUFFER POINTER.
	POP	D
	MVI	B,0
;...SAVE TABLE END ADDRESS.
	PUSH	H
STRTXT:	INX	H
	LDAX	D
	MOV	M,A
	INX	D
	INR	B
	LDAX	D
	CPI	CR
	JNZ	STRTXT
	INX	H
	SHLD	COMEND
	MVI	M,0FFH
	INX	H
	MVI	M,0FFH
	POP	H
	MOV	M,B
	JMP	GETCMD
;CHECK FOR A COMMENT AT THIS ADDRESS.
;   MATCH:C=0.
COMCHK:	LHLD	COMST
COMCHK1:	MOV	A,M
	INX	H
	ANA	M
	DCX	H
	INR	A
	STC
;RETURN IF ADDRESS FFFFH HAS BEEN REACHED.
	RZ
	INX	H
	MOV	A,D
	CMP	M
	DCX	H
	JNZ	NXTC
	MOV	A,E
	CMP	M
;THERE IS A COMMENT IF Z=1.
	RZ
NXTC:	INX	H
	INX	H
	MOV	A,M
	CALL	SKIP
	INX	H
	JMP	COMCHK1
ONECMT:	CALL	COMCHK
	JMP	LSTAGN
LSTCMT:	LHLD	COMST
LSTAGN:	CALL	BRKCHK
	MOV	E,M
	INX	H
	MOV	D,M
	INX	H
	MOV	A,D
	ANA	E
	INR	A
	JZ	GETCMD
	XCHG
	CALL	PVALUE
	XCHG
	MVI	A,';'
	CALL	TYPE
	MOV	B,M
;...LIST THE TEXT OF A LINE.
TEXT:	INX	H
	MOV	A,M
	CALL	TYPE
	DCR	B
	JNZ	TEXT
	CALL	CRLF
	INX	H
	JMP	LSTAGN
;...DELETE AN EXISTING COMMENT.
DELCMT:	MOV	A,M
	INX	H
	ANA	M
	INR	A
	RZ
	DCX	H
	PUSH	D
	MOV	D,H
	MOV	E,L
	INX	H
	INX	H
	MOV	A,M
	CALL	SKIP
	INX	H
	MVI	B,0
;...SHIFT (M) TO (DE) UNTIL FFFFH IS ENCOUNTERED.
SHFTCT:	MOV	A,M
	STAX	D
	INX	H
	INX	D
	MOV	C,A
	ANA	B
	INR	A
	MOV	B,C
	JNZ	SHFTCT
	XCHG
	DCX	H
	DCX	H
	SHLD	COMEND
	POP	D
	RET
AREACK:	LHLD	COMST
	MOV	A,H
	ORA	L
	RNZ
	CALL	PSTRNG
	DB	'++COMMAND IGNORED++',CR
	DB	LF,'++Issue ''UNNNN'' to tell '
	DB	'RESOURCE to use address '
	DB	'NNNN',CR,LF,'as the start '
	DB	'of the comments table',CR
	DB	LF,0
	JMP	GETCMD
;
;DEFINE THE COMMENTS AREA.
;
UAREA:	LXI	H,INBUF+3
	MOV	A,M
	CPI	CR
	JZ	WHAT
	CPI	'.'
	JZ	WHAT
	CALL	CNVRT
	XCHG
	MOV	A,H
;>>>>NOTE: The following allows 600h bytes for the symbol
	CPI	(symtab+600H) shr 8
	JC	UAREA0
	SHLD	COMST
	SHLD	COMEND
	MVI	M,0FFH
	INX	H
	MVI	M,0FFH
	JMP	GETCMD
UAREA0:	CALL	PSTRNG
	DB	'++NO!! <'
	DB	0
	mvi	h,(symtab+600H) shr 8
	mvi	l,0
	call	pvalue
	call	crlf
	JMP	GETCMD
;..HANDLE SYMBOLS.
HSYM:	PUSH	D	;print a symbol if it exists.
	PUSH	H
	MVI	A,1
	STA	WRTENAB	;make sure it gets to file.
	LHLD	PC
	XCHG
	CALL	SYMSCH
;JUMP IF THERE IS NO SYMBOL.
	JC	RESUME
	MOV	C,B
	PUSH	H
;...DON'T WANT TO PRINT EXPRESSIONS AS SYMBOLS.
HSYM0:	MOV	A,M
	CPI	'+'
	JZ	HSYM1
	CPI	'-'
	JZ	HSYM1
	INX	H
	DCR	C
	JNZ	HSYM0
	POP	H
	CALL	PRNT	;the symbol is printed
	MVI	A,':'	;.. then its colon
	CALL	TYPE
	CALL	TAB
	CALL	PDERTN
	CALL	CRLF
	JMP	RESUME
HSYM1:	POP	H
RESUME:	XRA	A	;now put address on tube but
	STA	WRTENAB	;.. not into the file.
	CALL	SPACE
	CALL	SPACE
	LHLD	PC
	CALL	PVALUE
	MVI	A,1
	STA	WRTENAB	;get ready for mnemonic and enable file write.
	CALL	TAB
	POP	H
	POP	D
	RET
;------------------------------------------------------------------------
DASM:	CALL	HSYM		;WRITE A SYMBOL IF IT EXISTS
				;.. AND PUT PC ON THE CRT
	LHLD	RPLPTR		;SEE IF THIS LINE IS REPLACED
	MOV	A,H
	ORA	L
	JZ	DASM1
	MOV	B,M
	INX	H		;SKIP THE '*'
	DCR	B
	CALL	NWLN0		;PRINT THE REPLACING LINE AS A COMMENT
	MVI	A,0FFH
	STA	REPLSW		;INDICATE NO MORE PRINTING
DASM1:	LHLD	PC	
	XCHG
	LHLD	OFFSET
	DAD	D		;HL IS NOW THE BIASED PC
	SHLD	BIASED
	XCHG			;DE IS NOW THE BIASED PC
	INX	H
	SHLD	PC		;THE NEW PC (NEXT BYTE)
	XCHG			;DE IS THE BYTE AFTER THE INSTRUCTION
	MOV	B,M
	LXI	H,OPC-4
	CALL	GTCD
	CALL	TYPEOC
	CPI	LF		;TYPES 0 THRU 9 ARE 1 BYTE
	JC	OLDPC		; .. SO DON'T CHANGE THE PC
	LHLD	PC
	INX	H
	CPI	10H		;TYPES 0A THRU 0FH ARE 2-BYTERS
	JC	NEWPC
	CPI	16H		;TYPES 10H THRU 15H ARE 3 BYTES
	JNC	NEWPC
	INX	H
NEWPC:	SHLD	PC
OLDPC:	PUSH	D		;SAVE THE 'E' REGISTER (MAY BE 'X' OR 'Y')
	MOV	E,A
	MVI	D,0
	LXI	H,JMPTBL
	DAD	D		;ADD 2*OPCODE TYPE TO JMPTBL TO GET
	DAD	D		;.. ROUTINE ADDRESS
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG			;HL NOW CONTAINS THE ROUTINE ADDRESS
	POP	D
	PUSH	H
	LHLD	BIASED
	RET			;'RETURN' TO THE ROUTINE
;
GTCD:	LXI	D,4
NXTCD:	DAD	D
NXTCD1:	MOV	A,M
	ORA	A	;SEE IF WE'RE AT THE NEXT MASK YET
	INX	H
	JP	NXTCD1	;JUMP IF NOT
	ANA	B	;MASK OUT VARIABLES IN THE INSTRUCTION
	CMP	M	;CHECK THE GENERIC INSTRUCTION TYPE
	JNZ	NXTCD
	INX	H
	MOV	A,M	;AFTER A MATCH, GET THE OPCODE TYPE
	STA	OPCTP
	RET
;
TOC2:	CPI	20H	;CONVERT SPACES IN THE TABLE TO TABS
	JNZ	TOC1
	MVI	A,9
TOC1:	CALL	TYPE
TYPEOC:	INX	H	;TYPE THE OPCODE THAT HL IS POINTING TO
	MOV	A,M
	ORA	A
	JZ	TYPEOC
	JP	TOC2
	LHLD	PC
	LDA	OPCTP
	RET
;
JMPTBL:	DW	T0		;SIMPLE 1 BYTE INSTRUCTIONS
	DW	T1		;8 BIT, REGISTER ARITHMETIC & LOGICAL
	DW	T2		;DEC & INC
	DW	T3		;DOUBLE REGISTER SINGLE BYTE ARITHMETIC
	DW	T4		;8 BIT LOAD FROM MEMORY
	DW	T5		;8 BIT LOAD TO MEMORY
	DW	T6		;POP's AND PUSH's
	DW	T7		;CONDITIONAL RETURNS
	DW	T8		;THE RST INSTRUCTIONS
	DW	T9		;REGISTER TO REGISTER LOADS
;2 BYTE INSTRUCTIONS
	DW	TA		;8 BIT LOAD IMMEDIATES
	DW	TB		;8 BIT IMMEDIATE ARITH. & LOGICAL
	DW	TC		;IN A,(n)
	DW	TD		;OUT (n),A
	DW	TE		;CONDITIONAL, RELATIVE JUMPS
	DW	TF		;OTHER RELATIVE JUMPS
;3 BYTE INSTRUCTIONS
	DW	T10		;16 BIT LOADS
	DW	T11		;JUMPS & CALLS
	DW	T12		;DIRECT LOADS
	DW	T13		;DIRECT STORES
	DW	T14		;LD (nn),A
	DW	T15		;CONDITIONAL JUMPS & CALLS
;MULTI-BYTE OPCODES
	DW	T16		;THE 'CB' SERIES {1, 1A, 2A}
	DW	T17		;THE 'DD' SERIES {1B thru 25 & 2A}
	DW	T18		;THE 'FD' SERIES {1B thru 25 & 2A}
	DW	T19		;THE 'ED' SERIES {0, 2, 3, 26 thru 2A}
;1 BYTE
	DW	T1A		;THE BIT, RES & SET FOR 'CB'
	DW	T1B		;INDEX REGISTER LOADS
	DW	T1C		;JUMP INDIRECT INDEX REGISTER
	DW	T1D		;INDEX REGISTER ADD
;2 BYTE
	DW	T1E		;INDEX REGISTER ARITH. AND LOGICAL
	DW	T1F		;INDEXED LOAD TO REGISTER
	DW	T20		;INDEXED REGISTER STORE
;3 BYTES AFTER 'DD' OR 'FE'
	DW	T21		;LD xx,nn
	DW	T22		;LD (nn),n
	DW	T23		;LD xx,(nn)
	DW	T24		;LD (xx+d),n
	DW	T25		;THE 'CB' EXTENSIONS TO 'DD' OR 'FD'
;1 BYTE AFTER 'ED'
	DW	T26		;IN r,(C)
	DW	T27		;BLOCK MOVES
;3 BYTES AFTER 'ED'
	DW	T28		;LD (nn),dd
	DW	T29		;LD dd,(nn)
;WHATEVER IS LEFT
	DW	T2A		;INDEFINED OPCODES	
;
;ONE BYTE INSTRUCTIONS, SIMPLE
;
T0:	JMP	DCRLF
;
;ARITHMETIC & LOGICAL, 8 BIT, REGISTER
;
T1:	CALL	PSREG		;PRINT THE SOURCE REGISTER
	JMP	DCRLF
;
;DEC AND INC INSTRUCTIONS
;
T2:	CALL	PDREG		;PRINT THE DESTINATION REGISTER
	JMP	DCRLF
;
;DOUBLE REGISTER SINGLE BYTE
;
T3:	CALL	PXSREG		;PRINT HL, DE, BC, OR SP
	JMP	DCRLF
T4:	CALL	LPAR		;  LD A,(BC or DE)
	CALL	PXSREG
	CALL	RPAR
	JMP	DCRLF
T5:	CALL	LPAR		;  LD (BC or DE),A
	CALL	PXSREG
	CALL	RPAR
	CALL	PCMAA
	JMP	DCRLF
;
;POP AND PUSH
;
T6:	CALL	PXQREG		;PRINT HL, DE, BC, OR AF
	JMP	DCRLF
;
;CONDITIONAL RETURNS
;
T7:	CALL	PRCND
	JMP	DCRLF
;
;THE RST INSTRUCTIONS
;
T8:	MOV	A,M
	ANI	38H
	CALL	PRST
	JMP	DCRLF
;
;REGISTER TO REGISTER LOADS
;
T9:	CALL	PDREG
	CALL	COMMA
	LHLD	BIASED
	CALL	PSREG
	JMP	DCRLF
;
;TWO BYTE INSTRUCTIONS
; 8 BIT IMMEDIATE LOADS
;
TA:	CALL	PDREG
	CALL	COMMA
	LHLD	BIASED
;ARITHMETIC & LOGICAL IMMEDIATES
TB:	INX	H
DTABYT:	MOV	A,M
	CPI	' '
	JC	NOTASC
	CPI	5BH
	JNC	NOTASC
	CALL	PASCII
	MVI	A,''''
	CALL	TYPE
	LDA	XCSW		;WANT SYMBOL COMMENTS?
	ORA	A
	JZ	DCRLF
	CALL	TAB
	CALL	SEMI
NOTASC:	MOV	A,M
	CPI	LF
	JC	NTSC0
	CALL	PASHEX
	MVI	A,'H'
	CALL	TYPE
	JMP	DCRLF
NTSC0:	ADI	'0'
	CALL	TYPE
	JMP	DCRLF
;
;IN
;
TC:	CALL	LPAR	;FOR 'IN A,(C)'
	INX	H
	MOV	A,M
	CALL	PASHEX
	MVI	A,'H'
	CALL	TYPE
	CALL	RPAR
	JMP	DCRLF
;OUT
TD:	CALL	LPAR
	INX	H
	MOV	A,M
	CALL	PASHEX
	MVI	A,'H'
	CALL	TYPE
	CALL	RPAR
	CALL	COMMA
	MVI	A,'A'
	CALL	TYPE
	JMP	DCRLF
;
;CONDITIONAL RELATIVE JUMPS
;
TE:	CALL	PRCND1		;THE SPECIAL CC LIST
	LHLD	BIASED
	CALL	COMMA
;OTHER RELATIVE INSTRUCTIONS
TF:	INX	H
	MOV	A,M
	MOV	E,A
	MVI	D,0
	LHLD	PC
	ORA	A
	JP	PSTV
	DCR	D
PSTV:	DAD	D
	XCHG
	CALL	PRNTDE
	CC	PDERTN
	JMP	DCRLF
;
;THREE BYTE INSTRUCTIONS
;16 BIT LOADS
;
T10:	CALL	PXSREG
	CALL	COMMA
	LHLD	BIASED
;JUMPS AND CALLS
T11	CALL	PRNN
	CC	PDERTN
	JMP	DCRLF
;
;LOAD DIRECT
;
T12:	CALL	DRADR
	CC	PDERTN
	JMP	DCRLF
DRADR:	CALL	LPAR	;PRINT THE VALUE FOR DE IN PARENTHESIS
	CALL	PRNN
	PUSH	PSW
	CALL	RPAR
	POP	PSW
	RET
;
;STORE DIRECT
;
T13:	CALL	DRADR
	PUSH	PSW
	CALL	COMMA
	MVI	A,'H'
	CALL	TYPE
	MVI	A,'L'
	CALL	TYPE
	POP	PSW
	CC	PDERTN
	JMP	DCRLF
;
;STORE ACCUMULATOR DIRECT
;
T14:	CALL	DRADR
	PUSH	PSW
	CALL	PCMAA
	POP	PSW
	CC	PDERTN
	JMP	DCRLF
;
;CONDITIONAL JUMPS & CALLS
;
T15:	CALL	PRCND
	CALL	COMMA
	LHLD	BIASED
	CALL	PRNN
	CC	PDERTN
	JMP	DCRLF
;
;THE 'CB' SERIES LEAD IN
;
T16:	INX	H
	MOV	B,M	;THE SECOND BYTE OF THE INSTRUCTION
	SHLD	BIASED
	LXI	H,OPC2-4
	CALL	GTCD	;FIND THE TYPE OF THE 'CB' INSTRUCTION
	CALL	TYPEOC
	JMP	OLDPC
;
;THE 'DD' SERIES LEAD IN
;
T17:	MVI	E,'X'	;FOR THE 'IX' INSTRUCTIONS
T170:	PUSH	D
	INX	H
	SHLD	BIASED
	MOV	B,M
	LXI	H,OPC3-4
	CALL	GTCD
	CALL	TYPEOC
	POP	D
	CPI	1EH
	JC	OLDPC
	CPI	2AH
	JZ	OLDPC
	CPI	21H
	INX	H
	JC	NEWPC
	INX	H
	JMP	NEWPC
;
;THE 'FD' SERIES LEAD IN
;
T18:	MVI	E,'Y'
	JMP	T170
;
;THE 'ED' SERIES LEAD IN
;
T19:	INX	H
	SHLD	BIASED
	MOV	B,M
	LXI	H,OPC4-4
	CALL	GTCD
	CALL	TYPEOC
	CPI	28H
	JC	OLDPC
	CPI	2AH
	JZ	OLDPC
	INX	H
	INX	H
	JMP	NEWPC
;
;BIT, RES AND SET
;
T1A:	CALL	PBIT
	CALL	COMMA
	CALL	PSREG
	JMP	DCRLF
;
;INDEX REGISTER MOVES
;
T1B:	CALL	PRXX	;TO TYPE EITHER 'IX' OR 'IY'
	JMP	DCRLF
;
;JUMP INDIRECT TO INDEX REGISTER
;
T1C:	CALL	LPAR
	CALL	PRXX
	CALL	RPAR
	JMP	DCRLF
;
;INDEX REGISTER ADDITION
;
T1D:	CALL	PRXX
	CALL	COMMA
	MOV	A,E
	CPI	'X'
	MOV	A,M
	LXI	H,IXREGS
	JZ	T1D0
	LXI	H,IYREGS
T1D0:	CALL	PXREG
	JMP	DCRLF
;
;INDEX REGISTER ARITHMETIC AND LOGICAL
;
T1E:	INX	H
	CALL	PDISP	;PRINT '(IX(Y)+d)
	JMP	DCRLF
;
;INDEXED LOAD TO REGISTER
;
T1F:	CALL	PDREG
	CALL	COMMA
	LHLD	BIASED
	INX	H
	CALL	PDISP
	JMP	DCRLF
;
;INDEXED REGISTER STORE
;
T20:	INX	H
	CALL	PDISP
	CALL	COMMA
	LHLD	BIASED
	CALL	PSREG		
	JMP	DCRLF
;
; LD xx,nn
;
T21:	CALL	PRXX
	CALL	COMMA
	CALL	PRNN
	CC	PDERTN
	JMP	DCRLF
;
; LD (nn),xx
;
T22:	CALL	LPAR
	PUSH	D
	CALL	PRNN
	XCHG		;HL NOW CONTAINS THE NUMBER
	POP	D	;RECOVER THE 'E' REG.  ('X' OR 'Y')
	PUSH	PSW	;SAVE THE CARRY FOR A LATER 'PEDRTN'
	CALL	RPAR
	CALL	COMMA
	CALL	PRXX
	POP	PSW	;THE CARRY FLAG IS RESTORED
	XCHG		;DE AGAIN CONTAINS THE VALUE FOR nn
	CC	PDERTN
	JMP	DCRLF
;
; LD xx,(nn)
;
T23:	CALL	PRXX
	CALL	COMMA
	CALL	LPAR
	CALL	PRNN
	PUSH	PSW	;SAVE Cy VALUE
	CALL	RPAR
	POP	PSW
	CC	PDERTN
	JMP	DCRLF
;
; LD (xx+d),n
;
T24:	INX	H
	CALL	PDISP
	CALL	COMMA
	JMP	TB
;
;THE 'CB' EXTENSIONS TO 'DD' OR 'FD'
;
T25:	INX	H
	INX	H
	MOV	B,M
	LXI	H,OPC2-4
	PUSH	D	;SAVE 'X' OR 'Y'
	CALL	GTCD
	CALL	TYPEOC
	POP	D
	MOV	A,B	;GET THE O.C.
	ANI	7
	CPI	6
	JNZ	ILLEG
	LDA	OPCTP
	LHLD	BIASED
	CPI	1AH
	JC	T1E
	JZ	DD12
ILLEG:	LHLD	PC
	DCX	H
	DCX	H
	SHLD	PC
	JMP	T2A
DD12:	INX	H
	INX	H
	CALL	PBIT
	CALL	COMMA
	DCX	H
	DCX	H
	JMP	T1E
;
; IN r,(C)
;
T26:	CALL	PDREG
	CALL	COMMA
	CALL	LPAR
	MVI	A,'C'
	CALL	TYPE
	CALL	RPAR
	JMP	DCRLF
;
;THE BLOCK MOVES AND I/O
;
T27:	MOV	A,M
	ANI	8
	MVI	A,'I'	;AN INCREMENTING TYPE OF INSTRUCTION?
	JZ	T270
	MVI	A,'D'	;NO, IT WAS DECREMENTING
T270:	CALL	TYPE
	MOV	A,M
	ANI	10H
	JZ	DCRLF
	MVI	A,'R'	;A REPEATING INSTRUCTION TYPE
	CALL	TYPE
	JMP	DCRLF
;
; LD (nn),dd
;
T28:	CALL	LPAR
	CALL	PRNN
	PUSH	PSW	;SAVE Cy VALUE
	PUSH	D	;SAVE THE 'NN' VALUE
	CALL	RPAR
	CALL	COMMA
	LHLD	BIASED
	CALL	PXSREG
	POP	D
	POP	PSW
	CC	PDERTN
	JMP	DCRLF
;
; LD dd,(nn)
;
T29:	CALL	PXSREG
	CALL	COMMA
	LHLD	BIASED
	CALL	LPAR
	CALL	PRNN
	PUSH	PSW
	CALL	RPAR
	POP	PSW
	CC	PDERTN
	JMP	DCRLF
;
;ALL UNDEFINED OPCODES COME HERE FOR A 'DB VALUE' TREATMENT
;
T2A:	LHLD	PC
	DCX	H
	SHLD	PC
	LHLD	BIASED
	DCX	H
	CALL	PSTG
	DB	'DB',9,0
	JMP	DTABYT
;
;
;
;------------------------------------------------------------------------
;
COMMA:	MVI	A,','
	JMP	TYPE
TAB:	MVI	A,9
	JMP	TYPE
SEMI:	MVI	A,';'
	JMP	TYPE
LPAR:	MVI	A,'('
	JMP	TYPE
RPAR:	MVI	A,')'
	JMP	TYPE
PCMAA:	CALL	COMMA
	MVI	A,'A'
	JMP	TYPE
;PRINT THE CONDITION CODE LETTERS FOR THIS INSTRUCTION.
PRCND:	MOV	A,M
	ANI	38H	;FOR A FULL SET OF CONDITION CODES
PRC:	RRC
	RRC
	LXI	H,CNDTAB
	CALL	SKIP
	MOV	A,M
	CALL	TYPE
	INX	H
	MOV	A,M
	CPI	'.'
	CNZ	TYPE
	RET
PRCND1:	MOV	A,M
	ANI	18H
	JMP	PRC
CNDTAB:	DB	'NZZ.NCC.POPEP.M.'
;
;PRINT THE SOURCE REGISTER FOR A BYTE
PSREG:	MOV	A,M
PREG:	LXI	H,REGTAB
	ANI	7
	CPI	6	;MUST CATCH THE (HL) REFERENCES
	JZ	PHLREG
	CALL	SKIP
	MOV	A,M
	JMP	TYPE
PHLREG:	CALL	LPAR
	MVI	A,'H'
	CALL	TYPE
	MVI	A,'L'
	CALL	TYPE
	JMP	RPAR
PDREG:	MOV	A,M	;PRINT THE DESTINATION REGISTER FOR A BYTE
	RAR
	RAR
	RAR
	JMP	PREG
;ADVANCE H&L BY (A)
SKIP:	ADD	L
	MOV	L,A
	RNC
	INR	H
	RET
REGTAB:	DB	'BCDEHLMA'	;'M' IS NEVER PRINTED - '(HL)' IS INSTEAD
;
;PRINT A DOUBLE REGISTER PAIR
PXSREG:	MOV	A,M
	LXI	H,DREGS
	JMP	PXREG
PXQREG:	MOV	A,M
	LXI	H,DREGQ
PXREG:	RAR
	RAR
	RAR
	ANI	6
	CALL	SKIP
	MOV	A,M
	CALL	TYPE
	INX	H
	MOV	A,M
	JMP	TYPE
DREGS:	DB	'BCDEHLSP'
DREGQ:	DB	'BCDEHLAF'
IXREGS:	DB	'BCDEIXSP'
IYREGS:	DB	'BCDEIYSP'
;
PBIT:	MOV	A,M
	RAR
	RAR
	RAR
	ANI	7
	ADI	'0'
	JMP	TYPE
PRXX:	MVI	A,'I'
	CALL	TYPE
	MOV	A,E
	JMP	TYPE
;PRINT A LEADING QUOTE AND THEN THE ASCII
;.. (PRINT '' FOR ').
PASCII:	PUSH	PSW
	MVI	A,''''
	CALL	TYPE
	POP	PSW
	CPI	''''
	JNZ	TYPE
	PUSH	PSW
	CALL	TYPE
	POP	PSW
	JMP	TYPE
;PRINT THE VALUE IN A AS HEX
;  WITH A LEADING ZERO IF NECESSARY
PASHEX:	CPI	0A0H
	JC	PHEX
	PUSH	PSW
	MVI	A,'0'
	CALL	TYPE
	POP	PSW
	JMP	PHEX
;PRINT THE STRING AT (HL) FOR (B) CHARACTERS.
PRNT:	MOV	A,M
	CALL	TYPE
	INX	H
	DCR	B
	JNZ	PRNT
	RET
;
;PRINT A DISPLACEMENT IN THE FORM '(IX+d)'
PDISP:	CALL	LPAR
	CALL	PRXX
	MVI	A,'+'
	CALL	TYPE
	MOV	A,M
	CALL	PASHEX
	MVI	A,'H'
	CALL	TYPE
	JMP	RPAR
;
;PRINT THE NEXT 2 BYTES AS A SYMBOL (AND RETURN Cy=1) IF POSSIBLE
;
PRNN:	INX	H
	MOV	E,M
	INX	H
	MOV	D,M
PRNTDE:	PUSH	D
	CALL	SYMSCH
	JC	NOMTCH
	CALL	PRNT	;GOT ONE, SO PRINT IT
	POP	D
	STC		;INDICATE THAT A SYMBOL WAS PRINTED
	RET
NOMTCH:	LDA	BUILD	;DO WE BUILD A SYMBOL?
	ORA	A
	POP	D
	JZ	NOBLD	;JUST PRINT THE HEX VALUE
	PUSH	D
	CALL	BLDSYM
	POP	D
	JMP	NOBLD
PDERTN:	LDA	XCSW
	ORA	A
	RZ		;DON'T PRINT THE SYMBOL AS A COMMENT
	CALL	TAB	;WE'LL PRINT A VALUE AS A COMMENT
	CALL	SEMI
NOBLD:	MOV	A,D
	ORA	E
	MVI	A,'0'
	JZ	NOBLD1
	MOV	A,D
	ORA	A
	JZ	NOBLD2
	CALL	PASHEX	;PRINT THE HIGH ORDER BYTE
	MOV	A,E
	CALL	PHEX
NOBLD0:	MVI	A,'H'
NOBLD1:	CALL	TYPE
	ORA	A	;CLEAR THE CARRY
	RET
NOBLD2:	MOV	A,E
PRST:	CPI	LF
	JC	NOBLD3
	CALL	PASHEX
	JMP	NOBLD0
NOBLD3:	ADI	'0'
	JMP	NOBLD1
;
;
;<><><><><><><><><><><><><><><> OPCODE TABLES <><><><><><><><><><><><><><><>
;
OPC:	DB	0FFH,0EBH,0,'EX DE,HL'
	DB	0FFH,008H,0,'EX AF,AF'''
	DB	0FFH,0D9H,0,'EXX'
	DB	0FFH,0E3H,0,'EX (SP),HL'
	DB	0FFH,027H,0,'DAA'
	DB	0FFH,0F3H,0,'DI'
	DB	0FFH,0FBH,0,'EI'
	DB	0FFH,076H,0,'HALT'
	DB	0FFH,02FH,0,'CPL'
	DB	0FFH,03FH,0,'CCF'
	DB	0FFH,000H,0,'NOP'
	DB	0FFH,037H,0,'SCF'
	DB	0FFH,0E9H,0,'JP (HL)'
	DB	0FFH,007H,0,'RLCA'
	DB	0FFH,017H,0,'RLA'
	DB	0FFH,00FH,0,'RRCA'
	DB	0FFH,01FH,0,'RRA'
	DB	0FFH,0C9H,0,'RET'
	DB	0FFH,0F9H,0,'LD SP,HL'
	DB	0F8H,088H,1,'ADC A,'
	DB	0F8H,080H,1,'ADD A,'
	DB	0F8H,0A0H,1,'AND '
	DB	0F8H,0B8H,1,'CP '
	DB	0F8H,0B0H,1,'OR '
	DB	0F8H,098H,1,'SBC A,'
	DB	0F8H,090H,1,'SUB '
	DB	0F8H,0A8H,1,'XOR '
	DB	0C7H,005H,2,'DEC '
	DB	0C7H,004H,2,'INC '
	DB	0CFH,009H,3,'ADD HL,'
	DB	0CFH,00BH,3,'DEC '
	DB	0CFH,003H,3,'INC '
	DB	0EFH,00AH,4,'LD A,'
	DB	0EFH,002H,5,'LD '
	DB	0CFH,0C1H,6,'POP '
	DB	0CFH,0C5H,6,'PUSH '
	DB	0C7H,0C0H,7,'RET '
	DB	0C7H,0C7H,8,'RST '
	DB	0C0H,040H,9,'LD '
	DB	0C7H,006H,LF,'LD '
	DB	0FFH,0C6H,0BH,'ADD A,'
	DB	0FFH,0CEH,0BH,'ADC A,'
	DB	0FFH,0E6H,0BH,'AND '
	DB	0FFH,0FEH,0BH,'CP '
	DB	0FFH,0F6H,0BH,'OR '
	DB	0FFH,0D6H,0BH,'SUB '
	DB	0FFH,0DEH,0BH,'SBC A,'
	DB	0FFH,0EEH,0BH,'XOR '
	DB	0FFH,0DBH,0CH,'IN A,'
	DB	0FFH,0D3H,CR,'OUT '
	DB	0E7H,020H,0EH,'JR '
	DB	0FFH,010H,0FH,'DJNZ '
	DB	0FFH,018H,0FH,'JR '
	DB	0CFH,001H,10H,'LD '
	DB	0FFH,0C3H,11H,'JP '
	DB	0FFH,0CDH,11H,'CALL '
	DB	0FFH,03AH,12H,'LD A,'
	DB	0FFH,02AH,12H,'LD HL,'
	DB	0FFH,022H,13H,'LD '
	DB	0FFH,032H,14H,'LD '
	DB	0C7H,0C4H,15H,'CALL '
	DB	0C7H,0C2H,15H,'JP '
	DB	0FFH,0CBH,16H,0,0
	DB	0FFH,0DDH,17H,0,0
	DB	0FFH,0FDH,18H,0,0
	DB	0FFH,0EDH,19H
OPC2:	DB	0F8H,000H,01H,'RLC '
	DB	0F8H,008H,01H,'RRC '
	DB	0F8H,010H,01H,'RL '
	DB	0F8H,018H,01H,'RR '
	DB	0F8H,020H,01H,'SLA '
	DB	0F8H,028H,01H,'SRA '
	DB	0F8H,038H,01H,'SRL '
	DB	0C0H,040H,1AH,'BIT '
	DB	0C0H,080H,1AH,'RES '
	DB	0C0H,0C0H,1AH,'SET '
	DB	080H,000H,2AH
OPC3:	DB	0FFH,0E3H,1BH,'EX (SP),'
	DB	0FFH,0E9H,1CH,'JP '
	DB	0FFH,0F9H,1BH,'LD SP,'
	DB	0FFH,0E1H,1BH,'POP '
	DB	0FFH,0E5H,1BH,'PUSH '
	DB	0CFH,009H,1DH,'ADD '
	DB	0FFH,023H,1BH,'INC '
	DB	0FFH,02BH,1BH,'DEC '
	DB	0FFH,034H,1EH,'INC '
	DB	0FFH,035H,1EH,'DEC '
	DB	0FFH,086H,1EH,'ADD A,'
	DB	0FFH,08EH,1EH,'ADC A,'
	DB	0FFH,096H,1EH,'SUB '
	DB	0FFH,09EH,1EH,'SBC A,'
	DB	0FFH,0A6H,1EH,'AND '
	DB	0FFH,0AEH,1EH,'XOR '
	DB	0FFH,0B6H,1EH,'OR '
	DB	0FFH,0BEH,1EH,'CP '
	DB	0C7H,046H,1FH,'LD '
	DB	0F8H,070H,20H,'LD '
	DB	0FFH,021H,21H,'LD '
	DB	0FFH,022H,22H,'LD '
	DB	0FFH,02AH,23H,'LD '
	DB	0FFH,036H,24H,'LD '
	DB	0FFH,0CBH,25H,0,0
	DB	080H,000H,2AH,0,0
	DB	080H,080H,2AH
OPC4:	DB	0FEH,070H,2AH,0,0	;PREVENTS 'IN (HL),(C)'
	DB	0FFH,044H,00H,'NEG'
	DB	0FFH,045H,00H,'RETN'
	DB	0FFH,046H,00H,'IM 0'
	DB	0FFH,056H,00H,'IM 1'
	DB	0FFH,05EH,00H,'IM 2'
	DB	0FFH,047H,00H,'LD I,A'
	DB	0FFH,04DH,00H,'RETI'
	DB	0FFH,04FH,00H,'LD R,A'
	DB	0FFH,057H,00H,'LD A,I'
	DB	0FFH,05FH,00H,'LD A,R'
	DB	0FFH,067H,00H,'RRD'
	DB	0FFH,06FH,00H,'RLD'
	DB	0CFH,042H,03H,'SBC HL,'
	DB	0CFH,04AH,03H,'ADC HL,'
	DB	0C7H,040H,26H,'IN '
	DB	0C7H,041H,02H,'OUT (C),'
	DB	0E7H,0A0H,27H,'LD'
	DB	0E7H,0A1H,27H,'CP'
	DB	0E7H,0A2H,27H,'IN'
	DB	0F7H,0A3H,27H,'OUT'
	DB	0F7H,0B3H,27H,'OT'
	DB	0CFH,043H,28H,'LD '
	DB	0CFH,04BH,29H,'LD '
	DB	080H,000H,2AH,0,0
	DB	080H,080H,2AH
;--------------------------- END OF OPCODE TABLE ---------------------
;
;   BUILD A SYMBOL IN THE BUFFER FOR THE VALUE IN DE.
BLDSYM:	LXI	H,INBUF
	MVI	M,'L'
	INX	H
	MOV	A,D
	CALL	ACCTOASC
	MOV	A,E
	CALL	ACCTOASC
	LXI	H,INBUF
	MVI	B,5
;..INSERT A SYMBOL ALPHABETICALLY INTO TABLE.
INSERT:	CALL	PLCSYM
	JC	NEWSYM
	MOV	M,E
	INX	H
	MOV	M,D
	RET
NEWSYM:	PUSH	H
	PUSH	D
	PUSH	B
;----------------
;MOVE THE END OF THE TABLE BY LENGTH+3.
	LHLD	SYMEND
	MOV	D,H
	MOV	E,L
	MOV	A,B
	ADI	3
	ADD	L
	MOV	L,A
	MOV	A,H
	ACI	0
	MOV	H,A
	SHLD	SYMEND
;--------------------
	INX	H
	INX	H
;---STORE A NULL LENGTH FOR 'LAST' SYMBOL.
	MVI	M,0
	DCX	H
	DCX	H
	MOV	B,H
	MOV	C,L
	LHLD	SYMRKR
;   EXPAND THE TABLE UNTIL SPACE IS MADE AT THE NEW SPOT.
LUP3:	MOV	A,E
	CMP	L
	JNZ	AHD
	MOV	A,D
	CMP	H
	JZ	STICKAD
AHD:	DCX	D
	DCX	B
	LDAX	D
	STAX	B
	JMP	LUP3
;  ENTER THE ADDRESS AND LENGTH.
STICKAD:	POP	B
	POP	D
	MOV	M,E
	INX	H
	MOV	M,D
	INX	H
	MOV	M,B
	POP	D
;  ENTER THE SYMBOL STRING.
STICKSM:	INX	H
	LDAX	D
	MOV	M,A
	INX	D
	DCR	B
	JNZ	STICKSM
	RET
;FIND SPOT FOR NEW SYMBOL (HL), VALUE DE.
;RTN: C=0 FOR MTCH, HL=SYMBOL
PLCSYM:	PUSH	D
;VALUE SAVED, NOW SAVE SYMBOL STRING ADDRESS.
	PUSH	H
	LXI	H,SYMTAB
ANTHR:	POP	D
	PUSH	D
	INX	H
	INX	H
	PUSH	H
	MOV	A,M
	INX	H
	ORA	A
;...JUMP IF THE END OF THE SYMBOL TABLE HAS BEEN REACHED.
	JZ	NONE
	CMP	B
;..JUMP IF STRING LENGTH IS LESS
	JC	LESS
;..JUMP IF STRING LENGTH IS MORE
	JNZ	NTLESS
	MOV	C,A
	CALL	CHKSTG
	JZ	FOUND
	JC	NONE
LATER:	POP	H
	MOV	A,M
	INX	H
	call	skip
	JMP	ANTHR
FOUND:	POP	H
	DCX	H
	DCX	H
	POP	D
	POP	D
	ORA	A
	RET
LESS:	MOV	C,A
	CALL	CHKSTG
	JNC	LATER
	JMP	NONE
NTLESS:	MOV	C,B
	CALL	CHKSTG
	JZ	NONE
	JNC	LATER
;THERE IS NO SYMBOL TOR THIS VALUE
;  THIS VALUE SHOULD GO AT HL.
NONE:	POP	H
	DCX	H
	DCX	H
	SHLD	SYMRKR
	POP	H
	POP	D
	STC
	RET
;...SEARCH THE SYMBOL TABLE FOR A (DE) ENTRY.
;MATCH: C=0
SYMSCH:	LXI	H,SYMTAB
;... M IS START OF SYMBOL; (B) IS LENGTH.
MORE:	MOV	A,M
	INX	H
	CMP	E
	JNZ	SKPOVR
	MOV	A,M
	CMP	D
	JZ	FNDSYM
SKPOVR:	INX	H
	MOV	A,M
	ORA	A
	STC
	RZ
	INX	H
	ADD	L
	MOV	L,A
	JNC	MORE
	INR	H
	JMP	MORE
;...RETURN WITH NO CARRY AND LENGTH IN B IF MATCHED.
FNDSYM:	INX	H
	MOV	A,M
	INX	H
	MOV	B,A
	ORA	A
	RNZ
	STC
	RET
;PLACE A SYMBOL IN THE SYMBOL TABLE.
;
ENTER:	LXI	H,INBUF+3
	CALL	CNVRT
	MOV	A,M
	CPI	' '
	JZ	ENTER0
	CPI	','
	JNZ	WHAT
ENTER0:	INX	H
	MOV	A,M
	CPI	'.'
	JNZ	WHAT
	push	d	;save the value
	push	h	;save the buffer pointer
;Ensure label to be entered does not exist
	CALL LNGTH	;Get length of label on input
	CALL PLCSYM	;Place symbol CY=match
	JC NOHIT	;Ok - label does not exist
	CALL PSTRNG	;Not ok
	DB BELL,'Duplicate label - not entered',CR,LF,BELL,0
	JMP WHAT	;Exit
;
NOHIT:
	POP H
	POP D
	PUSH D
	PUSH H
	call	symsch	;return with C=0 for match
			;.. B=length   HL=start of string
	jc	enter1	;nothing to delete
	push	h
	call	crlf
	call	prnt
	call	pstrng
	db	' was killed.',BELL,CR,LF,0
	pop	h
	dcx	h
	dcx	h
	dcx	h
	call	kill0
enter1:	pop	h
	call	lngth
	pop	d
	call	insert
	jmp	getcmd
;----------------------------------------------------------------
;   DELETE A SYMBOL FROM THE TABLE.
KILL:	LXI	H,INBUF+3
	MOV	A,M
	CPI	'.'
	JNZ	WHAT
	CALL	LNGTH
	CALL	PLCSYM
	JC	WHAT
	call	kill0
	jmp	getcmd
kill0:	MOV	B,H
	MOV	C,L
	INX	H
	INX	H
	MOV	A,M	;get the length
	INX	H
	call	skip
	XCHG
; DE IS THE START OF THE SYMBOL AFTER THE DEAD ONE.
	LHLD	SYMEND
; SHIFT THE SYMBOL TABLE TO DELETE THE DEAD SYMBOL.
LUP4:	MOV	A,E
	CMP	L
	JNZ	AHD1
	MOV	A,D
	CMP	H
	JZ	DEAD
AHD1:	LDAX	D
	STAX	B
	INX	B
	INX	D
	JMP	LUP4
;  THE SYMBOL IS DEAD.
DEAD:	MOV	H,B
	MOV	L,C
	SHLD	SYMEND
	INX	H
	INX	H
	MVI	M,0
	ret
;SCAN SYMBOL STARTING AT (HL),
; RETURN WITH LENGTH IN B.
LNGTH:	INX	H
	MVI	B,0
	PUSH	H
CHAROK:	MOV	A,M
	INX	H
	INR	B
	CPI	'+'
	JZ	CHAROK
	CPI	'-'
	JZ	CHAROK
	CPI	'0'
	JC	ILLSYM
	CPI	':'
	JC	CHAROK
	CPI	'A'
	JC	ILLSYM
	CPI	5BH
	JC	CHAROK
;...AN ILLEGAL CHARACTER FOUND IN A SYMBOL SCAN.
ILLSYM:	DCR	B
	JZ	WHAT
	DCX	H
	XCHG
	POP	H
	RET
;...CONVERT THE ACCUMULATOR TO HEX ASCII IN MEMORY.
ACCTOASC:	PUSH	PSW
	CALL	HINIB
	MOV	M,A
	INX	H
	POP	PSW
	CALL	LONIB
	MOV	M,A
	INX	H
	RET
; CONVERT THE HIGH NIBBLE TO HEX ASCII.
HINIB:	RAR
	RAR
	RAR
	RAR
LONIB:	ANI	0FH
	CPI	LF
	JC	AHD2
	ADI	7
AHD2:	ADI	'0'
	RET
;PRINT THE HEX CHARACTERS FOR THE VALUE IN A.
PHEX:	PUSH	PSW
	CALL	HINIB
	CALL	TYPE
	POP	PSW
	CALL	LONIB
	JMP	TYPE
;PRINT THE 4 HEX CHARACTERS FOR CONTENTS OF H & L.
PVALUE:	MOV	A,H
	CALL	PHEX
	MOV	A,L
	CALL	PHEX
SPACE:	MVI	A,' '
	JMP	TYPE
;READ HEX ASCII FROM MEMORY, CONVERT AND PLACE IN (DE).
CNVRT:	MOV	A,M
	CPI	'.'
	JZ	ITSASYM
	LXI	D,0
;CONTINUE UNTIL A NON-HEX CHARACTER IS READ.
AGAIN:	MOV	A,M
	CPI	'0'
	RC
	CPI	':'
	JC	NUMER
	CPI	'A'
	RC
	CPI	'G'
	RNC
	SUI	7
NUMER:	SUI	'0'
	XCHG
	DAD	H
	DAD	H
	DAD	H
	DAD	H
	ADD	L
	MOV	L,A
	XCHG
	INX	H
	JMP	AGAIN
;EVALUATE THE SYMBOL IN MEMORY.
;  RETURN WITH VALUE IN DE.
ITSASYM:	CALL	LNGTH
	PUSH	D
	CALL	PLCSYM
	JC	WHAT
	MOV	E,M
	INX	H
	MOV	D,M
	POP	H
	MOV	A,M
	RET
; OPEN A FILE FOR READING.
RDOPEN:	PUSH	H
	LXI	H,0100H
	SHLD	DMAPTR
	XRA	A
	STA	FCBNR
	LXI	D,FCB
;..OPEN A FILE.
	MVI	C,0FH
	CALL	BDOS
	POP	H
	INR	A
	RNZ
	CALL	PSTRNG
	DB	'++FILE NOT FOUND',CR,LF
	DB	0
	JMP	GETCMD
READMA:	PUSH	H
	LHLD	DMAPTR
	MOV	A,H
	CPI	1
;...JUMP IF NOT COMPLETELY READ YET.
	JNZ	NOTREAD
	PUSH	B
	PUSH	D
	LXI	D,FCB
;...READ A RECORD.
	MVI	C,14H
	CALL	BDOS
	ORA	A
	POP	D
	POP	B
	LXI	H,RECLEN
;JUMP IF THERE IS AN EOF BEFORE END OF TABLE IS REACHED.
	JNZ	ERROR
NOTREAD:	MOV	A,M
	INX	H
	SHLD	DMAPTR
	POP	H
	RET
ERROR:	CPI	3
	JC	RDDMA0
	CALL	PSTRNG
	DB	'++UNEXPECTED EOF',CR,LF
	DB	0
	JMP	GETCMD
RDDMA0:	MVI	A,1AH
	MOV	M,A
	JMP	NOTREAD
OPEN:	PUSH	H
	LXI	D,FCB
;ERASE FILE.
	MVI	C,13H
	CALL	BDOS
;MAKE FILE.
	LXI	D,FCB
	MVI	C,16H
	CALL	BDOS
	INR	A
;JUMP IF NO ROOM IN THE DIRECTORY.
	JZ	WHAT
	XRA	A
	STA	FCBNR
	LXI	H,RECLEN
	SHLD	DMAPTR
	POP	H
	RET
;  WRITE THE NEXT RECORD.
NXTRCRD:	LXI	D,FCB
	MVI	C,15H
	CALL	BDOS
	ORA	A
	JNZ	WRTERR
;  CLOSE A FILE.
	LXI	D,FCB
	MVI	C,10H
	CALL	BDOS
	INR	A
	RNZ
	CALL	PSTRNG
	DB	'++CLOSE ERROR',CR,LF,0
	JMP	GETCMD
;...AN ERROR OCCURRED DURING A WRITE RECORD ATTEMPT.
WRTERR:	CALL	PSTRNG
	DB	'++WRITE ERROR',CR,LF,0
;WRITE INTO THE DMA BUFFER,
;  IF IT'S FULL THEN
;    WRITE A RECORD.
WRTFILE:	PUSH	H
	LHLD	DMAPTR
	MOV	M,A
	INR	L
	SHLD	DMAPTR
;...RETURN IF 128 BYTES HAVE NOT YET BEEN WRITTEN.
	POP	H
	RNZ
	PUSH	B
	PUSH	D
	PUSH	H
	LXI	D,FCB
;...WRITE A RECORD.
	MVI	C,15H
	CALL	BDOS
	ORA	A
	JNZ	WRTERR
	LXI	H,RECLEN
	SHLD	DMAPTR
	POP	H
	POP	D
	POP	B
	RET
DCRLF:	LHLD	XCPTR
	MOV	A,H
	ORA	L		;LOOK FOR A COMMENT ADDRESS
	JZ	DCRLF3
	CALL	TAB
	MOV	B,M
	XRA	A
	ORA	B
	JZ	DCRLF2
DCRLF1:	INX	H
	MOV	A,M
	CALL	TYPE
	DCR	B
	JNZ	DCRLF1
DCRLF2:	LXI	H,0
	SHLD	XCPTR
DCRLF3:	SHLD	RPLPTR
	XRA	A
	STA	REPLSW
CRLF:	MVI	A,CR
	CALL	TYPE
	MVI	A,LF
	JMP	TYPE
; PRINT THE PROMPT.
TYPSTR:	MVI	A,'*'
; PRINT THE CHARACTER IN A.
TYPE:	PUSH	B
	PUSH	D
	PUSH	H
	MOV	E,A
	LDA	REPLSW
	ORA	A
	JNZ	NOTLF
	PUSH	D
	MVI	C,2
	LDA	HUSH
	ORA	A
	CZ	BDOS
	POP	D
	LDA	FOPEN
	LXI	H,WRTENAB
	ANA	M
	MOV	A,E
; IF WRITING IS ENABLED AND A FILE IS OPEN THEN WRITE TO IT.
	CNZ	WRTFILE
	MOV	A,E
	CPI	LF
	JNZ	NOTLF
;...DECREMENT THE LINE COUNT IF A LINE FEED WAS SENT.
	LDA	CNTENAB
	ORA	A
	JZ	NOTLF
	LXI	H,EFLNCT+1
	DCR	M
NOTLF:	POP	H
	POP	D
	POP	B
	RET
;
;PROMPT AND READ A COMMAND LINE FROM THE KEYBOARD.
;
PROMPT:	CALL	TYPSTR
	LXI	D,INBUF
	MVI	A,'N'
	STAX	D
; FILL THE INPUT BUFFER.
	MVI	C,LF
	CALL	BDOS
	LXI	H,INBUF+1
	MOV	E,M
	MVI	D,0
	DAD	D
	INX	H
; TERMINATE THE BUFFER WITH A CARRIAGE RETURN.
	MVI	M,CR
	LXI	H,INBUF+1
; CONVERT LOWER CASE TO UPPER CASE.
UPPR:	INX	H
	MOV	A,M
	CPI	CR
	JZ	CRLF
	CPI	61H
	JC	UPPR
	CPI	7BH
	JNC	UPPR
	ANI	5FH
	MOV	M,A
	JMP	UPPR
;
;PRINT THE STRING: ADD. AT TOP OF STACK, TERMINATED BY 00H.
;
PSTRNG:	XRA	A
	STA	WRTENAB
	STA	HUSH
PSTG:	XTHL
LUP5:	MOV	A,M
	CALL	TYPE
	INX	H
	MOV	A,M
	ORA	A
	JNZ	LUP5
	INX	H
	XTHL
	RET
; SOME INITIALIZATION.
INIT:	XRA	A
	STA	SYMTAB+2
	LXI	H,SYMTAB
	SHLD	SYMEND
	MVI	A,CR
	STA	INBUF+3
	LXI	H,0FFFFH
	SHLD	CTLTBL
;
;***** THE NEXT TWO INSTRUCTIONS ARE A MYSTERY !! *****
;
	MVI	A,'I'
	STA	CTLTBL-1
	LHLD	COMST
	MOV	A,H
	ORA	L
	RZ
	SHLD	COMEND
	MVI	M,0FFH
	INX	H
	MVI	M,0FFH
	RET
;RETURN WITH ZERO IF STRINGS (DE) AND (HL) MATCH.
;  LENGTH IS (B).
CHKSTG:	LDAX	D
	CMP	M
	RNZ
	INX	D
	INX	H
	DCR	C
	JNZ	CHKSTG
	RET
;
;  WATCH THE CONSOLE FOR A BREAK KEY.
;
BRKCHK:	PUSH	B
	PUSH	D
	PUSH	H
; CHECK THE CONSOLE.
	MVI	C,0BH
	CALL	BDOS
	ORA	A
; IF ZERO THERE IS NO CONSOLE INPUT.
	JZ	AHD3
; READ THE CONSOLE.
	MVI	C,1
	CALL	BDOS
	CPI	3
	JZ	ABORT
	CALL	CRLF
	JMP	GETCMD
ABORT:	CALL	PSTRNG
	DB	CR,LF,'ABORT Y/N ',0
	MVI	C,1
	CALL	BDOS
	ANI	5FH
	CPI	'Y'
	JZ	0
	JMP	GETCMD
AHD3:	POP	H
	POP	D
	POP	B
	RET
;CHECK FOR AN ASCII CHARACTER.
;  RETURN WITH Z=1 FOR C/R, L/F, & NULL
ISITASC:	CPI	CR
	RZ
	CPI	LF
	RZ
	ORA	A
	RZ
	CPI	' '
;  RETURN WITH C=0 FOR PRINTABLE ASCII.
	RC
	CPI	7FH
	CMC
	RET
	POP	D
	MVI	C,9
	CALL	BDOS
	LHLD	OLDST
	SPHL
	RET
DMPTR:	DW	0100H
DMPLEN:	DW	0100H
OFFSET:	DW	0
SYMEND:	DW	0
PC:	DW	100H
ENDLST:	DW	0FFFFH
BIASED:	DW	0
COMST:	DW	0
COMEND:	DW	0
FNDPC:	DW	0
FNDADD:	DW	0
DMPSET:	DW	7FH
EFLNCT:	DW	0A0AH
CNTENAB:	DB	0
tpall:	db	'ALL'
TPASM:	DB	'ASM'
TPCOM:	DB	'COM'
TPCTL:	DB	'CTL'
TPSYM:	DB	'SYM'
TPDOC:	DB	'DOC.'
WRTENAB:	DB	1
REPLSW:	DB	0
RPLPTR:	DW	0
XCPTR:	DW	0
XCSW:	DB	1
FOPEN:	DB	0
HUSH:	DB	0
NXTCTL:	DW	BLNGTH
BLNGTH:	DB	0
SYMRKR:	DW	0
DMAPTR:	DW	0
ASCBLD:	DB	0
BUILD:	DB	0
OPCTP:	DB	0,0,0
INBUF:	DB	4EH
	DS	004FH
	DS	20H	;FOR THE STACK
OLDST:	DS	2
	END
           