#include "printf.h"

#define YES 1
#define NO 0
#define EOS '\0'

main(argc,argv)
int argc;
char *argv[];


{
	int i;
	char debug, numsort, revord, blankskip, endrec, seteor;
	char *innam, *outnam, *s;

	debug = NO;		/* set program defaults */
	numsort = NO;
	revord = NO;
	blankskip = NO;
	endrec = '\n';		/* default EOR is new line */
	seteor = NO;
	if (argc <= 1) 		/* if no args given */
		usage();	/* print usage message */
	for (i = 1 ; i <= argc ; i++) {		/* loop through all args */
		s = argv[i];		/* point to argument string */
		if (*s == '-') {	/* if option flag */
		    while (*++s != EOS) {	/* while options */
			switch (*s) {	/* find option flag and set it */
			case 'B':
			     blankskip = YES;	/* skip blanks */
			     break;
			case 'D':
			     debug = YES;	/* debug mode */
			     break;
			case 'E':
			     seteor = YES;	/* use diff. EOR char */
			     break;
			case 'N':
			     numsort = YES;	/* sort on numbers */
			     break;
			case 'R':
			     revord = YES;	/* reverse sort */
			     break;
			default:
			     userr(*s);		/* usage error */
			     break;
			}
		    }
		}
		else {
			innam = s;		/* get input file */
			outnam = argv[++i];	/* get output file */
			break;
		}
	}
	if (seteor) {		/* if different EOR char wanted */
		printf("Enter end-of-record character -->");
		endrec = getchar();
	}
	sort(innam, outnam, endrec, revord, numsort, blankskip, debug);
	printf("Finished\n");
}


/* usage - type how to use this program. */

usage()
{
	printf("USAGE:\n");
	printf("sort [-b] [-d] [-e] [-n] [-r] infile outfile\n");
	printf("     infile:   name of file to be sorted\n");
	printf("     outfile:  name of sorted file\n");
	printf("OPTIONS:\n");
	printf("     -b:       skip leading blanks\n");
	printf("     -d:       print debug messages\n");
	printf("     -e:       set alternate EOR character (default: LF)\n");
	printf("     -n:       treat first column as numbers\n");
	printf("     -r:       sort in reverse order (high to low)\n");
	printf("All options default to OFF\n");
	exit();
}


/* userr - print error in usage. */

userr(c)
char c;
{
	printf("-%c is not a legal option.\n\n", c);
	usage();
}
