;
;   EX14.ASM - An enhanced version of EXEC and EX.
;
;   START   05-09-82
;
;   DATE    11-20-82  *LAST MAJOR CHANGE
;
;   HISTORY:
;
;   1.4     11-20-82  fix for 1.3 modification to put CP/M serial # on
;		      a page boundary and refresh it on warm starts.
;		      (Some programs are not subtracting 6 from the
;		       BDOS+1 location when calculating high memory,
;		       MBASIC is one of these)
;
;   1.3     11-07-82  fix for software that expects CP/M serial # below
;		      BDOS JMP address.
;
;   1.2.1   09-16-82  fix for MBASIC execution under EX 1.2 .
;
;   1.2     08-11-82  added '^:' EX runtime re-execute logic function,
;			    '^?' EX runtime wait for carriage return,
;			    logic to prevent input/EX buffer overlap,
;			    logic to insure (Xsub Already Present),
;			    logic to prevent EX runtime recursion loop,
;			and prompt character logic	   [Larry Steeger]
;
;   1.1     08-06-82  added ';;' EX comment's support,
;			    '^.' print suppression function,
;			    '^<...^>' immediate display support,
;			    '^#' EX message suppression function,
;			    '^$' default parameter support,
;			and '^|' cr,lf generation function [Larry Steeger]
;
;   1.0     08-03-82  corrected $^ error and ^<lowercase> error [Larry Steeger]
;
;   ?	    06-19-82  added missing TRUE and FALSE equates [Ron Fowler]
;
;   ?	    05-17-82  corrected last cold boot no active message
;
DATE	EQU	1122H	;SET UP DATE
YEAR	EQU	82H	;SET UP YEAR
MARK	EQU	1	;SET MARK
VERS	EQU	4	;SET VERSION
;
;	EX14.COM IS AN ENHANCEMENT OF EXEC.COM AND EX.COM
;
;	OPTIONS:
;
;	EX <subfile> <parameters> cr
;
;	EX cr
;
;	 ^<?> WILL GIVE CONTROL CHARACTER <?>
;
;	 | WILL BE CR
;
;	 ^| WILL BE CR,LF
;
;	 ^: WILL CAUSE EX TO RE-EXECUTE THE .SUB FILE FROM THE BEGINNING
;
;	 ^? WILL CAUSE EX TO WAIT FOR A CARRIAGE RETURN
;	    (^C WILL ABORT EX AT THIS POINT ALSO)
;
;	 ^$ WILL CAUSE THE REST OF THE LINE TO BE TREATED AS A
;	    SET OF DEFAULT PARAMETERS SEPARATED BY BLANKS TO BE
;	    USED IF THE USER HAS NOT PROVIDED ONE ON EX'S COMMAND LINE.
;
;	 ^# WILL TOGGLE PRINT SUPPRESSION OF EX MESSAGES
;
;	 ^. WILL START PRINT SUPPRESSION OF ALL CHARACTERS
;	    FROM .SUB FILE UNTIL A SUBSEQUENT ^. IS ENCOUNTERED
;
;	 ;; WILL INDICATE THAT THE ;; AND ALL CHARACTERS FOLLOWING IT
;	    UNTIL A LF IS ENCOUNTERED ARE NOT INCLUDED IN EX'S
;	    TEXT BUFFER
;	    (I.E. AN EX ONLY COMMENT)
;
;	 ^<  WILL START IMMEDIATE DISPLAY OF CHARACTERS FROM
;	    THE .SUB FILE UNTIL ^> IS ENCOUNTERED
;	    (I.E. DISPLAY ONLY .SUB INPUT)
;
;	 $<1-9> WILL REPLACE PARAMETER<1-9> IN TEXT FROM THE COMMAND LINE
;
;	 $$ WILL GIVE $
;
;	 $^ WILL GIVE ^
;
;	 $| WILL GIVE |
;
;	 |,cr,lf,1ah will eat last from | to end of buffer
;
;	 ^C FROM CONSOLE WILL ABORT EX
;
FALSE	EQU	0
TRUE	EQU	NOT FALSE
;
DAY0	SET	(DATE AND 0FH)+'0'
DAY1	SET	((LOW DATE) SHR 4)+'0'
MONTH0	SET	((HIGH DATE)AND 0FH)+'0'
MONTH1	SET	(DATE SHR 12)+'0'
;
YEAR0	SET	(YEAR AND 0FH)+'0'
YEAR1	SET	(YEAR SHR 4)+'0'
;
MARK0	SET	MARK+'0'
VERS0	SET	VERS+'0'
;
BELL	EQU	7
CR	EQU	0DH
LF	EQU	0AH
;
PSUP	EQU	80H	;^. PRINT SUPPRESS FLAG
IMON	EQU	81H	;^< IMMEDIATE MODE START
IMOFF	EQU	82H	;^> IMMEDIATE MODE STOP
MSUP	EQU	83H	;^# EX MESSAGE SUPPRESS FLAG
CRWAIT	EQU	84H	;^? EX RUNTIME WAIT FOR CR FLAG
REXEC	EQU	85H	;^: EX RUNTIME RE-EXECUTE FLAG
;JMPMON  EQU	 0FEH	 ;^; EX JMP TO SYSTEM MONITOR
;
WARM	EQU	0
BDISK	EQU	4
BDOS	EQU	5
DFCB	EQU	5CH
DBUFF	EQU	80H
;
;	NOTE: EX14.LIB IS CREATED BY THE EX14.SUB GENERATION PROCESS
;
	MACLIB	EX14
;
$-PRINT
	IF	BASE
$+PRINT
;
;	START OF EX INITIATOR CODE SEGMENT
;
	ORG	100H
;
START:	LXI	H,0
	DAD	SP
	SHLD	CCPSTK	;CCP STACK PTR
	LXI	SP,BEGREL	;USER STACK AREA
	MVI	A,0C9H	; (8080 RET)
	STA	START	;PREVENT RE-ENTRANCE BY ZCPR
	LXI	D,SIGNON;LOGO
	CALL	PRINT
	CALL	EXACTV	;CHECK FOR RECURSION
	LHLD	RELOCL	;GET RELOC PROGRAM LENGTH
	PUSH	H
	POP	B
	PUSH	B	;SAVE LENGTH FOR FUTURE USE
	LHLD	BDOS+1	;GET BASE
	LXI	D,-806H ;GET BEFORE CCP
	DAD	D
	MOV	A,L	;SUBTRACT RELOC LENGTH
	SUB	C
	MOV	E,A
	MOV	A,H
	SBB	B
	MOV	D,A
	PUSH	D	;SAVE NEW TOP/START TO MOVE TO
	LXI	H,BEGREL;START OF MOVE
OMOVE:	MOV	A,B
	ORA	C
	JZ	MOVEND
	DCX	B
	MOV	A,M
	STAX	D
	INX	D
	INX	H
	JMP	OMOVE
;
MOVEND: POP	D	;GET START OF MOVED PROGRAM
	POP	B	;LENGTH OF MOVE PROGRAM
	PUSH	H	;START OF BIT MAP
	MOV	H,D	;MSB OFFSET
	MOV	L,E	;LSB OFFSET
OFFLUP: MOV	A,B	;TEST LENGTH
	ORA	C	;IF 0
	JZ	GOTO	;JUMP TO RELOCATED PROGRAM
	DCX	B	;DECREMENT COUNT
	LDA	COUNT
	INR	A
	STA	COUNT
	ANI	07H
	JNZ	OFFBIT	;NO
	XTHL		;YES, GET BIT MAP
	MOV	A,M	;GET NEXT BYTE
	INX	H	;INCREMENT BIT MAP POINTER
	XTHL		;SAVE FOR LATER
	STA	BITMAP	;KEEP BIT OFFSET
OFFBIT: LDA	BITMAP
	RAL		;TEST FOR OFFSET
	STA	BITMAP	;SAVE NEW BYTE
	JNC	NOFSET	;NO
	DCX	D	;GET BACK TO LSB
	LDAX	D
	ADD	L
	STAX	D
	INX	D	;MSB
	LDAX	D	;YES
	ADC	H	;ADD IN OFFSET
	STAX	D	;PUT IN MOVED PLACE
NOFSET: INX	D	;INCREMENT MOVED POINTER
	JMP	OFFLUP	;CONTINUE WITH RELOCATE
;
GOTO:	POP	D	;RESTORE STACK
	DCX	H	;RELOCATE PROGRAM-1
	PUSH	H	;SAVE TO USE IN RELOCATED PROGRAM
	SHLD	OUTBUF
	INX	H	;GET TO BEGINNING OF RELOCATED PROGRAM
	PUSH	H
	LXI	D,DBUFF+1	;TERMINATE COMMAND LINE WITH CR
	PUSH	D
	LDA	DBUFF
	MOV	L,A
	MVI	H,0
	DAD	D
	MVI	M,CR
	LXI	H,PRMDMY;START AT DUMMY PARAMETER FOR .SUB FILE SPEC
	PUSH	H
	LXI	B,PRMPNL+2
	XRA	A
	CALL	FILL	;CLEAR PTR AREA
	POP	H
	POP	D
	MVI	A,(PRMPNL/2)+1
	STA	PRMMAX	;HIGHEST PARAMETER # + 1 for .SUB SPEC
	CALL	PARMS	;BUILD POINTERS FOR COMMAND LINE PARMS
	LDA	DBUFF	;SEE IF .SUB FILE PRESENT
	ORA	A
	JNZ	OPENSB	;OPEN SUB FILE
	LXI	H,0
	SHLD	LINES	;START LINE COUNTER
	MVI	A,7FH	;GET BUFFER LENGTH
	STA	DBUFF-1
	LXI	H,BEGREL;SET UP OUTPUT BUFFER
	SHLD	INBUF
GETLIN: CALL	CRLF
	LHLD	LINES
	INX	H
	SHLD	LINES
	CALL	DECOUT	;PRINT LINE #
	MVI	E,':'	;GET PROMPT
	CALL	OUTCHR
	MVI	E,' '
	CALL	OUTCHR
	LXI	D,DBUFF-1
	MVI	C,10	;READ CONSOLE BUFFER
	CALL	BDOS
	LXI	D,DBUFF
	LDAX	D	;GET LENGTH
	MOV	B,A
	INX	D
	LHLD	INBUF	;GET INPUT POINTER
	ORA	A	;SEE IF END
	JZ	ENDSTR	;THATS ALL FOLKS
	XCHG
	CALL	MOVE	;MOVE TO INPUT BUFFER
	XCHG
	MVI	M,CR
	INX	H
	MVI	M,LF
	INX	H
	SHLD	INBUF
	JMP	GETLIN
;
OPENSB: LXI	D,DFCB+9
	LXI	H,SUBNAM;MOVE 'SUB' TO DFCB FILE TYPE
	MVI	B,3
	CALL	MOVE
	XRA	A
	STA	DFCB+32
	LXI	D,DFCB
	MVI	C,15	;OPEN FILE
	CALL	BDOS
	INR	A
	JNZ	READTX
	LXI	H,NOSBF2
	LXI	D,DFCB+1
	MVI	B,8	;NAME LENGTH
	CALL	MOVEFN	;MOVE FILE NAME
	MVI	B,3	;TYPE LENGTH
	MVI	M,'.'
	INX	H
	LXI	D,DFCB+9;FILE TYPE POINTER
	CALL	MOVEFN	;MOVE FILE TYPE
	MVI	M,'$'	;END TERMINATER
	JMP	NOSUB
;
READTX: LHLD	INBUF
	XCHG
	LXI	H,80H	;GET SECTOR OFFSET
	DAD	D
	SHLD	INBUF
	MVI	C,26	;SET DMA ADDRESS
	CALL	BDOS
	LXI	D,DFCB
	MVI	C,20	;READ SEQUENTIAL
	CALL	BDOS
	ORA	A
	JZ	READTX	;READ COMPLETE .SUB FILE
	LHLD	INBUF	;MAKE SURE BUFFER'S TERMINATED
	LXI	D,-80H	;GET BACK TO END
	DAD	D
ENDSTR: MVI	M,1AH	;EOF CHARACTER
	SHLD	ENDBUF	;EOB ADDRESS
	MOV	A,L
	SUI	LOW BEGREL+1;SEE IF BUFFER'S EMPTY
	MOV	A,H
	SBI	HIGH BEGREL
	JC	BUFLOW
	XRA	A
	STA	IMFLG1
	STA	IMFLG2
	STA	PRTFLG
	STA	OUTCNT
	LXI	H,1
	SHLD	LINES
	LHLD	OUTBUF
	SHLD	OUTLNE
	SHLD	BUFSTR
	LXI	D,BEGREL
MOVSTR: LDAX	D
	INX	D
	ANI	7FH	;MAKE SURE NO PARITY
	CPI	LF
	JNZ	MOVST0
MOVSTX: CALL	INCR
	JMP	MOVSTR
;
MOVST0: CPI	1AH
	JZ	SETUP
	CPI	'|'	;CARRIAGE RETURN
	JNZ	MOVST1	;NOPE
	PUSH	D	;SAVE OLD POINTER
	INX	D
	INX	D
	LDAX	D	;GET PRESENT LOCATION+3
	POP	D	;GET OLD POINTER
	CPI	1AH	;END OF BUFFER
	JZ	SETUP	;THATS ALL SHE WROTE
	MVI	A,CR
	CALL	INCR	;INCREMENT LINES FOR ERRORS
	JMP	MOVST4
;
MOVST1: MOV	C,A
	LDA	IMFLG1
	CPI	IMON	;IMMEDIATE MODE ON ?
	MOV	A,C
	JZ	MOVST2	;YES..SKIP EX COMMENT PROCESSING
	CPI	';'
	JZ	EXCOMM	;PROCESS POSSIBLE EX COMMENT
MOVST2: CPI	'^'
	JZ	MOVST5	;CONVERT CONTROL CHARACTERS
	CPI	'$'
	CZ	GTPARM	;SUBSTITUTE COMMAND PARAMETER OR CONTROL CHAR.
MOVST3: STA	LCHR
	CPI	CR	;=CR?
	JNZ	MOVST4
	MOV	C,A
	LDA	OUTCNT
	ORA	A	;ANY CHAR?
	MOV	A,C
	JZ	MOVSTR	;NO..USE INPUT CR ONLY IF OTHER NON-CONTROL
;			     CHARACTERS IN CURRENT LINE
MOVST4: CALL	CHRSTR	;ADD TO BUFFER
	CALL	CNTINC	;INCREMENT COUNT
	JMP	MOVSTR
;
MOVST5: CALL	GETCMD	;VALIDATE CONTROL CHARACTERS
	CPI	':'
	JZ	REXC	;RE-EXECUTE
;	CPI	';'
;	JZ	JMPMN	;JMP TO MONITOR
	CPI	'?'
	JZ	GCRW	;CR WAIT
	CPI	'|'
	JZ	GCRLF	;CR,LF GENERATION
	CPI	'$'
	JZ	PRMDEF	;DEFAULT PARAMETERS' LINE
	CPI	'.'
	JZ	PRTSUP	;PRINT SUPPRESS TOGGLE
	CPI	'#'
	JZ	MSGSUP	;MESSAGE SUPPRESS TOGGLE
	CPI	'<'
	JZ	IMPRTY	;IMMEDIATE MODE START
	CPI	'>'
	JZ	IMPRTN	;IMMEDIATE MODE STOP
	JMP	MOVST3	;OTHER CONTROL CODES
;
REXC:	MVI	A,REXEC ;CONVERT '^:' TO RE-EXECUTE FLAG
	JMP	MOVST3
;
;JMPMN:  MVI	 A,JMPMON ;CONVERT '^;' TO JMP TO MONITOR FLAG
;	 JMP	 MOVST3
;
GCRW:	MVI	A,CRWAIT;CONVERT '^?' TO CRWAIT FLAG
	JMP	MOVST3
;
GCRLF:	MVI	A,CR	;GENERATE CR & LF
	CALL	CHRSTR
	MVI	A,LF
	CALL	CHRSTR
	STA	LCHR
	JMP	MOVSTR
;
PRMDEF: PUSH	H
	LXI	H,PRMDFP
	PUSH	H
	LXI	B,PRMDFL
	XRA	A
	CALL	FILL	;CLEAR PTR TABLE
	POP	H
	MVI	A,PRMDFL/2
	STA	PRMMAX	;HIGHEST PARAMETER #
	CALL	PARMS	;BUILD DEFAULT PARAMETERS PTRS
	POP	H
	INX	D	;SKIP CR
	MVI	A,LF
	JMP	MOVSTX	;CONTINUE AT EOL
;
EXCOMM: PUSH	H
	LXI	H,LCHR
	CMP	M	; DOUBLE ;?
	MOV	M,A
	POP	H
	JNZ	MOVST3	;NO...CONTINUE
	MOV	C,A
	LDA	PRTFLG
	CPI	PSUP
	MOV	A,C
	JZ	MOVST3	;PRINT SUPPRESS
	LDA	IMFLG1
	CPI	IMON
	MOV	A,C
	JZ	MOVST3	;IMMEDIATE MODE
	INX	H	;YES..IGNORE PREVIOUS ;
	PUSH	H
	LXI	H,LCHR
	LDA	OUTCNT
	DCR	A	;DROP 1 CHAR.
	STA	OUTCNT
EXCOML: LDAX	D	;IGNORE CHARACTERS UNTIL EOF OR LF
	INX	D
	CPI	1AH	;EOF
	JZ	EXCOMX
	CPI	LF	;LINE FEED
	JNZ	EXCOML
	MOV	M,A
	LDA	OUTCNT
	ORA	A	;ANY CHAR. ON THIS LINE?
	JZ	EXCOM2	;NO...SKIP CR
EXCOM1: POP	H	;YES..FORCE CR
	MVI	A,CR
	CALL	CHRSTR
	MVI	A,LF
	JMP	MOVSTX	;CONTINUE
;
EXCOM2: POP	H
	MVI	A,LF
	JMP	MOVSTX	;CONTINUE
;
EXCOMX: POP	H
	JMP	SETUP
;
MSGSUP: MVI	A,MSUP	;CONVERT '^#' TO MESSAGE SUPPRESS FLAG
	JMP	MOVST3
;
PRTSUP: MVI	A,PSUP	;CONVERT '^.' TO PRINT SUPPRESS FLAG
	PUSH	H
	LXI	H,PRTFLG
	CMP	M	;ALREADY ON?
	JNZ	PRTSST	;NO...SET FLAG
	XRA	A	;YES..CLEAR FLAG
PRTSST: MOV	M,A	;SET/RESET FLAG
	POP	H
	MVI	A,PSUP
	JMP	MOVST3
;
IMPRTY: MVI	A,IMON	;CONVERT '^<' TO IMMEDIATE MODE START
	STA	LCHR
	PUSH	H
	LXI	H,IMFLG1
	CMP	M	;ALREADY ON?
	POP	H
	JZ	MOVSTR	;YES..
	STA	IMFLG1
	STA	IMFLG2
	JMP	MOVST3	;NO...
;
IMPRTN: MVI	A,IMOFF ;CONVERT '^>' TO IMMEDIATE MODE STOP
	STA	LCHR
	PUSH	H
	LXI	H,IMFLG2
	CMP	M	;ALREADY OFF?
	POP	H
	JZ	MOVSTR	;YES..
	STA	IMFLG2
	STA	IMFLG1
	JMP	MOVST3	;NO...
;
CHRSTR: PUSH	PSW	;CHECK FOR INPUT/EX BUFFER OVERLAP
	PUSH	D
	PUSH	H
	LHLD	ENDBUF
	XCHG
	POP	H
	MOV	A,L
	CMP	E
	JNZ	CHRSTX	;LSB<>
	MOV	A,H
	CMP	D
	JZ	OVERL	;MSB=, OVERLAP WILL OCCUR/ABORT EX
;
CHRSTX: POP	D	;ADD CHAR. TO EX'S BUFFER
	POP	PSW
	MOV	M,A
	DCX	H
	RET
;
EXACTV: LHLD	BDOS+1	;CHECK FOR EX RECURSION
	INX	H
	INX	H
	INX	H	;SKIP 1ST JUMP
	MVI	A,'E'
	CMP	M
	RNZ		;NOT 'E'
	INX	H
	MVI	A,'X'
	CMP	M
	RNZ		;NOT 'X'
	INX	H
	MVI	A,0FFH
	CMP	M
	RNZ		;NOT 0FFH
	LXI	D,EXACT
	CALL	PRINT	;EX ALREADY PRESENT
CCPRET: LHLD	CCPSTK
	SPHL
	LDA	4
	RET		;RETURN TO CCP
;
SETUP:	MVI	M,0FFH	;SETUP END OF DATA
	DCX	H
	MVI	M,0FFH
	MOV	A,L	;SETUP EX RECURSION ID, XSUB PRESENT, AND CP/M S/N
	CPI	11	;12 BYTES ON THIS PAGE?
	JNC	SETUP1	;YES..OK
	DCR	H	;NO...DROP DOWN 1 PAGE
SETUP1: MVI	L,11	;FORCE PAGE BOUNDARY FOR CP/M S/N
	MVI	M,0FFH	;SETUP EX RESURSION ID
	DCX	H
	MVI	M,'X'
	DCX	H
	MVI	M,'E'
	DCX	H
	LDA	BDOS+2	;SET UP BDOS JUMP TO PROTECT DATA
	MOV	M,A
	DCX	H
	LDA	BDOS+1
	MOV	M,A
	DCX	H
	MVI	M,JMP
	PUSH	H
	LXI	D,-6
	DAD	D	;PTR TO PSEUDO CP/M SERIAL #
	PUSH	H
	LHLD	BDOS+1
	DAD	D	;PTR TO REAL CP/M SERIAL #
	POP	D
	MVI	B,6
	CALL	MOVE	;SETUP CP/M SERIAL #
	POP	H
	XTHL		;GET JUMP ADDRESS/SAVE TOP OF MEMORY
;
;	(SP)	TOP OF MEMORY ADDRESS
;	(SP+2)	START OF BUFFER ADDRESS
;
	PCHL		;GOTO IT
;
;	ERROR EXITS
;
GETERR: LXI	D,CMDER ;CONTROL CHARACTER INVALID
	CALL	PRINT
	JMP	LINE	;PRINT LINE # AND LINE AND EXIT
;
NODEFP: LXI	D,NOPRM ;UNKNOWN PARAMETER
	CALL	PRINT
	JMP	LINE	;PRINT LINE # AND LINE AND EXIT
;
PRMERR: LXI	D,PMERR
	CALL	PRINT
	JMP	LINE	;PRINT LINE # AND LINE AND EXIT
;
PRMTOO: LXI	D,TOOARG;TOO MANY PARAMETER ARGUMENTS
	CALL	PRINT
	LHLD	ERRLNE
	CALL	EPRT	;PRINT PARAMETER LINE
	JMP	CCPRET
;
BUFLOW: LXI	D,BUFMTY;TEXT BUFFER EMPTY
	CALL	PRINT
	JMP	CCPRET
;
NOSUB:	LXI	D,NOSBF1;.SUB FILE NOT FOUND
	CALL	PRINT
	LXI	D,NOTHER
	CALL	PRINT
	JMP	CCPRET
;
OVERL:	LXI	D,OVERLP;INPUT/EX BUFFER OVERLAP
	CALL	PRINT
	JMP	LINE
;
;	SUBROUTINES
;
;	CONTROL CODES 0-1FH
;	WITH SUPPORT FOR $ . # < >
;
GETCMD: LDAX	D	;GET NEXT CHARACTER
	INX	D	;INCREMENT POINTER
	CPI	'|'
	RZ		;CR,LF GENERATION
	CPI	'a'-1	;LOWERCASE?
	JC	GETUPR	;NOPE
	CPI	'z'+1	;a-z?
	JNC	GETERR	;NOPE
	sui	'a'-'A' ;GET TO UPPERCASE
GETUPR: CPI	'@'	;0-1FH CONTROL CODE?
	JNC	GETCC
;	CPI	';'
;	RZ		;JMP TO MONITOR
	CPI	':'
	RZ		;RE-EXECUTE
	CPI	'?'
	RZ		;CR WAIT
	CPI	'$'
	RZ		;DEFAULT PARAMETERS' LINE
	CPI	'.'
	RZ		;PRINT SUPPRESS TOGGLE
	CPI	'#'
	RZ		;MESSAGE SUPPRESS TOGGLE
	CPI	'<'
	RZ		;IMMEDIATE MODE START
	CPI	'>'
	RZ		;IMMEDIATE MODE STOP
	JMP	GETERR
GETCC:	SUI	40H	;GET CONTROL CODE
	RNC
	JMP	GETERR
;
GTPARM: LDAX	D
	INX	D
	CPI	'$'
	RZ
	CPI	'^'	;UP ARROW
	RZ
	CPI	'|'	;CARRIAGE RETURN
	RZ
	CPI	'1'
	JC	PRMERR
	CPI	'9'+1
	JNC	PRMERR
	SUI	'1'	;GET ACTUAL # (ZERO RELATIVE)
	ADD	A	;DOUBLE FOR OFFSET
	STA	PRMNUM
	PUSH	D
	PUSH	H
	LXI	H,PRMPNT
	CPI	PRMPNL-1
	JNC	NOPARM	;> HIGHEST #
	MOV	E,A
	MVI	D,0
	DAD	D
	MOV	E,M	;GET PARAMETER POINTER
	INX	H
	MOV	D,M
	POP	H
	MOV	A,E
	ORA	D
	JZ	NOPARM	;NO PARAMETER PRESENT, TRY DEFAULTS
MOVPRM: LDAX	D	;MOVE PARAMETER TO BUFFER
	INX	D
	ORA	A
	JZ	ENDPAR
	MOV	M,A
	DCX	H
	JMP	MOVPRM
;
ENDPAR: POP	D
	INX	H
	MOV	A,M
	RET
;
NOPARM: PUSH	H
	LXI	H,PRMDFP;TRY DEFAULT PARAMETERS
	LDA	PRMNUM
	CPI	PRMDFL-1
	JNC	NODEFP	;> HIGHEST #
	MOV	E,A
	MVI	D,0
	DAD	D
	MOV	E,M	;GET PARAMETER POINTER
	INX	H
	MOV	D,M
	POP	H
	MOV	A,E
	ORA	D
	JZ	NODEFP	;NO PARAMETER PRESENT
	JMP	MOVPRM	;MOVE PARAMETER TO BUFFER
;
MOVEFN: LDAX	D
	CPI	' '	;SEE IF SPACE
	RZ
	MOV	M,A
	INX	D	;INCREMENT POINTERS
	INX	H
	DCR	B
	JNZ	MOVEFN
	RET
;
INCR:	PUSH	H	;SAVE OUTPUT POINTER
	LHLD	LINES
	INX	H	;INCREMENT LINE COUNTER
	SHLD	LINES
	LXI	H,LCHR	;CLEAR LAST CHARACTER
	MVI	M,0
	LXI	H,OUTCNT;CLEAR CHARACTER COUNT
	MVI	M,0
	MOV	L,E	;DE=HL
	MOV	H,D
	SHLD	BEGLIN
	POP	H
	SHLD	OUTLNE	;SAVE NEW OUTPUT LINE
	RET
;
CNTINC: CPI	' '	;CONTROL CHARACTER?
	RC		;YES..
	ANI	80H	;SPECIAL CONTROL?
	RNZ		;YES..
	LDA	PRTFLG
	CPI	PSUP	;PRINT SUPPRESS FLAG?
	RZ		;YES..
	LDA	IMFLG1
	CPI	IMON	;IMMEDIATE MODE?
	RZ		;YES..
	LDA	OUTCNT
	INR	A
	STA	OUTCNT
	RET
;
PARMS:	MVI	B,0	;CLEAR PARAMETER COUNTER
	XCHG
	SHLD	ERRLNE	;SAVE IN CASE OF ERROR
	XCHG
;
PARMSL: LDAX	D	;IGNORE LEADING SPACES
	INX	D
	CPI	CR
	JZ	ENDLNE
	CPI	' '
	JZ	PARMSL
	DCX	D
	MOV	M,E
	INX	H
	MOV	M,D
	INX	H
	INX	D
	INR	B	;COUNT+1
	LDA	PRMMAX
	CMP	B
	JC	PRMTOO	;TOO MANY ARGUMENTS
;
ENDPRM: LDAX	D	;GET TO END OF PARAMETER
	INX	D
	CPI	CR
	JZ	ENDLNE
	CPI	' '
	JNZ	ENDPRM
	XRA	A
	DCX	D
	STAX	D	;TERMINATE PARAMETER
	INX	D
	JMP	PARMSL	;IGNORE SPACES BETWEEN PARAMETERS
ENDLNE: XRA	A
	DCX	D
	STAX	D	;TERMINATE LAST PARAMETER
	INX	D
	MVI	A,CR
	STAX	D
	RET
;
PRINT:	MVI	C,9	;PRINT STRING AT (DE)
	CALL	BDOS
	RET
;
EPRT:	MOV	A,M	;PRINT PARAMETER LINE AT (HL)
	CPI	CR
	RZ
	CPI	0
	JNZ	EPRT1
	MVI	A,' '
EPRT1:	INX	H
	PUSH	H
	MOV	E,A
	MVI	C,2
	CALL	BDOS
	POP	H
	JMP	EPRT
;
CRLF:	LXI	D,CRLFS ;PRINT CR/LF
	CALL	PRINT
	RET
;
LINE:	LXI	D,LINEM ;PRINT LINE # AND LINE IN ERROR AND EXIT
	CALL	PRINT
	LHLD	LINES
	CALL	DECOUT	;PRINT LINE #
	CALL	CRLF
	LHLD	BEGLIN
	PUSH	H	;SAVE BEGGING POINTER
FINDCR: MOV	A,M
	INX	H
	CPI	1AH	;END OF BUFFER
	JZ	FOUND
	CPI	CR
	JNZ	FINDCR
FOUND:	MVI	M,0	;END OF STRING
	POP	H	;START OF STRING
	CALL	PRNTHL	;PRINT BAD LINE
	JMP	CCPRET	;THATS ALL FOLKS
;
PRNTHL: MOV	A,M	;PRINT LINE AT (HL)
	INX	H
	ORA	A
	RZ
	MOV	E,A
	PUSH	H	;SAVE POINTER
	CALL	OUTCHR
	POP	H	;GET POINTER BACK
	JMP	PRNTHL
;
OUTCHR: MVI	C,2	;PRINT CHARACTER IN E
	JMP	BDOS
;
DECOUT: PUSH	H	;PRINT DECIMAL LINE NUMBER
	PUSH	D
	PUSH	B
	LXI	B,-10	;RADIX FOR CONVERSION
	LXI	D,-1	;THIS BECOMES NO DIVIDED BY RADIX
DX:	DAD	B	;SUBTRACT 10
	INX	D
	JC	DX
	LXI	B,10
	DAD	B	;ADD RADIX BACK IN ONCE
	XCHG
	MOV	A,H
	ORA	L	;TEST FOR ZERO
	CNZ	DECOUT	;RECURSIVE CALL
	MOV	A,E
	ADI	'0'	;CONVERT FROM BCD TO HEX
	MOV	E,A	;TO E FOR OUTPUT
	MVI	C,2
	CALL	BDOS
	POP	B	;RESTORE REGISTERS
	POP	D
	POP	H
	RET
;
MOVE:	MOV	A,M	;MOVE STRING AT (HL) TO (DE) FOR LENGTH IN B
	INX	H
	STAX	D
	INX	D
	DCR	B
	JNZ	MOVE
	RET
;
FILL:	PUSH	D	; FILL STORAGE AT (HL) WITH CHARACTER IN A
	MOV	E,A	; FOR LENGTH IN BC
	MOV	A,B
	ORA	C
	MOV	A,E
	POP	D
	RZ
	DCX	B
	MOV	M,A
	INX	H
	JMP	FILL
;
;	WORKING STORAGE AREA
;
SUBNAM: DB	'SUB'
LINEM:	DB	' error line # $'
EXACT:	DB	CR,LF,'(Ex Already Present)$'
BUFMTY	DB	CR,LF,'Text buffer empty$'
OVERLP: DB	CR,LF,'Input/EX Buffer Overlap$'
NOPRM:	DB	CR,LF,'No parameter or default parameter$'
PMERR:	DB	CR,LF,'Parameter$'
NOSBF1: DB	CR,LF,'File '
NOSBF2: DB	'filename.typ$'
NOTHER: DB	' not there$'
CMDER:	DB	CR,LF,'Control character$'
TOOARG: DB	CR,LF,'Too many arguments - $'
SIGNON: DB	'EX ',MARK0,'.',VERS0
	DB	'   ',MONTH1,MONTH0,'-',DAY1,DAY0,'-',YEAR1,YEAR0,'$'
CRLFS:	DB	CR,LF,'$'
;
CCPSTK: DW	0	;CCP STACK PTR
IMFLG1: DB	0	;=IMON ENCOUNTERED
IMFLG2: DB	0	;=IMOFF ENCOUNTERED
PRTFLG: DB	0	;=PSUP ON
LCHR:	DB	0	;LAST CHARACTER READ
PRMMAX: DB	0	;HIGHEST PARAMETER #
PRMNUM: DB	0	;CURRENT $<1-9> NUMBER * 2 (ZERO RELATIVE)
ERRLNE: DW	0
BITMAP: DB	0	;PRESENT OFFSET BIT'S
COUNT:	DB	0FFH	;PRESENT OFFSET BIT COUNT
BEGLIN: DW	BEGREL	;BEGINNING OF OLD LINE POINTER
LINES:	DW	1
INBUF:	DW	BEGREL
ENDBUF: DW	0	;END OF INPUT BUFFER
OUTCNT: DB	0
OUTLNE: DW	0
OUTBUF: DW	0
BUFSTR: DW	0
RELOCL: DW	0	;LENGTH OF RELOC PROGRAM(FILLED IN BY SID)
PRMDFP: 		;DEFAULT PARAMETER PTRS
	REPT	9
	DW	0
	ENDM
PRMDFL	EQU	$-PRMDFP
PRMDMY: DW	0	;DUMMY PARAMETER FOR .SUB FILE SPEC.
PRMPNT: 		;COMMAND LINE PARAMETER PTRS
	REPT	9
	DW	0
	ENDM
PRMPNL	EQU	$-PRMPNT
PATCH:			;PATCH AREA
	REPT	32
	DB	'p'
	ENDM
	REPT	30
	DW	0
	ENDM
;
;	INSURE 8 BYTE BOUNDARY FOR REL.UTL(RELS.UTL)
;
?PLOC	SET	$
	IF	(?PLOC MOD 8) GT 0
?PLOC	SET	(?PLOC AND 0FFF8H)+8 ;GET NEXT 8 BYTE BOUNDARY
	ORG	?PLOC
	ENDIF
;
BEGREL: DS	0	;RELOC PROGRAM STARTS HERE (ALSO USED AS BUFFER)
;
	ENDIF
;
;	END OF EX INITIATOR CODE SEGMENT
;
$-PRINT
	IF NOT	BASE
$+PRINT
;
;	START OF EX RELOCATED CODE SEGMENT
;
	ORG	REL
;
EX:	POP	H	;GET TOP OF MEMORY
	SHLD	MEMTOP
	POP	H	;GET START OF BUFFER
	SHLD	REVBUF
	SHLD	SAVBUF
	MOV	A,M
	CPI	MSUP	;1ST CHAR=MESSAGE SUPPRESS?
	JNZ	EX1	;NO...
	DCX	H	;YES..SKIP CHARACTER
	SHLD	REVBUF
	STA	MSUPFL	;SET INITIAL FLAG
EX1:	LXI	SP,MEMTOP
	LHLD	BDOS+1	;GET WARM JUMP FOR STANDARD CCP
	MOV	A,H
	SUI	8
	MOV	H,A
	MVI	L,3	;SET UP FOR WARM CCP JUMP
	SHLD	CCPJMP
	LHLD	WARM+1
	SHLD	WARMPT
	LXI	D,BSWARM
	MVI	B,12
	CALL	MOVE	;MOVE BIOS JUMPS
	LHLD	WARMPT
	XCHG
	LXI	H,LOCJMP
	MVI	B,12
	CALL	MOVE	;MOVE NEW BIOS JUMPS TO BIOS AREA
;
;	EX RUNTIME BIOS INTERCEPT ROUTINES
;
NWARM:	LXI	SP,MEMTOP
	LHLD	REVBUF	;SEE IF WE'RE AT BUFFERS END
	MOV	A,M
	CPI	0FFH	;TEST IT
	JZ	WARMR	;REAL WARM START RETURN
	LHLD	WARMPT
	SHLD	WARM+1
	LHLD	MEMTOP
	SHLD	BDOS+1
	PUSH	H	;RESTORE CP/M S/N
	LXI	D,-6	;
	DAD	D	;HL=BDOS+0
	XTHL		;(SP)=PSEUDO BDOS+0/HL=PSEUDO BDOS+6
	INX	H	;+1
	MOV	E,M	;GET BDOS+6
	INX	H	;
	MOV	D,M	;
	XCHG		;HL=BDOS+6
	LXI	D,-6	;
	DAD	D	;HL=BDOS+0
	POP	D	;DE=PSEUDO BDOS+0
	MVI	B,6	;LENGTH OF S/N
	CALL	MOVE	;
	LXI	D,DBUFF
	MVI	C,26	;SET DMA
	CALL	BDOS
	LXI	H,STARTM;TELL USER WE'RE STILL HERE
	CALL	PMSG
	LDA	BDISK
	MOV	C,A
	LHLD	CCPJMP
	PCHL		;GOTO CONSOLE PROCESSOR
;
;	JMP TABLE TO OVERLAY BIOS
;
LOCJMP: JMP	NWARM	;WARM
	JMP	BCONST	;CONST
	JMP	NCONIN	;CONIN
	JMP	NCONOT	;CONOT
;
;	CONSOLE INPUT INTERCEPT ROUTINE
;
NCONIN:
	LXI	H,0
	DAD	SP	;SAVE RETURN STACK LEVEL
	SHLD	CONSTK
	LXI	H,MEMTOP;SET USER STACK
NCONNL: CALL	BCONST	;GET CONSOLE STATUS
	ORA	A
	JZ	GETBUF	;GET CHARACTER FROM BUFFER
	CALL	BCONIN	;GET CHARACTER
	CPI	'C'-40H ;SEE IF TERMINATE CHARACTER
	JZ	EXABRT
	CPI	'S'-40H ;13H
	JNZ	NCONEX
	CALL	BCONIN	;WAIT FOR NEXT CHARACTER
	ANI	7FH
	LHLD	REVBUF
	INX	H
	MOV	M,A
	SHLD	REVBUF
	MVI	A,'S'-40H;13H
NCONEX: LHLD	CONSTK	;RESTORE CALLER'S STACK
	SPHL
	RET
;
GETBUF: LDA	PSUPFL	;SET PRINT SUPPRESS FLAG FOR NCONOT
	STA	OUTFLG
	CALL	GETCHR	;GET NEXT CHARACTER
;	CPI	JMPMON	;JMP TO MONITOR?
;	JZ	JPMON	;YES..DO IT
	CPI	REXEC	;RE-EXECUTE?
	JZ	REXECR	;YES..RESET BUFFER PTR
	CPI	CRWAIT	;CR WAIT?
	JZ	CRWRTN	;YES..WAIT FOR CR
	CPI	MSUP	;MESSAGE SUPPRESS FLAG?
	JZ	MSUPCK	;YES..TOGGLE FLAG
	CPI	PSUP	;PRINT SUPPRESS ?
	JZ	PSUPCK	;YES..TOGGLE FLAG
	CPI	IMON	;IMMEDIATE MODE START ?
	JZ	IMFLGS	;YES..SET FLAG
	CPI	IMOFF	;IMMEDIATE MODE STOP?
	JZ	IMFLGS	;YES..RESET FLAG
	CPI	CR	;CR?
	JNZ	GETEXT	;NO...EXIT
	XRA	A
	STA	OUTFLG	;YES..RESET PRINT SUPPRESSION
	MVI	A,CR
GETEXT: MOV	C,A
	LDA	IMFLG
	CPI	IMON	;IMMEDIATE MODE ?
	MOV	A,C
	JNZ	NCONEX	;NO...RETURN TO CALLER WITH CHAR
	CALL	BCONOT	;YES..IMMEDIATE ECHO TO CONSOLE
	JMP	NCONNL	;...LOOP UNTIL IMOFF
;
REXECR: LHLD	SAVBUF	;START AT TOP OF BUFFER AGAIN
	SHLD	REVBUF
	XRA	A
	STA	IMFLG	;RESET ALL FLAGS
	STA	PSUPFL
	STA	MSUPFL
	JMP	NCONNL	;...LOOP UNTIL ^C
;
CRWRTN: CALL	BCONST	;WAIT FOR CHAR.
	JZ	CRWRTN
	CALL	BCONIN
	CPI	'C'-40H
	JZ	EXABRT	;=^C
	CPI	CR
	JZ	CRWRTX	;=CR
	MVI	C,BELL
	CALL	BCONOT	;<>CR
	JMP	CRWRTN
;
CRWRTX: MOV	C,A	;ECHO CR/LF
	CALL	NCONOT
	MVI	C,LF
	CALL	NCONOT
	JMP	GETBUF
;
PSUPCK: LXI	H,PSUPFL
	CMP	M
	JNZ	PSUPST	;SET FLAGS IF NOT EQUAL
	XRA	A	;ELSE RESET FLAGS
PSUPST: MOV	M,A	;SET/RESET SAVED FLAG
	JMP	GETBUF	;AND GET NEXT CHARACTER(SETS EXEC FLAG)
;
MSUPCK: LXI	H,MSUPFL
	CMP	M
	JNZ	MSUPST	;SET FLAGS IF NOT EQUAL
	XRA	A	;ELSE RESET FLAG
MSUPST: MOV	M,A	;SET/RESET FLAG
	JMP	GETBUF	;AND GET NEXT CHARACTER
;
IMFLGS: STA	IMFLG	;SET/RESET IMMEDIATE MODE FLAG
	JMP	GETBUF	;GET NEXT CHARACTER
;
;JPMON:  DI		 ;DISABLE INTERRUPTS
;	 LHLD	 BDOS+1  ;SAVE BDOS JMP LOCATION
;	 SHLD	 BDOSVE  ;
;	 XRA	 A	 ;STOP H37 DRIVES
;	 OUT	 078H	 ;
;	 LDA	 0DH	 ;GET H88.CTL PORT VALUE
;	 ANI	 0CCH	 ;MASK 4MHZ, ORG-0, 2MS CLOCK, AND SINGLE-STEP OFF
;	 OUT	 0F2H
;	 JMP	 0	 ;JMP TO MTR90
;
;	CONSOLE OUTPUT INTERCEPT ROUTINE
;
NCONOT: LDA	OUTFLG	;PRINT SUPPRESSION?
	ORA	A
	RNZ		;YES...IGNORE ECHO
	MOV	A,C
	STA	PMCHR
	JMP	BCONOT
;
GETCHR: LHLD	REVBUF
	MOV	A,M
	DCX	H
	SHLD	REVBUF
	CPI	0FFH	;EOB?
	RNZ		;NO...RETURN
	LHLD	REVBUF
	INX	H	;POINT TO EOB
	SHLD	REVBUF
	CALL	MOVBAK	;MOVE JUMPS BACK
	LHLD	MEMTOP	;SEE IF BDOS+1=MEMTOP
	XCHG
	LHLD	BDOS+1
	MOV	A,E
	SUB	L
	MOV	A,D
	SBB	H
	JNZ	EXEND	;DON'T REPLACE BDOS JUMP
	INX	D	;GET TO BDOS JUMP
	LDAX	D
	MOV	L,A	;LSB
	INX	D
	LDAX	D
	MOV	H,A
	SHLD	BDOS+1
EXEND:	CALL	PMCHRS
	LXI	H,DONEM ;TELL USER WE'RE DONE
	CALL	PMSG
	LHLD	CONSTK	;GET OLD STACK
	SPHL
	JMP	BCONIN
;
;	^C ABORT EXIT
;
EXABRT: LXI	SP,MEMTOP	;^C ABORTS EX
	LXI	H,ABORTD
	CALL	PMSG
	JMP	WARMX
;
WARMR:	CALL	PMCHRS
	LXI	H,DONEM ;END MESSAGE
	CALL	PMSG
;
WARMX:	CALL	MOVBAK	;MOVE JUMPS BACK
	JMP	WARM
;
;	SUBROUTINES
;
MOVBAK: LHLD	WARMPT	;MOVE OLD JUMP TABLE BACK TO BIOS
	XCHG
	LXI	H,BSWARM
	MVI	B,12
	CALL	MOVE
	CALL	F121	;CALL 1.2.1 FIX FOR MBASIC	1.1.2
	RET
;
MOVE:	MOV	A,M	;MOVE STRING FROM (HL) TO (DE) FOR LENGTH IN B
	INX	H
	STAX	D
	INX	D
	DCR	B
	JNZ	MOVE
	RET
;
PMCHRS: LDA	PMCHR	;SET PROMPT CHAR ONLY IF SPECIAL CHARACTER
	CPI	' '+1
	RC
	CPI	'0'
	JC	PMCHRX
	CPI	'9'+1
	RC
	CPI	'A'
	JC	PMCHRX
	CPI	'Z'+1
	RC
	CPI	'a'
	JC	PMCHRX
	CPI	'z'+1
	RC
PMCHRX: STA	DONEC
	RET
;
PMSG:	LDA	MSUPFL	;PRINT MESSAGE AT (HL)
	CPI	MSUP	;MESSAGES SUPPRESSED?
	RZ		;YES..EXIT
	PUSH	H
PMSGL:	POP	H
	MOV	A,M
	CPI	'$'	;EOM?
	RZ		;YES..EXIT
	INX	H
	PUSH	H
	MOV	C,A
	CALL	BCONOT
	JMP	PMSGL
;
F121:	LXI	H,BSWARM	; INSURE ONLY BIOS	1.1.2
	LXI	D,NWARM 	;  CALLS FROM NOW ON	1.1.2
	MVI	B,3		;   FOR PROGRAMS	1.1.2
	CALL	MOVE		;    THAT MAY HAVE	1.1.2
	LXI	H,BCONIN	;     COPIED OUR	1.1.2
	LXI	D,NCONIN	;      ADDRESSES AS	1.1.2
	MVI	B,3		;	IF THEY WERE	1.1.2
	CALL	MOVE		;	 IN THE BIOS.	1.1.2
	LXI	H,BCONOT	;  (MBASIC DOES THIS)	1.1.2
	LXI	D,NCONOT	;			1.1.2
	MVI	B,3		;			1.1.2
	CALL	MOVE		;			1.1.2
	RET			;			1.1.2
;
;	WORKING STORAGE AREA
;
ABORTD: DB	CR,LF,'>>>Ex Aborted<<<',CR,LF,'$'
STARTM: DB	CR,LF,'(Ex Active)$'
DONEM:	DB	CR,LF,'(Ex Completed)',CR,LF
DONEC:	DB	'>$'
;
	REPT	10
	DW	0
	ENDM
MEMTOP: DW	0
REVBUF: DW	0
SAVBUF: DW	0
CCPJMP: DW	0
WARMPT: DW	0
;
;	ORIGINAL BIOS JMP TABLE
;
BSWARM: JMP	$
BCONST: JMP	$
BCONIN: JMP	$
BCONOT: JMP	$
;
PMCHR:	DB	0
PSUPFL: DB	0
OUTFLG: DB	0
IMFLG:	DB	0
MSUPFL: DB	0
CONSTK: DW	0
;	 DB	 'BDOS>'
;BDOSVE: DW	 0
;
?PLEN	SET	$
	IF (?PLEN MOD 8) GT 0
?PLEN	SET	(?PLEN AND 0FFF8H)+8;GET NEXT BOUNDARY
	ENDIF
;
DRVERL	EQU	?PLEN
;
DRVL8	EQU	DRVERL/8	;LENGTH OF RELOCATION BIT MAP
	ORG	DRVERL
;
	ENDIF
;
;	END OF EX RELOCATED CODE SEGMENT
;
	END

;
DRVL8	EQU	DRVE