;*************************************************************************
;
; Big Board I Cursor Character Setting Program.
; Written by Andy Robinson.
;
; This routine does the menial task of setting the cursor character
; displayed by PFM to any of the valid displayable ASCII characters as well
; as the graphics characters that correspond to ^A thru ^_. The choice also
; includes blinking. I wrote this up to help me when I use Wordstar as its
; easy to lose the cursor in a space on the screen if it doesn't blink.
; After reading issue #9 I realised some people may have never seen the
; graphics characters - here's an easy way to see them. This is written
; for the CP/M assembler as I've used it more than any other and everybody
; has it.
;*************************************************************************
BOOT	EQU	00H		;Standard CP/M warm boot
BDOS	EQU	05H		;Basic Disk Op. System call address
CRSCHR	EQU	0FF76H		;Location of cursor character in PFM
BLINK	EQU	080H		;Blink offset
CONOUT	EQU	09H		;Console Output function number for CP/M call
CONIN	EQU	01H		;Console Input function number for CP/M call
CNTRLC	EQU	03H		;^C constant
CR	EQU	0DH		;Carriage Return constant
LF	EQU	0AH		;Line Feed constant
TAB	EQU	09H		;Tab constant
CASE	EQU	020H		;Upper-Lower case offset
YES	EQU	01H		;Yes answer constant
NO	EQU	00H		;No answer constant
;
;
	ORG	0100H		;Standard CP/M TPA base
CURSOR	EQU	$
	LXI	D,SIGNON	;Print sign-on message
	MVI	C,CONOUT
	CALL	BDOS
Q1	LXI	D,QUERY1	;Print cursor character question
	MVI	C,CONOUT
	CALL	BDOS
	MVI	C,CONIN		;Get user's 1 character response
	CALL	BDOS
	STA	CHAR		;Save responsein CHAR
	LXI	D,QUERY2	;Set address of question about blinking
	CALL	GETYN		;Get a yes/no response
	LDA	ANSWER		;See what the response was 0=no, 1=yes
	CPI	NO		;If no, don't add the blink offset
	JZ	NOBLNK
	LDA	CHAR		;Recover character, add blink offset
	ADI	BLINK
	STA	CHAR		;Save it in CHAR
NOBLNK	LDA	CHAR		;Recover the cursor character
	LXI	H,CRSCHR	;Set the byte in PFM to the new character
	MOV	M,A
	LXI	D,QUERY3	;Set address of satisfactory question
	CALL	GETYN		;Get a yes/no response
	LDA	ANSWER		;See what the answer was
	CPI	NO		;If no, go back to Q1 and ask character again
	JZ	Q1
	JMP	BOOT		;Done, return to CP/M
;
; Routine to get a yes/no response from the console. Puts result in
; ANSWER coded as 1 = yes, 0 = no. Location of prompt is passed in D,E
;
GETYN	PUSH	B		;Save caller's registers (habit)
	PUSH	H
	PUSH	D
ASK	MVI	C,CONOUT	;Print prompt
	CALL	BDOS
	MVI	C,CONIN		;Get user's response
	CALL	BDOS
	CPI	CNTRLC		;See if user wants to abandon
	JZ	BOOT
	CPI	'a'		;Translate to upper case to be sure
	JM	NOSUB
	SUI	CASE
NOSUB	CPI	'Y'		;See what answer was
	JZ	YESANS
	CPI	'N'
	JZ	NOANS
	POP	D		;Answer was bad, restore prompt address
	PUSH	D		;and ask again
	JMP	ASK
YESANS	MVI	A,YES		;Set ANSWER to yes and return
	STA	ANSWER
	JMP	GO
NOANS	MVI	A,NO		;Set ANSWER to no and return
	STA	ANSWER
GO	POP	D		;Restore caller's registers
	POP	H
	POP	B
	RET
;
; Storage definitions
;
CHAR	DS	1
ANSWER	DS	1
SIGNON	DB	TAB,TAB,'Big Board I Cursor Character Selection Routine'
	DB	CR,LF,LF,'$'
QUERY1	DB	CR,LF,'Enter desired cursor character: $'
QUERY2	DB	CR,LF,'Blinking cursor? (Y/N) $'
QUERY3	DB	CR,LF,'This is the result. OK? (Y/N) $'
;
	END
