REM ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
REM
REM	DATABASE EXAMPLE   VERSION 6.3 1/1/82
REM
REM ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
REM
REM 	LINK TO MICRO B+(tm)
REM
REM	THIS PROGRAM USES 6 BUFFERS, 3 KEYS, AND 4 NODE SECTORS;
REM
REM 	CNTRFACE.BAS CONTAINS THE EXTERNAL DEFINITIONS OF THE
REM	MICRO B+(tm) ROUTINES
REM
%INCLUDE CNTRFACE.BAS
REM
REM ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
REM
REM	 SET-UP DATABASE FIELD & KEY DESCRIPTORS
REM
REM ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
	DIM FLD.NAME$(7),FLD.LEN%(7),NEW.FLD$(7),OLD.FLD$(7)
	DIM FLD.PTR%(7)
	MAX.FIELD%=7:NO.FIELDS%=MAX.FIELD%+1
	FLD.NAME$(0)="Customer Number" :FLD.LEN%(0)=4
	FLD.NAME$(1)="First Name"      :FLD.LEN%(1)=16
	FLD.NAME$(2)="Last Name"       :FLD.LEN%(2)=20
	FLD.NAME$(3)="Street Address"  :FLD.LEN%(3)=20
	FLD.NAME$(4)="City"            :FLD.LEN%(4)=20
	FLD.NAME$(5)="State"           :FLD.LEN%(5)=2
	FLD.NAME$(6)="Zipcode"         :FLD.LEN%(6)=9
	FLD.NAME$(7)="Customer Status" :FLD.LEN%(7)=8
REM
	DIM KEY.NAME$(2),KEY.LEN%(2),KEY.MAP%(2),KEY.TYPE%(2),MAX.KV%(2)
	MAX.KEY%=2
	KEY.LEN%(0)=10:KEY.TYPE%(0)=0:KEY.MAP%(0)=2 REM   KEY 0 = LAST NAME
	KEY.LEN%(1)=11:KEY.TYPE%(1)=0:KEY.MAP%(1)=6 REM   KEY 1 = ZIPCODE
	KEY.LEN%(2)=2 :KEY.TYPE%(2)=1:KEY.MAP%(2)=0 REM   KEY 2 = CUST NUMBER
	UNIQ.KEY%=2 REM  USED IN TEST OF UNIQUENESS
	FOR KEY%=0 TO MAX.KEY%
		KEY.NAME$(KEY%)=FLD.NAME$(KEY.MAP%(KEY%))
	NEXT KEY%
	DIM INDEX.NAME$(2)
	INDEX.NAME$(0)="K:NAME.IDX"
	INDEX.NAME$(1)="K:ZIPC.IDX"
	INDEX.NAME$(2)="K:NUMB.IDX"
REM
	NLOCK%=0 REM IGNORE LOCKS
	SLOCK%=1 REM SHARED RECORD LOCK
	XLOCK%=2 REM EXCLUSIVE RECORD LOCK
	RLOCK%=4 REM RELEASE SLOCK% OR XLOCK%
REM
REM ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
REM
REM		BEGINNING OF UTILITY FUNCTIONS
REM
REM
REM :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
REM
REM 		CLEAR SCREEN ROUTINE
REM
REM :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
DEF FN.CLEAR.SCREEN%
	FOR DUMMY%=1 TO 24
		PRINT
	NEXT DUMMY%
	RETURN
FEND
REM
REM :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
REM
REM 		MAIN MENU ROUTINE
REM
REM :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
DEF FN.MAIN.MENU%
	PRINT TAB(21);"MICRO B+(tm) DEMONSTRATION" :PRINT
	PRINT TAB(20);"Customer Database Operations"
	PRINT TAB(20);"      Terminal ";TERMINAL%
	PRINT TAB(20);"****************************":PRINT :PRINT
	PRINT TAB(5);"1. Enter New Customers"
	PRINT TAB(5);"2. Scan/Update/Delete Customer Records"
	PRINT TAB(5);"3 Lis Custome Records"
	PRINT TAB(5);"4 Databas Statistics"
	PRINT TAB(5);"5 Sav Al File  Restar Operations"
	PRINT TAB(5);"6. Terminate Operations":PRINT :PRINT
1000	INPUT "Ente desire operatio number>>";OP%
	IF OP%<1 OR OP%>6 THEN PRINT :PRINT :GOTO 1000
	FN.MAIN.MENU%=OP%
	RETURN
FEND

REM
REM :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
REM
REM 		SELECT SEARCH KEY ROUTINE
REM
REM :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
DEF FN.SEARCH.KEY%
	DUMMY%=FN.CLEAR.SCREEN%
	PRINT TAB(25);"Customer Database Search Keys":PRINT :PRINT
	FOR KEY%=0 TO MAX.KEY%
		KEY.NO%=KEY%+1
		PRINT TAB(5);KEY.NO%;"- ";KEY.NAME$(KEY%)
	NEXT KEY%
1040	PRINT :PRINT
	INPUT "Enter desired key number>>";OP%
	IF OP%<1 OR OP%>NO.KEYS% THEN 1040
	FN.SEARCH.KEY%=OP%-1
	RETURN
FEND
REM
REM ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
REM
REM 		ERROR HANDLING
REM
REM ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
DEF FN.ERROR.TYPE%(TYPE%)	
	PRINT
	PRINT "User Error #";ERRCOD;" occurred while trying to ";
	ON TYPE% GOTO 9210,9230,9250,9290,9300,9320,9330,9340,9350,9360, \
		9370,9380
9210	PRINT "access ";INDEX.NAME$(KEY%) : GOTO 9700
9230	PRINT "search ";KEY.NAME$(KEY%);" Index File" : GOTO 9500 
9250	PRINT "save ";INDEX.NAME$(KEY%) : GOTO 9600 
9290	PRINT "remove old key from ";INDEX.NAME$(KEY%) : GOTO 9500
9300	PRINT "enter key into ";INDEX.NAME$(KEY%) :GOTO 9500
9320	PRINT "delete key from ";INDEX.NAME$(KEY%) :GOTO 9500
9330	PRINT "save ";FILE.NAME$ :KEY%=-1:GOTO 9600
9340	PRINT "get a new data record":GOTO 9700
9350	PRINT "delete data record #";DRN% :GOTO 9700
9360	PRINT "open ";FILE.NAME$ :GOTO 9700
9370	PRINT "read data record #";DRN%:GOTO 9700
9380	PRINT "write data record.":GOTO 9700	
9500	CALL CLDATA(FILE.NO%)
	FOR T.KEY%=0 TO MAX.KEY%
		IF T.KEY%<>KEY% THEN CALL CLSIDX(T.KEY%)
	NEXT T.KEY%
	GOTO 9700 REM  STOP ERROR MESSAGE
9600	T.KEY%=KEY%+1
	IF T.KEY%>MAX.KEY% THEN STOP
	FOR KEY%=T.KEY% TO MAX.KEY%
		CALL CLSIDX(KEY%)
	NEXT KEY%
9700	PRINT
	PRINT "DEMONSTRATION TERMINATING WITH ERROR CODE #";ERRCOD
	STOP
FEND
DEF FN.LOCK.TYPE%(TYPE%)
	PRINT "Lock Type: ";TYPE%;"  Lock Code:";LOKCOD
	CALL CLDATA(FILE.NO%)
	FOR T.KEY%=0 TO MAX.KEY%
		CALL CLSIDX(T.KEY%)
	NEXT T.KEY%
	STOP
FEND
REM
REM :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
REM
REM		STRIP TRAILING BLANKS
REM
REM :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
DEF FN.STRIP.BLANKS$(OLD.VAL$,FLD%)
	FOR TEST%=FLD.LEN%(FLD%) TO 1 STEP -1
		IF MID$(OLD.VAL$,TEST%,1)<>" " THEN \
			FN.STRIP.BLANKS$=LEFT$(OLD.VAL$,TEST%) :\
			RETURN
	NEXT TEST%
	FN.STRIP.BLANKS$=""
	RETURN
FEND
REM
REM :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
REM
REM 		READ DATA RECORD ROUTINE
REM
REM :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
DEF FN.READ.CUST%(DRN%)
	IF READAT(FILE.NO%,DRN%,INPBUF.PTR%)<>0 THEN \
		DUMMY%=FN.ERROR.TYPE%(11)
	OFFSET%=2		REM SKIP DELETE FLAG FIELD
	FOR D.FLD%=0 TO MAX.FIELD%
		OLD.FLD.VAL$=MID$(INPBUF$,OFFSET%,FLD.LEN%(D.FLD%))
		OLD.FLD$(D.FLD%)=FN.STRIP.BLANKS$(OLD.FLD.VAL$,D.FLD%)
		OFFSET%=OFFSET%+FLD.LEN%(D.FLD%)
	NEXT D.FLD%
	RETURN
FEND
REM
REM :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
REM
REM 		LIST CUSTOMER RECORD ROUTINE
REM
REM :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
DEF FN.PRINT.CUST%
	IF ROUTE$="Y" THEN \
		LPRINTER
	PRINT
	PRINT TAB(5);OLD.FLD$(0);TAB(15);OLD.FLD$(7)
	PRINT TAB(25);OLD.FLD$(1);" ";OLD.FLD$(2)
	PRINT TAB(25);OLD.FLD$(3)
	PRINT TAB(25);OLD.FLD$(4);", ";OLD.FLD$(5);"    ";OLD.FLD$(6)
	PRINT
	CONSOLE
	RETURN
FEND
REM
REM :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
REM
REM 		PAUSE ROUTINE
REM
REM :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
DEF FN.PAUSE%
	PRINT
	INPUT "Press 'RETURN' to continue ---";LINE PAUSE$
	RETURN
FEND
REM
REM ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
REM
REM 	NUMERIC CONVERSION ROUTINE
REM
REM ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
DEF FN.NUMERIC$(NUMBER)
	FACTOR=INT(NUMBER/256.)
	FN.NUMERIC$=CHR$(NUMBER-256.*FACTOR)+CHR$(FACTOR)
	RETURN
FEND	
REM
REM :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
REM
REM 	CONVERT TARGET VALUE TO KEY FORMAT ROUTINE
REM
REM :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
DEF FN.KEY.FORMAT$(KEY%,TARGET$)
	IF KEY.TYPE%(KEY%)=1 THEN \
		FN.KEY.FORMAT$=FN.NUMERIC$(VAL(TARGET$)) :\
		RETURN
	KL%=KEY.LEN%(KEY%)
	FN.KEY.FORMAT$=LEFT$(TARGET$+SPACE$,KL%-2)+CHR$(0)+CHR$(0)
	RETURN
FEND
REM
REM :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
REM
REM 		COMPARE INDEX.KEY & U.VALUE ROUTINE
REM
REM :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
DEF FN.COMPARE%
	WHILE KEY.TYPE%(KEY%)=0 REM  ALPHANUMERIC COMPARE
		KL%=KEY.LEN%(KEY%)-2 REM  ADJUST FOR LAST TWO BYTES (DATA REC #)
		C1$=LEFT$(INDEX.KEY$+SPACE$,KL%)
		C2$=LEFT$(U.VALUE$+SPACE$,KL%)
		IF C1$<C2$ THEN \
			FN.COMPARE%=-1 :\
			RETURN
      		IF C1$>C2$ THEN \
			FN.COMPARE%=1 \
      		ELSE \
			FN.COMPARE%=0
		RETURN
	WEND
	WHILE KEY.TYPE%(KEY%)=1 REM  NUMERIC COMPARE
		C1%=ASC(INDEX.KEY$)+256*ASC(RIGHT$(INDEX.KEY$,1))
		C2%=ASC(U.VALUE$)+256*ASC(RIGHT$(U.VALUE$,1))
		IF C1%<C2% THEN \
			FN.COMPARE%=-1 :\
			RETURN
      		IF C1%>C2% THEN \
			FN.COMPARE%=1 \
      		ELSE \
			FN.COMPARE%=0
		RETURN
	WEND
FEND
REM
REM :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
REM
REM		CHECK LOCK ROUTINES
REM
REM :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
DEF FN.SKIP.LOCK%
	WHILE DRN%<>0 AND LOKCOD<>0
		L.VALUE$=LEFT$(INDEX.KEY$,KEY.LEN%(KEY%))
		INDEX.KEY$=SET.LENGTH$
		DRN%=AFTKEY(KEY%,FILE.NO%,SLOCK%,L.VALUE$,INDEX.KEY$)
	WEND
	RETURN
FEND
DEF FN.CHECK.LOCK%
	PRINT
	INPUT "Enter a 'W' if you wish to wait for locked record(s)>>"; \
		LINE DUMMY$
	IF UCASE$(DUMMY$)="W" THEN \
		FN.CHECK.LOCK%=YES% :\
		RETURN
	WHILE DRN%<>0 AND LOKCOD<>0
		CONV.TARGET$=LEFT$(INDEX.KEY$,KEY.LEN%(KEY%))
		INDEX.KEY$=SET.LENGTH$
		IF OLD.ACTION$="2CONT" THEN \
			DRN%=AFTKEY(KEY%,FILE.NO%,SLOCK%, \
				CONV.TARGET$,INDEX.KEY$) \
		ELSE \
			DRN%=BEFKEY(KEY%,FILE.NO%,SLOCK%, \
				CONV.TARGET$,INDEX.KEY$)
	WEND
	FN.CHECK.LOCK%=NO%
	RETURN
FEND
DEF FN.SET.XLOCK$(OP$)
30010	IF SETLOK(FILE.NO%,XLOCK%,DRN%)<> 0 THEN \
		PRINT :PRINT "Customer update on hold due to record lock" :\
		INPUT \
"Enter 'W' if you wish to wait or press 'RET' to cancel update>>";LINE DUMMY$:\
		DUMMY$=UCASE$(DUMMY$) \
	ELSE \
		DUMMY$="ok"
	IF DUMMY$ = "W" THEN 30010
	IF DUMMY$ = "ok" AND OP$="S" THEN \
		FN.SET.XLOCK$="SAVE"
	IF DUMMY$ = "ok" AND OP$="D" THEN \
		FN.SET.XLOCK$="DELT"
	IF DUMMY$ <> "ok" THEN \
		FN.SET.XLOCK$=OLD.ACTION$
	RETURN
FEND
REM
REM :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
REM
REM 		CUST # UNIQUENESS TEST ROUTINE
REM
REM :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
DEF FN.TEST.UNIQUENESS%
	TEST$=FN.NUMERIC$(VAL(NEW.FLD$(0))) REM  CONVERT CUST # TO INTERNAL FORMAT
	TEST%=GETKEY(UNIQ.KEY%,0,NLOCK%,TEST$)
	IF LOKCOD<>0 THEN \
		DUMMY%=FN.LOCK.TYPE%(12)
	IF TEST%=0 THEN \
		FN.TEST.UNIQUENESS%=YES% \
      	ELSE \
		FN.TEST.UNIQUENESS%=NO% : \
		PRINT : \
		PRINT "*** Already Assigned ***" : \
		PRINT
	RETURN
FEND
REM
REM :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
REM
REM 		UPDATE DATA FIELD ROUTINE
REM
REM :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
DEF FN.UPDATE.FIELD%(FIELD.NO%)
	FIELD.NO%=FIELD.NO%-1
1050	PRINT
	PRINT "Input new ";FLD.NAME$(FIELD.NO%);
	INPUT ">>";LINE NEW.FLD$(FIELD.NO%)
	NEW.FLD$(FIELD.NO%)=LEFT$(NEW.FLD$(FIELD.NO%),FLD.LEN%(FIELD.NO%))
	IF FIELD.NO%<>0 OR NEW.FLD$(FIELD.NO%)=OLD.FLD$(FIELD.NO%) THEN RETURN
	UNIQUE%=FN.TEST.UNIQUENESS%
	IF NOT UNIQUE% THEN 1050
	RETURN
FEND
REM
REM ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
REM
REM		WARNING MESSAGES
REM
REM ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
DEF FN.WARNING.TYPE%(TYPE%,RET.CODE%)
	PRINT
	PRINT "WARNING...Return Code #";RET.CODE%;" occurred while trying to ";
	ON TYPE% GOTO 9930,9940,9950
9930	PRINT "remove old key from ";INDEX.NAME$(KEY%)
	DUMMY%=FN.PAUSE% :RETURN
9940	PRINT "enter key into ";INDEX.NAME$(KEY%)
	DUMMY%=FN.PAUSE% :RETURN
9950	PRINT "delete key from ";INDEX.NAME$(KEY%)
	DUMMY%=FN.PAUSE% :RETURN
FEND
REM
REM :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
REM
REM 		ADD NEW KEY VALUE ROUTINE
REM
REM :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
DEF FN.ADD.KEY%(KEY%,DRN%)
	K.FLD%=KEY.MAP%(KEY%): KL%=KEY.LEN%(KEY%) REM  SETUP PARAMETERS
	IF KEY%=UNIQ.KEY% THEN 1060 REM  TRANSFORM TO NUMERIC KEY
	DRN=DRN%
	SUFFIX$=FN.NUMERIC$(DRN) REM  APPENDED TO KEYS TO MAKE UNIQUE
	IF OLD.FLD$(K.FLD%)="" THEN \
		OLD.KEY$="" \
      	ELSE \
		OLD.KEY$=LEFT$(OLD.FLD$(K.FLD%)+SPACE$,KL%-2)+SUFFIX$
	IF NEW.FLD$(K.FLD%)="" THEN \
		NEW.KEY$="" \
      	ELSE \
		NEW.KEY$=LEFT$(NEW.FLD$(K.FLD%)+SPACE$,KL%-2)+SUFFIX$
	GOTO 1070 REM  SKIP NUMERIC TRANSFORMATION
1060	IF OLD.FLD$(K.FLD%)="" THEN \
		OLD.KEY$="" \
      	ELSE \
		OLD.KEY$=FN.NUMERIC$(VAL(OLD.FLD$(K.FLD%)))
	NEW.KEY$=FN.NUMERIC$(VAL(NEW.FLD$(K.FLD%)))
REM
REM REMOVE OLD KEY VALUE
REM
1070	RET.CODE%=DELKEY(KEY%,FILE.NO%,XLOCK%,OLD.KEY$,DRN%)
	IF ERRCOD<>0 THEN \
		DUMMY%=FN.ERROR.TYPE%(4)
	IF LOKCOD<>0 THEN \
		DUMMY%=FN.LOCK.TYPE%(6)
	IF RET.CODE%<>1 THEN \
		DUMMY%=FN.WARNING.TYPE%(1,RET.CODE%)
REM
REM ADD NEW KEY VALUE
REM
	RET.CODE%=ADDKEY(KEY%,FILE.NO%,XLOCK%,NEW.KEY$,DRN%)
	IF ERRCOD<>0 THEN \
		DUMMY%=FN.ERROR.TYPE%(5)
	IF LOKCOD<>0 THEN \
		DUUMY%=FN.LOCK.TYPE%(7)
	IF RET.CODE%<>1 THEN \
		DUMMY%=FN.WARNING.TYPE%(2,RET.CODE%)
	RETURN
FEND
REM
REM :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
REM
REM 		WRITE NEW DATA RECORD ROUTINE
REM
REM :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
DEF FN.WRITE.CUST%(DRN%)
	OUTBUF$=CHR$(0)		REM CLEAR DELETE FLAG
	FOR D.FLD%=0 TO MAX.FIELD%
		OUTBUF$=OUTBUF$+LEFT$(NEW.FLD$(D.FLD%)+FLD.SPC$, \
			FLD.LEN%(D.FLD%))
	NEXT D.FLD%
	OUTBUF.PTR%=SADD(OUTBUF$)+2
	IF WRTDAT(FILE.NO%,DRN%,OUTBUF.PTR%)<>0 THEN \
		DUMMY%=FN.ERROR.TYPE%(12)
	RETURN
FEND
REM
REM :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
REM
REM 		DELETE KEY VALUE FROM INDEX ROUTINE
REM
REM :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
DEF FN.DEL.KEY%(KEY%,DRN%)
	K.FLD%=KEY.MAP%(KEY%): KL%=KEY.LEN%(KEY%) REM  SETUP PARAMETERS
	IF KEY%=UNIQ.KEY% THEN 1080 REM  TRANSFORM NUMERIC KEY
	DRN=DRN%
	SUFFIX$=FN.NUMERIC$(DRN) REM  UNIQUE FIELD ADDED TO END OF KEYS
	IF OLD.FLD$(K.FLD%)="" THEN \
		OLD.KEY$="" \
      	ELSE \
		OLD.KEY$=LEFT$(OLD.FLD$(K.FLD%)+SPACE$,KL%-2)+SUFFIX$
	GOTO 1090 REM  SKIP NUMERIC TRANSFORMATION
1080	IF OLD.FLD$(K.FLD%)="" THEN \
		OLD.KEY$="" \
      	ELSE \
		OLD.KEY$=FN.NUMERIC$(VAL(OLD.FLD$(K.FLD%)))
1090	RET.CODE%=DELKEY(KEY%,FILE.NO%,XLOCK%,OLD.KEY$,DRN%)
	IF ERRCOD<>0 THEN \
		DUMMY%=FN.ERROR.TYPE%(6)
	IF LOKCOD<>0 THEN \
		DUMMY%=FN.LOCK.TYPE%(10)
	IF RET.CODE%<>1 THEN \
		DUMMY%=FN.WARNING.TYPE%(3,RET.CODE%)
	RETURN
FEND
REM
REM :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
REM
REM 		DATA ENTRY ROUTINE
REM
REM :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
DEF FN.ENTER.DATA$(ENTER.MODE$)
	IF ENTER.MODE$="NEW" THEN \
		FOR FLD%=0 TO MAX.FIELD%  : \
			OLD.FLD$(FLD%)="" : \
		NEXT FLD%
	IF ENTER.MODE$="OLD" THEN \
		FOR FLD%=0 TO MAX.FIELD%  	      : \
			NEW.FLD$(FLD%)=OLD.FLD$(FLD%) : \
		NEXT FLD%
	DUMMY%=FN.CLEAR.SCREEN%
	WHILE ENTER.MODE$="NEW"
		PRINT TAB(20);"Enter New Customer Information"
		PRINT TAB(20);"******************************":PRINT :PRINT
		PRINT TAB(5);"[A zero customer number will terminate input.]"
		PRINT
		FOR FLD%=0 TO MAX.FIELD%
			FLD.NO%=FLD%+1
1010			PRINT TAB(4);FLD.NO%;"- ";FLD.NAME$(FLD%);TAB(30);"(";\
				FLD.LEN%(FLD%);")";TAB(38);
			INPUT ">>";LINE NEW.FLD$(FLD%)
			IF FLD%=0 AND VAL(NEW.FLD$(FLD%))=0 THEN \
				FN.ENTER.DATA$="STOP" : \
				RETURN
			NEW.FLD$(FLD%)=LEFT$(NEW.FLD$(FLD%),FLD.LEN%(FLD%))
			IF FLD%=0 THEN \
				UNIQUE%=FN.TEST.UNIQUENESS% \
			ELSE \
				UNIQUE%=YES%
			IF NOT UNIQUE% THEN GOTO 1010
		NEXT FLD%
		ENTER.MODE$="NEWMOD"
	WEND
1015	PRINT :PRINT :PRINT
	PRINT TAB(20);"Current customer information" : PRINT
	FOR FLD%=0 TO MAX.FIELD%
		FLD.NO%=FLD%+1
		PRINT TAB(4);FLD.NO%;"- ";FLD.NAME$(FLD%);TAB(30); \
			NEW.FLD$(FLD%)
	NEXT FLD%
	IF ENTER.MODE$="NEWMOD" THEN 1030 REM  NEW DATA HAS FEWER OPTIONS
1020	PRINT :PRINT
	PRINT "Press 'RETURN' to continue scan, enter Field # to change data,"
	PRINT "S to save changes, D to delete data, B for back scan, or E"; \ 
		" to end scan";
	INPUT ">>";LINE OP$
	OP$=UCASE$(OP$)
	IF OP$=""  THEN FN.ENTER.DATA$="CONT":RETURN
	IF OP$="S" THEN FN.ENTER.DATA$=FN.SET.XLOCK$(OP$):RETURN
	IF OP$="D" THEN FN.ENTER.DATA$=FN.SET.XLOCK$(OP$):RETURN
	IF OP$="B" THEN FN.ENTER.DATA$="BACK":RETURN
	IF OP$="E" THEN FN.ENTER.DATA$="STOP":RETURN
	OP%=VAL(OP$)
	IF OP%<1 OR OP%>NO.FIELDS% THEN 1020
	DUMMY%=FN.UPDATE.FIELD%(OP%)
	GOTO 1015 REM  DISPLAY INFO
1030	PRINT :PRINT
	PRINT "Pres 'RETURN t sav data ente Fiel  t chang data,"
	INPUT "D to delete data, or E to end input>>";LINE OP$
	OP$=UCASE$(OP$)
	IF OP$="" OR OP$="S" THEN FN.ENTER.DATA$="SAVE":RETURN
	IF OP$="D" THEN FN.ENTER.DATA$="DELT":RETURN
	IF OP$="E" THEN FN.ENTER.DATA$="STOP":RETURN
	OP%=VAL(OP$)
	IF OP%<1 OR OP%>NO.FIELDS% THEN 1030
	DUMMY%=FN.UPDATE.FIELD%(OP%)
	GOTO 1015
FEND
REM
REM :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
REM
REM 		UPDATE INDICES & DATA FILE ROUTINE
REM
REM :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
DEF FN.UPDATE%(DATA.RECORD%)
	IF DATA.RECORD%=0 THEN \
		DATA.RECORD%=NEWREC(FILE.NO%,XLOCK%)
	FN.UPDATE%=DATA.RECORD%
	IF ERRCOD<>0 THEN \
		DUMMY%=FN.ERROR.TYPE%(8)
	IF LOKCOD<>0 THEN \
		DUMMY%=FN.LOCK.TYPE%(3) 
	FOR KEY%=0 TO MAX.KEY%
		FLD%=KEY.MAP%(KEY%)
		IF OLD.FLD$(FLD%)<>NEW.FLD$(FLD%) THEN \ KEY HAS CHANGED
			DUMMY%=FN.ADD.KEY%(KEY%,DATA.RECORD%)
	NEXT KEY%
	FOR FLD%=0 TO MAX.FIELD%
		IF OLD.FLD$(FLD%)<>NEW.FLD$(FLD%) THEN \ FIELD HAS CHANGED
			DUMMY%=FN.WRITE.CUST%(DATA.RECORD%) :\
			RETURN
	NEXT FLD%
	RETURN
FEND

REM
REM :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
REM
REM 		DELETE INDEX & DATA FILE ENTRY ROUTINE
REM
REM :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
DEF FN.DELETE%(DATA.RECORD%)
	FOR KEY%=0 TO MAX.KEY%
		FLD%=KEY.MAP%(KEY%)
		IF OLD.FLD$(FLD%)<>"" THEN \
			DUMMY%=FN.DEL.KEY%(KEY%,DATA.RECORD%)
	NEXT KEY%
	IF RETREC(FILE.NO%,XLOCK%,DATA.RECORD%)<>0 THEN \
		DUMMY%=FN.ERROR.TYPE%(9)
	IF LOKCOD<>0 THEN \
		DUMMY%=FN.LOCK.TYPE%(9)
	RETURN
FEND
REM
REM		END OF UTILITY FUNCTIONS
REM
REM ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
REM
REM ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
REM
REM 		INITIALIZE INDEX FILES
REM
REM ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
2000	YES%=-1 :NO%=0 
	SET.LENGTH$="12345678901"
	INDEX.KEY$=SET.LENGTH$
	SPACE$=    "           "
	NO.BUFFERS%=6 :NO.NODE.SECTORS%=4 :NO.HEADER.SECTORS%=4
	NO.DATA.FILES%=1 :NO.KEYS%=MAX.KEY%+1
	CALL SETUP(NO.BUFFERS%,NO.KEYS%,NO.NODE.SECTORS%, \
			NO.HEADER.SECTORS%,NO.DATA.FILES%,0)
REM
REM SET TERMINAL TO -1 FOR AUTOMATIC ASSIGNMENT BY MICRO B+
REM
	TERMINAL%=-1
	TERMINAL%=INTUSR(TERMINAL%,1)	REM  TRAP USER ERRORS
	FOR KEY%=0 TO MAX.KEY%
		MAX.KV%(KEY%)=(NO.NODE.SECTORS%*128-10)/(KEY.LEN%(KEY%)+4)
		MAX.KV%(KEY%)=MAX.KV%(KEY%)/2*2 REM  MAKE SURE ITS EVEN
		DUMMY%=OPNIDX(KEY%,INDEX.NAME$(KEY%),KEY.LEN%(KEY%), \
			KEY.TYPE%(KEY%),MAX.KV%(KEY%))
		IF ERRCOD <> 0 AND ERRCOD <> 33 THEN \
			DUMMY%=FN.ERROR.TYPE%(1)
	NEXT KEY%
REM
REM ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
REM
REM 		INITIALIZE DATA FILE
REM
REM ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
	FILE.NO%=0:RECORD.LENGTH%=100 REM   100 BYTE DATA FILE RECORD LENGTH
	FILE.NAME$="K:CUSTOMER.DAT"
	DUMMY%=OPDATA(FILE.NO%,NLOCK%,FILE.NAME$,RECORD.LENGTH%)
	IF ERROCD=0 OR ERRCOD=63 THEN \
		GOTO 4990 \
	ELSE \
		DUMMY%=FN.ERROR.TYPE%(10)
	IF LOKCOD<>0 THEN \
		DUMMY%=FN.LOCK.TYPE%(1)
4990	REM INITIALIZE STRING UTILITIES
TMPBUF$="12345678901234567890123456789012345678901234567890"
	INPBUF$=TMPBUF$+TMPBUF$
	INPBUF.PTR%=SADD(INPBUF$)+2
REM               123456789012345678901234567890123456
	FLD.SPC$="                                    "
REM
REM ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
REM
REM 		BEGIN DATABASE OPERATION
REM
REM ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
5000	DUMMY%=FN.CLEAR.SCREEN%
	CHOICE%=FN.MAIN.MENU%
	ON CHOICE% GOTO 5100,5300,5500,5700,5900,6100
REM
REM ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
REM
REM 		ENTER NEW CUSTOMERS
REM 
REM ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
5100	ACTION$=FN.ENTER.DATA$("NEW")
	LOCK.CODE%=0
	IF ACTION$="SAVE" THEN \
		NDRN%=FN.UPDATE%(0): \ UPDATE INDICES & DATA FILE
		LOCK.CODE%=FRELOK(FILE.NO%,XLOCK%,NDRN%)
	IF LOCK.CODE%<>0 THEN \
		DUMMY%=FN.LOCK.TYPE%(8)
	IF ACTION$="SAVE" THEN \
		GOTO 5100 \
	ELSE \
		GOTO 5000 REM  RETURN TO MENU
REM
REM ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
REM
REM 		SCAN/UPDATE/DELETE CUSTOMERS
REM
REM ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
5300	KEY%=FN.SEARCH.KEY% REM  DETERMINE SEARCH KEY
	PRINT
	PRINT "Enter target value for ";KEY.NAME$(KEY%);","
	INPUT "     or press 'RETURN' to see main menu>>";LINE TARGET$
	IF TARGET$="" THEN 5000
	CONV.TARGET$=FN.KEY.FORMAT$(KEY%,TARGET$) REM  TARGET TO KEY FORMAT
5345	DRN%=SERKEY(KEY%,FILE.NO%,SLOCK%,CONV.TARGET$,INDEX.KEY$)
	IF ERRCOD<>0 THEN \
		DUMMY%=FN.ERROR.TYPE%(2)
	IF LOKCOD<>0 THEN \
		STAYPUT%=FN.CHECK.LOCK% \
	ELSE \
		STAYPUT%=NO%
	IF STAYPUT% THEN 5345
	OLD.ACTION$="CONT"
	CONTINUE%=YES%
	WHILE CONTINUE% AND DRN%<>0
		LDRN%=DRN%  REM save drn for lock release
		DUMMY%=FN.READ.CUST%(DRN%) REM  READ CUSTOMER RECORD # DRN%
		ACTION$=FN.ENTER.DATA$("OLD")
		SAVE.KEY%=KEY%
		IF ACTION$="SAVE" THEN \
			DUMMY%=FN.UPDATE%(DRN%)
		IF ACTION$="DELT" \
			THEN DUMMY%=FN.DELETE%(DRN%)
		IF FRELOK(FILE.NO%,RLOCK%,LDRN%)<>0 THEN \
			DUMMY%=FN.LOCK.TYPE%(2)
		IF ACTION$="SAVE" OR ACTION$="DELT" THEN \ 
			KEY%=SAVE.KEY% : \ RESET SEARCH KEY
			ACTION$=OLD.ACTION$ REM reset direction
		OLD.ACTION$=ACTION$
		CONV.TARGET$=LEFT$(INDEX.KEY$,KEY.LEN%(KEY%))
		INDEX.KEY$=SET.LENGTH$
		LOCK.CODE% = 0
5390		IF ACTION$="CONT" THEN \
			DRN%=AFTKEY(KEY%,FILE.NO%,SLOCK%, \
				CONV.TARGET$,INDEX.KEY$) :\
			LOCK.CODE%=LOKCOD
		IF ACTION$="BACK" THEN \
			DRN%=BEFKEY(KEY%,FILE.NO%,SLOCK%, \
				CONV.TARGET$,INDEX.KEY$):\
			LOCK.CODE%=LOKCOD
		IF LOCK.CODE%<>0 THEN \
			STAYPUT%=FN.CHECK.LOCK% \
		ELSE \
			STAYPUT%=NO%
		IF STAYPUT% THEN 5390
		IF ACTION$="STOP" THEN \
			CONTINUE%=NO%
	WEND
	PRINT
	PRINT "SCAN ENDED"
	DUMMY%=FN.PAUSE%
	GOTO 5000 REM  RETURN TO MAIN MENU
REM
REM ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
REM
REM 			LIST CUSTOMERS
REM
REM ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
5500	KEY%=FN.SEARCH.KEY%
	PRINT
	INPUT "Do you want listing routed to printer (Y/N)>>";LINE ROUTE$
	ROUTE$=UCASE$(ROUTE$)
	PRINT
	PRINT "Enter lower and upper limits for ";KEY.NAME$(KEY%);" listing;"
	INPUT "     separate values with a comma >>";L.VALUE$,U.VALUE$
	L.VALUE$=FN.KEY.FORMAT$(KEY%,L.VALUE$)
	U.VALUE$=FN.KEY.FORMAT$(KEY%,U.VALUE$)
	DRN%=SERKEY(KEY%,FILE.NO%,SLOCK%,L.VALUE$,INDEX.KEY$)
	IF LOKCOD<>0 THEN \
		DUMMY%=FN.SKIP.LOCK%
	NO.LISTED%=0
	WHILE DRN%<>0 AND FN.COMPARE%<=0
		DUMMY%=FN.READ.CUST%(DRN%)
		DUMMY%=FN.PRINT.CUST%
		NO.LISTED%=NO.LISTED%+1
		IF FRELOK(FILE.NO%,SLOCK%,DRN%)<>0 THEN \
			DUMMY%=FN.LOCK.TYPE%(4)
		L.VALUE$=LEFT$(INDEX.KEY$,KEY.LEN%(KEY%))
		INDEX.KEY$=SET.LENGTH$
		DRN%=AFTKEY(KEY%,FILE.NO%,SLOCK%,L.VALUE$,INDEX.KEY$)
		IF LOKCOD<>0 THEN \
			DUMMY%=FN.SKIP.LOCK%
	WEND
	IF DRN% <> 0 THEN \
		LOCK.CODE%=FRELOK(FILE.NO%,SLOCK%,DRN%) \
	ELSE \
		LOCK.CODE%=0
	IF LOCK.CODE%<>0 THEN \
		DUMMY%=FN.LOCK.TYPE%(5)
	PRINT
	PRINT TAB(5);NO.LISTED%;" records listed."
	DUMMY%=FN.PAUSE%
	GOTO 5000 REM  RETURN TO MAIN MENU
REM
REM ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
REM
REM 		DATABASE STATISTICS
REM
REM ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
5700	DUMMY%=FN.CLEAR.SCREEN%
	PRINT TAB(5);FILE.NAME$;" has ";GETDFS(FILE.NO%); \
		" records; currently, ";
	PRINT GETDFU(FILE.NO%);" of them are in use."
	PRINT :PRINT :PRINT :PRINT
	PRINT TAB(5);"INDEX";TAB(30);"ENTRIES"
	PRINT TAB(5);"-----------------";TAB(30);"-------"
	FOR KEY%=0 TO MAX.KEY%
		PRINT TAB(5);KEY.NAME$(KEY%);TAB(32);NOKEYS(KEY%)
	NEXT KEY%
	PRINT :PRINT :PRINT :PRINT
	DUMMY%=FN.PAUSE%
	GOTO 5000 REM  RETURN TO MAIN MENU
REM
REM ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
REM
REM 		SAVE DATABASE UPDATES & RESTART
REM
REM ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
5900	RESTART%=YES%
5910	IF SAVDAT(FILE.NO%) <>0 THEN \
		DUMMY%=FN.ERROR.TYPE%(7)
	FOR KEY%=0 TO MAX.KEY%
		IF SAVIDX(KEY%)<>0 THEN \
			DUMMY%=FN.ERROR.TYPE%(3)
	NEXT KEY%
	IF RESTART% THEN GOTO 5000
	PRINT
	PRINT "*** SUCCESSFUL TERMINATION ***"
	STOP
REM
REM ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
REM
REM 		SAVE DATABASE UPDATES & TERMINATE
REM
REM ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
6100	RESTART%=NO%
	GOTO 5910

