	TITLE	'8080/Z-80 MEMORY TEST VERSION 1.0'
	PAGE	56
;
; THERE IS NO MEMORY TEST AVAILABLE THAT CAN BE
; CALLED THE "DEFINITIVE MEMORLY TEST PROGRAM".
;
; THE FOLLOWING IS ONE THAT WILL AT LEAST PROVIDE
; SOME DIAGNOSTIC ASSISTANCE, AS WELL AS SOME
; DEGREE OF CONFIDENCE.
;
; THE BEST TEST IS A FEW WEEKS OF TIME, RUNNING
; THE SYSTEM, AND EXERCISING THE SYSTEM AS A
; WHOLE. YOU WILL KNOW SOON ENOUGH IF THE
; MEMORY IS SOUND
;
; THIS PROGRAM STARTS AT ADDRESS 0100H. (YOU MAY TEST
; MEMORY FROM 0400H ON UPWARDS. MAX=0FFFFH). THE
; PROGRAM HAS BEAN MODIFIED TO RUN IN ROM AND WILL TEST
; MEMORY FROM 0000H UPWARD.
;
; THIS PROGRAM WILL SIGN ON, AND ASK FOR THE RANGE.
; THIS SHOULD BE GIVEN IN HEX; "START"[,]"FINISH".
; IT WILL TEST CONTINOUSLY UNTILL A CONTROL-C IS
; SEEN ON THE KEYBOARD. ERRORS WILL BE PRINTED OUT
; WITH THE ADDRESS OF THE ERROR, THE TEST BYTE,
; AND THE MEMORY ERROR PATTERN. THE BITS THAT DON'T
; AGREE ARE "1". ALSO, WHILE THE TEST IS IN PROGRESS,
; A NUMBER WILL BE PRINTED ON THE CONSOLE FOR EACH 
; LOOP THROUGH ALL TESTS. EXA 1,,,4,,,71,,,4,,6.
;
;	<CONSTANTS>
;
STAT:	EQU	0H	;STATUS PORT
DATA:	EQU	1H	;DATA PORT
TTBE:	EQU	80H	;XMIT EMPTY
TTDA:	EQU	1H	;RECIEVE DATA AVAILABLE
CR:	EQU	0DH	;CARAGE RETURN
LF:	EQU	0AH	;LINE FEED
AMS80	EQU	0E120H	;AMS80 MONITOR
;
;	<PROGRAM BEGINS HERE>
;
	ORG	0100H	;STARTING ADDRESS OF PROGRAM

START:	LXI	SP,STACK;SET UP A STACK
	LXI	H,MSG0	;SIGN ON MESSAGE
	CALL	TYPE
	LXI	H,TEMP	;INITIALIZE TEMP. VALUES
	MVI	M,0
	INX	H
	MVI	M,40H
	MVI	B,2	;GET TWO ADDRESSES
EXPR:	LXI	H,0
EX0:	CALL	KBD	;GET PARAMETERS
	MOV	C,A
EX1:	CALL	NIBBLE	;CONVERT TO HEXADECIMAL
	JC	EX2
	DAD	H	;CONVERT TO BINARY
	DAD	H
	DAD	H
	DAD	H
	ORA	L
	MOV	L,A
	JMP	EX0
NIBBLE:	SUI	'0'	;ASCII TO HEX
	RC
	CPI	'G'-'0'
	CMC
	RC
	CPI	10
	CMC
	RNC
	SUI	'A'-'9'-1
	CPI	10
	RET
EX2:	MOV	A,C
	CALL	CHK
	XCHG
	DCR	B	;TWO ADDRESSES YET?
	JNZ	EXPR
	MVI	A,'O'	;ALL OK
	CALL	SEND
	MVI	A,'K'
	CALL	SEND
	CALL	CRLF
;
DOIT:	PUSH	H	;START TESTING
T1:	MVI	M,0AAH	;10101010 PATTERN
	INX	H
	MVI	M,55H	;01010101 PATTERN
	CALL	HILO	;RANGE SATISFIED YET?
	JNC	T1
	CALL	DELAY	;BITS ARE TRICKY AT TIMES
	POP 	H	;RESTORE START POINTER
	PUSH	H	;SAVE IN STACK
T2:	MVI	A,0AAH
	MOV	B,M	;PICK UP MEMORY BYTE
	CMP	B	;NOW VERIFY MEMORY
	CNZ	ERROR	;TELL IF BAD
	INX 	H
	MVI	A,55H
	MOV	B,M
	CMP	B
	CNZ	ERROR
	CALL	HILO	;RANGE TEST
	JNC	T2
	POP	H
	PUSH	H
T3:	MVI	M,055H	;REVERSE (CHECKERBOARD)
	INX	H
	MVI	M,0AAH
	CALL	HILO
	JNC	T3
	CALL	DELAY
	POP	H
	PUSH	H
T4:	MVI	A,55H
	MOV	B,M
	CMP	B
	CNZ	ERROR
	INX	H
	MVI	A,0AAH
	MOV	B,M
	CMP	B
	CNZ	ERROR
	CALL	HILO
	JNC	T4
	POP	H
	PUSH	H
T5:	MVI	M,0FFH	;ALL ONES
	CALL	HILO
	JNC	T5
	CALL	DELAY
	POP	H
	PUSH	H
T6:	MVI	A,0FFH
	MOV	B,M
	CMP	B
	CNZ	ERROR
	CALL	HILO
	JNC	T6
	POP	H
	PUSH	H
	MVI	C,0	;SEQUENTIAL NUMBERS TEST
T7:	MOV	M,C	;START WITH ZERO
	INR 	C
	CALL	HILO
	JNC	T7
	CALL	DELAY
	POP	H
	PUSH	H
	MVI	C,0
T8:	MOV	A,C
	INR	C
	MOV	B,M
	CMP	B
	CNZ	ERROR
	CALL	HILO
	JNC	T8
	POP	H
	PUSH	H
T9:	MOV	M,H	;PAGE DECODING TEST
	INR	H
	CALL	HILO+1	;JUST INCREMENT H REG
	JNC	T9
	CALL	DELAY
	POP	H
	PUSH	H
TA:	MOV	A,H
	MOV	B,M
	CMP	B
	CNZ	ERROR
	INR	H
	CALL	HILO+1
	JNC	TA
	POP	H
	PUSH	H
TB:	MOV	A,M	;FAST COMPLIMENT TEST
	CMA
	MOV	M,A
	MOV	B,M
	CMP	B
	CNZ	ERROR
	MVI	M,00H	;ZERO MEMORY TEST
	CALL	HILO
	JNC	TB
	CALL	DELAY
	POP	H
	PUSH	H
TC:	XRA	A	;TEST FOR STILL ZERO
	MOV	B,M
	CMP	B
	CNZ	ERROR
	CALL	HILO
	JNC	TC
	CALL	STOP	;SEE IF CONSOLE WANT TO ABORT
	LXI	H,TEMPO	;PICK UP COUNTER
	MOV	A,M
	ANI	7
	ORI	'0'	;COUNT OF THE NUMBER OF
	CALL	SEND	; TIMES THROUGH THE MEMORY
	INR	M
	CM	LINE	;CRLF EACH 64 CHARACTERS
	POP	H
	JMP	DOIT	;DO ALL OF THIS AGAIN
;
;	<SUBROUTINES>
;
STOP:	IN	STAT	;SEE IF CONSOLE WANTS TO STOP
	ANI	TTDA
	RNZ
	IN	DATA
	ANI	7FH
	CPI	3	;CONTROL-C
	RNZ
	JMP	AMS80	;INSERT A MONITOR JUMP HERE
DELAY:	MVI	H,0FFH	;CAN BE SHORTENED IF TESTING
DELO:	MVI	L,0FFH	;LARGE AMOUNTS OF MEMORY
	DCR	L
	JNZ	$-1
	DCR	H
	JNZ	DELO
	RET
HILO:	INX	H
	MOV	A,E
	SUB	L
	MOV	A,D
	SBB	H
	RET
;
ERROR:	PUSH	PSW	;SAVE TEST BYTE
	LDA	TEMP	;SEND MESSAGE?
	ORA	A
	JNZ	NO	;NO
	CMA
	STA	TEMP	;MESSAGE	SENT
	PUSH	H
	LXI	H,MSG
	CALL	TYPE
	POP	H
NO:	MOV	A,H	;SEND HIGH BYTE OF ADDRESS
	CALL	WRIT2
	MOV	A,L	;AND LOW BYTE
	CALL	WRIT2
	CALL	BLK	;SPACE OVER
	POP	PSW	;GET TEST BYTE
	PUSH	PSW	;SAVE AGAIN
	CALL	WRIT2	;PRINT IT
	CALL	BLK
	POP	PSW	;GET BYTE BACK
	XRA	B	;DET BAD BIT LOC.
	MVI	B,8	;NUMBER OF BITS/BYTE
BIT:	RAL		;SET/RESET CARRY
	PUSH	PSW	;SAVE THE BAD BITS
	MVI	A,('0')/2
	ADC	A	;MAKE '0' OR '1'
	CALL	SEND
	POP	PSW	;GET BAD BYTE
	DCR	B
	JNZ	BIT	;PUMP EM OUT.
	CALL	CRLF
	JMP	STOP	;SEE IF CONSOLE WANTS TO STOP
WRIT2:	PUSH	PSW	;BINARY TO ASCII HEX
	RRC
	RRC
	RRC
	RRC
	CALL	ST
	POP	PSW
ST:	ANI	0FH	;THIS DAA IS CUTE
	ADI	90H
	DAA		;(THANKS, INTEL)
	ACI	40H
	DAA
;
SEND:	PUSH	PSW	;MAIN TELETYPE OUTPUT
S:	IN	STAT
	ANI	TTBE
	JNZ	S
	POP	PSW
	OUT	DATA
	RET
BLK:	MVI	A,' '
	CALL	SEND
	JMP	SEND
LINE:	MVI	M,40H	;RESET TEST COUNTER
CRLF	MVI	A,CR	;CRLF ON CONSOLE
	CALL	SEND
	MVI	A,LF
	JMP	SEND
;
CHK:	CPI	','	;SPACE OR COMMA BETWEEN ADDR
	RZ
	CPI	' '
	RZ
	CPI	CR	;TERMINATION?
	JNZ	START	;HHMMM.....
	MOV	A,B
	DCR	A
	JNZ	START	;TOO MANY OR TOO FEW PARAMS
	JMP	CRLF
;
KBD:	IN	STAT	;MAIN TELETYPE INPUT ROUTINE
	ANI	TTDA
	JNZ	KBD
	IN	DATA
	ANI	7FH	;CLR PARITY
	JMP	SEND	;ECHO INPUT
;
TYPE:	CALL	STOP	;TEST FOR AN ABORT
	MOV	A,M	;MESSAGE SENDER ROUTINE
	ORA	A
	RZ
	CALL	SEND
	INX	H
	JMP	TYPE
;
;	<MESSAGES>
;
MSG0:	DB	CR,LF
	DB	'MEMORY TEST VER. 1.0'
	DB	CR,LF
	DB	'RANGE- ',00
MSG:	DB	CR,LF
	DB	'ADDR TEST 76543210  -BAD BITS'
	DB	CR,LF,00
;
TEMP:	DB	00
TEMPO:	DB	40H	;COUNTER
STACK:	EQU	$+20
;
END	DB	$
