;---------------------------------------------------------------------------
; Creates a ZIP file from the highlighted file or the marked files.
; On entry: nothing
; Modifies: Assume everything
; Returns: nothing
;----------------------------------------------------------------------------

 ASSUME CS:_TEXT, DS:_TEXT, ES:_TEXT
 ZIP		PROC NEAR

     mov  doing_zip,al          ;use doing_zip to store keycode
                                ;=71h for Primary
                                ;=A9h for secondary
     CALL CURSOR_OFF
	call	create_zfile		  ;creates temp file for file to ZIP
						  ;This file used as input file list by PKZIP
	jnc	_ZIP_05
	mov	si,offset file_err_msg
	mov	ah,intense            ;temporary file creation failed
	or	ah,80h                ;display error message and return
	mov	di,prompt_loc2
	call	put_stratt
	call	delay
	stc
	ret

 _ZIP_05:
	CALL	COUNT_MARKS
	JNZ	_ZIP_1
	CALL	PUT_AMARK
     push es
     mov  es,dir_buf_seg
     MOV  BYTE PTR es:[SI],space
     pop  es
	JMP	SHORT _ZIP_3

 _ZIP_1:	CALL	HOME_BAR

 _ZIP_2:	CALL	REFRESH_DIR_DISP
	CALL	GET_NAME
     push es
     mov  es,dir_buf_seg
     CMP  BYTE PTR es:[SI],COPY_MARK
     pop  es
	JZ	_ZIP_3
	CALL	DN_ARROW
	JMP	SHORT _ZIP_2

 _ZIP_3:	CALL	GET_NAME
	JNC	_ZIP_4          ;Carry flag set by GET_NAME if illegal function
	INC	MARK_CNT
	JMP	_ZIP_7

 _ZIP_4:	MOV	DX,OFFSET SOURCE
 _ZIP_6:
	CALL	STORE_ZFILE		 ;saves the filename in temp file
	jc	_ZIP_7			 ;failed
	MOV	SI,CUR_FILE
     push es
     mov  es,dir_buf_seg
     MOV  BYTE PTR es:[SI],'*'
     pop  es
	JMP	_ZIP_8

 _ZIP_7:	CALL	BEEP
	CALL	DN_ARROW

 _ZIP_8:	DEC	MARK_CNT
	CALL	CK_KEY
	JNZ	_ZIP_9
	CMP	MARK_CNT,0
	JLE	_ZIP_X
	JMP	_ZIP_2

 _ZIP_9:	CALL	READ_KEY
	CALL	CK_KEY
	JNZ	_ZIP_9

 _ZIP_X:	CALL	REFRESH_DIR_DISP   ;Redisplays with changed attributes and
	call		count_marks
	mov		si,offset marked_msg
	mov		di,prompt_loc
	call		put_string
	call		close_zfile		;close the file with the filenames
     mov       al,doing_zip        ;poke in stored phony scan code
     mov       doing_zip,1
	call		MULTI			;This runs the "ZIP command line"
;	call		erase_zfile         ;erase it
	mov		doing_zip,0
	clc
	RET


 ZIP		ENDP

;---------------------------------------------------------------------------
; Function attempts to create a tempoary file for the filenames to be zipped.
; On entry: nothing
; Modifies: AX,CX,BX,DX
; Returns:  If successful -- carry flag clear; AX = file handle
;			handle also saved in ZIP_HANDLE
;           If failed -- carry flag set
;-------------------------------------------------------------------------

 CREATE_ZFILE	PROC NEAR

	mov		dx,offset zip_temp	;filename for temporary file
	mov		cx,0				;normal file attribute
	mov		ah,3Ch			;create or truncate file
	int		21h
	pushf					;save state of carry flag
	mov		zip_handle,ax       ;store handle
	popf
	ret
 CREATE_ZFILE	ENDP

;---------------------------------------------------------------------------
; Stores the filename in the temporary file.
; On entry: DX points to the filename
; Modifies: ax,bx,cx -- uses but preserves si and dx
; Returns: carry flag clear if successful, set if failed
;----------------------------------------------------------------------------

 STORE_ZFILE	PROC NEAR

	push		si
	push		dx
	mov		si,dx			;make si point to start of filename
	call		str_len			;get length (stored in cx)
	mov		bx,zip_handle
	mov		ah,40h
	int		21h
	mov		dx,offset zip_end_line
	mov		cx,2
	mov		ah,40h
	int		21h				;add <CR>,<NL> after filename
	pop		dx
	pop		si
	ret

 STORE_ZFILE	ENDP

;--------------------------------------------------------------------------
; Close the temporary file.
; On entry: nothing
; Modifies: AX,BX
; Returns: carry flag clear if successful; set if failure
;--------------------------------------------------------------------------
 CLOSE_ZFILE	PROC NEAR

	mov		bx,zip_handle
	mov		ah,3Eh
	int		21h
	ret
 CLOSE_ZFILE	ENDP

;--------------------------------------------------------------------------
; Erase the temporary file.
; On entry: nothing
; Modifies: AX
; Returns: carry flag clear if successful; set if failure
;--------------------------------------------------------------------------
 ERASE_ZFILE	PROC NEAR
	mov		dx,offset zip_temp
	mov		ah,41h
	int		21h
	ret
 ERASE_ZFILE	ENDP