
;--------------------------------------------------------------------------
; Reads Volume label using DOS Function 4Eh (only applicable to DOS
; rev 3.0 and later) and puts it in the string for display
; A digression on how volume labels are stored -- knowledge attained
; through tedious debugging:
;  Volume names are a special type of filename, e.g. FILENAME.EXT
;    However, we don't normally display the period and here's where things
;    get trick and ugly.
;
;  IF the name is less than 8 characters, we just display it.
;  IF the name is 12 characters (counting the period), we just ignore
;     the period
;  IF we're in between these two (actually number 2 is a subset of this),
;     a period in position 9 is ignored while a space is substituted for
;     a period in position 8.  Periods in other positions are treated just
;     like any other character. (e.g. ..... ... . is a perfectly valid label.)
;
;--------------------------------------------------------------------------

 temp_volume   db 12 dup(space)    ;temporary storage for volume name
                                   ;added 4.60 to make this function more
                                   ;general purpose (for sysinfo)

 READ_VOLUME	PROC NEAR

	MOV		AX,DOS_VERSION   ;file handle functions cannot be used to search
	CMP		AL,3             ;for volume labels below DOS 3.00
	JB		_RV_RET

;     MOV       DI,OFFSET VOL_NAME+8     ;clean out display string
;     MOV       CX,11
;     CLD
;     mov       al,space
;     REP       STOSB

     MOV       DI,OFFSET temp_volume     ;clean out display string
     MOV       CX,11
     CLD
     mov       al,space
     REP       STOSB

	call		find_volume_file
	jc		_RV_RET
	call		str_len
;     MOV       DI,OFFSET VOL_NAME+8   ;fill in volume name str_len messes up di
     mov       di,offset temp_volume
	mov		bx,cx

	cmp		cx,8				   ;if <= 8 characters, just copy
	jle		_RV7                   ;else do byte by byte; deal with .'s
 _RV1:                                ;is it a . ?
	cmp		byte ptr[si],'.'
	je		_RV3
 _RV2:                                ;no? just copy?
	movsb
	loop		_RV1
	jmp		short _RV_RET
 _RV3:
	mov		ax,bx                  ;yes? Calculate position
	sub		ax,cx
	inc		ax

	cmp		ax,9                   ;is it position 9?
	je  		_RV4                   ;if so, skip over period
	cmp		ax,8                   ;is it position 8?
	jne		_RV2                   ;otherwise just do a regular move
							   ;
	mov		al,space               ;if so, substitute space for period
	stosb
	inc		si
	loop		_RV1
	jmp		short _RV_RET
 _RV4:
	inc		si                     ;skip over period
	loop		_RV1
	jmp		short _RV_RET

 _RV6:
;	mov		cx,8
;	rep		movsb
;	inc		si
;	mov		cx,3
;	rep		movsb
;	jmp		short _rv_ret

 _RV7:
	REP		MOVSB

_RV_RET:
	RET

 READ_VOLUME ENDP

 FIND_VOLUME_FILE	PROC NEAR

	MOV		DX,OFFSET DTA			;Set DTA for FIND_FIRST function
	MOV		AH,1AH
	INT		21H

	MOV		CX,8 				;attribute for volume label
	MOV		DX,OFFSET STAR_DOT_STAR  ;look at all files

	CALL		FIND_FIRST
	JC		_FVM_NO

	MOV		CX,12			   ;copy from buffer to display string
	MOV		SI,OFFSET DTA+1Eh      ;Volume name placed at offset 1Eh in DTA
	clc
	RET
 _FVM_NO:
	stc
	ret
 FIND_VOLUME_FILE	ENDP

;--------------------------------------------------------------------------
; Edits the volume name on the currently displayed drive.
; On entry: nothing
; Modifies: Assume everything
; Returns: nothing
;---------------------------------------------------------------------------
 edit_volume	proc near

	MOV		AX,DOS_VERSION   ;file handle functions cannot be used to search
	CMP		AL,3             ;for volume labels below DOS 3.00
	JAE		_EV_cont		  ;Wouldn't be that hard to rewrite if there was
						  ;a real need to though -- change handle functions
						  ;in READ_VOLUME
	jmp		_ev_ret
 _ev_cont:
	call	clr_msg
	mov	si,offset ent_volume_msg		;Volume entry prompt
	mov	di,prompt_loc
	call	put_string

	call	clear_old
	mov	dx,prompt_loc2_RC
	call	set_cursor
	mov	cx,11
	call input_param
JUMPS
     jc   _ev_ret                       ;input was aborted, exit
NOJUMPS
	mov	ah,19h					;get default disk drive so can reset later
	int	21h
	mov	tmp_default_drive,AL
	mov	di,offset work_path
	mov	dl,byte ptr [di]			;get displayed drive letter
	sub	dl,41h					;convert ASCII Drive letter to number
								;40h->41h DF4 p 4.  One too high before
	mov	ah,0Eh					;set default drive
	int	21h

	mov	dx,offset dta
	mov	ah,1Ah
	int	21h

	mov	dx,offset xfcb
	mov	ah,11h
	int	21h
	cmp	al,0ffh					;is there an existing volume label?
	je	_ev_newfile                   ;no? create new one

	mov	ah,13h					;delete existing volume label
	mov	dx,offset xfcb                ;(couldn't make rename work so we
	int	21h                           ; delete and create)
	cmp	al,0FFh
	je	_ev_error					;shouldn't happen -- an error occurred

 _ev_newfile:
	mov	si,offset entry			;copy new name to xfcb
	mov	di,offset xfcb + 08h
	mov	cx,11
 _ev_1:
	cmp	byte ptr [si],0               ;copy 11 characters, pad with spaces
	jne	_ev_2
	mov	al,20h
	stosb
	inc	si
	loop	_ev_1
	jmp	short _ev_3

 _ev_2:
	movsb
	loop	_ev_1
 _ev_3:
	mov	dx,offset xfcb			;create new volume label (file)
	mov	ah,16h
	int	21h
;commented out 4.61 because this error was occurring when volume name was
;deleted.  Since this error check shouldn't be needed under these 
;circumstances anyway, just took it out
;     cmp  al,0FFh
;     je   _ev_error                ;shouldn't happen -- an error occurred

	call	clr_msg

     MOV       DI,OFFSET VOL_NAME+8     ;clean out display string
     MOV       CX,11
     CLD
     mov       al,space
     REP       STOSB
     call read_volume              ;this isn't the most efficient way of doing
     mov      si,offset temp_volume
     mov       di,offset vol_name+8
     mov       cx,11
     rep       movsb
	call	put_menu_paths           ;things, but it uses the least code and is
	jmp	short _ev_reset          ;the most reliable in that it does a reread
							;of the volume label with was actually created

 _ev_error:
	call	beep
 _ev_reset:
	mov	dl,tmp_default_drive
	mov	ah,0Eh
	int	21h
 _ev_ret:
	call	clr_msg
	ret
 edit_volume	endp