 SUBTTL View file command and subroutines
 page
 ;------------------------------------------------------------;
 ; This subroutine displays the highlighted file for viewing. ;
 ; On entry : no known parameters
 ; Returns  : nothing
 ; Modifies : everything
 ;
 ;"global" variables used in the regular segment are
 ;
 ;temporary variables in the extended buffer segment "DUMMY_SEG":
 ;     PAGES is an array of byte sizes of previously formatted pages
 ;     LAST_PAGE is the buffer pointer value (SI)
 ;               for the top of the current page
 ;     ROW  = # of rows into LAST_PAGE for current display
 ;------------------------------------------------------------;
       ASSUME  CS:_TEXT,DS:_TEXT,ES:_TEXT
 VIEW  PROC    NEAR

       CALL    GET_NAME                ;Get the file name.
       MOV     SI,OFFSET SOURCE        ; point to it
       JNC     _VW1                    ;view file, not directory
       CMP     BYTE PTR es:[SI+3],00H     ;is the 4th character in the path a null
							    ;i.e. b:\{null} indicating that there is
							    ;nothing under the highlight?
	  JNE	_VW1_5                  ;no? then go ahead
	  CALL	BEEP                    ;else indicate an error and return
	  RET
 _VW1_5:
       JMP     VIEW_DIR

 _VW1: ;RET     ;bypass internal viewer for 4.60 debug
       CALL    GET_MEM
       JNC     _VW2
       RET

 _VW2:
       MOV     DX,SI                   ;Open the file
       MOV     AX,3D00H
       INT     DOSINT
       MOV     READ_HANDLE,AX          ;Save filehandle.
       MOV     AL,NORMAL
       CALL    CLR_SCR                 ;Clear screen.
       MOV     AL,INVERSE              ;reverse video attribute
       XOR     CX,CX                   ;setup status line
       CALL    CLR_EOL

       XOR     DI,DI                   ;start at top of screen
       MOV     SI,CUR_FILE             ;get ptr to record
       INC     SI                      ;inc to filename
       MOV     CX,WHERE_LOC            ;bytes to write
       push    ds
       mov     ax,dir_buf_seg
       mov     ds,ax
       CALL    PUT_CX_CHARS            ;write filename
       ADD     DI,2 * WHERE_LEN        ;skip over file ptr field
       MOV     AL,'/'                  ;add a "/"
       CALL    PUT_CHAR
       MOV     CX,BAR_LEN - WHERE_LOC  ;remainder of status line
       CALL    PUT_CX_CHARS                    ;display it
       pop     ds

       MOV     DS,MEM_BUF_SEG
       ASSUME  DS:DUMMY_SEG

       CALL    FIRST_READ
       MOV     LAST_COL,80
       MOV     BP,OFFSET PAGES         ;Initialize page pointer.
       MOV     ROW,0                   ;And row pointer.

 _VW3: MOV     SI,LAST_PAGE            ;Get top of current page.
       XOR     AH,AH                   ;clear word-wrap/cr flag register
       XOR     CH,CH
       MOV     CL,ROW                  ;Get row offset into page.
       JCXZ    _VW4                    ;skip if it is row zero
       AND     VIEW_FLAGS,NOT DISPLAY_BIT      ; skip display.
       CALL    LINES                   ;format and count BH rows

 _VW4: PUSH    AX                      ;save AH cr/wrap flag
       CALL    PUT_WHERE
       MOV     AH,1
       INT     16h                     ;test keyboard
       POP     AX
       MOV     CX,VIEW_ROWS            ;Now display one screen
       MOV     DI,ROW_LEN              ;start down one line
       JNZ     _VW5                    ;if another key struck, skip display
       OR      VIEW_FLAGS,DISPLAY_BIT          ;Display.
;		inc	cx				    ;REMEMBER-this messes up the Zero flag!
							    ;that's why we're way down here
							    ;line modified per p. esherick 2/11/90
							    ; (+1 added to VIEW_FLAGS)
							    ;but we got rid of the EQU so it got messy
 ;took inc back out again 4.0 -- was causing last line to not be displayed.
 ; Can't reproduce any problems as a result of taking this out.
 _VW5: CALL    LINES                   ;format (and display?) BH lines

 ;process keyboard command entry
 _VW6:
	  cmp	is_mouse,1
	  jne	_VW7
	  call	chk_mb_press
	  jnc 	_VW7
	  call	emulate_keys
	  jmp	short _VW_8
 _VW7:
	  MOV     AH,BIOS_KYBD_01         ;Retrieve keystroke via BIOS.
       INT     16H
	  jz		_VW6
	  MOV	AH,BIOS_KYBD_00
	  int	16h
 _VW_8:
       CMP     AH,1                    ;Is it Esc?
       JZ      _VW_RET                 ;If yes, exit view.
; IFNDEF SAG
       CMP     AH,1CH                  ;Is it carriage return?
       JNZ      _VW9                 ;
	  call	DN_PG
	  jmp	_vw3
; ENDIF
 _VW9:
       MOV     DI,OFFSET VIEW_KEYS     ;get key dispatch
       MOV     AL,AH
       MOV     CX,VIEW_CNT             ;number of valid commands.
       MOV     BX,OFFSET VIEW_TABLE_END
       CALL    LOOKUP                  ;VIEW_KEYS
       JNZ     _VW6                    ;If no, match, get next stroke.
       CALL    CS:[BX]                 ;Do subroutine.
       JC      _VW6                    ;Carry indicates no screen update.
       JMP     _VW3                    ;Else, update and get next command.

 _VW_RET:
       PUSH    CS
       POP     DS

       ASSUME  DS:_TEXT,ES:_TEXT
       CALL    RELEASE_MEM
       MOV     BX,READ_HANDLE          ;Close the file.
       MOV     AH,3EH
       INT     DOSINT
       CALL    PUT_MENU_PATHS          ;Restore menu.
       RET
 VIEW  ENDP
 ;----------------------------------------------------------------------;
 ; These six subroutines control the page and starting row of the view. ;
 ; Screen is updated unless carry flag is set upon return
 ;----------------------------------------------------------------------;
 ; This subroutine moves back one line in the file
 ; On entry : parameters as discussed above
 ; Modifies : ROW
 ;--------------------------------------------------------;
       ASSUME  DS:DUMMY_SEG,ES:_TEXT
 UP_LINE       PROC    NEAR
       CMP     ROW,0                   ;Are we at row zero?
       JNZ     _U_L1                   ;If no, decrement one row.
       CMP     BP,OFFSET PAGES         ;Else, are we at first page?
       STC
       JZ      _U_L_RET                ;If yes, no change.
       CALL    UP_PG                   ;Else, move up one page.
	  mov	cx,view_rows
       MOV     ROW,cl		         ;And move starting row to bottom
 _U_L1:        DEC     ROW                     ;Decrement row.
       CLC                             ;Flag to update screen.
 _U_L_RET:
       RET
 UP_LINE       ENDP

 ;--------------------------------------------------------;
 ; This subroutine moves forward one line in the file
 ; On entry : parameters as discussed above
 ; Modifies : ROW
 ;--------------------------------------------------------;
 DN_LINE       PROC    NEAR
       CALL    CK_FILE_END             ;Are we at end of file?
       JNC     _D_L1                   ;If no, check row.
       RET                             ;Else, return.
 _D_L1:
	  mov	ax,view_rows
	  dec	ax
	  CMP     ROW,al		         ;Are we at last row?
       JB      _D_L2                   ;If no, increment row.
       CALL    DN_PG                   ;Else, page down.
       MOV     ROW,-1                  ;And move row to top.

 _D_L2:        INC     ROW
       CLC
       RET
 DN_LINE       ENDP

 ;--------------------------------------------------------;
 ; This subroutine moves back one full screen in the file
 ; On entry : parameters as discussed above
 ; Modifies : ROW, LAST_PAGE
 ;--------------------------------------------------------;
 UP_PG PROC    NEAR
       CMP     BP,OFFSET PAGES         ;Are we already at first page?
       JNZ     _U_P2                   ;If no, decrement page.
       CMP     ROW,0                   ;Are we at first row?
       STC
       JZ      _U_P_RET                        ;If yes, no update.
       MOV     ROW,0                   ;Else move to first row.
       JMP     SHORT _U_P4

 _U_P1:        CALL    BACKWARD                ;read in previous 1/2 buff

 _U_P2:        MOV     SI,LAST_PAGE            ;Get current page.
       SUB     SI,DS:[BP]              ;Subtract difference to prev page.
       JC      _U_P1                   ;have we already passed zero?
       CMP     SI,OFFSET FILE_BUFF     ;Beyond top of buffer?
       JC      _U_P1                   ;If no, page up.

 _U_P3:        DEC     BP
       DEC     BP                      ;Decrement page pointer.
       MOV     LAST_PAGE,SI            ;Store new starting position.

 _U_P4:        CLC
 _U_P_RET:
       RET
 UP_PG ENDP

 ;--------------------------------------------------------;
 ; This subroutine moves foward one full screen in the file
 ; On entry : parameters as discussed above
 ; Modifies : ROW, LAST_PAGE
 ;--------------------------------------------------------;
 DN_PG PROC    NEAR
       CMP     BP,OFFSET FILE_BUFF-2   ;Out of room for page storage?
       JAE     _D_P1                   ;If yes, skip.
       MOV     SI,LAST_PAGE            ;Else, retrieve current page.
       AND     VIEW_FLAGS,NOT DISPLAY_BIT      ;No display.
       MOV     CX,VIEW_ROWS                    ;Move up 24 lines.
	  XOR	AH,AH			    ;clear eol flag
							    ;p. esherick fix 2/11/90
       CALL    LINES
       CALL    CK_FILE_END             ;End of file?
       JC      _D_P1                   ;If yes, no update.
       MOV     DX,LAST_PAGE            ;Else, save current offset.
       MOV     LAST_PAGE,SI            ;Store new offset.
       MOV     AX,SI
       SUB     AX,DX                   ;Get difference between pages.
       INC     BP                      ;Increment page storage.
       INC     BP
       MOV     DS:[BP],AX              ;And store.
       CLC
       RET

 _D_P1:        STC
       RET
 DN_PG ENDP


 ;--------------------------------------------------------;
 ; This subroutine moves the display pointer
 ; back to the beginning of the file
 ; On entry : FILE_PTR + SI points to current location in file
 ; Modifies : ROW, LAST_PAGE
 ;--------------------------------------------------------;
 HOME_FILE     PROC    NEAR
       CMP     FILE_PTR+2,-1           ;check if start of file is in buffer
       JNZ     _H_F1                   ;nope
       MOV     AX,FILE_PTR             ;yes, then ptr to start of file
       NEG     AX                      ; will be = 0 - FILE_PTR
       MOV     LAST_PAGE,AX            ;save it
       JMP     SHORT _H_F_RET

 _H_F1:        XOR     DX,DX                   ;reset DOS file ptr to start of file
       XOR     CX,CX
       MOV     BX,READ_HANDLE
       MOV     AX,4200H                ;reset file ptr to start of file
       INT     DOSINT
       CALL    FIRST_READ              ;go read it

 _H_F_RET:
       MOV     ROW,0                   ;re-zero counters
       MOV     BP,OFFSET PAGES
       MOV     LAST_COL,80
       CLC
       RET
 HOME_FILE     ENDP


 ;--------------------------------------------------------;
 ; This subroutine moves the display pointer to the end of the file
 ; by successively paging through the buffer
 ;--------------------------------------------------------;
 END_FILE      PROC    NEAR
       CALL    DN_PG                   ;Page down until end of file.
       JNC     END_FILE
       CLC
       RET
 END_FILE      ENDP

 ;--------------------------------------------------------;
 ; This subroutine moves an unwrapped display 16 cols to the left
 ; On entry : VIEW_FLAGS indicates if wrap is in effect
 ; Returns  : modified LAST_COL
 ; Modifies : AX
 ;--------------------------------------------------------;
 LEFT  PROC    NEAR
       TEST    VIEW_FLAGS,WRAP_BIT
       JNZ     _LFT_RET
       MOV     AX,LAST_COL
       CMP     AX,80
       STC
       JZ      _LFT_RET
       SUB     AX,16
       MOV     LAST_COL,AX
 _LFT_RET:
       RET
 LEFT  ENDP

 ;--------------------------------------------------------;
 ; This subroutine moves an unwrapped display 16 cols to the right
 ; On entry : VIEW_FLAGS indicates if wrap is in effect
 ; Returns  : modified LAST_COL
 ; Modifies : AX
 ;--------------------------------------------------------;
 RIGHT PROC    NEAR
       TEST    VIEW_FLAGS,WRAP_BIT
       JNZ     _RGT_RET
       ADD     LAST_COL,16
 _RGT_RET:
       RET
 RIGHT ENDP

 ;--------------------------------------------------------;
 ; The following two subroutines toggle the ASCII and  WRAP flags
 ; when in view mode and then re-start the display at the beginning.
 ;--------------------------------------------------------;
       ASSUME  DS:DUMMY_SEG
 V_ASCII       PROC    NEAR
       CALL    ASCII
       JMP     SHORT   _VSF_1

 VWRAP PROC    NEAR
       CALL    WRAP
 _VSF_1:       CALL    HOME_FILE
       CLC                             ;call for screen update
       RET
 VWRAP ENDP
 V_ASCII       ENDP

 ;----------------------------------------------------------------;
 ; This subroutine checks to see if end of file has been reached. ;
 ;----------------------------------------------------------------;
 CK_FILE_END   PROC    NEAR
       CMP     SI,FILE_END
       JB      _CK_F1
       CMP     FILE_END,OFFSET FILE_BUFF+(READ_SIZE * 2)
       JC      _CK_F2
;      JAE     _CK_F1
;      STC
;      RET

 _CK_F1:       CLC
 _CK_F2:       RET
 CK_FILE_END   ENDP

 ;----------------------------------------------------------------;
 ; This subroutine formats the text into lines.  A line is marked ;
 ; by a line feed, a lone carriage return or,
 ; if word wrap is in effect, by reaching the last column (80).
 ; On entry :  DS:SI points to beginning of text to display
 ;             BP points to a page size entry in PAGES
 ;             CX contains the number of rows to display
 ;             ES:DI points to position in display buffer
 ; Modifies : AX, BX, CX, DX, SI, DI
 ;             AH is used as a flag register for testing end of line cases
 ;             BL is used as a register copy of VIEW_FLAGS
 ;             BH is used as a register copy of STAR_MASK
 ;----------------------------------------------------------------;
       ASSUME  DS:DUMMY_SEG,ES:_TEXT
 LINES PROC    NEAR
       PUSH    ES                      ;save seg register

       MOV     DX,STATUS_REG           ;Retrieve status register.
       MOV     BL,VIEW_FLAGS
       MOV     BH,STAR_MASK

       MOV     ES,VIDEO_SEG            ;Point to screen segment.
       ASSUME  ES:nothing

 _LN0: PUSH    CX
 _LN1: AND     DI,0FFE0H               ;point back to start of line
       MOV     CX,LAST_COL             ;80 columns.

 _LN2: CMP     SI,FILE_END             ;If end of file, pad with spaces.
       JB      _LN3
       CALL    FORWARD                 ;read next block of file
       JC      _LN15

 _LN3: LODS    FILE_BUFF               ;Get a byte.
       AND     AL,BH                   ;Strip high bit for WordStar?
       CMP     AL,cr                   ;Carriage return?
       JA      _LN8                    ; printable char?
       JNZ     _LN4                    ;no, go check for tab or lf
       OR      AH,2                    ;set flag to mark cr
       JMP     _LN2                    ;get next char

 _LN4: CMP     AL,lf                   ; linefeed?
       JNZ     _LN8                    ; no, go display char
       TEST    AH,1                    ;are we following a word wrap?
       MOV     AH,0                    ;clear flags
       JNZ     _LN2                    ;if just wrapped, ignore lf
 _LN5: TEST    BL,ASCII_BIT            ;stripping non-ascii ?
       JZ      _LN7                    ;no
 _LN6: CMP     CX,76                   ;have we had more than five displayed?
       JAE     _LN1                    ;go point back to start of line

 _LN7: CALL    PAD_TO_EOL              ;If yes, pad balance of line.
       JMP     SHORT _LN15

 _LN8: CMP     AH,2            ;was there a CR without a lf or a wrap?
       MOV     AH,0                    ;clear flag
       JNZ     _LN9                    ;no CR, go display this char
       DEC     SI                      ;back up one character
       JMP     _LN5                    ;pad to EOL

 _LN9: JCXZ    _LN2                    ;bypass if 80 chars already written
       CMP     AL,tab                  ;is it a tab?
       JNZ     _LN10                   ;no
       MOV     AL,space                ;expand to spaces
       TEST    BL,ASCII_BIT            ;stripping non-ascii ?
       JNZ     _LN12                   ;yes - just display 1 space
       CALL    DO_TAB                  ;write out spaces
       JCXZ    _LN14                   ;all done ?
       JMP     _LN2                    ;still more

 _LN10:        CMP     CX,80                   ;horizontal scroll in effect?
       JA      _LN13                   ;yes - skip chars at left edge

 IFDEF BLANK_BIT
       TEST    BL,ASCII_BIT+BLANK_BIT          ;stripping non-ascii ?
       JZ      _LN12                   ;no - go display char
       CMP     AL,space                ;control character?
       JGE     _LN12                   ;no - go display char
       TEST    BL,ASCII_BIT            ;stripping non-ascii ?
       JNZ     _LN6                    ;yes, go write EOL
       MOV     AL,space                ;blank non-ascii char
 ELSE
       TEST    BL,ASCII_BIT            ;stripping non-ascii ?
       JZ      _LN12                   ;no - go display char
       CMP     AL,space                ;control character?
       JL      _LN6                    ;yes, go write EOL
 ENDIF

 _LN12:        TEST    BL,DISPLAY_BIT          ;display ?
       JZ      _LN13                   ;return - just counting lines

       CALL    PUT_BYTE
       INC     DI                      ;Bump pointer past attribute.

 _LN13:        LOOP    _LN2                    ;Get next byte.

 _LN14:        TEST    BL,WRAP_BIT             ;is word wrap on?
       JZ      _LN2                    ;no - keep looking for end of line

       MOV     AH,1                    ;set word-wrap flag

 _LN15:        POP     CX                      ;get back line counter
       DEC     CX                      ;this line done- dec line counter
       JZ      _LN17                   ;all done

       JMP     _LN0

 _LN17:        POP     ES                      ;restore segment register
       RET
 LINES         ENDP

 PAD_TO_EOL    PROC    NEAR
       CMP     CX,80                   ;horizontal scroll?
       JBE     PAD_SPACES              ;yes, we only need 80 spaces
       MOV     CX,80

 PAD_SPACES    PROC    NEAR
       MOV     AX,space                ;clear flag, display space
       JCXZ    _PSP_RET
       MOV     DX,STATUS_REG           ;Retrieve status register.
       TEST    BL,DISPLAY_BIT          ;Are we to write it to screen?
       JZ      _PSP_RET                ;If no, return.

 _PSP_1:       CALL    PUT_BYTE
       INC     DI                      ;Bump pointer past attribute.
       LOOP    _PSP_1

 _PSP_RET:
       RET
 PAD_SPACES    ENDP
 PAD_TO_EOL    ENDP


 ;--------------------------------------------------------;
 ; This subroutine expands tabs in VIEW
 ; On entry : CX = columns remaining to display
 ; Returns  : updated CX
 ; Modifies : AX, CX
 ;--------------------------------------------------------;
       ASSUME  DS:DUMMY_SEG,ES:nothing
 DO_TAB        PROC    NEAR
       JCXZ    _D_T2
       MOV     AX,CX
       DEC     AX                      ;Adjust column counter.
       AND     AX,7                    ;Get bottom three bits.
       INC     AX                      ;Adjust.
       CMP     CX,80
       JA      _D_T1
       PUSH    CX
       PUSH    AX
       XCHG    AX,CX
       CALL    PAD_SPACES              ;Move to next tab position.
       POP     AX
       POP     CX
 _D_T1:        SUB     CX,AX                   ;Adjust counter.
 _D_T2:        RET
 DO_TAB        ENDP

 ;-------------------------------------------------------------------;
 ; This subroutine reads the next 1/2 buff
 ; Saves :AX, BX, CX, DX, DI unless end of file encountered
 ;--------------------------------------------------------;
       ASSUME  DS:DUMMY_SEG,ES:nothing
 FORWARD       PROC    NEAR
       CMP     FILE_END,OFFSET FILE_BUFF+ (READ_SIZE * 2)
       JNB     _FWD1
       CALL    PAD_TO_EOL
       STC
       RET

 _FWD1:        PUSH    ES
       PUSH    DI                      ;read next block of file
       PUSH    DX                      ; save pointers
       PUSH    CX
       PUSH    BX
       PUSH    AX
       PUSH    CS
       POP     ES
       ASSUME  DS:DUMMY_SEG,ES:_TEXT

       SUB     LAST_PAGE,READ_SIZE     ;Adjust current page offset.
       XOR     CX,CX                   ;Move file pointer
       MOV     DX,READ_SIZE            ; forward 1/2 buffer
       CALL    MOVE_POINTER
       CALL    NEXT_READ
       CLC
       POP     AX
       POP     BX                      ;Restore pointers.
       POP     CX
       POP     DX
       POP     DI
       POP     ES
       RET
 FORWARD               ENDP


 ;--------------------------------------------------------;
 ; This subroutine starts the first buffer read of a file
 ;--------------------------------------------------------;
 FIRST_READ    PROC    NEAR
       MOV     LAST_PAGE,OFFSET FILE_BUFF+READ_SIZE

 ;--------------------------------------------------------;
 ; This subroutine moves the second half of the buffer to the
 ; the first half and then reads in a half buffer of info into the
 ; second half
 ; On entry : no known parameters
 ; Returns  : nothing
 ; Modifies : everything
 ;--------------------------------------------------------;
 NEXT_READ     PROC    NEAR
       MOV     SI,OFFSET FILE_BUFF+READ_SIZE
       MOV     DI,OFFSET FILE_BUFF     ;Move second half of buffer
       CALL    MOVE_BUFFER             ; to first half and read 1/2 buffer
       MOV     CX,-1                   ;Move file pointer back.
       NEG     DX
       CALL    MOVE_POINTER
       SUB     AX,OFFSET FILE_BUFF + READ_SIZE
       CALL    SAVE_FPTR
       RET
 NEXT_READ     ENDP
 FIRST_READ    ENDP

 ;--------------------------------------------------------;
 ; This subroutine goes back and reads the previous 1/2 buff
 ;--------------------------------------------------------;
 BACKWARD      PROC    NEAR
       ADD     LAST_PAGE,READ_SIZE     ;Adjust current page offset.
       MOV     CX,-1                   ;Move pointer back full buffer
       MOV     DX,- (READ_SIZE * 2)
       CALL    MOVE_POINTER
       SUB     AX,OFFSET FILE_BUFF
       MOV     SI,OFFSET FILE_BUFF+READ_SIZE; buffer to second
       CALL    SAVE_FPTR
       MOV     DI,SI
       MOV     SI,OFFSET FILE_BUFF     ;Move first half of
       CALL    MOVE_BUFFER
       RET
 BACKWARD      ENDP

 ;--------------------------------------------------------;
 ; This subroutine moves 1/2 buffer from [SI] to [DI]
 ; and then reads in a half buffer into the original [SI] position
 ; On entry : SI, DI pointers
 ; Returns  : DX = bytes read
 ; Modifies : everything
 ;--------------------------------------------------------;
       ASSUME  DS:DUMMY_SEG,ES:_TEXT
 MOVE_BUFFER   PROC    NEAR
       MOV     DX,SI                   ;Save pointer.
       MOV     CX,READ_SIZE / 2        ;Move (1/4 buffer) words=1/2 buffer
       PUSH    ES
       MOV     ES,MEM_BUF_SEG

       ASSUME  ES:DUMMY_SEG
       REP     MOVSW
       MOV     BX,READ_HANDLE
       MOV     CX,READ_SIZE            ;Read 1/2 buffer.
       MOV     AH,3FH                  ;Read file into DS:DX
       INT     DOSINT                  ;return AX= # bytes read
       POP     ES

       ASSUME  DS:DUMMY_SEG,ES:_TEXT
       MOV     SI,DX                   ;get back pointer
       MOV     DX,AX                   ;save number of bytes read
       ADD     AX,OFFSET FILE_BUFF + READ_SIZE
       MOV     FILE_END,AX             ;Store end of buffer offset.
       RET
 MOVE_BUFFER   ENDP

 ;--------------------------------------------------------;
 ; This subroutine call DOS function to do a relative move of the file pointer
 ; On entry : no known parameters
 ; Returns  : DX:AX = new pointer location
 ; Modifies : everything
 ;--------------------------------------------------------;
       ASSUME  DS:DUMMY_SEG,ES:_TEXT
 MOVE_POINTER  PROC    NEAR
       MOV     BX,READ_HANDLE
       MOV     AX,4201H                ;Move file pointer.
       INT     DOSINT
       RET
 MOVE_POINTER  ENDP


 ;--------------------------------------------------------;
 ; This subroutine saves the current absolute file pointer location
 ; in a form such that SI + FILE_PTR = absolute location in file of
 ; the first byte displayed on the screen
 ; On entry : DX:AX = (DOS pointer) - OFFSET FILE_BUFF of last read
 ; Returns  : nothing
 ; Modifies : DX
 ;--------------------------------------------------------;
       ASSUME  DS:DUMMY_SEG,ES:_TEXT
 SAVE_FPTR     PROC    NEAR
       JNC     _SFP1
       DEC     DX
 _SFP1:        MOV     FILE_PTR,AX             ;save pointer low word
       MOV     FILE_PTR+2,DX           ;and high
 ;     RET                     ;let this run on and display pointer
 SAVE_FPTR     ENDP

 ;-------------------------------------------------------------------;
 ; Display on VIEW status line the current position in file
 ; On entry : SI contains current position in buffer
 ; Returns  : nothing
 ; Modifies : AX, BX, CX, DX, DI
 ; Preserves: DS, SI, BP
 ;-------------------------------------------------------------------;
 PUT_WHERE     PROC    NEAR
       ASSUME  DS:DUMMY_SEG,ES:_TEXT
       PUSH    SI
       PUSH    DS
       MOV     AX,FILE_PTR
       MOV     DX,FILE_PTR+2
       PUSH    CS
       POP     DS
       ASSUME  DS:_TEXT
       ADD     AX,SI
       JNC     _P_W1
       INC     DX
 _P_W1:        MOV     DI,OFFSET CMD_LINE
       PUSH    DI
       MOV     CX,WHERE_LEN
       CALL    FORMAT
       POP     SI
       MOV     CX,WHERE_LEN
       MOV     DI,2 * WHERE_LOC
       CALL    PUT_CX_CHARS
       MOV     SI,OFFSET OPTIONS
       MOV     DI,2 * (78 - OPTIONS_LEN)
       MOV     CX,OPTIONS_LEN
       MOV     BL,VIEW_FLAGS           ;get option flags
       ROL     BL,1                    ;star option always displayed
 _P_W2:        LODSB                           ;get option mneumonic
       RCR     BL,1                    ;rotate through carry
       JC      _P_W3                   ;is option set?
       OR      AL,20H                  ;no - display lower case
 _P_W3:        CALL    PUT_CHAR                ;display it
       LOOP    _P_W2                   ;do some more
       POP     DS
       POP     SI
       RET
 PUT_WHERE     ENDP
 ;----------------------------------------------------------------------;
 ; This subroutine displays the highlighted file for viewing. ;
 ; On entry : no known parameters
 ; Returns  : nothing
 ; Modifies : everything
 ;----------------------------------------------------------------------;
       ASSUME  DS:_TEXT,ES:_TEXT
 VIEW_DIR      PROC    NEAR
       PUSH    SI                      ;save pointer
       MOV     DI,OFFSET TMP_BUFF      ;point to storage
       MOV     SI,DI                   ;and save a copy
       MOV     AL,space                ;use spaces
       MOV     CX,80                   ;to clear TMP_BUFF
							    ;increased from 12 4.0
       REP     STOSB
       MOV     DI,FILE_NAME            ;get dir/filename pointed to
       MOV     AX,[DI]
       CMP     AX,'..'                 ;is it parent?
       JNZ     _V_D2                   ;no - go ahead

       DEC     DI                      ;save currently displayed dir name
       DEC     DI
       PUSH    DI
       MOV     CX,DI
       SUB     CX,OFFSET SOURCE -1
       MOV     AL,'\'

 IFDEF SAG
       CMP     SWITCH,"/"              ;do we really want "/" instead?
       JE      _V_D1                   ;no
       MOV     AL,'/'                  ;yes
 _V_D1:
 ENDIF
       STD
       REPNZ   SCASB                   ;find beginning
       INC     DI
       CLD
       POP     CX
       SUB     CX,DI
       XCHG    SI,DI                   ;now DI points to TMP_BUFF
       INC     SI
       REP     MOVSB                   ;save current dir

 _V_D2:        POP     SI                      ;get back pointer to cur dir
       CALL    NEW_WORK_DIR            ; and change directory

       PUSH    DI
	  MOV	SI,OFFSET TMP_BUFF
	  CALL	DIR_FORMAT
	  POP	DI

 _V_D3:
       CALL    GET_NAME                ;get SI pointer to current name
       INC     SI                      ;point to first char
       MOV     CX,12                    ;limit search to filename field
       MOV     DI,OFFSET TMP_BUFF
       PUSH    DI

       push    ds
       mov     ax,dir_buf_seg
       mov     ds,ax
       assume ds:NOTHING
       REPZ    CMPSB                   ;string compare
       assume ds:_TEXT
       pop     ds
       assume ds:_TEXT
       POP     DI
       JZ      _V_D_RET                ;found it - all done
       MOV     BL,[DI]                 ;check first char of dir name
       CMP     BL,space                ;is there anything but spaces?
       JZ      _V_D_RET                ;no, so all done
       CALL    SEARCH
       JNC     _V_D3                   ;carry if SEARCH failed

 _V_D_RET:
       RET
 VIEW_DIR      ENDP

 ;-----------------------------------------------------------------------;
 ; This subroutine searches for a filename matching the characters
 ; contained in TMP_BUFF (space terminated)
 ; On entry : TMP_BUFF contains string to search for
 ; Returns  : nothing
 ; Modifies : assume everything
 ;-----------------------------------------------------------------------;
 SEARCH_DIR        PROC    NEAR
       assume  es:nothing

       mov     di,offset tmp_buff
       inc     di
       xor     cx,cx
 _sdir_25:
       cmp     byte ptr [di],20
       jne     _sdir_50
       inc     di
       inc     cx
       jmp     _sdir_25
 _sdir_50:
       ;length of string now in cx

       push    es
       mov     es,dir_buf_seg

 _SDIR_100:       
       push    cx                      ;Save String length
       CALL    GET_NAME                ;Get current position.
       pop     bx                      ;transfer string length to bx
       XOR     DX,DX                   ;Zero out file counter.
       MOV     DI,SI                   ;Store current position in DI.
       INC     DI                      ;point to filename

       mov     di,dbs_start
       inc     di

       sub     di,FIELD_SIZE
;       CMP     BYTE PTR es:[DI],BL        ;Are we currently at a match?
;       JNZ     _SDIR_300                  ;If no, start from top.

 _SDIR_200:       INC     DX                      ;Increment count.
        ADD     DI,FIELD_SIZE           ;Increment record.
;       CMP     SI,DI                   ;New record?
;       JBE     _SDIR_200                  ;If no, find it.

 _SDIR_300:       
       mov     si,offset tmp_buff+1
       rep     cmpsb
;      CMP     BYTE PTR es:[SI],BL        ;Got a match?
       JZ      _SDIR_400                  ;If yes, process.

       ADD     SI,FIELD_SIZE           ;Else, point to next record.
       INC     DX
       CMP     BYTE PTR es:[SI],space     ;End of listing?
       JNZ     _SDIR_300                  ;If no, keep searching.
       CALL    BEEP                    ;No matches, so beep.
       pop     es
       assume  es:_text
       STC
       RET

 _SDIR_400:
;       assume es:nothing

       ;DF 4.60 pass 6.  I think moving this pop up here solves all the
       ; VERY hard to trace garbage on screen problems.  Not sure
       ;exactly where the garbage was coming from but it had something
       ;to do with the scroll/bar movement routines.  We have
       ;the count so don't need the directory segment any longer here


       pop     es
       MOV     CX,COUNT                ;Retrieve file count.
       SUB     CX,DX                   ;Subtract search count.
       MOV     SEARCH_COUNT,CX         ;And store.
       MOV     CL,NORMAL               ;Turn off bar for now.
	  MOV	LINE_CNT_DISP,0	    ;Turn off line number display for now
       MOV     BAR_ATTRIBUTE,CL
       CALL    END_BAR                 ;First move to end.
       JMP     SHORT _SDIR_600

 _SDIR_500:       CALL    UP_ARROW                ;Move up to matching filename.

 _SDIR_600:       DEC     SEARCH_COUNT
       JNZ     _SDIR_500

       MOV     CL,INVERSE              ;Turn bar back on and display.
	  MOV	LINE_CNT_DISP,1	    ;Turn line number display back on
       MOV     BAR_ATTRIBUTE,CL
       XOR     BP,BP
       CALL    SCROLL_BAR
       CLC
       RET
 SEARCH_DIR        ENDP

