;--------------------------------------------------------------------------
; Print the directory listing to the PRN device
;--------------------------------------------------------------------------
     stack_pointer  dw   ?

 print_dir	proc near

     mov       ax,sp                    ;lot of error handling here
     mov       stack_pointer,ax         ;make sure stack pointer comes out OK

	call		open_printer
	jc		_pd_err

	mov		bx,ax
	push		bx					;save file handle

	call		print_cr
	jc		_pd_err

     call      print_pad
	jc		_pd_err
     mov       si,offset directory
	mov		ax,80
	call		print_string
	jc		_pd_err
	mov		si,offset work_path
	mov		ax,80
	call		print_string
	jc		_pd_err

     MOV       si,OFFSET WORK_PATH     ;Display working directory.
     mov	     bl,byte ptr [si+3]      ;if there's a NULL at offset 3, then it's a
							    ;drive letter only (which means it already
							    ;has a trailing '/'
     mov	     si,offset file_mask     ;display mask with preceeding \
     and	     bl,bl	   		         ;don't add another \ if have a F:\ type line
     jz		_PD_1
     dec	     si
 _PD_1:
	pop		bx
     mov       ax,20
	call		print_string
	jc		_pd_err
	call		print_cr
	jc		_pd_err
	call		print_cr
	jc		_pd_err

     assume es:nothing
     push      es
     mov       es,dir_buf_seg
;     mov       si,offset dir_buff
     mov       si,dbs_start
	mov		cx,count
 _PD_2:
	inc		si			;skip past the first character; the mark <esc>
						;character was causing indigestion
     assume ds:nothing
     push      ds
     mov       ax,es
     mov       ds,ax
	mov		ax,field_size-1 ;compensate for si increment
     call      print_pad
	jc		_pd_err
	call		print_string
     pop       ds
     assume ds:_text
     jc        _pd_err_res
	call		print_cr
     jc        _pd_err_res
	loop		_pd_2
	jmp		short _pd_3
 _pd_err_res:
     pop       es                       ;,ake sure es is restored
 _pd_err:
	jmp		short _pd_err_ret		;lily pad for error jumps

 _PD_3:
     pop       es
     assume es:_text
	call		print_cr
	jc		_pd_err

     call      print_pad
	jc		_pd_err
     mov       ax,field_size-2          ;adjusted length 4.61
	mov		si,offset vol_name
	call		print_string
	jc		_pd_err
	call		print_cr
	jc		_pd_err

;	mov		ax,field_size-3
;	mov		si,offset dest_free
;	call		print_string
;	jc		_pd_err
	call		print_cr
;	jc		_pd_err

     call      print_pad
	jc		_pd_err
     mov       ax,26                    ;adjusted length 4.81
	mov		si,offset subdir_msg+16
	call		print_string
	jc		_pd_err
	call		print_cr
	jc		_pd_err

	call		print_ff
	jc		_pd_err

	mov		ah,3Eh				;close file
	int		21h
	jc		_pd_err
	ret
 _PD_err_ret:
     mov     ax,stack_pointer
     mov     sp,ax
     mov     si,offset open_print_err
     MOV     AH,INTENSE              ;get display attribute
     OR      AH,80H                  ;make it blink
     MOV     DI,PROMPT_LOC+6
     CALL    PUT_STRATT
     CALL    DELAY
	ret
 print_dir 	endp

;----------------------------------------------------------------------------
; Prints a string to the set printer device; either null terminated or
;   AX characters -- whichever comes first
; On entry: BX contains the file handle, SI points to beginning of string
;           AX contains max chars to print
; Modifies: AX, SI,AX -- uses but preserves CX
;           Advances SI
; Returns: clear carry if successful, set carry if failed with status in AH
;----------------------------------------------------------------------------
 print_string	proc near

	push		cx
_ps_1:

	push		ax
	call		str_len			;gets length of string pointed to by si
	pop		ax
	sub		ax,cx
	jnc		_ps_2			;cx < ax (length less than max chars. Use length.)
	add		ax,cx
	mov		cx,ax
_ps_2:
	mov		dx,si               ;point to string
							;bx = file handle
	mov		ah,40h			;write to file/device
	int		21h
     jc        _ps_err
	add		si,cx
	jmp		short _ps_ret

_ps_err:
	pop		cx
	stc
	ret
_ps_ret:
	pop		cx
	clc
	ret

print_string	endp

pad_char  db   ' '

print_pad      proc near
     push      ax cx dx si
     ;with directory, can't guarantee how ds and es are set
     push      ds
     push      cs
     pop       ds
     mov       cx,1
     xor       ax,ax
     mov       dx,offset pad_char
     mov       al,PAD_CHARS
     mov       si,ax
_ppad1:
     cmp       si,0
     je        _ppad_ret
     mov       ah,040h
     int       21h
     jc        _ppad_err
     dec       si
     jmp       _ppad1
_ppad_err:
     pop       ds si dx cx ax
     stc
     ret
_ppad_ret:
     pop       ds si dx cx ax
     clc
     ret
print_pad      endp

 cr_nl	db	13,10

 print_cr		proc near
	push	cx
	mov	ah,40h
	mov	cx,2
	mov	dx,offset cr_nl
	int	21h
	pop	cx
	jc	_pcr_err
	clc
	ret
 _pcr_err:
	stc
	ret
 print_cr		endp

 ff		db	12

 send_ff  proc near
	call		open_printer
     jc        _pff_err
	mov		bx,ax
 print_ff proc near
	push	cx
	mov	ah,40h
	mov	cx,1
	mov	dx,offset ff
	int	21h
	pop	cx
	jc	_pff_err
	clc
	ret
 _pff_err:
	stc
	ret
 print_ff	endp
 send_ff  endp


 prn_name db   'PRN '

 open_printer	proc near

	mov		al,printer_port
     cmp       al,9
     jne       _op_1
     mov       cx,4
     mov       si,offset prn_name
     mov       di,offset printer_name
     rep       movsb
     jmp       short _op_2
 _op_1:
     add       al,31h              ;convert printer number to ASCII (0=LPT1)
	mov		byte ptr[printer_name+3],al
 _op_2:
	mov		ah,3Dh                  ;open printer
	mov		al,10b
	mov		al,10b
	mov		dx,offset printer_name
	int		21h
	jnc		_op_ret
 _op_err:
	stc
	ret
 _op_ret:
	clc
	ret
 open_printer	endp