;returns BIOS equipment info (40:10h) in reg16
.RETURN_EQUIP  MACRO     reg16
     push      es
     mov       ax,040h
     mov       es,ax
     mov       reg16,es:[010h]
     pop       es
ENDM

;pass the address in the CMOS data area
;Byte value at that address is retruned in al
.READ_CMOS   MACRO     adr
     cli
     mov       dx,070h
     mov       al,adr
     out       dx,al
     nop
     nop
     inc       dx
     in        al,dx
     sti
ENDM

;Pass the address in the CMOS data area
;Value to write in al
.WRITE_CMOS    MACRO     adr,data
     cli
     mov       dx,070h
     mov       al,adr
     out       dx,al
     inc       dx
     mov       al,data
     nop
     nop
     out       dx,al
     sti
ENDM

.put_MSG     MACRO
     mov       si,offset none
     mov       di,offset si_line1
     call      copy_null
ENDM

IODELAY macro
        jmp     short $+2          ; short delay between I/O
        jmp     short $+2          ;  to same device
        endm

.testchar  macro reg16
     push ax
     push di
     mov  al,'T'
     mov  di,reg16
     stosb
     pop  di
     pop  ax
endm

 WORK_EQ_DEST		MACRO
	call		read_dir
 ENDM

.to_upper macro     arg1
local          to_upper_080
          cmp  arg1,"a"
           jb  to_upper_080
          cmp  arg1,"z"
           ja  to_upper_080
          and  arg1,0DFh
to_upper_080   label     near
endm

.ABS macro arg1
local	nosign
		or 	arg1,arg1
		jns	nosign
		neg	arg1
nosign	label near
endm

.pushall      MACRO
     push ax bx cx dx si di ds es
     pushf
endm

.popall        MACRO
     popf
     pop  es ds di si dx cx bx ax
endm