;DFERROR.ASM
;Critical error handler adapted from Spontaneous Assembler routines

 err_table label word
				dw	err0,err1,err2,err3,err4,err5,err6,err7
                    dw   err8,err9,errA,errB,errC,errD,errE,errF
 err_count		equ $-err_table
 err0			db	"Write-protected diskette",0
 err1			db	"Unknown or bad unit",0
 err2			db	"Drive not ready",0
 err3			db	"Unknown command",0
 err4			db	"Data error (bad CRC)",0
 err5			db	"Bad reqst struct lngth",0
 err6			db	"Seek error",0
 err7			db	"Unknown media type",0
 err8			db	"Sector not found",0
 err9			db	"Printer out of paper",0
 errA			db	"Write fault",0
 errB			db	"Read fault",0
 errC			db	"General failure",0
 errD               db   "Share violation",0
 errE               db   "Lock violation",0
 errF               db   "Wrong disk",0

 COMMAND_LINE_ERR   db "Fatal command line error occurred on Drive  ",13,10,'$'
 DISK_MSG      DB  " on "
 ERROR_DISK    DB  " :  ",0
 RETRY_MSG     DB  "(R)etry, (Q)uit or Escape?",0
 RETRY2_MSG    DB  "(R)etry or Escape?",0
 errtest_msg   db  "Error Message Test",0

user_error     proc near
_ue_20:
     call      beep
     push      es
     mov       bx,ds
     mov       es,bx

     xor       bx,bx
     mov       bl,al
     sub       bl,19
     shl       bl,1
     mov       si,[err_table+bx]

     cmp       on_command_line,0
                 ;command line termination added rev. 4.0
                 ;The system was hanging if a critical
                 ;error such as no floppy was occurring
                 ;on the command line.  (Probably some of
                 ;the functions or variables used by the
                 ;functions called by the critical error
                 ;handler weren't initialized yet.
     jz        _ue_30                  ;not on coomand line, continue
     mov      di,offset command_line_err+43 ;add failed drive letter to error message
     mov      [di],dh                       ;dh contains drive letter
     mov      dx,offset command_line_err
     mov      ax,0900h
     int      21h                           ;print error message to console
     mov       si,offset error_exit
     mov       dh,CE_QUIT
     pop       ax                      ;leave es = ds
     retf


_ue_30:
     push      di dx
     call      clr_error
     pop       dx di
     cmp       in_sysinfo,0
     je        _ue_38

     mov       di,prompt_loc2 +4
     call      put_string
       mov     al,dh
       push    di
       mov     di,offset error_disk
       stosb
       pop     di

       MOV     SI,OFFSET DISK_MSG      ;display drive letter
       CALL    PUT_STRING

       MOV     SI,OFFSET RETRY2_MSG
       MOV     DI,PROMPT_LOC3 + 4         ;Display <esc>, (Q)uit, (R)etry
       CALL    PUT_STRING
      jmp       short _ue_50

_ue_38:
       MOV     DI,PROMPT_LOC           ;display error message
       CALL    PUT_STRING
       test    dl,010000000b           ;if DL bit 7 =0, is disk drive
       jnz     _ue_40                  ;set, therefore other device
       mov     al,dh
       push    di
       mov     di,offset error_disk
       stosb
       pop     di

       MOV     SI,OFFSET DISK_MSG      ;display drive letter
       CALL    PUT_STRING
_ue_40:
       MOV     SI,OFFSET RETRY_MSG
       MOV     DI,PROMPT_LOC2          ;Display <esc>, (Q)uit, (R)etry
       CALL    PUT_STRING
_ue_50:
     CALL      READ_KEY
     CMP       AH,13H                  ;Was it scan code for "R"?
     jne       _ue_100
     mov       dh,CE_RETRY
     CALL      CLR_error          ;Clear disk error message.
;     mov       in_sysinfo,0
     pop       es
     retf
_ue_100:
     CMP       AH,1                    ;Is it Esc?
     jne       _ue_110
     mov       dh,CE_FAIL
     CALL      CLR_error          ;Clear disk error message.
;     mov       in_sysinfo,0
     pop       es
     retf
_ue_110:
     cmp       ah,10h
     jne       _ue_50
     CALL      CLR_error          ;Clear disk error message.
     cmp       in_sysinfo,0
     jne        _ue_50
_ue_120:
     mov       dh,CE_QUIT
     mov       si,offset terminate ;offset of termination address
     pop       ax                  ;adjust stack
     mov       ax,ds
     mov       es,ax               ;es:si points to address of TERMINATE
     mov       in_sysinfo,0
     retf
user_error     endp

clr_error      proc near

     push      ax cx dx
     mov       al,c_intense
     mov       dx,end_window
     mov       cx,beg_window
     cmp       in_sysinfo,0
     je        _cerror_50
     add       cx,100h                  ;add a row
_cerror_50:
     call      clr_window
     pop       dx cx ax
     ret

clr_error      endp



$cem_user dw   0         ;word address of CEM user function
_osmajor  db   0

;FUNC:    CEM_INSTALL
;
;DESC:    Installs the Critical Error Manager.
;
;IN: DX:AX          address of the user function to be called whenever
;              a critical error occurs ("addr"); AX=-1 if none (DX
;              ignored in small code models)
;
;ASUMS:   DS        @DATASEG (small data models only)
;
;OUT:     None
;
assume         cs:_TEXT, ds:_TEXT, es:nothing, ss:nothing

cem_install    proc near
          push     ax dx

          mov  word ptr $cem_user,ax    ;store user function address
          mov  dx,cs               ;DX:AX points to $CEM
          mov  ax,offset $cem
          call     ce_install          ;install as crit err handler
          pop dx ax
          ret
cem_install    endp


;FUNC:    $CEM
;
;DESC:    Critical Error Manager
;
;IN:      None
;
;OUT:     None
;
;ALG:     Be careful in choosing which function call to use in forcing DOS
;    into a stable state.  Some calls are intercepted by TSR's and are
;    not passed along to DOS.  Other calls are only superficially
;    processed by DOS, so they won't force DOS into a stable state--
;    even if they have function numbers greater than 0Ch.


assume         cs:_TEXT, ds:nothing, es:nothing, ss:nothing

$cem      proc far
          push     bx cx dx ds es ;!! code depends on 5 pushes !!

;-----------------------------------------------------------------------------
; Set up input values for user function
;-----------------------------------------------------------------------------

          push cs
          pop  ds
          mov  dx,dos_version
          mov  _osmajor,dl

assume ds:_TEXT

          xchg dx,ax          ;DH = error information
          add  dl,"A"         ;DL = drive *letter* if block device
          cmp  _osmajor,3     ;running DOS 3.0 or later?
           jae $cem_010  ;  y: leave bits 3-5 alone
          or   dh,00111000b   ;  n: allow FAIL, RETRY, IGNORE
$cem_010: mov  es,bp
          mov  bp,sp          ;!! (assumes only 5 items on stack)
          test dh,80h         ;disk drive?
           jz  $cem_030  ;  y: DL holds drive letter
          xor  dl,dl          ;  n: DL holds device code
          mov  ax,es:[si+4]   ;get device attribute bits
          test ah,80h         ;error in the FAT?
           jz  $cem_030  ;  y: DL=0 if FAT
          mov  cx,4      ;  n: get device number in DL
$cem_020: inc  dx        ;DL=01 if standard input device
          shr  al,1      ;DL=02 if standard output device
           jc  $cem_030  ;DL=03 if NULL device
           loop     $cem_020  ;DL=04 if clock device
          mov  dl,-1          ;DL=-1 otherwise (unknown device)
$cem_030: xchg dl,dh          ;DL=info, DH=drive
          add  si,10          ;ES:SI -> 8 byte name of device
          mov  ax,di
          add  al,E_WRPROTECT ;AL = default E_CODE error code
          mov  ah,[bp+10+6+1] ;!! AH = DOS function call number

;-----------------------------------------------------------------------------
; Call user function and perform requested action (if installed)
;-----------------------------------------------------------------------------

          cmp  word ptr $cem_user,-1    ;user function installed?
           je  $cem_080       ;  n: skip call, FAIL
          push     ax dx bp ds         ;save required registers
          push cs             ;emulate far call
          call $cem_user      ;call user func (does RETF)
          pop ds bp cx ax     ;restore needed registers
          mov  dl,cl               ;restore DL via CL
          cmp  dh,-1
           je  $cem_070       ;QUIT (always allowed)
          cmp  dh,3
           jae $cem_080       ;FAIL (always allowed, even
          cmp  dh,1           ;  if not allowed by DOS)
           ja  $cem_050       ;ABORT
          mov  cl,00010000b
           je  $cem_040       ;RETRY
          shl  cl,1           ;IGNORE
$cem_040: test dl,cl               ;is this operation allowed?
           jz  $cem_080       ;  n: FAIL instead
$cem_050: mov  al,dh               ;AL = action code

;-----------------------------------------------------------------------------
; ABORT or RETRY or IGNORE
; AL      00 = ignore
;         01 = retry
;         02 = abort
;-----------------------------------------------------------------------------

$cem_060: pop es ds dx cx bx  ;let DOS perform the action
          iret

;-----------------------------------------------------------------------------
; QUIT (pass control to arbitrary address)
; ES:SI        address of location to which control should be passed
; BP      same as SP
;-----------------------------------------------------------------------------

$cem_070: mov  [bp+10+6+18],si          ;!! set up return address
          mov  [bp+10+6+18+2],es   ;!!
          jmp  short $cem_100      ;restore regs and exit

;-----------------------------------------------------------------------------
; FAIL
; AL      default error code (describing the critical error)
; AH      function number of DOS call to FAIL
; BP      same as SP
;-----------------------------------------------------------------------------

$cem_080: cmp  ah,0Fh              ;function 00h-0Eh?
           jb  $cem_120       ;  y: return -1 in AH
          cmp  ah,36h              ;function 0Fh-35h?
           jb  $cem_110       ;  y: return -1 in AL
           je  $cem_130       ;  36h: return -1 in AX

;-----------------------------------------------------------------------------
; FAIL (DOS 2.x functions which return an error code in AX)
; AH      function number of DOS call to FAIL
; AL      default error code
;-----------------------------------------------------------------------------

          xor  ah,ah               ;extend error code into AX
$cem_090: mov  [bp+10+6],ax        ;!! return in AX
$cem_100: mov  ah,30h              ;force DOS into a stable state
          int  21h            ;(trashes AX,BX,CX)
          or   byte ptr [bp+10+6+18+4],01h;!! return CF set
          add  sp,10+6             ;!! strip junk from stack
          pop  ax bx cx dx si di bp ds es
          iret                ;return just past INT 21h

;-----------------------------------------------------------------------------
; FAIL (DOS 1.x functions which return an error code in AL)
; AH      function number of DOS call to FAIL
;-----------------------------------------------------------------------------

$cem_110: mov  al,-1               ;return -1 in AL
          jmp  $cem_090

;-----------------------------------------------------------------------------
; FAIL (DOS 1.x functions which return no error code)
;-----------------------------------------------------------------------------

$cem_120: mov  byte ptr [bp+10+6+1],-1  ;!! return -1 in AH
          jmp  $cem_100

;-----------------------------------------------------------------------------
; FAIL (DOS function 36h, which returns -1 in AX)
;-----------------------------------------------------------------------------

$cem_130: mov  ax,-1               ;return -1 in AX
          jmp  $cem_090       ;restore regs and continue
$cem      endp

;FUNC:    CE_REMOVE
;
;DESC:    Removes an installed DOS critical error handler.
;
;IN: _PSP      segment address of the Program Segment Prefix
;              (all models except TINY)
;
;ASUMS:   DS        @DATASEG (SMALL and MEDIUM models only)
;
;OUT:     None
;
assume         cs:_TEXT, ds:_TEXT, es:nothing, ss:nothing

ce_remove  proc near
          push     ax dx ds

          lds  dx,cs:12h ;get original critical error handler
          mov  ax,2524h  ;  address from PSP storage location
          int  21h       ;reinstall as INT 24h vector
          pop  ds dx ax
          ret
ce_remove endp;FUNC:    CE_INSTALL


;DESC:    Installs a critical error handler.
;
;IN: DX:AX          address of the new critical error handler ("addr")
;
;OUT:     None

ce_install     proc near
          push     dx ds
          mov  ds,dx
          xchg dx,ax          ;DS:DX now holds crit err handler addr
          mov  ax,2524h  ;set vector for INT 24h
          int  21h
          xchg ax,dx          ;restore AX
          pop dx ds
          ret
ce_install     endp