;-----------------------------------------------------------------------
;DFCFG.ASM
;
;Module which reads in the readings from a .cfg file
;-----------------------------------------------------------------------

;-----------------------------------------------------------------------
; Command-line CFG setup
; Have to do this before the regular command-line parsing because the
; user-defined attributes have to be correct before all the pre-processing
; can proceed
;------------------------------------------------------------------------
cfg_cmdline    proc near

       cmp     no_cfg,1
       je      _cc_ret
       MOV     DI,OFFSET CMD_LINE      ;Point to command line
       XOR     CX,CX
       MOV     CL,[DI]
       INC     CX
       INC     DI
       PUSH    DI
       PUSH    CX

 _cc100:
       MOV     AL,SWITCH
       REPNZ   SCASB
       JNZ     _cc200
       MOV     AL,[DI]
       PUSH    DI
       PUSH    CX

       AND     AL,5FH

       cmp     AL,"C"
       jz      _cc150
       pop     cx
       pop     di
       loop    _cc100
_cc150:
       MOV     WORD PTR [DI-1],2020h
       pop     cx
       pop     di
       call    set_cfg_file
;       call    read_cfg_file
 _cc200:
       call    read_cfg_file
       POP     CX
       POP     DI
_cc_ret:
       ret

cfg_cmdline    endp

;-----------------------------------------------------------------------
; Stores CFG file name from command line in tmp_file_buf
;-----------------------------------------------------------------------
set_cfg_file  proc near
     push di
     mov  is_cfg,1     ;flags that a cfg file is stored
     mov  si,di

     mov  di,offset target
     inc  si                       ;si was pointing to the flag character
_stf_100:
     cmp  byte ptr [si],0Dh
     je   _stf_ret
     cmp  byte ptr [si],20h
     je   _stf_ret
     movsb
     mov  byte ptr [si-1],20h   ;command line parsing requires blanking as used
     jmp _stf_100

_stf_ret:
     mov byte ptr [di],0           ;null terminate
     pop  di
     ret
set_cfg_file  endp



read_cfg_file  proc near
     push bx   ;must save for file stuff in DF initialization
     cmp  is_cfg,1
     je   _rcf_200       ;filename specified on command line

                         ;first we copy DF's name from the PSP
                         ;we will then clear off the name on the
                         ;end and leave the path
     push es
     mov  ax,psp_env_seg
     mov  env_seg,ax
     mov  es,ax
     xor  di,di
     mov  al,0
     mov  cx,0FFFFh      ;set cx to max for scasb search
_rcf_50:
     repne scasb           ;search for the double 0's which mark the end
                           ;of the environment block
     cmp  byte ptr es:[di],0
     je   _rcf_60
     inc  di
     jmp  _rcf_50
_rcf_60:
     add  di,3               ;pointing to the start of the filename
     mov  si,offset work_path   ;more temporary storage
_rcf_65:
     mov  al, byte ptr es:[di]
     mov  byte ptr ds:[si],al
     cmp  al,0
     je   _rcf_80
     inc  si
     inc  di
     jmp  _rcf_65
_rcf_80:
     pop  es
     mov  si,offset work_path
     mov  di,offset target
     mov  cx,2
     rep  movsb       ;copy the drive letter which split_path doesn't
     call split_path

     mov  si,offset cfg_file
_rcf_100:
     cmp  byte ptr [si],0
     je   _rcf_150
     movsb
     jmp  _rcf_100
_rcf_150:
     mov byte ptr [di],0           ;null terminate
_rcf_200:                          ;We now have a null-terminated .CFG
                                   ;file name stored in target
                                   ;with the pathname of the executing
                                   ;version of DF
     mov  si,offset target
     mov  al,0                ;read-only
     call openex_h            ;open existing file
                              ;bx=file handle
     jc   _rcf_not_found      ;file not found
     call parse_cfg_file
     jc   _rcf_bad
     pop  bx
     clc
     ret
_rcf_not_found:
     cmp  is_cfg,1
     jne  _rcf_ok        ;we couldn't find the deafult df.cfg.  This is OK.
                         ;we just use the stored values in the COM file
                         ;if cfg file was specified on command line, isn't ok
     mov  dx,offset miss_cfg_file
     mov  ah,9
     int  21h
     pop  bx
     jmp  _cfg_exit
_rcf_ok:
     pop  bx
     clc
     ret
_rcf_bad:
     mov  dx,offset bad_cfg_file
     mov  ah,9
     int  21h
     pop  bx
                 ;jumping to standard error_exit sequence isn't a good idea
                 ;lots of things haven't been set up yet
_cfg_exit:
     mov  dx,offset press_a_key
     mov  ah,9
     int  21h
     call read_key
     call cursor_on
       MOV     AH,4CH
       INT     DOSINT                  ;and go home


read_cfg_file  endp

parse_cfg_file proc near

     call getfsize_h
     jc   _pcf_error
     mov  cx,ax               ;file bytes in cx
     mov  si,offset dir_buff  ;use directory buffer to hold cfg file
     call read_h              ;read file into buffer
     jne  _pcf_error

                              ;si points to start of buffer
     mov  cx,6                ;check file marker of cfg file
     mov  di, offset marker
     repe  cmpsb              ;mismatch - error
     jnz  _pcf_error

     call clean_lines

     call read_in_cfg

     jmp  short _pcf_ret


_pcf_error:
     stc
     ret
_pcf_not_found:
     stc
     ret
_pcf_ret:
     clc
     ret
parse_cfg_file endp


read_in_cfg    proc near

     mov  si,offset dir_buff
     add  si,7                ;skip over marker
     mov  cx,7                ;attributes and switch
     mov  di,offset c_normal
     rep  movsb
     inc  si
     movsb                    ;status_reg
     add  di,3                ;skip over diralloc
     mov  cx,9
     rep  movsb
     inc  di                  ;m_vertical
     inc  si
     movsb
     dec  si
     dec  di


     movsb                    ;mouse
     movsb                    ;sort_up_flag
     movsb                    ;over_key

     inc  di                  ;read in the blanks
     mov  cx,8
     rep  movsb

                              ;skip over the following two switches which
                              ;are CURRENTLY not configurable, but which
     inc  si                  ;could be in a future rev
     inc  si

     mov  di,offset drive_table
     call copy_to_zero

     mov  cx,47
     mov  di,offset viewer_line
     sub  di,35
_ric_100:
     add  di,35
     call copy_to_zero
     loop _ric_100

     add  di,35+1
     sub  di,12
     mov  cx,20
_ric_200:
     add  di,12
     call copy_to_zero
     loop _ric_200

     mov  cx,45                    ;copy control flags
     mov  di,offset func01_stat
     rep  movsb

     mov  cx,12
     mov  di,offset ctrl_menu
     sub  di,24-6
_ric_300:
     add  di,24
     call copy_to_zero
     loop _ric_300

     mov  cx,12
     mov  di,offset rshift_menu
     sub  di,24-6
_ric_400:
     add  di,24
     call copy_to_zero
     loop _ric_400

     mov  cx,18
     mov  di,offset help3
     sub  di,77
_ric_500:
     add  di,77
     call copy_to_zero
     loop _ric_500

     ret
read_in_cfg endp
;-------------------------------------------------------------------------
; Copies null-terminated string to destination.  Does NOT append a
; terminator to the destination
; On entry: si and di point to source and destination.
; On exit:  si points to the character after the null
;           di is preserved
;-------------------------------------------------------------------------

copy_to_zero  proc near

     push di
_ctz_100:
     cmp  byte ptr [si],0
     je   _ctz_ret
     ;not totally clear on reasons, but the blank end of help
     ;gets padded with 0FF characters.  Treating them as if they were nulls
     ;seems to fix the problem. (4.61)
     cmp  byte ptr [si],0FFh
     je   _ctz_ret
     movsb
     jmp _ctz_100
_ctz_ret:
     inc  si
     pop  di
     ret
copy_to_zero endp

;----------------------------------------------------------------------
; Blank out the existing command lines, menus, etc.
;----------------------------------------------------------------------

clean_lines    proc near

_cl_50:
                              ;Clean out command-line strings
     mov  bx,34               ;number of characters to overwrite
     mov  al,space            ;character to overwrite with
     mov  dx,47               ;times to loop
     mov  di,offset viewer_line  ;starting offset
     dec  di                  ;back up
_cl_60:                       ;loop now
     inc  di                  ;increment past ending character
     mov  cx,bx
     rep  stosb
     dec  dx
     cmp  dx,0
     jne  _cl_60

     inc  di                   ;viewer extensions
     mov  dx,20
     mov  bx,11
_cl_70:
     inc  di
     mov  cx,bx
     rep  stosb
     dec  dx
     cmp  dx,0
     jne  _cl_70

     mov  di,offset ctrl_menu
     mov  dx,12
     mov  bx,19
_cl_80:
     add  di,5
     mov  cx,bx
     rep  stosb
     dec  dx
     cmp  dx,0
     jne  _cl_80

     mov  di,offset rshift_menu
     mov  dx,12
     mov  bx,19
_cl_90:
     add  di,5
     mov  cx,bx
     rep  stosb
     dec  dx
     cmp  dx,0
     jne  _cl_90

     mov  di,offset help3
     mov  dx,18
     mov  bx,76
     dec  di
_cl_110:
     inc  di
     mov  cx,bx
     rep  stosb
     dec  dx
     cmp  dx,0
     jne  _cl_110

ret

clean_lines    endp



;-----------------------------------------------------------------------
; Support routines for file opening, reading, and closing
; Adapted from Spontaneous Assembler 2.0
;-----------------------------------------------------------------------

;FUNC:    OPENEX_H
;
;DESC:    Opens an existing file.
;
;IN: DS:SI          address of ASCIIZ path/filename ("namestr")
;    AL        open flags  ("flags")
;
;OUT:     JNC if the file was successfully opened.
;      BX      DOS file handle for the opened file
;    JC if the function was unsuccessful.
;

openex_h  proc near
          push dx
          push ax
          mov  dx,si
          mov  ah,3Dh         ;open file with open modes
          int  21h            ;was file opened?
           jc  open_040       ;  y: setup for JC exit, else ...
          xchg ax,bx          ;BX = file handle
open_040: pop ax
          pop dx
          ret

openex_h endp


;FUNC:    READ_H
;
;DESC:    Reads a specified number of bytes from a file into a buffer.
;
;IN: DS:SI          address of the destination buffer ("buffer")
;    CX        maximum number of bytes to read from the file ("num")
;    BX        DOS file handle ("handle")
;
;OUT:     JE if the read was successful.
;      "buffer"     data from file associated with "handle"
;      CX      actual number of bytes read into "buffer"
;    JA if the file pointer was already at end-of-file.
;      CX      zero (0)
;    JB if an error was encountered.
;      CX      zero (0)
;

read_h proc near
          push     ax
          push     dx
          test cx,cx          ;setup for JE return if "num" = 0
           je  read_050  ;need to read any bytes?
          mov  dx,si          ;DS:DX = address of buffer
          mov  ah,3Fh         ;read CX characters from file/device
          int  21h       ;AX = # of byte read or error code
           jc  read_080  ;if error, setup for JB exit
          xchg cx,ax          ;CX = # of bytes read
          mov  al,2      ;setup for JA return if EOF
           jcxz     read_030  ;any bytes read?
          dec  ax        ;  y: not EOF; JE return
read_030: cmp  al,1      ;return JE or JA condition
read_050: pop dx
          pop ax
          ret

read_080:
          mov  cx,0      ;zero bytes read
          inc  ax        ;clear ZF; CF unchanged (JNE, JB)
          jmp  read_050
read_h  endp


;FUNC:    CLOSE_H
;
;DESC:    Closes a file.
;
;IN: BX        file handle ("handle")
;
;OUT:     JNC if the file was successfully closed.
;    JC if the function was unsuccessful.
;

close_h  proc      near
          push ax
          mov  ah,3Eh         ;close the file
          int  21h       ;error?
           jnc close_080 ;  n: JNC exit
close_080:     pop  ax
          ret
close_h   endp


;FUNC:    GETFSIZE_H
;
;DESC:    Gets the current size of an open file.
;
;IN: BX        DOS file handle ("handle")
;
;OUT:     JNC if the function was successful.
;      DX;AX        size of the file (in bytes)
;    JC if the function was unsuccessful.
;      DX;AX        undefined
;


getfsize_h proc    near
          push     cx
          push     ds
          push     di
          sub  cx,cx
          mov  dx,cx          ;seek offset = 0000 0000
          mov  ax,4201h  ;set for relative seek
          int  21h       ;system call
           jc  getfsize_h_080 ;if error, set E_CODE and JC return
          push ax             ;save starting offset from DX;AX
          push dx
          mov  dx,cx          ;seek offset = 0000 0000
          mov  ax,4202h  ;set for EOF seek
          int  21h       ;system call
          pop  cx          ;restore starting offset in CX;DI
          pop  di
           jc  getfsize_h_080 ;if error, set E_CODE and JC return
          push ax        ;save file size LSW
          xchg di,dx          ;save file size MSW, set seek LSW
          mov  ax,4200h  ;set for BOF seek
          int  21h       ;system call
          pop  cx        ;restore file size LSW into CX
           jc  getfsize_h_080 ;if error, set E_CODE and JC return
          mov  ax,cx          ;move file size LSW to AX
          mov  dx,di          ;move file size MSW to DX
          jmp  short getfsize_h_090
getfsize_h_080:
getfsize_h_090:
          pop di
          pop ds
          pop cx

          ret
getfsize_h  endp