;---------------------------------------------------------------------------
; Initialize pointer into the drive table which contains valid drives
; for moving between with left/right cursor keys.
;
; Initial pointer (drive_table_pointer) setting = -1 (no drives in table)
; Set pointer to OFFSET+11 within table of initial work drive if found.
; If entries in table BUT the initial drive is not one of them, pointer=0.
;
; Table entries are assumes to be 1) Valid drive letters, 2) Uppercase, and
; 3) Start in first position of entry and be contiguous (e.g. CFEF).


init_drive_pointer  proc near
     mov  cx,26     ;max length
     mov  di,offset drive_table
     mov  al,20h    ;space
     repne scasb    ;get length of drive entries
     inc  cx
     neg  cx
     add  cx,26     ;number of entries
     mov  num_drive_entries,cl
     or   cx,cx     ;any entries?
     jnz  _idp1    ;yes: continue
     ret            ;no: return w/ -1 pointer value still set
 _idp1:
     inc  cx
     mov  si,offset WORK_PATH  ;get current (initial) work drive
     mov  al,byte ptr[si]      ;store in AL
     mov  di,offset drive_table
     push di
     repne scasb         ;look for current drive
     pop  ax
     xchg ax,di
     sub  ax,di          ;turn into offset+1 (i.e. first position=1)
     jcxz _idp_notfound  ;reached end of list with no match?
     mov  drive_table_pointer,al    ;no: Store pointer entry
     ret
 _idp_notfound:
     mov  drive_table_pointer,0     ;yes: store zero
     ret
init_drive_pointer  endp

;--------------------------------------------------------------------------
; Change the current drive per the current value of the drive_table_pointer
; stored in al.
;--------------------------------------------------------------------------
temp_dt_pointer     db   0    ;temporary storage of pointer in case of error

change_drive_table  proc near
     push ax
     mov  al,drive_table_pointer
     mov  temp_dt_pointer,al
     pop  ax
     mov  di,OFFSET TMP_BUFF     ;point to a scratch area
     push di
     mov  si,offset drive_table
     dec  si
     add  si,ax                  ;point to the entry in the drive table
     movsb                       ;copy to scratch area
     mov  byte ptr[di],':'       ;and append drive specifier and ending null
  ;not sure why this period is required, but needed to make change_path
  ;logic work properly.  Fixes (together with saving drive pointer info)
  ;critical error problem with drive table (4.60)
     mov  byte ptr[di+1],'.'
     mov  byte ptr[di+2],0
     mov  drive_table_pointer,al ;store the new table pointer
     pop  si                     ;retrieve scratch address for CHANGE_PATH
     call CHANGE_PATH            ;and change the path
     jc   _cdt_err
     call READ_DIR
_cdt_ret:
     ret
_cdt_err:
     push ax
     mov  al,temp_dt_pointer
     mov  drive_table_pointer,al
     pop  ax
     call read_dir
     ret
change_drive_table  endp

;----------------------------------------------------------------------------
; Increment the drive by one letter
;----------------------------------------------------------------------------
     drive_up_key   db   04Dh

drive_up       proc near
     ;check if valid key for drive_keys setting
     cmp  al,drive_up_key
     jne  _du_ret

     xor  ax,ax
     cmp  drive_table_pointer,0
     jne  _du50
     mov  al,1
     jmp  short _du100
 _du50:
     mov  al,drive_table_pointer
     cmp  al,-1     ;no drives in table?
     je   _du_ret   ;correct: return
     inc  ax        ;otherwise, increment pointer by 1
     cmp  al,num_drive_entries ;compare to number of entries
     jbe  _du100
     mov  al,1                ;if above, wraparound to first entry
 _du100:
     call change_drive_table  ;change drive
 _du_ret:
     ret
drive_up  endp

;-----------------------------------------------------------------------------
; Decrement the drive by one letter
;-----------------------------------------------------------------------------
     drive_down_key      db   04Bh

drive_down     proc near

     ;check if valid key for drive_keys setting
     cmp  al,drive_down_key
     jne  _dd_ret

     xor  ax,ax
     cmp  drive_table_pointer,0
     jne  _dd50
     mov  al,num_drive_entries
     jmp  short _dd100
 _dd50:
     mov  al,drive_table_pointer
     cmp  al,-1     ;no drives in table?
     je   _dd_ret   ;correct: return
     dec  ax
     or   ax,ax
     jnz  _dd100
     mov  al,num_drive_entries
 _dd100:
     call change_drive_table
 _dd_ret:
     ret
drive_down endp

;----------------------------------------------------------------------
; Remark -- equivalent to F6 + F7
;----------------------------------------------------------------------
REMARK    Proc Near

     call mark_blank
     call swap_mark
     ret

REMARK    endp

;----------------------------------------------------------------------
; UPDIR -- equivalent of F9 ..
;----------------------------------------------------------------------
updir_str db   '..',0

UPDIR     proc near
     mov  si,offset updir_str
     call  cd_wentry

     ret
UPDIR     endp