;-----------------------------------------------------------------------
; "Touch" files -- i.e. set to current date and time
;  see EXEC_MARKED for detailed comments on general structure
;  added rev 4
;-----------------------------------------------------------------------

;DF 4.60 Pass 8.  Various es segment overrides added to correct touch bugs

JUMPS
 ASSUME CS:_TEXT, DS:_TEXT, ES:_TEXT
 TOUCH		PROC NEAR

;	ADD	FUNCTION,DIR_OK_BIT   ;OK to do this to directories
						  ;no it's not
	CALL	CURSOR_OFF
	call	store_sys_dt
	call	setup_touch
	jc	_TO_RET			  ;abort
	call	flush_kybd_buff	  ;flush keyboard buffer
	call	parse_date_time	  ;parse system date and time into appropriate
						  ;form for DOS set time/date functions
						  ;and store in SYS_TIME and SYS_DATE
	CALL	COUNT_MARKS
	JNZ	_TO_1
	CALL	PUT_AMARK
     assume es:nothing
     push es
     mov  es,dir_buf_seg
     MOV  BYTE PTR es:[SI],space
     pop  es
     assume es:_TEXT
	JMP	SHORT _TO_3

 _TO_1:	CALL	HOME_BAR

 _TO_2:	CALL	REFRESH_DIR_DISP
	CALL	GET_NAME
     assume es:nothing
     push es
     mov  es,dir_buf_seg
     CMP  BYTE PTR es:[SI],COPY_MARK
     pop  es
     assume es:_TEXT
	JZ	_TO_3
	CALL	DN_ARROW
	JMP	SHORT _TO_2

 _TO_3:	CALL	GET_NAME
	JNC	_TO_4          ;Carry flag set by GET_NAME if illegal function
	INC	MARK_CNT
	JMP	_TO_7

 _TO_4:	MOV	DX,OFFSET SOURCE
;	CALL	GETMOD
 _TO_6:
	CALL	DO_TOUCH             ;DO_TOUCH sets the specified file to the current time/date
	jc	_TO_7			 ;failed
	MOV	SI,CUR_FILE
     assume es:nothing
     push es
     mov  es,dir_buf_seg
     MOV  BYTE PTR es:[SI],'*'
     pop  es
     assume es:_TEXT
	CALL	UPDATE_date
	JMP	_TO_8

 _TO_7:	CALL	BEEP
	CALL	DN_ARROW

 _TO_8:	DEC	MARK_CNT
	CALL	CK_KEY
	JNZ	_TO_9
	CMP	MARK_CNT,0
	JLE	_TO_X
	JMP	_TO_2

 _TO_9:	CALL	READ_KEY
	CALL	CK_KEY
	JNZ	_TO_9

 _TO_X:	CALL	REFRESH_DIR_DISP   ;Redisplays with changed attributes and
	call		count_marks
	mov		si,offset marked_msg
	mov		di,prompt_loc
	call		put_string

 _TO_RET:
	call		clr_msg
	RET


 TOUCH		ENDP
NOJUMPS
;---------------------------------------------------------------------------
; Updates the screen display of files which have had their dates successfully
; changed
;----------------------------------------------------------------------------


 ASSUME CS:_TEXT, DS:_TEXT, ES:_TEXT
 UPDATE_DATE		PROC NEAR


 	add		si,24			;moves pointer to date field
	mov		dx,s_year           ;setup registers
	mov		ax,s_md             ;with stored info
     push      ds
     push      es
     mov       es,dir_buf_seg
     push      es
     pop       ds
     call      asc_date            ;call date writing function
     pop       es
     pop       ds
	add		si,10
	mov		dx,s_hm
	mov		bx,1
     push      ds
     push      es
     mov       es,dir_buf_seg
     push      es
     pop       ds
	call		asc_time
     pop       es
     pop       ds
	ret


 UPDATE_DATE	ENDP

;----------------------------------------------------------------------------
; Performs the actual date and time change.
; On entry: DS:DX = ACSIIZ pathname
;----------------------------------------------------------------------------

 DO_TOUCH		PROC NEAR

	mov		ah,3Dh			;open file
	mov		al,1				;write mode
	int		21h
	jc		_dt_err			;open file failure
	mov		bx,ax			;bx now contains file handle
	mov		ah,57h			;get/set file date and time
	mov		al,1				;set
	mov		cx,sys_time
	mov		dx,sys_date
	int		21h
	jc		_dt_set_err
	mov		ah,3Eh			;release file handle
	int		21h
	clc
	ret
 _dt_err:
;	call		beep
	stc
	ret
 _dt_set_err:
	mov		ah,3Eh			;release file handle
	int		21h
;	call		beep
	stc
	ret

 DO_TOUCH		ENDP

;-------------------------------------------------------------------------
; Gets the current system date and time and parses into an appropriate
; form for the set time and date DOS functions.  Saves as sys_date
; and sys_time.
; time:  Bits 0B-0F	hours(0-23)
;	    Bits 05-0A minutes
;             00-04 number of 2 second increments
; date:       09-0F year (relative to 1980)
;             05-08 month
;             00-04 day of month
;-------------------------------------------------------------------------

 PARSE_DATE_TIME PROC NEAR

	mov		cx,s_year		;Retrieve date info
	mov		dx,s_md
	sub		cx,1980		;subtract 1980 from year to get relative year
	xor		bx,bx
	mov		bh,cl		;store relative year
	shl		bh,1			;and shift left 1 (from bit 8 to bit 9)

	xor		ax,ax
	mov		al,dh		;store month
	mov		cl,5
	shl		ax,cl		;shift it up 5 bits
	or		bx,ax		;and OR into bx

	or		bl,dl		;OR in day

	mov		sys_date,bx		;store date

	mov		cx,s_hm		;save this info for later use
	xor		bx,bx		;zero storage register
	shr		dh,1			;divide seconds by 2
	mov		bl,dh		;store
	xor		ax,ax
	mov		al,cl		;move minutes to ax
	mov 		cl,5           ;shift left to Bit 5 position
	shl		ax,cl
	or		bx,ax          ;OR ax into bx
	xor		ax,ax
	mov		ah,ch		;move hours to ax
	mov		cl,3 		;shift from 08 to 0B bit position
	shl		ah,cl
	or		bh,ah          ;OR into bx
	mov		sys_time,bx

	ret

 PARSE_DATE_TIME ENDP

;----------------------------------------------------------------------------
;FUNC:    ASC_DATE
;
;DESC:    Creates an ASCIIZ date string of the form MM/DD/YY.
;
;IN: Date in dword format ("date"):
;      DX      year (1980-2099)
;      AH      month (1-12)
;      AL      day (1-31)
;    DS:SI          destination string ("string")
;
;ASUMS:
;
;OUT:     "string"  ASCIIZ date string (MM/DD/YY)
;
; Spontaneous Assembler Library function -- modified
;
 assume ds:nothing, es:nothing
 ASC_DATE      PROC NEAR

          mov  di,si          ;DI = SI
          xchg ax,bx          ;BX = month and day
          mov  al,bh          ;AL = month
          aam         		;AX = month in BCD format
          add  ax,"00"        ;AX = month in decimal digits
          xchg al,ah
		cmp	al,'0'
		jne	asc_date_101
		mov	al,space
asc_date_101:
          stosb               ;write month to string
		xchg al,ah
		stosb
          mov  al,"-"
          stosb               ;write "-" to string
          xchg ax,bx          ;AL = day
          aam            ;AX = day in BCD format
          add  ax,"00"        ;AX = day in decimal digits
          xchg al,ah
          stosw               ;write day to string
          mov  al,"-"
          stosb               ;write "-" to string
          xchg ax,dx          ;AX = year
          mov  dl,100
          div  dl        ;DL = last two digits of year
          mov  al,ah          ;AL = last two digits of year
          aam            ;AX = year in BCD format
          add  ax,"00"        ;AX = year in decimal digits
          xchg al,ah
          stosw               ;write year to string
          mov  al,space
          stosb               ;write NULL to end of string
          ret
 ASC_DATE ENDP

;-------------------------------------------------------------------------
;FUNC:    ASC_TIME
;
;DESC:    Creates an ASCIIZ time string of the form HH:MM or HH:MMx (where x
;			is a or p)
;
;IN: DS:SI          destination string ("string")
;    Time in dword format ("time"):
;      DH      hours (0-23)
;      DL      minutes (0-59)
;      bx		0 if 24 hour time
;
;ASUMS:   ES        same as DS (small data models only)
;
;OUT:     "string"  ASCIIZ time string (HH:MM Xm)
;
 assume ds:nothing, es:nothing
 ASC_TIME PROC NEAR

          mov  di,si          ;DI = SI
          mov  al,dh          ;Al = hours (24 hr clock)
		and	bx,bx		;bx=0 if 24 hour time display
		jz	asc_time_120	;
          mov  dh,"p"         ;set DH for pm
          cmp  al,12          ;is it pm?
           jae asc_time_100   ;  y: leave DH setup for pm
          mov  dh,"a"         ;  n: set DH for am
asc_time_100:  cmp  al,13          ;is time 1pm or later?
           jb  asc_time_120   ;  n: skip 24 to 12 hr clock adjust
          sub  al,12          ;AL = hours (12 hr clock)
asc_time_120:  cmp  al,0      ;is time 12 am?
           jne asc_time_140   ;  n: skip 12am adjust
          mov  al,12          ;  y: make hour 0 = 12am
asc_time_140:  aam            ;AX = hours in BCD format
          add  ax,"00"         ;AX = hours in decimal digits
          xchg al,ah
		cmp	al,'0'
		jne	asc_time_141	;sub space for leading zero
		mov	al,space
asc_time_141:
          stosb               ;write hours to string
		xchg	al,ah
		stosb
          mov  al,":"
          stosb               ;write ":" to string
          mov  al,dl          ;AL = minutes
          aam            ;AX = minutes in BCD format
          add  ax,"00"        ;AX = minutes in decimal digits
          xchg al,ah
          stosw               ;write minutes to string
		and	bx,bx     	;bx=0 if 24 hour time display
		jz	asc_time_150	;
          mov  al,dh          ;AX = am/pm indicator
          stosb               ;write am/pm indicator
asc_time_150:
          mov	al,space
          stosb               ;write space to end of string
		ret
 ASC_TIME  ENDP

;----------------------------------------;
; INPUT                                  ;
;   DS:SI points to ASCII number string. ;
;                                        ;
; OUTPUT                                 ;
;   BX = hexidecimal number.             ;
;   DS:SI points to byte after string.   ;
;   If (ZF) = 1  --  BX =  0             ;
;   If (ZF) = 0  --  BX <> 0             ;
;                                        ;
;   AX, BX, CX, DI destroyed.            ;
;----------------------------------------;

GET_NUMBER     PROC    NEAR

               XOR     BX,BX                   ;Start with zero.
PARSE_DELIMIT: LODSB                           ;Get a byte.
               MOV     DI,OFFSET date_DELIMIT    ;Is it a delimiter?
               MOV     CX,3
               REPNZ   SCASB
               JZ      PARSE_DELIMIT           ;If yes, get next byte.

               MOV     CL,10
NEXT_NUMBER:   XOR     AH,AH                   ;Zero in high half.
               CMP     AL,CR                   ;Is byte a carriage return?
               JZ      NUMBER_END              ;If yes, done.
               CMP     AL,"0"                  ;Is byte a number?
               JB      NUMBER_END
               CMP     AL,"9"
               JA      NUMBER_END              ;If no, done.
               SUB     AL,"0"                  ;Else, convert to hex.
               XCHG    AX,BX                   ;Store in BX.
               MUL     CL                      ;Multiply accumulated by 10.
               ADD     BX,AX                   ;Add new number.
               LODSB                           ;Next byte.
               JMP     SHORT NEXT_NUMBER

NUMBER_END:    DEC     SI                      ;Adjust pointer to delimiter.
               OR      BX,BX                   ;Set zero flag if results zero.
               RET
GET_NUMBER     ENDP

;--------------------------------------------------------;
; Parses off leading string delimiters.                  ;
; If carriage return encountered, jump directly to exit. ;
;                                                        ;
; INPUT                                                  ;
;   DS:SI points to ASCII string.                        ;
;                                                        ;
; OUTPUT                                                 ;
;   DS:SI points to first non-delimiting byte in string. ;
;                                                        ;
;   All registers preserved.                             ;
;--------------------------------------------------------;

PARSE_LEADING  PROC    NEAR

               LODSB                           ;Get a byte.
               CMP     AL,SPACE                ;Is it a space char or below?
               JA      LEADING_END             ;If no, done here.
               CMP     AL,CR                   ;Is it carriage return?
               JNZ     PARSE_LEADING           ;If no, get next byte.
               JMP     _st_abort               ;Else, immediate error exit.
LEADING_END:   DEC     SI                      ;Adjust pointer to string start.
               RET

PARSE_LEADING  ENDP

setup_touch	proc near

	call	clr_msg
	mov	si,offset touch_prompt		;Enter date/time
	mov	di,prompt_loc
	call	put_string
	mov	si,offset date_prompt         ;Date:
	mov	di,prompt_loc2
	call	put_string
	mov	si,offset	time_prompt         ;Time:
	mov	di,prompt_loc3
	call put_string
	call	clear_old
	mov	dx,s_year
	mov	ax,s_md
	mov	si,offset entry
	call	asc_date                      ;Converts date to ASCII format
	mov	si,offset entry
	mov	di,prompt_loc2 + 12
	mov	cx,8                          ;8 characters to copy
 _st_1:
	lodsb                              ;forces an 8 character copy
	or	al,al                         ;ignoring nulls and not forcing
	call	put_char                      ;null termination
	loop	_st_1

	call	clear_old
	mov	dx,s_hm  					;do the same thing with the time
	mov	si,offset entry
	mov	bx,0
	call	asc_time
	mov	si,offset entry
	mov	di,prompt_loc3 + 12
	mov	cx,6
 _st_2:
	lodsb
	or	al,al
	call	put_char
	loop	_st_2

	mov	dx,prompt_loc2_RC+6           ;first we work on the date
	call	set_cursor
	call	read_kybd_status
	cmp	al,cr					;is it a <CR>?
	jne	_st_3
	mov	ah,0
	int	16h						;clear out buffer
	jmp	short _st_4
 _st_3:
	call	clear_old
	mov	al,normal
	mov	cx,prompt_loc2_rc+6
	call	clr_eol
	mov	dx,prompt_loc2_RC+6
	call	set_cursor
	mov	cx,10
	call input_param
	jc	_st_abort					;input was aborted, exit
	mov	si,offset entry
	call	parse_leading
	call	get_number
	jz	_st_error
	mov	dh,bl					;store month
	call	get_number
	jz	_st_error
	mov	dl,bl					;store day
	call	get_number
;	jz	_st_error
	mov	cx,bx					;store year
	call	correct_year				;parses 2 digit years in a logical manner
	mov	s_year,cx
	mov	s_md,dx
 _st_4:
	mov	dx,prompt_loc3_RC+6           ;first we work on the date
	call	set_cursor
	call	read_kybd_status
	cmp	al,cr					;is it a <CR>?
	je	_st_ret
	call	clear_old
	mov	al,normal
	mov	cx,prompt_loc3_rc+6
	call	clr_eol
	mov	dx,prompt_loc3_RC+6
	call	set_cursor
;	mov	di,prompt_loc3 + 12
	mov	cx,8
	call input_param
	jc	_st_abort
	mov	si,offset entry
	call	parse_leading
	call	get_number
	mov	dh,bl					;store hour in dh
	call	get_number
	mov	dl,bl					;store minutes in dl
	call	get_number
	mov	s_hm,dx					;store hours and minutes in s_hm

 _st_ret:
	clc
	ret

 _st_error:
	call	beep
 _st_abort:
	stc
	ret

setup_touch	endp

;---------------------------------------------------------------------
; Takes a year in the CX register and converts it to a 4-digit date
; if it isn't so already
;---------------------------------------------------------------------

correct_year	proc near

	cmp	cx,99
	ja	_cy_ret	;apparently already in 4-digit form
	cmp	cx,80	;is it 1980 (lowest date PC can handle)
	jbe	_cy_2000	;No?  Must be 2xxx
	add	cx,1900
	jmp	short _cy_ret
_cy_2000:
	add	cx,2000
_cy_ret:
	ret
correct_year	endp



READ_KYBD_STATUS	PROC NEAR

 _RKS_1:
	mov	ah,BIOS_KYBD_01
	int	16h
	jz	_RKS_1
 ret
READ_KYBD_STATUS ENDP

store_sys_dt	proc near

	mov		ah,2Ah
	int		21h			;get system date
						;cx=year, dh=month, dl=day
	mov		s_year,cx		;save this info for later use
	mov		s_md,dx

	mov		ah,2Ch		;get system time
	int		21h			;ch=hour,cl=minutes,dh=seconds
	mov		s_hm,cx		;save this info for later use
	ret

store_sys_dt	endp

flush_kybd_buff	proc near

 _fkb_1:
	push		si		;bios doesn't save si
	mov		ah,1		;is key waiting
	int		16h
	jz		_fkb_ret  ;no? return
	mov		ah,0
	int		16h       ;yes? read out and loop
;	jmp		_fkb_1
 _fkb_ret:
	pop		si
	ret

flush_kybd_buff	endp