 ;--------------------------------------------------------------------------;
 ; Command to restore to the working directory and then re-read from disk
 ; On entry : no known parameters
 ; Returns  : nothing
 ; Modifies : everything
 ;--------------------------------------------------------------------------;
 REFRESH       PROC    NEAR
       MOV     SI,OFFSET WORK_PATH
       CALL    NEW_WORK_DIR
       RET
 REFRESH               ENDP


 ;------------------------------------------------------------------------;
 ; This subroutine changes the sorting option
 ; On entry : AL contains a scan code
 ;            If CTRL_PRESSED =1, do descending order sort
 ;             otherwise, do ascending order
 ; Returns  : nothing
 ; Modifies : assume everything
 ;------------------------------------------------------------------------;

 RE_SORT       PROC    NEAR
       MOV     DI,OFFSET SORT_OPT
       CALL    SET_SORT

       mov     bl,1
       mov     cx,sort_index
       shr     cx,1
       shl     bx,cl

       cmp     ctrl_pressed,0
       je      _rs_50
       or      sort_up_flag,bl
       jmp     short _rs_100
 _rs_50:
       not     bx
       and     sort_up_flag,bl

 _rs_100:
       CMP     SORT_LEN,-1                   ;sort_len=-1 if orig order
       JZ      REFRESH                 ;re-load unsorted dir

       MOV     DI,SORT_LOC
       MOV     SI,OFFSET SORT_MSG
       CALL    PUT_STRING

 ;------------------------------------------;
 ; This subroutine does the actual sorting. ;
 ; On entry : no known parameters
 ; Returns  : nothing
 ; Modifies : assume everything
 ;------------------------------------------;

;FUNC:    $QUICK_SORT
;
;DESC:    Sorts the elements of an array using a quicksort algorithm.
;
;IN: DS:SI          address of the first element in the array ("left")
;    DS:DI          address of the last element in the array ("right")
;    CX        size in bytes of the array elements ("size")
;    SS:BP          pointer to a far comparison function pointer
;              (near function pointer for small code models)
;
;ASUMS:   ES        same as DS
;
;OUT:     "array"        all elements are in sorted order
;
;NOTES:   This function sorts an array using a 'median of three' recursive
;    quicksort algorithm.
;
;ALG:     Following is the algorithm used for the sort in a C-like pseudo code.
;    A median of three modification is implemented to improve performance
;    when the array initially list is in  sorted or partially-sorted order.
;    The array (or list) being sorted is represented as "r".  The element
;    size in bytes is "esize", "left" and "right" are pointers to the first
;    and last elements of the list and the sub-lists.  "j" and "k" are
;    working pointers to elements.
;
;    function: qsort(left, right: pointers) {
;      if (left < right) {
;
;    /* median of three modification */
;
;        if (r[middle] <> r[left])
;          swap(r[middle],r[left]);
;        if (r[left + 1] > r[right])
;          swap(r[left + 1], r[right]);
;        if (r[left] > r[right])
;          swap(r[left], r[right]);
;        if (r[left + 1] > r[left])
;          swap(r[left + 1], r[left]);
;
;    /* now the actual sort */
;
;        j = left + esize;
;        k = right;           /* point one past the last element */
;        repeat {
;          repeat {j = j + esize} while (r[j] < r[left]);
;          repeat {k = k - esize} while (r[k] > r[left]);
;          if (j < k) swap(r[j], r[k]);
;        } until (j > k);
;        swap(r[left], r[k]);
;        qsort(left, k - 1);       /* sort the left sub-list */
;        qsort(k + 1, right); /* sort the right sub-list */
;      }
;    }

auto_iptr EQU  <WORD PTR>

;FUNC:    QUICK_SORT
;
;DESC:    Sorts the elements in a generic array.
;
;IN: ES:DI          address of the array ("array")
;    BX        number of elements in the array ("num")
;    CX        size of the array elements in bytes ("size")
;    DX:AX          address of a comparison function ("cmpf")
;
;OUT:     "array"        all elements are in sorted order
;
sort     proc near
          mov  bx,offset comp_funcs     ;move to start of functions
          add  bx,sort_index            ;index to the right one
          mov  ax,[bx]                  ;and store the address

;          mov  di,offset DIR_BUFF  ;address of buffer with "array"
          mov  di,dbs_start
          mov  bx,COUNT            ;number of rows in array
          mov  cx,FIELD_SIZE       ;element size of array
          cld

;The rest of this routine is the Spontaneous Assembler quick_sort routine

          push es
          mov  es,dir_buf_seg

          cmp  bx,1
           jna qsort_080
           jcxz     qsort_080
          push     ax dx di si ds bp
          push es
          pop  ds        ;force DS = ES
          push ax        ;push ofs("cmpf")
          mov  bp,sp          ;SS:BP-> comparison function pointer
          mov  si,di          ;SI-> first element
          mov  ax,bx          ;AX = "num"
          dec  ax        ;AX = "num" - 1
          xor  dx,dx
          mul  cx        ;AX = total bytes - one element
          add  di,ax          ;DI-> last element
          call $quick_sort    ;go do the sort
qsort_070:     pop  ax        ;pop pointer to "cmpf"
          pop  bp ds si di dx ax
          mov  function,upd_cnt_bit     ;clear message, restore counter
qsort_080:
         pop   es
         ret
sort     endp

 RE_SORT               ENDP

     assume es:NOTHING, ds:NOTHING
$quick_sort    proc near

          push     ax
          push     dx
          push     di
          push     si
          mov  ax,di          ;DI = AX->"right", SI->"left"
          xor  dx,dx
          sub  ax,si          ;AX = number of bytes in the array
          div  cx        ;AX = number of elements - 1
          inc  ax        ;AX = number of elements

;------ early out if only two elements in sub-list

          cmp  ax,2      ;only two elements?
           jne quick_sort_004 ;  n: continue
          call auto_iptr [bp] ;are they already in sorted order?
           jna quick_sort_080 ;  y: early exit
          call $swap          ;  n: put them in sorted order
          jmp  short quick_sort_080; and early exit

;------ median of three modification

quick_sort_004:     shr  ax,1      ;AX = number of elements/2
          mul  cx        ;AX = bytes to middle element
          add  ax,si          ;AX->"middle"
          xchg ax,di          ;DI->"middle", AX->"right"
          call auto_iptr [bp] ;is r["middle"] = r["left"]?
           je  quick_sort_006 ;  y: do not swap
          call $swap          ;  n: swap them
quick_sort_006:     xchg di,ax          ;DI->"right"
          mov  ax,si          ;AX->"left" element
          add  si,cx          ;SI->"left" + 1 element
          call auto_iptr [bp] ;is r["left" + 1] > r["right"]?
           jna quick_sort_008 ;  n: go continue
          call $swap          ;  y: swap them
quick_sort_008:     xchg si,ax          ;SI->"left", AX->"left" + 1
          call auto_iptr [bp] ;is r["left"] > r["right"]?
           jna quick_sort_010 ;  n: go continue
          call $swap          ;  y: swap them
quick_sort_010:     xchg di,ax          ;DI->"left" + 1, AX->"right"
          call auto_iptr [bp] ;is r["left" + 1] > r["left"]
           jnb quick_sort_020 ;  n: go do the sort
          call $swap          ;  y: swap them

;------ now the actual sort

quick_sort_020:     xchg dx,ax          ;DX->"right"
          xchg ax,si          ;AX->"left"
          mov  si,di          ;SI->"j" ("left" + 1)
          mov  di,dx          ;DI->"k" ("right")
quick_sort_030:     xchg di,ax          ;DI->"left", AX->"k"
quick_sort_040:     add  si,cx          ;SI->"j"
          call auto_iptr [bp] ;is "j" < "left"?
           jb  quick_sort_040 ;  y: go look at next "j"
          xchg si,ax          ;  n: AX->"j" >= "left"
quick_sort_050:     sub  si,cx          ;SI->"k"
          call auto_iptr [bp] ;is "k" > "left"?
           ja  quick_sort_050 ;  y: go look at next "k"
          xchg si,ax          ;  n: SI->"j", AX->"k"
          xchg di,ax          ;DI->"k", AX->"left"
          cmp  si,di          ;overlapping "j" and "k" pointers?
           ja  quick_sort_060 ;  y: go sort sub-lists
          call $swap          ;  n: swap elements "j" and "k"
          jmp  quick_sort_030 ;     and go sort some more

quick_sort_060:     xchg si,ax          ;SI->"left", DI->"k", AX->"j"
          call $swap          ;put "left" elem between sub-lists
          mov  ax,di          ;AX->"k"
          add  ax,cx          ;AX->"k" + 1, DX->"right"
          sub  di,cx          ;SI->"left", DI->"k" - 1
          cmp  si,di          ;more than 1 element in sub-list?
           jnb quick_sort_070 ;  n: don't bother sorting
          call $quick_sort           ;sort left sub-list
quick_sort_070:     cmp  ax,dx          ;more than 1 element in sub-list?
           jnb quick_sort_080 ;  n: don't bother sorting
          xchg si,ax          ;SI->"k" + 1
          mov  di,dx          ;DI->"right"
          call $quick_sort           ;sort right sub-list
quick_sort_080:
          pop       si
          pop       di
          pop       dx
          pop       ax
          ret
$quick_sort endp



;FUNC:    $SWAP
;
;DESC:    Swaps two elements in an array.
;
;IN: DS:SI          address of the first element in the array ("j")
;    DS:DI          address of the last element in the array ("k")
;    CX        size in bytes of the array elements ("size")
;
;ASUMS:   ES        same as DS
;
;OUT:     "array"        elements "j" and "k" are swapped.
;
;NOTES:   This function swaps array elements "j" and "k" in the array. "size"
;    must not be zero, or the state of the array is undefined.

$swap     proc     near
          cmp  si,di
           je  swap_080  ;early exit if pointers are the same
          push ax
          push cx
          push di
          push si
          shr  cx,1      ;CX = number words, CF set if odd byte
           jnc swap_020  ;if one more byte, swap it
          mov  al,[di]
          movsb
          mov  [si-1],al ;swap a byte between "j" and "k"
           jcxz     swap_060
swap_020: mov  ax,[di]
          movsw
          mov  [si-2],ax ;swap a word between "j" and "k"
           loop     swap_020  ;if more words, go swap them
swap_060:
          pop  si
          pop  di
          pop  cx
          pop  ax
swap_080: ret
$swap endp

;----------------------------------------------------------------------
; Comparison function #1 for Quick Sort
; Sorts Files in ascensing name order with directories first
; Sorts extensions also in ascending order also within filenames
; REMEMBER that flags are important on return.  See QA reference
;   in SA manual!!!!!!!
;----------------------------------------------------------------------
comp1  proc near
     push di
     push si
     push cx
     push ax
     inc  si
     inc  di
     mov  al,byte ptr [di+13] ;treat directories special
     mov  ah,byte ptr [si+13]
     cmp  ax,03C3Ch           ;='<<'
     je   _comp1_10           ;if both are directories, go thru the routine
     cmp  ah,'<'              ;if only one is, it has precedence
     je   comp_ret2
     cmp  al,'<'
     je   comp_ret2

;     cmp  al,byte ptr [si+13] ;compare a < in the proper position for a
                              ;directory vs. a blank for a non-directory

                              ;NO!!! If a file is > 10MB, this location will
                              ;not be a blank (4.60 thanks to James Heyl)
;     cmp  al,ah
;     jne  comp_ret
_comp1_10:
     mov  cl,sort_up_flag
     and  cl,NAME_MASK
     jz   _comp1_up
     xchg di,si
     mov  cx,8        ;For descending order, need to make filenames only
                      ;desccending and extensions ascending
     repz cmpsb
     jcxz _comp_dn_50   ;mismatch found;return
     jmp  short comp_ret
_comp_dn_50:
     xchg di,si            ;filenames match.  Switch back to ascending
                           ;order and do extensions
     inc  si
     inc  di
     mov  cx,3
     repz cmpsb

     jmp  short comp_ret
_comp1_up:
     mov  cx,12       ;this is real simple for ascending order
     repz cmpsb       ;just look at whole filename with extension (fortunately
                      ;this is most common so most important to get fast)
     jmp  short comp_ret
 comp_ret2:
     cmp  al,ah       ;to get comparator output for quick_sort
 comp_ret:
     pop  ax
     pop  cx
     pop  si
     pop  di
     ret
comp1 endp

;----------------------------------------------------------------------
; Sort files in extension order.  Directories first, secondary sort
;  key is the filename always in ascending order.
;----------------------------------------------------------------------
comp2  proc near
     push di
     push si
     push cx
     push ax
     mov  al,byte ptr [di+14] ;treat directories special
     mov  ah,byte ptr [si+14]
     cmp  ax,03C3Ch
     je   comp2_50
     cmp  ah,'<'
     je   comp2_ret2
     cmp  al,'<'
     je   comp2_ret2
 comp2_50:
     add  si,10                ;go to extension field
     add  di,10
     mov  cx,3
     push cx
     mov  cl,sort_up_flag
     and  cl,EXT_MASK         ;check if ascending or descending sort
     pop  cx
     jz   comp2_100
     xchg di,si               ;if descending, switch pointers
 comp2_100:
     repz cmpsb               ;compare extensions
     jnz  comp2_ret           ;mismatch, done
     mov  cl,sort_up_flag
     and  cl,EXT_MASK
     jz   comp2_200
     xchg di,si               ;names ascending, so we have to switch back
 comp2_200:
     sub  si,13               ;go back to name field
     sub  di,13
     mov  cx,9                ;fixed DF 4.60 (was 8, was missing 1)
     repz cmpsb               ;compare names
 comp2_ret:
     pop  ax
     pop  cx
     pop  si
     pop  di
     ret
 comp2_ret2:
     cmp  al,ah
     jmp  comp2_ret
comp2 endp

;---------------------------------------------------------------------------
; Sort files in size order.  Secondary key is name always in ascending order
;---------------------------------------------------------------------------

comp3  proc near
     push di
     push si
     push cx
     push ax
     inc  si
     inc  di
     mov  al,byte ptr [di+13] ;treat directories special
     mov  ah,byte ptr [si+13]
     cmp  ax,03C3Ch
     je   _comp3_50
     cmp  ah,'<'
     je   comp3_ret2
     cmp  al,'<'
     je   comp3_ret2
_comp3_50:
     mov  cl,sort_up_flag
     and  cl,SIZE_MASK
     jz   _comp3_100
     xchg di,si
_comp3_100:
     push si
     push di
     add  si,sort_offset
     add  di,sort_offset
     xor  cx,cx
     mov  cl,sort_len
     repz cmpsb
     pop  di
     pop  si
     jnz  comp3_ret           ;mismatch, done
                              ;otherwise sort ascensing on names
     mov  cl,sort_up_flag
     and  cl,SIZE_MASK
     jz   comp3_200
     xchg di,si               ;names ascending, so we have to switch back
 comp3_200:
     mov  cx,12
     repz cmpsb               ;compare names
 comp3_ret:
     pop  ax
     pop  cx
     pop  si
     pop  di
     ret
 comp3_ret2:
     cmp  al,ah
     jmp  comp3_ret

comp3 endp

;----------------------------------------------------------------------------
; Sort files in date order.  Secondary key is name always in ascending order.
;----------------------------------------------------------------------------

comp4 proc near
     push di
     push si
     push cx
     push ax
     push bx
     inc  si
     inc  di
     mov  al,byte ptr [di+13] ;treat directories special
     mov  ah,byte ptr [si+13]
     cmp  ax,03C3Ch
     je   _comp4_50
     cmp  ah,'<'
     je   comp4_ret2
     cmp  al,'<'
     je   comp4_ret2
_comp4_50:
     mov  cl,sort_up_flag
     and  cl,DATE_MASK
     je   _comp4_100
     xchg di,si
_comp4_100:
     add  si,sort_offset
     add  di,sort_offset
     mov  cx,2
     repz cmpsb          ;compare year
     jnz  comp4_ret
     sub  si,8
     sub  di,8
     mov  cx,5
     repz cmpsb          ;compare month/day
     jnz  comp4_ret
     add  si,10
     add  di,10
     cmpsb               ;compare am/pm
     jnz  comp4_ret
     mov  ax,word ptr [si-6]
     cmp  ax,3231h           ;is source hour 12?
     jne  _comp4_120
     mov  ax,2020h           ;save 2 spaces (i.e. make 12: -> 00:)
_comp4_120:
     mov  bx,word ptr [di-6]
     cmp  bx,3231h
     jne  _comp4_140         ;same deal with destination
     mov  bx,2020h
_comp4_140:
     xchg al,ah              ;fix up byte ordering
     xchg bl,bh
     cmp  ax,bx              ;compare
     jnz  comp4_ret
     sub  si,3               ;still match, we do minutes
     sub  di,3
     mov  cx,2
     repz cmpsb
     jnz  comp4_ret
_comp4_200:                  ;still the same, match names
     mov  cl,sort_up_flag
     and  cl,DATE_MASK
     jz  _comp4_220
     xchg si,di              ;so names will be in ascending order
_comp4_220:
     sub  si,37
     sub  di,37
     mov  cx,12
     repz cmpsb
     jmp  short comp4_ret
 comp4_ret2:
     cmp  al,ah
 comp4_ret:
     pop  bx
     pop  ax
     pop  cx
     pop  si
     pop  di
     ret

comp4 endp

;----------------------------------------------------------------------
; Sort files in attribute order.  Directories first, secondary sort
;  key is the filename always in ascending order.
;----------------------------------------------------------------------
comp5  proc near
     push di
     push si
     push cx
     push ax
     mov  al,byte ptr [di+14] ;treat directories special
     mov  ah,byte ptr [si+14]
     cmp  ax,03C3Ch
     je   _comp5_50
     cmp  ah,'<'
     je   comp5_ret2
     cmp  al,'<'
     je   comp5_ret2
_comp5_50:
     add  si,40                ;go to attribute field
     add  di,40
     mov  cx,4
     push cx
     mov  cl,sort_up_flag
     and  cl,ATTR_MASK         ;check if ascending or descending sort
     pop  cx
     jnz  comp5_100
     xchg di,si               ;if descending, switch pointers
 comp5_100:
     repz cmpsb               ;compare extensions
     jnz  comp5_ret           ;mismatch, done
     mov  cl,sort_up_flag     ;otherwise sort ascensing on names
     and  cl,ATTR_MASK
     jnz   comp5_200
     xchg di,si               ;names ascending, so we have to switch back
 comp5_200:
     sub  si,43               ;go back to name field
     sub  di,43
     mov  cx,12
     repz cmpsb               ;compare names/extensions
 comp5_ret:
     pop  ax
     pop  cx
     pop  si
     pop  di
     ret
 comp5_ret2:
     cmp  al,ah
     jmp  comp5_ret
comp5 endp

; ------------------------------------------------------------------------
; New DF 5.00 functions. Basically these tell the sort functions
; what to sort on.  Was easier to do things this way and keep the
; existing functions
;-------------------------------------------------------------------------

 NAME_UP  proc near
     ;mov  sort_index, 0
     mov  al,'N'
     mov  ctrl_pressed,0
     call re_sort
     ret
 NAME_UP endp

 DATE_UP  proc near
     ;mov  sort_index, 6
     mov  al,'D'
     mov  ctrl_pressed,0
     call re_sort
     ret
 DATE_UP endp

 EXT_UP  proc near
     ;mov  sort_index, 2
     mov  al,'E'
     mov  ctrl_pressed,0
     call re_sort
     ret
 EXT_UP endp

 SIZE_UP  proc near
     ;mov  sort_index, 4
     mov  al,'S'
     mov  ctrl_pressed,0
     call re_sort
     ret
 SIZE_UP endp

 ATTRIB_UP  proc near
     ;mov  sort_index, 8
     mov  al,'T'
     mov  ctrl_pressed,0
     call re_sort
     ret
 ATTRIB_UP endp

 NAME_DN  proc near
     ;mov  sort_index, 0
     mov  al,'N'
     mov  ctrl_pressed,1
     call re_sort
     ret
 NAME_DN endp

 DATE_DN  proc near
     ;mov  sort_index, 6
     mov  al,'D'
     mov  ctrl_pressed,1
     call re_sort
     ret
 DATE_DN endp

 EXT_DN  proc near
     ;mov  sort_index, 2
     mov  al,'E'
     mov  ctrl_pressed,1
     call re_sort
     ret
 EXT_DN endp

 SIZE_DN  proc near
     ;mov  sort_index, 4
     mov  al,'S'
     mov  ctrl_pressed,1
     call re_sort
     ret
 SIZE_DN endp

 ATTRIB_DN  proc near
     ;mov  sort_index, 8
     mov  al,'T'
     mov  ctrl_pressed,1
     call re_sort
     ret
 ATTRIB_DN endp

 SORT_ORIG proc near
     mov  al,'O'
     ;mov  byte ptr SORT_LEN,-1
     call    re_sort
     ret
 SORT_ORIG endp