JUMPS
;---------------------------------------------------------------------------
;Contains the code for parsing user-defined command lines
;Checks for regular expressions and inserts into the dynamically
;constructed command line.  The one exception is the dynamic run-time parameters
;which, for efficiency reasons, are coupled with other code.

;On entry: SI points to current location in line to be decoded
;          DI points to current location in command line being constructed
;Preserves:AX
;Returns:  Carry set if command line overrun, else carry clear
;          SI and DI incremented as required
;---------------------------------------------------------------------------

COMMAND_LINE_PARSE  PROC NEAR

     push   ax
_clp_100:
     CMP    BYTE PTR [SI],'~'     ;Check for file marker character
     JNE    _clp_200              ;if it's there, insert the file name
_clp_150:
     CALL   PUT_NAME_IN           ;otherwise continue on with the copy
     JC     _CLP_OVER              ;overrun in destination area
     INC    SI                    ;save source but increment for ~
     JMP    _clp_ret               ;move already done, skip over

_clp_200:
     ;%% allows literal %.  %x where x is unrecognized simply ignores the
     ;%

     cmp  byte ptr [si],'%'       ;look for general expression character
     jne  _clp_500                ;No? Nothing special about this character
     inc  si                      ;Yes? Advance to next character
     cmp  byte ptr [si],'%'       ;is it a % also
     je   _clp_500                ;if so -- treat as literal

     ;we've handled the special cases.  we're now ready to handle all the
     ;special %x parameters

     mov  al,byte ptr [si]        ;convert character to upper case if needed
     call to_upper

     cmp  al,'N'
     je   _clp_150

     cmp  al,'D'                  ;current work drive
     jne  _clp_210
_clp_205:
     call put_drive_in
     jc   _clp_over
     INC    SI                    ;save source but increment for ~
     JMP    _clp_ret              ;move already done, skip over
_clp_210:
     cmp  al,'C'                  ;current DOS (destination) drive
     je   _clp_205

     cmp  al,'B'                   ;base filename (i.e. w/o extension) added 4.60
     jne   _clp_220
     call put_base_in
     jc   _clp_over
     INC    SI
     JMP  _clp_ret

_clp_220:
     cmp  al,'E'
     jne  _clp_240
_clp_230:
     call put_ext_in
     jc   _clp_over
     INC    SI
     JMP    _clp_ret
_clp_240:
     cmp  al,'F'
     je   _clp_230

_clp_300:
     cmp  al,'P'
     jne  _clp_400
     call put_path_in
     jc   _clp_over
     inc  si
     jmp  _clp_ret

_clp_400:                          ;target pathname added DF 4.61
     cmp  al,'T'
     jne  _clp_450
     call put_target_in
     jc   _clp_over
     inc  si
     jmp  _clp_ret


_clp_450:
     cmp  al,'Z'
     jne  _clp_460
     call put_listfile
     mov  doing_zip,1              ;erase the file
     jc   _clp_over
     inc  si
     jmp  _clp_ret

_clp_460:
     cmp  al,'Y'
     jne  _clp_470
     call put_listfile
                                   ;don't erase the file
     jc   _clp_over
     inc  si
     jmp  _clp_ret

_clp_470:

_clp_500:
     MOVSB


_clp_ret:
     pop    ax
     clc
     ret
_clp_over:
     pop    ax
     stc
     ret

COMMAND_LINE_PARSE ENDP

NOJUMPS
;-----------------------------------------------------------------------
; Inserts the entire drive\path\filename
;-----------------------------------------------------------------------
PUT_NAME_IN	PROC NEAR
		PUSH    AX      ;Save current Source count
		PUSH 	SI	;Push source destination so we can go back to it

		PUSH	DI
		CALL	GET_NAME
		POP	DI
		MOV	SI,OFFSET SOURCE
		CALL	FIND_LENGTH
          call check_for_overrun

          jc   pni_ret
PNI_1:
		MOV	CX,AX
		REP	MOVSB

		MOV     BX,AX
          clc
PNI_RET:
		POP	SI
		POP	AX

		RET

PUT_NAME_IN	ENDP

;-----------------------------------------------------------------------
;Inserts the drive letter followed by a colon only
;-----------------------------------------------------------------------
put_drive_in   proc near
		PUSH    AX      ;Save current Source count
          PUSH    SI      ;Push source destination so we can go back to it

          cmp  al,'D'
          jne  PDI_50
          MOV  SI,OFFSET WORK_PATH
          jmp  short pdi_75
pdi_50:
          MOV  SI,OFFSET DEST_PATH
pdi_75:
          mov  ax,2      ;string to be inserted always 3 chracters
          call check_for_overrun
          jc   pdi_ret
PDI_100:
          movsw
          clc
PDI_RET:
		POP	SI
		POP	AX

		RET

put_drive_in   endp

;-----------------------------------------------------------------------
;Inserts the extension
;-----------------------------------------------------------------------
put_ext_in   proc near
		PUSH    AX      ;Save current Source count
          PUSH    SI      ;Push source destination so we can go back to it


          PUSH DI
          push ax
		CALL	GET_NAME
		MOV	SI,OFFSET SOURCE
          call point_to_ext
          pop  ax
          cmp  al,'F'              ;do we want the filename or the extension?
          je   _pei_100
          mov  si,di               ;we do this for the extension
_pei_100:
          call str_len
          mov  ax,cx               ;store in ax
          POP  DI
          call check_for_overrun   ;and check length
          jc   PEI_ret
          call find_length         ;returns length of whole filename in ax
          sub  ax,cx               ;subtract length of extension
          add  si,ax               ;skip to start of extension
          rep  movsb               ;copy
          clc

PEI_RET:
		POP	SI
		POP	AX

		RET

put_ext_in   endp

put_base_in    proc near
     push      ax si

     PUSH      DI
     push      ax
     CALL      GET_NAME
     MOV       SI,OFFSET SOURCE
     call      point_to_ext
     pop       ax

     call      str_len
     mov       ax,cx               ;store in ax
     POP       DI
     call      check_for_overrun   ;and check length
     jc        PBI_ret
     call      find_length         ;returns length of whole filename in ax
PBI_100:
                                   ;now point to start of filename
     cmp       byte ptr [si],0     ;loop until null or period (i.e. eextension)
     je        PBI_RET
     cmp       byte ptr [si],'.'
     je        PBI_RET
     movsb
     jmp       PBI_100
     clc
PBI_RET:
     pop       si ax
     ret
put_base_in    endp

;-----------------------------------------------------------------------
; Inserts the source path name
;-----------------------------------------------------------------------
PUT_PATH_IN    PROC NEAR
		PUSH    AX      ;Save current Source count
          PUSH    SI      ;Push source destination so we can go back to it

          MOV  SI,OFFSET WORK_PATH
		CALL	FIND_LENGTH
          inc  ax             ;we're going to stick on a trailing backslash
          call check_for_overrun

          jc   ppi_ret
PPI_1:
          dec  ax             ;adjust back to the correct value after check
          MOV  CX,AX
          REP  MOVSB          ;store the path
;          mov  al,'\'         ;store a trailing backslash
          ;trailing backslash removed 4.60
;          stosb
          cmp  byte ptr [di-1],'\'
          jne  ppi_10
          mov  al,space       ;eliminate extra backslash problem with root
          dec  di
          stosb
ppi_10:
          clc
PPI_RET:
		POP	SI
		POP	AX

		RET

PUT_PATH_IN    ENDP


;-----------------------------------------------------------------------
; Inserts the target path name
;-----------------------------------------------------------------------
PUT_TARGET_IN    PROC NEAR
		PUSH    AX      ;Save current Source count
          PUSH    SI      ;Push source destination so we can go back to it

          MOV  SI,OFFSET DEST_PATH
		CALL	FIND_LENGTH
          inc  ax             ;we're going to stick on a trailing backslash
          call check_for_overrun

          jc   pti_ret
PTI_1:
          dec  ax             ;adjust back to the correct value after check
          MOV  CX,AX
          REP  MOVSB          ;store the path
          cmp  byte ptr [di-1],'\'
          jne  pti_10
          mov  al,space       ;eliminate extra backslash problem with root
          dec  di
          stosb
pti_10:
          clc
PtI_RET:
		POP	SI
		POP	AX

		RET

PUT_TARGET_IN    ENDP


;-------------------------------------------------------------------------
;Checks that the desired length of insertion won't cause a command-line
;overrun
;On entry:
;    AX   length to check for
;    DI   points to beginning of area to be inserted to
;On exit:
;    carry set if overrun, clear otherwise
;-------------------------------------------------------------------------

check_for_overrun   proc near

     push di
     push ax

     add  di,ax
     cmp  di,offset viewer_line-1
     ja   _cor_err
     clc
     jmp  short _cor_ret
_cor_err:
     stc
_cor_ret:
     pop  ax
     pop  di
     ret

check_for_overrun   endp


;------------------------------------------------------------------------
; inserts the filename for a <CR>/<LF> delimited listfile and creates
; the contents of the listfile
;------------------------------------------------------------------------

put_listfile proc near

          PUSH    AX      ;Save current Source count
          PUSH    SI      ;Push source destination so we can go back to it

          MOV  SI,offset zip_temp
          CALL FIND_LENGTH
          call check_for_overrun

          jc   plf_ret
plf_1:
          MOV  CX,AX
          REP  MOVSB          ;store the temporary filename
plf_10:
          ;we've modified the command line.  Now we have to create the
          ; file itself
          .pushall
          call zip
          .popall

          clc
plf_RET:
		POP	SI
		POP	AX

		RET

put_listfile endp