 ;-----------------------------------------;
 ; New (modified) routine for 5.00
 ; We are ready for business now. We will  ;
 ; loop here, waiting for user keystrokes. ;
 ; Performs CALL [DI] to execute function
 ; On entry : no known parameters
 ; Returns  : nothing
 ; Modifies : everything
 ;-----------------------------------------;
 GET_KEY       PROC    NEAR
       CALL    REFRESH_DIR_DISP
       CMP     FUNCTION,0
       JE      _G_K0A

       MOV     AX,DEST_CLUSTER
       MOV     TARG_CLUSTER,AX
       CALL    DISP_COUNT_MSG          ;display files and space available
       MOV     FUNCTION,0              ;Restore function flags.

 _G_K0A:
       ;we read the keystrokes (including mouse fakeouts) here

       CALL READ_C_KEY              ;Get a keystroke.
                                    ;Retrieves keystroke via BIOS.
                                    ;    Returns : ascii value in AL,
                                    ;            : scan code in AH
       push ax
       CALL get_hotkey              ;Get shift flag status
                                    ;    Returns : hotkey code in ax
       mov     cx,ax
       pop     ax

	  CMP	CLR_MSG_FLAG,0
	  PUSH	AX                      ;preserve keystroke returned by READ_C_KEY
	  JE		MENU_FLAG_CLR
	  MOV	CLR_MSG_FLAG,0
       push    cx
       CALL    CLR_MSG
       pop     cx

 MENU_FLAG_CLR:
       POP     AX
       MOV     BX,AX                   ;Save returned key.

       ;check to see if pressed key is one of the search keys
       ;(0-9, a-z, A-Z) if so, returns carry not set; otherwise
       ;returns carry set

       call    check_for_search
       jc      _G_K1

       ;valid search key -- execute the search routine

       call    search
       jmp     get_key


       ; From here on we can assume we have a function (valid or invalid)

 _G_K1:
    	  mov	first_time,0			;used to only ask for parameter first time through
 _G_K25:
       mov     al,cl
       MOV     AH,BH
       MOV     DI,OFFSET DISPATCH_KEY
       MOV     CX,DISPATCH_CNT
       mov     bx,offset dispatch_table
       CALL    KEYLOOKUP_WRAPPER
       jnc      _G_K3
	  jmp	_G_K0A
 _G_K3:
      CALL    [BX]                    ;Else do subroutine.
;       call    quit
       JMP     GET_KEY                 ;Update screen; get next command.
GET_KEY       ENDP


 ;-------------------------------------------------------------------;
 ; Retrieve keystroke via BIOS.
 ; Returns : ascii value in AL,
 ;       : scan code in AH
 ;-------------------------------------------------------------------;
 READ_C_KEY      PROC    NEAR
       cmp     is_mouse,0   ;4.50 pull out ALL mouse stuff if no mouse
       je      start_read   ;4.50
       xor     bx,bx               ;zero out bx for holding vertical mickeys
	  mov	ax,11
	  int	33h				;and zero out motion counters
	  mov	m_movement,0
	  cmp	is_mouse,1
	  je		read_w_mouse
 START_READ:
       CALL    MENU_CHECK
       MOV     AH,BIOS_KYBD_01	;check for keystroke
       INT     16H
       JNZ     SREAD_2             ;loop until keystroke
       call    dv_pause            ;relinquish rest of time slice to DV
       call    mswin_pause
       jmp     short start_read
 SREAD_2:
       MOV     AH,BIOS_KYBD_00     ;read keystroke
       INT     16H
       RET
 READ_W_MOUSE:
       CALL    MENU_CHECK		;check if menu to be changed with hot key

	  call	chk_mb_press
	  jnc	_rwm_but5		     ;nothing, continue
	  call	emulate_keys
	  ret

 _RWM_but5:

       MOV     AH,BIOS_KYBD_01	;check for keystroke
       INT     16H
       JNZ     READ_KEYSTROKE      ;was a keystroke -- process


	  mov	ax,11
	  int	33h
	  add	m_movement,dx
	  mov	dx,m_movement
	  .ABS	dx				;dx = ABS(dx)
       xor     cx,cx               ;m_vertical changed to byte in DF 5.0
       mov     cl,m_vertical
	  cmp	dx,cx
	  ja	    _M_ENOUGH
       call    dv_pause            ;give up rest of time slide to DV
       call    mswin_pause
	  jmp	READ_W_MOUSE
_M_ENOUGH:
	  cmp	m_movement,0
	  jl		_M_UP

	  mov	ax,5000h			;down arrow equivalent
;	  sub	m_movement,cx
	  ret
 _M_UP:
	  mov	ax,4800h            ;up arrow equivalent
;	  add	m_movement,cx
	  ret

 READ_KEYSTROKE:
	  MOV	AX,11		     ;read mouse motion counters
	  INT	33h                 ;hence zeroing them out
       MOV     AH,BIOS_KYBD_00     ;read keystroke
       INT     16H
       RET

 READ_C_KEY      ENDP

 CHK_MB_PRESS	PROC NEAR

	  mov	but_press_mask,0
	  mov	ax,3				;is any button down?
	  int	33h
	  and	bx,bx
	  jz		_cmp_no             ;No? continue
 _cmp1:
	  mov	ax,5
	  mov	bx,0
	  int	33h
	  cmp	bx,0				;was the left button pressed?
	  je		_cmp2
	  or		but_press_mask,1b
 	  stc
	  ret
 _cmp2:
	  mov	ax,5
	  mov	bx,1
	  int	33h
	  cmp	bx,0                ;was the right button pressed?
	  je		_cmp3
	  or		but_press_mask,10b
 	  stc
	  ret
 _cmp3:
	  cmp	mouse_but,3
	  jne	_cmp_no
	  mov	ax,5
	  mov	bx,2
	  int	33h
	  cmp	bx,0                ;was the middle button pressed?
	  je		_cmp_no
	  or		but_press_mask,100b
 	  stc
	  ret
 _cmp_no:
	  clc			;nothing pressed
	  ret

 CHK_MB_PRESS ENDP

 EMULATE_KEYS PROC NEAR

 _EK1:
	  test	but_press_mask,100b			;middle
	  jz		_EK2
	  mov	ax,3920h            ;space bar
	  ret
 _EK2:
	  test	but_press_mask,1b			;left
	  jz		_EK3
	  mov	ax,1C0Dh            ;Enter
	  ret
 _EK3:
	  test	but_press_mask,10b			;right
	  jz		_EK_RET
	  mov	ax,011Bh            ;<esc>
	  ret
 _EK_RET:
	  clc
	  ret
 EMULATE_KEYS ENDP

 ;-------------------------------------------------------------------;
 ; Retrieve keystroke via BIOS.
 ; Returns : ascii value in AL,
 ;       : scan code in AH
 ;-------------------------------------------------------------------;
 READ_KEY      PROC    NEAR

;       MOV     AH,BIOS_KYBD_00
	  MOV	AH,0
	;don't need extended services here and they were causing trouble
       INT     16H
       RET
 READ_KEY      ENDP

 ;-------------------------------------------------------------------;
 ; Check for keystroke via BIOS.
 ; returns Z Flag set if no char
 ;         character in AX if NZ
 ;-------------------------------------------------------------------;
 CK_KEY        PROC    NEAR
;       MOV     AH,BIOS_KYBD_01
	  MOV	AH,1
       INT     16H
       RET
 CK_KEY        ENDP

 ;---------------------------------------------------------------------
 ; Returns Shift State in CL
 ; Uses but preserves AX
 ;---------------------------------------------------------------------
 READ_SHIFT_STATE proc near
     push ax
     mov  ah,2
     int  16h
     mov  cl,al
     pop  ax
     ret
 READ_SHIFT_STATE ENDP


 ;---------------------------------------------------------------------
 ;check to see if pressed key is one of the search keys
 ;(0-9, a-z, A-Z)
 ;    On entry: ax contains scan/ascii
 ;              cl contains shift flag
 ;    Modifies: carry flag
 ;    Returns:  carry not set if pressed key is one of the search keys
 ;              otherwise returns carry set
 ;---------------------------------------------------------------------
 CHECK_FOR_SEARCH   proc near
     cmp       cx,0           ;no hotkey pressed
     je        cfs_005
     cmp       cx,5           ;Alt or Ctrl
     jb        cfs_set

     ;check for ASCII codes:
     ;    0-9  30h-39h
     ;    A-Z  41h-5Ah
     ;    a-z  61h-7Ah
 CFS_005:
     cmp  al,30h
     jb   cfs_set
     cmp  al,39h
     ja   cfs_01
     jmp  short cfs_clear
 cfs_01:
     cmp  al,41h
     jb   cfs_set
     cmp  al,5Ah
     ja   cfs_02
     jmp  short cfs_clear
 cfs_02:
     cmp  al,61h
     jb   cfs_set
     cmp  al,7Ah
     ja   cfs_set
 cfs_clear:
     clc
     ret
 cfs_set:
     stc
     ret
 CHECK_FOR_SEARCH endp


;---------------------------------------------------------------------------
     ;Turns the results of the used BIOS call into the following:
     ;0   no hotkey
     ;1   LCtrl (or just Ctrl)
     ;2   RCtrl
     ;3   LAlt (or just Alt)
     ;4   RAlt
     ;5   LShift
     ;6   RShift
;     Returns this value in AX
;---------------------------------------------------------------------------

 get_hotkey    proc near

     ;some general zeroing and so forth
     mov  ctrl_pressed,0
     MOV     BYTE PTR SORT_LEN,0

     cmp  use_ext_menus,1
     jne  ghot_normal
     cmp  ext_kybd_flag,1
     jne  ghot_normal


     ;uses extended keyboard shift call
     ;returns extended shift status in ah, standard shift status in al
     mov  ah,12h
     int  16h
     jmp  short ghot_crack

 ghot_normal:
     ;use normal shift/toggle BIOS call
     ;and blank out ah
     mov  ah,2
     int 16h
     xor  ah,ah

 ghot_crack:

     test al,01b    ;RShift
     jz   ghc_10
     mov  ax,6
     ret
 ghc_10:
     test al,10b    ;LShift
     jz   ghc_20
     mov  ax,5
     ret
 ghc_20:
     cmp  ah,0
     je   ghc_100   ;Non-extended function
     test ah,01b    ;LCtrl
     jz   ghc_30
     mov  ax,1
     ret
 ghc_30:
     test ah,10b    ;LAlt
     jz   ghc_40
     mov  ax,3
     ret
 ghc_40:
     test ah,100b   ;RCtrl
     jz   ghc_50
     mov  ax,2
     ret
 ghc_50:
     test ah,1000b  ;RAlt
     jz   ghc_60
     mov  ax,4
     ret
 ghc_60:
     mov  ax,0
     ret

 ghc_100:
     test al,100b   ;Control
     jz   ghc_110
     mov  ax,1
     ret
 ghc_110:
     test al,1000b  ;Alt
     jz   ghc_120
     mov  ax,3
     ret
 ghc_120:
     mov  ax,0
     ret

 get_hotkey endp

 ;-----------------------------------------------------------------------;
 ; This subroutine searches for a filename with a specific first letter. ;
 ; On entry : BL contains character to search for
 ; Returns  : nothing
 ; Modifies : assume everything
 ;-----------------------------------------------------------------------;
 SEARCH        PROC    NEAR
       assume  es:nothing
       push    es
       mov     es,dir_buf_seg
       CMP     BL,"a"                  ;Capitalize if lower case.
       JB      _SRCH1
       CMP     BL,"z"
       JA      _SRCH1
       AND     BL,5FH

 _SRCH1:       CALL    GET_NAME                ;Get current position.
       XOR     DX,DX                   ;Zero out file counter.
       MOV     DI,SI                   ;Store current position in DI.
       INC     DI                      ;point to filename
;       MOV     SI,OFFSET DIR_BUFF + 1  ;Point to top of listing.
       mov     si,dbs_start
       inc     si

       CMP     BYTE PTR es:[DI],BL        ;Are we currently at a match?
       JNZ     _SRCH3                  ;If no, start from top.

 _SRCH2:       INC     DX                      ;Increment count.
       ADD     SI,FIELD_SIZE           ;Increment record.
       CMP     SI,DI                   ;New record?
       JBE     _SRCH2                  ;If no, find it.

 _SRCH3:       CMP     BYTE PTR es:[SI],BL        ;Got a match?
       JZ      _SRCH4                  ;If yes, process.

       ADD     SI,FIELD_SIZE           ;Else, point to next record.
       INC     DX
       CMP     BYTE PTR es:[SI],space     ;End of listing?
       JNZ     _SRCH3                  ;If no, keep searching.
       CALL    BEEP                    ;No matches, so beep.
       pop     es
       assume  es:_text
       STC
       RET

 _SRCH4:
;       assume es:nothing

       ;DF 4.60 pass 6.  I think moving this pop up here solves all the
       ; VERY hard to trace garbage on screen problems.  Not sure
       ;exactly where the garbage was coming from but it had something
       ;to do with the scroll/bar movement routines.  We have
       ;the count so don't need the directory segment any longer here


       pop     es
       MOV     CX,COUNT                ;Retrieve file count.
       SUB     CX,DX                   ;Subtract search count.
       MOV     SEARCH_COUNT,CX         ;And store.
       MOV     CL,NORMAL               ;Turn off bar for now.
	  MOV	LINE_CNT_DISP,0	    ;Turn off line number display for now
       MOV     BAR_ATTRIBUTE,CL
       CALL    END_BAR                 ;First move to end.
       JMP     SHORT _SRCH6

 _SRCH5:       CALL    UP_ARROW                ;Move up to matching filename.

 _SRCH6:       DEC     SEARCH_COUNT
       JNZ     _SRCH5

       MOV     CL,INVERSE              ;Turn bar back on and display.
	  MOV	LINE_CNT_DISP,1	    ;Turn line number display back on
       MOV     BAR_ATTRIBUTE,CL
       XOR     BP,BP
       CALL    SCROLL_BAR
       CLC
;       pop     es
;       assume es:_text
       RET
 SEARCH        ENDP


 ;Original lookup routine
 ;----------------------------------------------------;
 ; This subroutine performs a table lookup
 ; On entry :  AL contains a byte
 ;             DI points to a lookup table of length CX
 ;             BX points to last entry of a result table
 ; Returns  :  BX points to the matching entry in the result table
 ;             NZ implies no match found
 ; Modifies : BX, CX,  DI
 ;----------------------------------------------------;
 LOOKUP        PROC    NEAR
       REPNZ   SCASB           ;scan table
       PUSHF                   ;save flags
       JNZ     _LK_RET         ;not found
       SHL     CX,1            ;multiply by two bytes per word
       SUB     BX,CX           ;this many bytes from end
 _LK_RET:      POPF                    ;restore flags
       RET
 LOOKUP        ENDP

 ;----------------------------------------------------;
 ; This subroutine performs a table lookup on the key tables
 ;   Two keys per function address
 ; On entry :  AH contains a scancode
 ;             AL contains a hotkey
 ;             DI points to a lookup table of length CX/2 bytes
 ;             BX points to the first entry of a lookup table
 ; Returns  :  BX points to the matching entry in the result table
 ;             carry set implies no match found
 ; Modifies : BX, CX,  DI, DX
 ;----------------------------------------------------;
 KEYLOOKUP        PROC    NEAR
       shr     cx,1
       mov     dx,cx
       REPNZ   SCASW           ;scan table
       JNZ     _KLK_RET         ;not found
       sub     dx,cx
       sub     dx,1
       shr     dx,1
       mov     cx,dx
       shl     cx,1
       add     bx,cx
       clc
       ret
 _KLK_RET:
       stc
       RET
 KEYLOOKUP        ENDP


 ;Translate L/R Ctrl-Alt into standard keys
 KeyTranslate db 0,7,7,8,8,5,6
 ;-------------------------------------------------------------------
 ; Wrapper function for KEYLOOKUP
 ;  Scans for valid key combinations other than the explicit.
 ;   e.g. Left-Control valid for either Left-Control or Any Control
 ;--------------------------------------------------------------------

 KEYLOOKUP_WRAPPER proc near
     push bx cx dx di
     call keylookup
     jnc _klw_ret
     cmp  al,8
     ja   _klw_notfound            ;hotkey should never be >8, but just in case...
     pop  di dx cx bx
     push ax
     push bx
     mov  bx,offset KeyTranslate
     xlat
     pop  bx
     call keylookup
     pop  ax
     jnc   _klw_ret2
     cmp  nobadkey,1
     je   _klw_nf
     call beep
_klw_nf:
     stc
     ret


_klw_ret:                     ;success
     add  sp,8                ;fix stack but don't messup lookup results
_klw_ret2:
     clc
     ret
_klw_notfound:
     stc
     add  sp,8                ;fix stack but don't messup lookup results
     ret


 KEYLOOKUP_WRAPPER endp