 PPI_PORT        EQU     061H
 TIMER2_PORT     EQU     042H
 TIMER_CTRL      EQU     043H
 TIMER2_RATE     EQU     1193180   ;rate x 10^6

 factor1       dd   0         ;denominator for clktime calc
 factor2       dd   0
 clktime       dw   0
 tclktime      dw   0         ;temporary clock time variable
 temp_qw       dq   0

 FREQCOUNT     EQU  1000
 TRIALS        EQU  100

 MULCLK88      EQU  118
 MULCLK286     EQU  21
 MULCLK386     EQU  25
 MULCLK486     EQU  26

 MULOHD88      EQU  31+(22*FREQCOUNT/100)
 MULOHD286     EQU  15+(14*FREQCOUNT/100)
 MULOHD386     EQU  15+(14*FREQCOUNT/100)
 MULOHD486     EQU  15+(14*FREQCOUNT/100)

; FACTOR88      =  (TIMER2_RATE*MULCLK88*FREQCOUNT)+MULOHD88
; FACTOR286     =  (TIMER2_RATE*MULCLK286*FREQCOUNT)+MULOHD286
; FACTOR386     =  (TIMER2_RATE*MULCLK386*FREQCOUNT)+MULOHD386
; FACTOR486     =  (TIMER2_RATE*MULCLK486*FREQCOUNT)+MULOHD486



 mulclk        dw   0
 mulohd        dw   0



;----------------------------------------------------------------------------
; GET_FREQ
; Returns the frequency of the system clock in the cpuclock variable.  The
; stored value is the actual frequency x 10 (i.e. 20 MHz is stored as 200).
;
; Uses cpucode with top byte stored as 01 for 8088 through 04 for 486
;
;        Have no idea if AMD etc. clones have the same instruction cycle
;          timing as Intel
;----------------------------------------------------------------------------
 GET_FREQ      proc near
JUMPS
     mov       clktime,0
     xor       ax,ax          ;set ax=0 so if we bailout for unsupported CPU
                              ;we don't get garbage for the frequency
                              ;added DF 4.61

     mov       bx,cpucode
     dec       bh             ;bh contains CPU code -- put on zero basis
     cmp       bh,3
     ja        _gfreq_ret     ;unsupported cpu (V20, 186, etc.)

     cmp       bh,0
     jne       _gfreq_100
     mov       mulclk,MULCLK88
     mov       mulohd,MULOHD88
     jmp       short _gfreq_130
 _gfreq_100:
     cmp       bh,1
     jne       _gfreq_110
     mov       mulclk,MULCLK286
     mov       mulohd,MULOHD286
     jmp       short _gfreq_130
 _gfreq_110:
     cmp       bh,2
     jne       _gfreq_120
     mov       mulclk,MULCLK386
     mov       mulohd,MULOHD386
     jmp       short _gfreq_130
 _gfreq_120:
     mov       mulclk,MULCLK486
     mov       mulohd,MULOHD486
 _gfreq_130:
;     .mov_d    dx,ax,timer2_rate
     mov       dx,012h             ;load timer2 rate manually
     mov       ax,034DCh
     .mul_dw   mulclk,bx
     .add_dw   dx,ax,mulohd
     mov       word ptr [factor1],ax
     mov       word ptr [factor1+2],dx
     ;factor1 = TIMER2_RATE (*10^6) * MULCLK + MULOHD

     mov       cx,TRIALS         ;number of trials

 _gfreq_150:
     push      cx
     ;restore top number
     mov       bx,word ptr [factor1]
     mov       cx,word ptr [factor1+2]
     .mov_qd   temp_qw,cx,bx,ax    ;store as numerator in quadword
     mov       ax,FREQCOUNT
     call      multime        ;ax contains raw time
     xor       dx,dx
     mov       bx,100
     .mul_dw   bx                  ;dx:ax contains this trial's clock time
     mov       di,offset temp_qw
     mov       cx,dx
     mov       bx,ax
     call      div_qd
     mov       ax,word ptr [temp_qw]  ;extract result
     .add_dw   clktime+2,clktime,ax

     pop       cx
     loop      _gfreq_150

     mov       dx,word ptr clktime+2
     mov       ax,word ptr clktime
     mov       bx,TRIALS
     call      div_dw



 _gfreq_ret:
     ret

 GET_FREQ      endp
NOJUMPS
;***************************************************************;
;       MULTIME                                                ;
;       TIME EXECUTION OF MULTIPLY INSTRUCTIONS                 ;
;       On entry: AX = #of passes
;       On exit: timer count in AX
;***************************************************************;
        EVEN
        DB      ?, ?
MULTIME        PROC    NEAR
        PUSH    DI                      ; SAVE DI
        CALL    SETUP_TIMER             ; SET UP TIMER
        MOV     DI, 08000H              ; SET DI
        ADD     AX, 99                  ; ROUND UP
        MOV     CX, 100                 ; DIVIDE BY 100 =
        DIV     CL                      ;  NUMBER OF INSTRUCTIONS
        MOV     CL, AL                  ;  PER PASS
        NOP                             ; ALIGN INSTRUCTIONS
        IN      AL, PPI_PORT            ; GET CURRENT CONTROL
        MOV     BL, AL                  ; SAVE IN BL
        OR      AX, 1                   ; SET TIMER ENABLE BIT
        CLI                             ; STOP INTERRUPTS
        OUT     PPI_PORT, AL            ; ENABLE TIMER
ML:     REPT    100                     ; DO 100 MULTIPLIES
        MUL     DI                      ;
        ENDM                            ; END MACRO
        DEC     CX                      ; COUNT THIS PASS
        JZ      MD                      ; JUMP IF COMPLETE
        JMP     ML                      ; LOOP BACK IF NOT DONE
MD:     MOV     AL, BL                  ; RESTORE CONTROL VALUE
        OUT     PPI_PORT, AL            ;
        STI                             ; START INTERRUPTS
        CALL    GET_TIMER               ; OBTAIN FINAL COUNT
        POP     DI                      ; RESTORE DI
        RET                             ; RETURN
MULTIME        ENDP

;***************************************************************;
;       SETUP_TIMER                                             ;
;       SET UP THE TIMER FOR MAXIMUM COUNT, TO TIME A RUN       ;
;***************************************************************;
SETUP_TIMER     PROC    NEAR
        PUSH    AX                      ; SAVE AX
        IN      AL, PPI_PORT            ; STOP THE TIMER
        AND     AL, 0FCH                ;
        OUT     PPI_PORT, AL            ;
        MOV     AL, 0B4H                ; INITIALIZE THE TIMER
        OUT     TIMER_CTRL, AL          ;
        MOV     AL, 0                   ; CLEAR THE COUNT
        OUT     TIMER2_PORT, AL         ;
        NOP                             ;
        OUT     TIMER2_PORT, AL         ;
        POP     AX                      ; RESTORE AX
        RET                             ; RETURN
SETUP_TIMER     ENDP
;***************************************************************;
;       GET_TIMER                                               ;
;       TAKE THE COUNT FROM THE TIMER                           ;
;***************************************************************;
GET_TIMER       PROC    NEAR
        PUSH    BX                      ; SAVE REGISTERS
        IN      AL, TIMER2_PORT         ; GET LOW BYTE OF TIME
        MOV     AH, AL                  ;
        IN      AL, TIMER2_PORT         ; GET HIGH BYTE
        XCHG    AL, AH                  ; TIME IN AX
        NEG     AX                      ; CORRECT FOR COUNT-DOWN
        POP     BX                      ; RESTORE REGISTERS
        RET                             ; RETURN
GET_TIMER       ENDP