;------------------------------------------------------------     ;
; This subroutine EXEC's to the program given by VIEWER_LINE= to  ;
;  display the highlighted file for viewing.                      ;
;------------------------------------------------------------     ;

 ASSUME CS:_TEXT, DS:_TEXT, ES:_TEXT
 LIST          PROC NEAR

		  push   ax				;preserve keypress to examine for override
                                        ;with 5.00, preserves command choice
                                        ;0 = SmartViewers
                                        ;1 = Main w/ no SmartViewers
                                        ;2 = Secondary
	       CALL   GET_NAME
		  pop    ax
	       MOV    SI,OFFSET SOURCE
	       JNC    LIST_CONT            ;if not a directory, continue
	       CALL   VIEW     			;otherwise go to view for pass to view_dir
	       RET

LIST_CONT:

            call    select_viewer       ;picks the viewer number to use
            push    ax

		  call	calc_viewer_offset	;calculates the offset of the viewer to use
								;takes as input the viewer number
            MOV     DX,COMMAND_LINE_MAX      ;Load length of VIEWER_LINE for pass to CX

	       MOV     LIST_FLAG,1
            CALL    MOD_LIST
	       JC      LIST_ABORT

            CALL    MOD_CMD_LINE
            pop     ax                  ;viewer number still in ax
            cmp     ax,99
            je      _lc_150             ;secondary viewer
            cmp     ax,0
            je      _lc_150             ;standard viewer
            mov     bx,offset view2_stat
            add     bx,ax               ;advance to proper control var
            dec     bx
            push    bx                  ;store address of control_var
            test    byte ptr [bx],01b   ;return pause var set?
            je      _lc_100             ;not set, continue
            call    exec_ret            ;"Press any key to continue"
            mov     al,c_normal
            call    clr_scr
_lc_100:
            pop     bx                  ;retrieve byte for reread test
            test    byte ptr [bx],010b  ;text for reread
            jz      _lc_150             ;skip reread
            call    get_name            ;do reread
            mov     al,c_normal
            call    clr_scr
            call    refresh_pos
_lc_150:
            CALL    PUT_MENU_PATHS
	       MOV     LIST_FLAG,0

            RET
 LIST_ABORT:
           pop     ax         ;added 4.50 pass 5 -- corrected internal viewer
                              ;crash problem
	      MOV     LIST_FLAG,0
	      CLC
	      RET

 LIST         ENDP


;--------------------------------------------------------------------------
; Figures out which text viewer to use.
; Input: SI points to the source file
;        AX contains keypress info
; Modifies: Assume everything except SI
; Returns: Viewer number in AX
;--------------------------------------------------------------------------

 select_viewer		proc near

		push		si

          cmp       al,02h        ;secondary viewer
          je        _sv_sec

          cmp       al,01h      ;Main viewer override?
          je        _sv_zero

_sv_50:

          call      point_to_ext   ;point to the extension with di
          jc        _sv_zero       ;no extension found

		    ;we're now sitting at the beginning of the extension
		    ;time to compare to the various available extensions

              ;di -> beginning of extension to be searched for
              ;cx -> length of extension to be searched for
          mov       dx,NUM_VIEWERS
          mov       si,offset VIEW2_EXT-1
          call advance_to_next
          jc   _sv_zero
              ;dx = number of viewer extension lines to search through
              ;si = starting offset of first viewer line

_sv_200:
          call do_ext_compare
          jc   _sv_end        ;match found
          call advance_to_next
          jc   _sv_zero
          jmp  _sv_200

 _sv_end:
		mov		ax,NUM_VIEWERS+1
		sub		ax,dx
		jmp		short _sv_ret
 _sv_sec:
          mov       ax,99
          jmp short _sv_ret       ;use secondary viewer
 _sv_zero:
          xor       ax,ax         ;use default viewer
 _sv_ret:
		pop		si
		ret
 select_viewer		endp

;--------------------------------------------------------------------------
; Calculates the offset of the viewer to use.
; Input: AX is number of viewer
; Modifies: assume everything except SI
; Returns: Offset of viewer command line in BX
;---------------------------------------------------------------------------

 calc_viewer_offset	proc near

		push		si

		and		ax,ax
		jz		_cvo_2

          cmp       ax,99     ;secondary viewer
          je        _cvo_3

		mov		bx,offset view2_line
		dec		ax
		mov		dx,COMMAND_LINE_MAX+1
		mul		dx
		add		bx,ax
		jmp		short _cvo_ret
 _cvo_2:
		mov		bx,offset viewer_line
          jmp       short _cvo_ret
 _cvo_3:
          mov       bx,offset viewer_line_sec
 _cvo_ret:
		pop		si
		ret
 calc_viewer_offset endp


;------------------------------------------------------------------
;Checks current template extension pointed to by si for match with
;file extension pointed to by di.
;If found, returns carry set.  Otherwise returns carry clear.
;Preserves di.
;-------------------------------------------------------------------
 do_ext_compare     proc near

          push      cx
          push      di

          mov       ax,cx          ;stores length of file extension
          call      str_len_ns     ;returns length of ext template in cx
                                   ;counts to null OR space

          cmp       ax,cx
          jne       _dec_not_found ;if unequal lengths, can't match
               ;Note -- assume ? character can't match a nonexistent character
               ; even on the end
 _dec_100:
          cmpsb
          jne   _dec_check_hook
 _dec_150:
          dec  cx
          jcxz _dec_found
          jmp  _dec_100

 _dec_check_hook:
          ;before we draw any final conclusions, see if it was a hook which
          ;didn't match.  If so, we continue as if compare OK
          cmp       byte ptr [si-1],'?'
          je        _dec_150
 _dec_not_found:
          pop       di
          pop       cx
          clc
          ret
 _dec_found:
          pop       di
          pop       cx
          stc
          ret

 do_ext_compare     endp



;-------------------------------------------------------------------
;Gets length of extension in current template
;On entry: si points to current extension in template to be compared
;Returns length of extension template in cx.  Preserves di and ax.
;-------------------------------------------------------------------
 str_len_ns     proc near

		push		di
          push      ax
          mov       di,si
		xor		cx,cx
 _sln_1:
          cmp       byte ptr [di],space
          je        _sln_ret
          cmp       byte ptr [di],0
          je        _sln_ret

          inc       cx
          inc       di
          cmp       cx,3      ;force to be done at 3 (i.e. ignore extra chars)
          jne       _sln_1

 _sln_ret:
          pop       ax
          pop       di
		ret
 str_len_ns     endp


;--------------------------------------------------------------------------
;Point si at the beginning of the extension in a filename
;On entry:  si points to the start of the null terminated filename
;On exit:   di points to the start of the extension
;           si points to start of filename
;           carry set if no extension found
;--------------------------------------------------------------------------

 point_to_ext       proc near

          call      str_len       ;get length of path+filename
          mov       di,si
		add		di,cx         ;go to the null at the end
		std                     ;scan from the end
		mov		al,'\'        ;until we hit a path delimiter
		repne	scasb
		inc		di            ;advance back to beginning of filename
		inc		di

		cld                     ;we're looking forward now
		mov		si,di
		call		str_len	    ;get the length of just the filename
		mov		al,'.'
		repne	scasb
          jcxz      _pte_none      ;no extension found
          clc
          ret
_pte_none:
          stc
          ret
 point_to_ext  endp



;--------------------------------------------------------------------
; Advances to next extension template
; If one is found, carry clear and si points to the beginning of the
;   template. dx decremented (for NUM_VIEWER) as appropriate.
; If one is not found, carry set.

 advance_to_next    proc near

          push      bx
          xor       bx,bx          ;use bx as flag -- 0 until we get
                                   ;spaces and 0's
_atn_100:
          cmp       byte ptr[si],0
          je        _atn_next
          cmp       byte ptr[si],space
          jne       _atn_continue
          mov       bx,1
_atn_150:
          inc       si
          jmp       _atn_100

_atn_continue:
          and       bx,bx
          jnz       _atn_found
          jmp       _atn_150

_atn_next:
          mov       bx,1
          dec       dx
          and       dx,dx
          jz        _atn_not_found
          inc       si
          jmp       _atn_100

_atn_found:
          pop       bx
          clc
          ret

_atn_not_found:
          pop       bx
          stc
          ret

 advance_to_next    endp




;;-------------------------------------------------;
; Run a Program.  This function uses the EXEC     ;
; routine to shell to DOS and execute the program.;
;-------------------------------------------------;

 RUN_PROG	PROC NEAR

		MOV   DI,OFFSET LIST_CMD_LINE +4  ;Move it to the
		CALL	 NAME_PATH_INS              ;insert full file name and path
	                                      ;of high-lighted file

_RP_2:
		INC	 DI
		DEC	 DI
		MOV	 BYTE PTR [DI],20H          ;insert space before parameter
		INC	 DI
		MOV    WORD PTR CMD_LINE_PTR, OFFSET LIST_CMD_LINE
		MOV   WORD PTR CMD_LINE_PTR + 2,DS
		PUSH		DI
		MOV		CX,MAX_PARAM	;4.0 Enter_Param now has definable length
		CALL 	ENTER_PARAM
		POP		DI
		JC		RUN_END

RUN_IT:
		MOV   SI,OFFSET ENTRY          ;Copy the parameters
		MOV   CX,MAX_PARAM
		REP   MOVSB
		MOV   DX,0000H                 ;Hide the cursor
		CALL  SET_CURSOR

		CALL  CLR_SCR
		CALL  EXEC                     ;Execute the program

		CALL  CURSOR_OFF               ;Turn the cursor back off
		CALL  CLEAR_MSG
		CALL  EXEC_RET                 ;Scroll up and get a keystroke

          CALL  REFRESH_POS            ;Try to find the cursor position again
RUN_END:
		CALL  CURSOR_OFF             ;Abort the run Program routine
          CALL  CLEAR_MSG
          RET

MOVE_BS:
		CMP	DI,OFFSET ENTRY
		JZ	MOVE_BS_END
		DEC	DI
		MOV	SI,OFFSET BS
		CALL	GET_TEXT
MOVE_BS_END:
		RET

CLEAR_MSG:
		CALL	CLR_MSG
		RET

 RUN_PROG       ENDP

;------------------------------------------------------------------------
;Inserts full name and path of highlighted file at the location pointed
;to by DI which is passed to this subroutine.
;Preserves SI, assume changes all else; advances DI to char after
;inserted filename
;------------------------------------------------------------------------

 ASSUME CS:_TEXT, DS:_TEXT, ES:_TEXT

 NAME_PATH_INS  PROC NEAR

	PUSH		AX
	PUSH		SI

	PUSH		DI             ;keeps DI from being corrupted by GET_NAME
	CALL		GET_NAME
	POP		DI

	MOV		SI,OFFSET SOURCE	;points to full path/filename

	PUSH 	SI                  ;find length of path/filename
	MOV		CX,0                ;store in CX

_NPI_1:
	INC		CX
	INC		SI
	CMP		BYTE PTR [SI],0
	JNE		_NPI_1
     POP 		SI
	REP		MOVSB			;copy string to command line

	POP		SI				;restores SI for exit
	POP		AX

	RET

 NAME_PATH_INS		ENDP


;---------------------------------------------------------------------------
;Inserts Name of file to be operated on and shells to exec
;---------------------------------------------------------------------------


 ASSUME CS:_TEXT, DS:_TEXT, ES:_TEXT

 MOD_CMD_LINE  PROC NEAR

	       CALL   CLR_SCR
	       MOV    DX,0
	       CALL   SET_CURSOR

			call   set_fcbs
			MOV    WORD PTR CMD_LINE_PTR, OFFSET LIST_CMD_LINE
               MOV    WORD PTR CMD_LINE_PTR + 2,DS
			MOV	  FCB_1ST+2,DS
			MOV	  FCB_2ND+2,DS

               CALL   EXEC                   ;Shell to DOS
               JMP    LIST_EXIT

	       CALL   SHELL_ERROR

LIST_ERROR:    CALL   CLR_SCR
               MOV    EXEC_ERROR,01          ;SET FLAG
               CALL   CLR_SCR
               CALL   EXEC_RET               ;Alert user and get keystroke

LIST_EXIT:     RET

MOD_CMD_LINE   ENDP

;------------------------------------------------------------------------
; Parse the command line and set the proper location for the
; file control block function calls and set the FCB's
; On entry: nothing
; Modifies: AX,SI,DI,CX
; Returns: Nothing (sets FCB's)
;------------------------------------------------------------------------

 SET_FCBS	PROC NEAR

		mov		si,offset LIST_CMD_LINE+4
 sf_1:
		mov		di,offset delimiters
		lodsb
		mov		cx,6
		repnz	scasb
		jnz		sf_1

		dec		si                  ;si is now set to character after filename

		mov		di,offset fcb_5ch   ;sets file control blocks
		mov		ax,2901h
		int		21h
		mov		di,offset fcb_6ch
		mov		ax,2901h
		int		21h

		ret

 SET_FCBS ENDP


;------------------------------------------------------------------------
;Error occurred when trying to shell
;------------------------------------------------------------------------

SHELL_ERROR    PROC NEAR
               CALL   CLR_SCR
               MOV    EXEC_ERROR,01          ;SET FLAG
               CALL   CLR_SCR
               CALL   EXEC_RET               ;Alert user and get keystroke
	       RET

SHELL_ERROR    ENDP

;------------------------------------------------------------------
;Finds the length of a string pointed to by SI and delineated by
;a null.  Rteurns the value (including the trailing null) in AX.
;
;------------------------------------------------------------------

FIND_LENGTH	PROC NEAR

		PUSH 	SI
		MOV	AX,0
BEGIN_FIND:

		INC	AX
		INC	SI
		CMP	BYTE PTR [SI],0
		JNE	BEGIN_FIND

        	POP	SI
		RET

FIND_LENGTH	ENDP
;------------------------------------------------------------------
;Finds the command pointed to by the variable passed in BX of the
;length passed to by DX.  Modifies the LIST_CMD_LINE by inserting
;the command name found in the environment.
;------------------------------------------------------------------


ASSUME CS:_TEXT, DS:_TEXT, ES:_TEXT

MOD_LIST      PROC NEAR
            MOV    SI,BX                  ;Point to source
	       XOR    AX,AX                  ;Put command_line length in AX
	       CMP    BYTE PTR [SI],' '
	       JE     NO_MATCH               ;If first space is blank, assume empty

FIND_SPEC:
            MOV    DI, OFFSET LIST_CMD_LINE + 4  ;Point to destination
		  XOR    BX,BX                  ;zero out file insertion count

;deal with the special case of dynamic-parameters first
CONT_COPY:
		  CMP	BYTE PTR [SI],'`'
		  JNE	_CC_1
		  CALL	USER_PARAM_INS
		  JCXZ	ZIP_ERR			;if CX non-zero, <esc> was pressed
		  JC		OVER_ERR
		  INC	SI
		  INC	AX
		  JMP	CONT_COPY_1
_cc_1:
            call    command_line_parse    ;parse character
            jc      over_err              ;overrun in destination area
CONT_COPY_1:
	       INC    AX
		  CMP    DI,OFFSET VIEWER_LINE - 1 ;have we run out of room in list_cmd_line?
		  JE	    OVER_ERR

            CMP    AX,COMMAND_LINE_MAX  ;don't include trailing null
                                        ;used to be ..._MAX-1
                                        ;changed 4.50 -- was truncating last
                                        ;character
            JNE    CONT_COPY

		  JMP    END_COPY
OVER_ERR:
;            cmp     doing_zip,1
;            je      zip_err
	       MOV    SI,OFFSET OVERRUN_MSG  ;Print possible overrun warning
	       MOV    AH,INTENSE
	       OR     AH,80H
	       MOV    DI,PROMPT_LOC
	       CALL   PUT_STRATT
		  CALL   DELAY
ZIP_ERR:                           ;bail out from ZIP -- skip all the other stuff
            STC
            RET
END_COPY:
		  DEC	DI
		  DEC	AX        ;compensate count for characters "backspaced"
		  CMP	BYTE PTR [DI],20H
		  JE	     END_COPY	;backspace until we encounter a non-space character
		  INC	DI
		  INC     AX
		  MOV	BYTE PTR [DI],0DH ;and insert a carriage return
		  INC	DI
		  INC	AX

; Black out anything left lying around from previous shells on the
;rest of the command line.  Note that you have to do this after popping DS
;because DS is still pointing to the segment that contains the environment
;and DS:SI is the full address of the source
;
;	       MOV    CX,LENGTH_CMD-3
;	       SUB    CX,AX       ;Compensate for characters copied in command line
;	       SUB    CX,BX       ;Compensate for length of file name
 _ML_1:
            CMP    DI,OFFSET VIEWER_LINE-1
		  JE	    _ML_2
		  MOV    BYTE PTR [DI],20H
		  INC    DI
		  LOOP   _ML_1
 _ML_2:
 		  MOV    BYTE PTR [DI],0DH ; cr
		  clc	;DF 4.00 pass 4 added -- may have caused flakies previously
				;by not being here
            RET

NO_MATCH:			 	     ;String is blank

	       CMP    LIST_FLAG,1        ;If we're trying to do a list and
				         ;the string for VIEWER_LINE
				         ;isn't found, we use the built-in VIEW
				         ;function rather than aborting
	       JE     GO_VIEW
	       MOV    SI,OFFSET ENV_ERR_MSG  ;Print environment not found error
	       MOV    AH,INTENSE             ;and return with carry flag set
	       OR     AH,80H
	       MOV    DI,PROMPT_LOC2
	       CALL   PUT_STRATT
	       CALL   DELAY
	       STC
	       RET

GO_VIEW:       CALL   VIEW
	       MOV    LIST_FLAG,0
	       STC
	       RET


MOD_LIST      ENDP

;-------------------------------------------------;
; Shell to DOS for EXEC function.  Invokes a      ;
;  copy of COMMAND.COM, so we do not have to      ;
;  specify the drive and path for the EXEC'ed     ;
;  program - by using COMMAND.COM, we have access ;
;  to DOS' PATH algorithm.  All EXEC calls use    ;
;  this subroutine.  Upon entry, the command line ;
;  must already be built, and the pointer to it   ;
;  must be set.                                   ;
;-------------------------------------------------;

tempa     db 65 dup(0)

 ASSUME CS:_TEXT, DS:_TEXT, ES:_TEXT
EXEC           PROC NEAR

			call		get_cmd_length    ;store command length as 1st byte
								   ;in string

;			MOV	  SI,OFFSET WORK_PATH  ;See DOS SHELL for comments
								   ;on some of the housekeeping
;			CALL	  CHANGE_PATH

			MOV    AX,3301H
			MOV    DL,BREAK_STAT
			INT	  DOSINT

               call   pre_exec
               jnc    _exec_100
               mov    dx,offset bad_memory
               mov    ah,9
               int    21h
               jmp    error_exit           ;some sort of memory error happened
                                           ;e.g. XMS block couldn't be accessed
_exec_100:
               CLI
               MOV    STACK_SEG,SS           ;Save stack segment and pointer.
               MOV    STACK_PTR,SP
               STI

	       MOV    DX,0100H                ;move cursor down one row so that
	       MOV    AL,ORIG_ATT
	       CALL   CLR_SCR
		  MOV    DX,0100H
	       CALL   SET_CURSOR             ;EXEC_RET doesn't scroll off top

               MOV    AX,DS:[2CH]                 ;Retrieve environment segment.
               MOV    ENVIRONMENT,AX              ;And put in parameter block.
               MOV    DS,AX                       ;And data segment.

               XOR    AX,AX                  ;Zero out pointer.
FIND_COMSPEC:  MOV    SI,AX                  ;Point to environment offset.
               INC    AX                     ;Next offset.


;****************** We actuallly shell here

               MOV    DI,OFFSET COMSPEC      ;Find "Comspec=".
               MOV    CX,8
               REP    CMPSB
               JNZ    FIND_COMSPEC
               MOV    DX,SI                  ;What follows is Command.com path.
               MOV    BX,OFFSET ENVIRONMENT  ;Point to parameter block.
               MOV    AX,4B00H               ;EXEC to program
               INT    21H

			PUSH   CS
               POP    DS
			PUSH	  CS
               POP    ES                     ;Restore segment registers.
               CLI
               MOV    SP,CS:STACK_PTR        ;Restore stack segment and pointer.
               MOV    SS,CS:STACK_SEG
               STI
               cmp    ReturnPathFlag,1
               jne    _exec_200
               call   return_dos_path
_exec_200:
               call   post_exec
               pushf


			MOV	  AX,3301H			;Control-Break on again
			MOV	  DL,0
			INT    DOSINT

               MOV    DX,80H                 ;Restore Disk Transfer Address.
               MOV    AH,1AH
               INT    21H

               MOV    AH,4AH                 ;Release all but 64K of memory
               MOV    BX,1000H               ; back to DOS
               INT    21H                    ;Call DOS

               popf
               jnc    _exec_ret
               mov    dx,offset bad_memory
               mov    ah,9
               int    21h
               jmp    error_exit           ;some sort of memory error happened

 _exec_ret:
	       RET
EXEC           ENDP


;-------------------------------------------------;
; This subroutine is used to prompt the user to   ;
;  press a key to return to DF.                   ;
;-------------------------------------------------;

 ASSUME CS:_TEXT, DS:_TEXT, ES:_TEXT
EXEC_RET       PROC NEAR
               XOR    CX,CX                  ;Scroll screen up one line
               MOV    DX, 184FH
               PUSH   BP
               PUSH   BX

            IFDEF  M
                MOV    BH,INVERSE
                ELSE
            MOV    BH,BAR_COLOR                ;Use same attributes as bar
            ENDIF

               MOV    AX,601H
               INT    10H
               POP    BX
               POP    BP

               CMP    EXEC_ERROR,00             ;Was EXEC successful?
               JZ     NO_ERROR                  ;EXEC'ed program ran
               MOV    EXEC_ERROR,00             ;Error in EXEC - reset flag
               MOV    SI, OFFSET BAD_EXEC_MSG   ;Wasn't enough memory
               JMP    PRT_RET_MSG               ;Tell user
NO_ERROR:      MOV    SI, OFFSET RET_TO_DF_MSG  ;Prompt to press a key
PRT_RET_MSG:   MOV    DX,1812H                  ;Column 18, Row 25
               CALL   DISPLAY_TEXT              ;Write message
               CALL   READ_KEY                  ;Get keystroke and return to DF

               RET
EXEC_RET       ENDP


;-------------------------------------------------------------------------------
; Gets the length of the current shell command line.  Counts the characters
; through the <cr> and stores them as the first byte in the sequence
; Input: Nothing
; Modified: AX,CX,DI
; Returns: Nothing; modifies LIST_CMD_LINE
;------------------------------------------------------------------------------
 ASSUME CS:_TEXT, DS:_TEXT, ES:_TEXT
GET_CMD_LENGTH PROC NEAR

	MOV		DI,OFFSET LIST_CMD_LINE +1 ;skip over where count will be stored
	MOV  	AL,13                      ;store <cr> as comparitor
	MOV		CX,100
	REPNE	SCASB
	NEG		CX
	ADD		CX,100                     ;store count in cx (cl actually since only
								  ;lower byte will be needed
	dec		cx
	mov		di,offset list_cmd_line    ;store computer count as first byte in
								  ;command line
	MOV		[di],CL
	RET
GET_CMD_LENGTH ENDP

;-------------------------------------------------------------------
; This subroutine checks to see if the multi-execute flag is set.
; If it isn't, it just executes the command once.  Else it sees
; if files are marked and executes the command sequentially on
; multiple files
; On entry, CX = function line #
;-------------------------------------------------------------------

 MULTI		PROC NEAR

       mov     me_flag,0      ;reset the multi-execute flag to 0
       mov     doing_zip,0    ;indicates if list file being created using marks
       inc     cx             ;messed up.  Too lazy to retype UFUNC's
                              ;contains User Function # (1->n)
       ;need to preserve in ax the count
       ;added DF 5.00 Pass1 (other changes had obviously messed up)
       mov     ax,cx

       MOV     BX,OFFSET UFUNC_LINE     ;Load FUNC for pass to DI
       MOV     DX,COMMAND_LINE_MAX      ;Load length of FUNC for pass to CX
	  PUSH	DX					;preserve bx,dx for pass to mod_list
	  SUB	BX,DX
	  DEC	BX
 multi_3:
	  ADD	BX,DX   		;advance pointer to proper command line
	  INC	BX             ;advance by (max_command_line +1)*offset
	  LOOP   multi_3

	  POP    DX

       call  check_for_zip     ;peeks to see if we plan to create a list file.
                              ;if so, we change the appropriate marks


	  PUSH   AX              ;preserve value of offset number
	  push   bx              ;preserve pointer to command line
       MOV    BX,OFFSET FUNC_STAT  ;point to first return status variable
	  ADD    BX,AX 		;increment to the right one (+1)
	  DEC    BX              ;decrement to the right one

       MOV    aL,BYTE PTR [BX]
	  TEST   AL,100b		;Is the MULTI-EXECUTE STATUS bit set?
       jz     multi_4         ;nope
	  mov    me_flag,1       ;yup -- set multi-execution flag
 multi_4:
       pop    bx
       pop    ax
       push   bx
       call   multe
       pop    bx


	ret
 MULTI		ENDP

;---------------------------------------------------------------------------
; Multi-executes a highlighted file if me_flag set
; On entry: AX,BX,DX
; Modifies: Assume everything
; Returns: nothing
;----------------------------------------------------------------------------

 ASSUME CS:_TEXT, DS:_TEXT, ES:_TEXT
 MULTE	PROC NEAR

     or function,dir_ok_bit

     push ax
	push	bx
	push	dx
     ;cmp  doing_zip,1
     ;je   _multe_3
	cmp	me_flag,1				;do we do multi-execute?
     je  _multe_05				;yes? go ahead
	call ufunc                    ;otherwise skip this mess and execute ufunc
	jmp  _multe_x
 _MULTE_05:
	CALL	COUNT_MARKS
	JNZ	_MULTE_1
	CALL	PUT_AMARK
     push es
     mov  es,dir_buf_seg
     MOV  BYTE PTR es:[SI],space
     pop  es
	JMP	SHORT _MULTE_3

 _MULTE_1:	CALL	HOME_BAR
	call	refresh_dir_disp

 _MULTE_2: ;CALL REFRESH_DIR_DISP
	CALL	GET_NAME
     push es
     mov  es,dir_buf_seg
     CMP  BYTE PTR es:[SI],COPY_MARK
     pop  es
	JZ	_MULTE_3
	CALL	DN_ARROW
	JMP	SHORT _MULTE_2

 _MULTE_3:	CALL	GET_NAME
	JNC	_MULTE_4          ;Carry flag set by GET_NAME if illegal function
	INC	MARK_CNT
	JMP	_MULTE_7

 _MULTE_4:	MOV	DX,OFFSET SOURCE
 _MULTE_6:
	pop	dx
	pop	bx
	pop	ax
	push	ax
	push	bx
	push	dx
	mov	cx,mark_cnt
	push	cx
	mov	si,cur_file
	push	si
	CALL	UFUNC		 ;executes
	jnc	_multe_6_5
	pop	si
	pop	cx
	jmp	short _multe_x
 _multe_6_5:
	mov	first_time,1			;used to only ask for parameter first time through
;	call refresh_dir_disp
	pop	si
	mov	cur_file,si
	pop	cx
	mov	mark_cnt,cx
;	CALL	REFRESH_DIR_DISP   ;Redisplays with changed attributes and
;	jc	_MULTE_7			 ;failed
;	MOV	SI,CUR_FILE
     push es
     mov  es,dir_buf_seg
     MOV  BYTE PTR es:[SI],'*'
     pop  es
;	CALL	UPDATE_date
	JMP	_MULTE_8

 _MULTE_7:	CALL	BEEP
	CALL	DN_ARROW

 _MULTE_8:	DEC	MARK_CNT
	CALL	CK_KEY
	JNZ	_MULTE_9
	CMP	MARK_CNT,0
	JLE	_MULTE_X
	JMP	_MULTE_2

 _MULTE_9:	CALL	READ_KEY
	CALL	CK_KEY
	JNZ	_MULTE_9

 _MULTE_X:
	pop	dx
	pop	bx
	pop	ax
 _MULTE_X2:
       cmp    doing_zip,1
	  jne    _MULTE_X2B
	  push	ax
	  push	dx
	  call	erase_zfile  ;have to erase file before refresh
	  pop	dx
	  pop	ax
_MULTE_X2B:
       MOV    BX,OFFSET FUNC_STAT  ;point to first return status variable
	  ADD    BX,AX 		;increment to the right one (+1)
	  DEC    BX              ;decrement to the right one
     TEST byte ptr[bx],010b		;TEST READ_STATUS bit
							;DF 4 pass 4 fix
     JZ   _MULTE_X3		;no -- skip reread
     CALL GET_NAME
	mov	al,c_normal
	call	clr_scr
     CALL REFRESH_POS
;	CALL	REFRESH_DIR_DISP   ;Redisplays with changed attributes and
 _MULTE_X3:
     CALL   PUT_MENU_PATHS
	call		count_marks
	clc
	RET


 MULTE		ENDP

;------------------------------------------------------------     ;
; This subroutine EXEC's to the program given by FUNCxx_LINE= to  ;
;  display the highlighted file for viewing.  On entry,AL         ;
;  contains the extended scan code of the pressed key             ;
;------------------------------------------------------------     ;

 ASSUME CS:_TEXT, DS:_TEXT, ES:_TEXT
 UFUNC        PROC NEAR

		  push   bx
		  push   ax
		  clc
            CALL   MOD_LIST
		  POP    AX
            JC     UFUNC_ABORT

		  PUSH   AX
            CALL   MOD_CMD_LINE
		  POP    AX
		  pop    bx

            MOV    BX,OFFSET FUNC_STAT  ;point to first return status variable
		  ADD    BX,AX 		;increment to the right one (+1)
		  DEC    BX              ;decrement to the right one

	       MOV    aL,BYTE PTR [BX]
		  TEST   AL,01b		;Is the RETURN STATUS bit set?
		  PUSH   ax
	       JE     UFUNC_RET
	       CALL   EXEC_RET
	       CALL   CLR_SCR
UFUNC_RET:
;           MOV    BX,OFFSET FUNC_STAT  ;point to first status variable
;		  ADD    BX,AX 		;increment to the right one (+1)
;		  DEC    BX              ;decrement to the right one
;	       MOV    AX,BYTE PTR [BX]
		  pop    ax
;		  TEST   Al,010b		;TEST READ_STATUS bit
;	       JE     UFUNC_RD
;		  CALL   GET_NAME  <-- don't want to do these between files
;	       CALL   REFRESH_POS  < -- move to MULTE
UFUNC_RD:
;	       CALL   PUT_MENU_PATHS
		  clc
               RET
UFUNC_ABORT:
		 POP		BX
		 STC			;changed from CLC DF 4.00 pass 4
	      RET

 UFUNC       ENDP



UFUNC1 proc near
     mov  cx,0
     call  MULTI
     ret
UFUNC1 endp

UFUNC2 proc near
     mov  cx,1
     call  MULTI
     ret
UFUNC2 endp

UFUNC3 proc near
     mov  cx,2
     call  MULTI
     ret
UFUNC3 endp

UFUNC4 proc near
     mov  cx,3
     call  MULTI
     ret
UFUNC4 endp

UFUNC5 proc near
     mov  cx,4
     call  MULTI
     ret
UFUNC5 endp

UFUNC6 proc near
     mov  cx,5
     call  MULTI
     ret
UFUNC6 endp

UFUNC7 proc near
     mov  cx,6
     call  MULTI
     ret
UFUNC7 endp

UFUNC8 proc near
     mov  cx,7
     call  MULTI
     ret
UFUNC8 endp

UFUNC9 proc near
     mov  cx,8
     call  MULTI
     ret
UFUNC9 endp

UFUNC10 proc near
     mov  cx,9
     call  MULTI
     ret
UFUNC10 endp

UFUNC11 proc near
     mov  cx,10
     call  MULTI
     ret
UFUNC11 endp

UFUNC12 proc near
     mov  cx,11
     call  MULTI
     ret
UFUNC12 endp

UFUNC13 proc near
     mov  cx,12
     call  MULTI
     ret
UFUNC13 endp

UFUNC14 proc near
     mov  cx,13
     call  MULTI
     ret
UFUNC14 endp

UFUNC15 proc near
     mov  cx,14
     call  MULTI
     ret
UFUNC15 endp

UFUNC16 proc near
     mov  cx,15
     call  MULTI
     ret
UFUNC16 endp

UFUNC17 proc near
     mov  cx,16
     call  MULTI
     ret
UFUNC17 endp

UFUNC18 proc near
     mov  cx,17
     call  MULTI
     ret
UFUNC18 endp

UFUNC19 proc near
     mov  cx,18
     call  MULTI
     ret
UFUNC19 endp

UFUNC20 proc near
     mov  cx,19
     call  MULTI
     ret
UFUNC20 endp

UFUNC21 proc near
     mov  cx,20
     call  MULTI
     ret
UFUNC21 endp

UFUNC22 proc near
     mov  cx,21
     call  MULTI
     ret
UFUNC22 endp

UFUNC23 proc near
     mov  cx,22
     call  MULTI
     ret
UFUNC23 endp

UFUNC24 proc near
     mov  cx,23
     call  MULTI
     ret
UFUNC24 endp

UFUNC25 proc near
     mov  cx,24
     call  MULTI
     ret
UFUNC25 endp

UFUNC26 proc near
     mov  cx,25
     call  MULTI
     ret
UFUNC26 endp

UFUNC27 proc near
     mov  cx,26
     call  MULTI
     ret
UFUNC27 endp

UFUNC28 proc near
     mov  cx,27
     call  MULTI
     ret
UFUNC28 endp

UFUNC29 proc near
     mov  cx,28
     call  MULTI
     ret
UFUNC29 endp

UFUNC30 proc near
     mov  cx,29
     call  MULTI
     ret
UFUNC30 endp

UFUNC31 proc near
     mov  cx,30
     call  MULTI
     ret
UFUNC31 endp

UFUNC32 proc near
     mov  cx,31
     call  MULTI
     ret
UFUNC32 endp

UFUNC33 proc near
     mov  cx,32
     call  MULTI
     ret
UFUNC33 endp

UFUNC34 proc near
     mov  cx,33
     call  MULTI
     ret
UFUNC34 endp

UFUNC35 proc near
     mov  cx,34
     call  MULTI
     ret
UFUNC35 endp

UFUNC36 proc near
     mov  cx,35
     call  MULTI
     ret
UFUNC36 endp

UFUNC37 proc near
     mov  cx,36
     call  MULTI
     ret
UFUNC37 endp

UFUNC38 proc near
     mov  cx,37
     call  MULTI
     ret
UFUNC38 endp

UFUNC39 proc near
     mov  cx,38
     call  MULTI
     ret
UFUNC39 endp

UFUNC40 proc near
     mov  cx,39
     call  MULTI
     ret
UFUNC40 endp

UFUNC41 proc near
     mov  cx,40
     call  MULTI
     ret
UFUNC41 endp

UFUNC42 proc near
     mov  cx,41
     call  MULTI
     ret
UFUNC42 endp

UFUNC43 proc near
     mov  cx,42
     call  MULTI
     ret
UFUNC43 endp

UFUNC44 proc near
     mov  cx,43
     call  MULTI
     ret
UFUNC44 endp

UFUNC45 proc near
     mov  cx,44
     call  MULTI
     ret
UFUNC45 endp

UFUNC46 proc near
     mov  cx,45
     call  MULTI
     ret
UFUNC46 endp

UFUNC47 proc near
     mov  cx,46
     call  MULTI
     ret
UFUNC47 endp

UFUNC48 proc near
     mov  cx,47
     call  MULTI
     ret
UFUNC48 endp

UFUNC49 proc near
     mov  cx,48
     call  MULTI
     ret
UFUNC49 endp

UFUNC50 proc near
     mov  cx,49
     call  MULTI
     ret
UFUNC50 endp

UFUNC51 proc near
     mov  cx,50
     call  MULTI
     ret
UFUNC51 endp

UFUNC52 proc near
     mov  cx,51
     call  MULTI
     ret
UFUNC52 endp

UFUNC53 proc near
     mov  cx,52
     call  MULTI
     ret
UFUNC53 endp

UFUNC54 proc near
     mov  cx,53
     call  MULTI
     ret
UFUNC54 endp

UFUNC55 proc near
     mov  cx,54
     call  MULTI
     ret
UFUNC55 endp

UFUNC56 proc near
     mov  cx,55
     call  MULTI
     ret
UFUNC56 endp

UFUNC57 proc near
     mov  cx,56
     call  MULTI
     ret
UFUNC57 endp

UFUNC58 proc near
     mov  cx,57
     call  MULTI
     ret
UFUNC58 endp

UFUNC59 proc near
     mov  cx,58
     call  MULTI
     ret
UFUNC59 endp

UFUNC60 proc near
     mov  cx,59
     call  MULTI
     ret
UFUNC60 endp

UFUNC61 proc near
     mov  cx,60
     call MULTI
     ret
UFUNC61 endp

LIST_SV proc near
     mov  ax,0
     call LIST
     ret
LIST_SV endp

LIST_SEC proc near
     mov  ax,2
     call LIST
     ret
LIST_SEC endp

LIST_MAIN proc near
     mov  ax,1
     call LIST
     ret
LIST_MAIN endp

;---------------------------------------------------------------------------
;
; Returns fully qualified DOS path with disk drive pointed to by si.
; String is null terminated
;----------------------------------------------------------------------------

return_dos_path proc near

               mov    si,offset tmp_buff
               push   si
               mov    dl,0
               mov    ah,47h
               int    21h
               pop    si
               mov    di,offset tmp_buff2
               push   di
               mov    ah,19h
               int    21h
               add    al,'A'
               stosb
               mov    al,':'
               stosb
               call   copy_null
               mov    al,0
               stosb
               pop    si ;intentional mismatch, we want to return si
               ret

return_dos_path endp

exec_return_path    proc near
            mov    ReturnPathFlag,1
            mov    bx,offset returnpath1
            xor    dx,dx
            mov    dl,FUNC_LNGTH
		  clc
            CALL   MOD_LIST
            JC     erp_err

            CALL   MOD_CMD_LINE
            mov    si,offset TMP_BUFF2
            jmp    short erp_ret

erp_err:
            stc
            jmp     short erp_ret1
erp_ret:
            clc
erp_ret1:
            mov    ReturnPathFlag,0
            push   si
            mov    al,c_normal
            call   clr_scr
            CALL   REFRESH_POS
            pop    si
            ret
exec_return_path    endp