 ;--------------------------------------------------------------;
 ; These two subroutines retrieve or change a file's attribute. ;
 ; On entry : DS:DX =ASCIIZ pathname
 ;          CX = attribute
 ; Returns  : AX = error codes if carry set
 ;--------------------------------------------------------------;
 CHMOD PROC    NEAR
	  TEST	CX,10h ;did GETMOD say it's a subdirectory
	  JZ	     _CHM_1
	  SUB	CX,10h;if so, no problem -- just get rid of it
 _CHM_1:
       MOV     AX,4301H
       INT     DOSINT
       RET
 CHMOD ENDP

 GETMOD        PROC    NEAR
       MOV     AX,4300H
       INT     DOSINT
       RET
 GETMOD        ENDP

;----------------------------------------------------------------------
;Set or remove archive bit
;----------------------------------------------------------------------

 ASSUME CS:_TEXT, DS:_TEXT, ES:_TEXT
 ARCHIVE	PROC NEAR

	MOV	ATTR_BYTE_VAL,32   ;bit 5
	CALL	ATTRIB
	RET

 ARCHIVE	ENDP

;----------------------------------------------------------------------
;Set or remove read_only bit
;----------------------------------------------------------------------

 ASSUME CS:_TEXT, DS:_TEXT, ES:_TEXT
 READ_ONLY	PROC NEAR

	MOV	ATTR_BYTE_VAL,1
	CALL	ATTRIB             ;bit 0
	RET

 READ_ONLY	ENDP

;----------------------------------------------------------------------
;Set or remove hidden bit
;----------------------------------------------------------------------

 ASSUME CS:_TEXT, DS:_TEXT, ES:_TEXT
 HIDDEN		PROC NEAR

	ADD 	FUNCTION,HID_OK_BIT   ;OK to change hidden files
	MOV	ATTR_BYTE_VAL,2    ;bit 1
	CALL	ATTRIB
	SUB	FUNCTION,HID_OK_BIT   ;Not OK any longer
	RET

 HIDDEN		ENDP

;----------------------------------------------------------------------
;Set or remove system bit
;----------------------------------------------------------------------

 ASSUME CS:_TEXT, DS:_TEXT, ES:_TEXT
 SYSTEM		PROC NEAR

	MOV	ATTR_BYTE_VAL,4    ;bit 2
	CALL	ATTRIB
	RET

 SYSTEM		ENDP

;-----------------------------------------------------------------------
;Alter attribute bits
;  see EXEC_MARKED for detailed comments on general structure
;-----------------------------------------------------------------------

 ASSUME CS:_TEXT, DS:_TEXT, ES:_TEXT
 ATTRIB		PROC NEAR

	ADD	FUNCTION,DIR_OK_BIT
	CALL	CURSOR_OFF
	CALL	COUNT_MARKS
	JNZ	_AM_1
	CALL	PUT_AMARK
     push es
     mov  es,dir_buf_seg
     MOV  BYTE PTR es:[SI],space
     pop  es
	JMP	SHORT _AM_3

 _AM_1:	CALL	HOME_BAR

 _AM_2:	CALL	REFRESH_DIR_DISP
	CALL	GET_NAME
     push es
     mov  es,dir_buf_seg
     CMP  BYTE PTR es:[SI],COPY_MARK
     pop  es
	JZ	_AM_3
	CALL	DN_ARROW
	JMP	SHORT _AM_2

 _AM_3:	CALL	GET_NAME
	JNC	_AM_4          ;Carry flag set by GET_NAME if illegal function
	INC	MARK_CNT
	JMP	_AM_7

 _AM_4:	MOV	DX,OFFSET SOURCE
	CALL	GETMOD
	CMP	CTRL_PRESSED,0
	JNE	_AM_5
	OR	CX,ATTR_BYTE_VAL     ;OR's CX with attribute value if adding
	JMP	_AM_6

 _AM_5: MOV	BX,ATTR_BYTE_VAL
	NOT	BL
	AND	CL,BL                ;NAND's with attribute value if removing
 _AM_6:
	CALL	CHMOD                ;CHMOD executes DOS interrupt 43h to change attribute
	MOV	SI,CUR_FILE
     push es
     mov  es,dir_buf_seg
     MOV  BYTE PTR es:[SI],'*'
     pop  es
	JMP	_AM_8

 _AM_7:	CALL	BEEP
	CALL	DN_ARROW

 _AM_8:	DEC	MARK_CNT
	CALL	UPDATE_ATTRIBUTE
	CALL	CK_KEY
	JNZ	_AM_9
	CMP	MARK_CNT,0
	JLE	_AM_X
	JMP	_AM_2

 _AM_9:	CALL	READ_KEY
	CALL	CK_KEY
	JNZ	_AM_9

 _AM_X:	CALL	REFRESH_DIR_DISP   ;Redisplays with changed attributes and
	MOV	CTRL_PRESSED,0     ;resets CTRL_PRESSED value
	MOV	FUNCTION,0
	RET


 ATTRIB		ENDP

;-------------------------------------------------------------------
;Update Attribute Values based on CTRL_PRESSED (add or remove)
;and ATTR_BYTE_VAL - which indicates the attribute being changed.
;Writes directly to the directory entry for the file
;--------------------------------------------------------------------
 UPDATE_ATTRIBUTE  PROC	NEAR
     ASSUME CS:_TEXT, DS:_TEXT, ES:nothing

     push es
     mov  es,dir_buf_seg

	CMP	CTRL_PRESSED,0
	JNE	_UA_4                  ;delete attribute from directory structure

	CMP 	ATTR_BYTE_VAL,1
	JNE	_UA_1
     MOV  BYTE PTR es:[SI].D_RO,"R" ;add read-only
 _UA_1:
	CMP	ATTR_BYTE_VAL,2
	JNE	_UA_2
     MOV  BYTE PTR es:[SI].D_HID,"H" ;add hidden
 _UA_2:
	CMP	ATTR_BYTE_VAL,4
	JNE	_UA_3
     MOV  BYTE PTR es:[SI].D_SYS,"S" ;add system
 _UA_3:
	CMP	ATTR_BYTE_VAL,32
	JNE	_UA_8
     MOV  BYTE PTR es:[SI].D_ARC,"A" ;add archive
	JMP	_UA_8

 _UA_4:

 	CMP 	ATTR_BYTE_VAL,1
	JNE	_UA_5
     MOV  BYTE PTR es:[SI].D_RO,space
 _UA_5:
	CMP	ATTR_BYTE_VAL,2
  	JNE	_UA_6
     MOV  BYTE PTR es:[SI].D_HID,space
 _UA_6:
	CMP	ATTR_BYTE_VAL,4
	JNE	_UA_7
     MOV  BYTE PTR es:[SI].D_SYS,space
 _UA_7:
	CMP	ATTR_BYTE_VAL,32
	JNE	_UA_8
     MOV  BYTE PTR es:[SI].D_ARC,space

 _UA_8:
     pop  es
     RET

 UPDATE_ATTRIBUTE  ENDP

ARCHIVE_ADD proc near
     mov  ctrl_pressed,0
     call archive
     ret
archive_add    endp

read_only_add proc near
     mov  ctrl_pressed,0
     call read_only
     ret
read_only_add endp

hidden_add     proc near
     mov  ctrl_pressed,0
     call hidden
     ret
hidden_add endp

system_add     proc near
     mov  ctrl_pressed,0
     call system
     ret
system_add endp

ARCHIVE_del proc near
     mov  ctrl_pressed,1
     call archive
     ret
archive_del    endp

read_only_del proc near
     mov  ctrl_pressed,1
     call read_only
     ret
read_only_del endp

hidden_del     proc near
     mov  ctrl_pressed,1
     call hidden
     ret
hidden_del endp

system_del     proc near
     mov  ctrl_pressed,1
     call system
     ret
system_del endp


