{$M 8192,0,10240}  { 10k reserved for data }
{$N-,E- no math support needed}
{$X- function calls may not be discarded}
{$I- disable I/O checking (trap errors by checking IOResult)}

PROGRAM Create_Description_Files;

{===========================================================================}
                      (** Global declarations **)
{===========================================================================}

USES DOS, ArcID, ImageID;
CONST
  progdesc = 'CDesc v1.10 - Free DOS utility: Create a descriptive list of specified files.';
  author   = 'Copyright (c) April 12, 1996 by David Daniel Anderson - Reign Ware.';
  Divider = '';
VAR
  unARC, unARJ, unHAP, unLZH, unPAK,
  unRAR, unUC2, unZIP, unZOO,
  unHA, unHPK, unHYP, unSQZ: STRING;

{===========================================================================}
                  (** Custom help & exit procedure **)
{===========================================================================}

VAR SavedExitProc: POINTER;
FUNCTION WordToHex (W: WORD): STRING; FORWARD;

PROCEDURE CustomExit; FAR;
{---- Always exit through here ----}
CONST
  usage    = 'Usage:    CDesc <files_to_query> <text_file_output>';
  example  = 'Example:  CDesc c:\download\*.* files.bbs';
  note     = 'Note: DOS wildcards may be used when specifying the files to query.';

VAR
  message: STRING [79];
BEGIN
  ExitProc := SavedExitProc;
  IF (ExitCode > 0) THEN BEGIN
    WriteLn (usage);
    WriteLn (example);   WriteLn;
    WriteLn (note);      WriteLn;
  END;
  IF ErrorAddr <> NIL THEN
  BEGIN
    WriteLn ('An unanticipated error occurred, please contact DDA with the following data:');
    WriteLn ('Address = ', WordToHex (Seg (ErrorAddr^)), ':', WordToHex (Ofs (ErrorAddr^)));
    WriteLn ('Code    = ', ExitCode);
    ErrorAddr := NIL;
  END
  ELSE
    IF (ExitCode > 0) AND (ExitCode < 255) THEN BEGIN
      CASE ExitCode OF
        2 : message := 'No files found.  First parameter must be a valid file specification.';
        7 : message := 'File handling error.  Text file is most likely incomplete - or nonexistent.';
        ELSE  message := 'Unknown error.';
      END;
      WriteLn ('Error encountered, number ', ExitCode, ':'); WriteLn (message);
    END;
END;

{===========================================================================}
                     (** Supporting subroutines **)
{===========================================================================}

CONST
  HexDigits : ARRAY [0..15] OF CHAR = '0123456789ABCDEF';

FUNCTION ByteToHex (B: BYTE): STRING; {Convert a BYTE var to Hex string}
BEGIN
  ByteToHex := Concat (HexDigits [B SHR 4], HexDigits [B AND $F]);
END;

FUNCTION WordToHex (W: WORD): STRING; {Convert a WORD var to Hex string}
BEGIN
  WordToHex := ByteToHex (Hi (W)) + ByteToHex (Lo (W));
END;

PROCEDURE CheckIO;
BEGIN
  IF IOResult <> 0 THEN Halt (7);
END;

FUNCTION LZero (CONST w: WORD): STRING;
VAR
  s : STRING;
BEGIN
  Str (w : 0, s);
  IF (Length (s) = 1) THEN
    s := '0' + s;
  LZero := s;
END;

FUNCTION LowerStr (w: STRING): STRING;
VAR
  cp  : INTEGER;        {The position of the character to change.}
BEGIN
  FOR cp := 1 TO Length (w) DO
    IF w [cp] in ['A'..'Z'] THEN
      System.Inc (w [cp], 32);
  LowerStr := w;
END;

FUNCTION RPad (bstr: STRING; CONST len: BYTE): STRING;
BEGIN
  WHILE (Length (bstr) < len) DO
    bstr := bstr + #32;
  RPad := bstr;
END;

FUNCTION RTrim (InStr: STRING): STRING;
BEGIN
  WHILE (Length (InStr) > 0) AND (InStr [Length (InStr) ] IN [#0, #9, #32]) DO
    system. Dec (InStr [0]);
  RTrim := InStr;
END;

FUNCTION LTrim (InStr: STRING): STRING;
BEGIN
  WHILE (Length (InStr) > 0) AND (InStr [1] IN [#0, #9, #32]) DO
    Delete (InStr, 1, 1);
  LTrim := InStr;
END;

FUNCTION Trim (InStr: STRING): STRING;
BEGIN
  Trim := RTrim (LTrim (InStr));
END;

FUNCTION IsDir (CONST FileName: PATHSTR): BOOLEAN;
VAR
  Attr  : WORD;
  cFile : FILE;
BEGIN
  Assign (cFile, FileName);
  GetFAttr (cFile, Attr);
  IF (DosError = 0) AND ((Attr AND Directory) = Directory)
    THEN IsDir := TRUE
    ELSE IsDir := FALSE;
END;

FUNCTION IsFile (CONST FileName: PATHSTR): BOOLEAN;
VAR
  Attr  : WORD;
  cFile : FILE;
BEGIN
  Assign (cFile, FileName);
  GetFAttr (cFile, Attr);
  IF (DosError = 0) AND ((Attr AND Directory) <> Directory)
    THEN IsFile := TRUE
    ELSE IsFile := FALSE;
END;

PROCEDURE EraseFile (CONST FileName : STRING);
VAR
  cFile : FILE;
BEGIN
  IF IsFile (FileName) THEN BEGIN
    Assign (cFile, FileName);
    SetFAttr (cFile, 0);
    Erase (cFile); CheckIO;
  END;
END;

{===========================================================================}
                      (** Primary subroutines **)
{===========================================================================}

FUNCTION GetFilePath (CONST PSTR: STRING; VAR ZDir: DIRSTR): PATHSTR;
VAR
  dirinfo   : SEARCHREC;
  jPath     : PATHSTR;  { file path,       }
  jDir      : DIRSTR;   {      directory,  }
  jName     : NAMESTR;  {      name,       }
  jExt      : EXTSTR;   {      extension.  }
BEGIN
  jPath := PStr;
  IF IsDir(jPath) THEN BEGIN
    IF NOT (jPath[Length(jPath)] in [':','\']) THEN
      jPath:=jPath+'\';
    jPath:=jPath+'*.*';
  END;

  FSplit (FExpand (jPath), jDir, jName, jExt);
  jPath := jDir+jName+jExt;

  ZDir := jdir;
  GetFilePath := jpath;
END;

PROCEDURE InitUnArchivers;
VAR
  epath, cpath   : PATHSTR;
  {epath & cpath are fully qualified pathnames of .exe & .cfg files}
  edir: DIRSTR; ename: NAMESTR; eext: EXTSTR;
  CfgFile        : TEXT;
  CfgLine,
  CfgVar, CfgVal : STRING [80];
  equalPos       : BYTE;

BEGIN
  epath := (ParamStr (0));
  FSplit (FExpand (epath), edir, ename, eext); { break up path into components }
  cpath := edir + ename + '.cfg';

  unARC := 'pkxarc';
  unARJ := 'arj e -y';
  unLZH := 'lha e -n2 -m+ -c+';
  unHAP := 'pah e';
  unPAK := 'pak e /wa';
  unRAR := 'rar e';
  unUC2 := 'uc e -f';
  unZIP := 'pkunzip -# -o';
  unZOO := 'zoo -extract';

  unHA    := 'ha ey';
  unHPK := 'hpack x -oa';
  unHYP := 'hyper -xo';
  unSQZ   := 'sqz e /o1';

  IF IsFile (cpath) THEN
  BEGIN
    Assign (CfgFile, cpath);
    Reset (CfgFile); CheckIO;
    IF NOT EOF (CfgFile) THEN
    REPEAT  { find vars }
      ReadLn (CfgFile, CfgLine);
      equalPos := Pos ('=', CfgLine);
      IF (Length (CfgLine) > 10) THEN BEGIN

        CfgVar := Trim (LowerStr (Copy (CfgLine, 1, equalPos - 1)));
        CfgVal := Trim (Copy (CfgLine, equalPos + 1, Length (CfgLine) - equalPos));

        IF (CfgVar = 'unARC') THEN
          unARC := CfgVal
        ELSE IF (CfgVar = 'unARJ') THEN
          unARJ := CfgVal
        ELSE IF (CfgVar = 'unHAP') THEN
          unHAP := CfgVal
        ELSE IF (CfgVar = 'unLZH') THEN
          unLZH := CfgVal
        ELSE IF (CfgVar = 'unPAK') THEN
          unPAK := CfgVal
        ELSE IF (CfgVar = 'unRAR') THEN
          unRAR := CfgVal
        ELSE IF (CfgVar = 'unUC2') THEN
          unUC2 := CfgVal
        ELSE IF (CfgVar = 'unZIP') THEN
          unZIP := CfgVal
        ELSE IF (CfgVar = 'unZOO') THEN
          unZOO := CfgVal
        ELSE IF (CfgVar = 'unHA') THEN
          unHA := CfgVal
        ELSE IF (CfgVar = 'unHPK') THEN
          unHPK := CfgVal
        ELSE IF (CfgVar = 'unHYP') THEN
          unHYP := CfgVal
        ELSE IF (CfgVar = 'unSQZ') THEN
          unSQZ := CfgVal

      END;
    UNTIL EoF (CfgFile); { loop back to read another line }
    Close (CfgFile); CheckIO;
  END;
END;

FUNCTION ExtractFile (CONST ArchiveFile, FileToEx: STRING; ExCMD : STRING): BOOLEAN;
BEGIN
  ExCMD := ExCMD + #32 + ArchiveFile + #32 + FileToEx;
  SwapVectors;
    Exec (GetEnv ('COMSPEC'), ' /c '+ExCMD+' >nul');
  SwapVectors;
  ExtractFile := IsFile (FileToEx)
END;

FUNCTION IsArchive (CONST SomeFile: STRING): STRING;
VAR
  ExCMD : STRING;
  FileID : ARCTYPE;
BEGIN
  ExCMD := '';
  FileID := IsArc (SomeFile);
  IF FileID <> NONE THEN BEGIN

     CASE FileID OF
       ARC : ExCMD := unARC;
       ARJ : ExCMD := unARJ;
       HAP : ExCMD := unHAP;
       LZH : ExCMD := unLZH;
       PAK : ExCMD := unPAK;
       RAR : ExCMD := unRAR;
       UC2 : ExCMD := unUC2;
       ZIP : ExCMD := unZIP;
       ZOO : ExCMD := unZOO;
       HA  : ExCMD := unHA ;
       HPK : ExCMD := unHPK;
       HYP : ExCMD := unHYP;
       SQZ : ExCMD := unSQZ;
     END;

     IF ExCMD <> '' THEN WriteLn ('Extracting with: ', ExCMD);
  END;
  IsArchive := ExCMD;
END;

PROCEDURE WriteFileInfo (VAR TXTfile: TEXT; CONST dirinfo: SEARCHREC);
VAR
  FSize       : STRING;
  DateTimeInf : DATETIME;
BEGIN
  Str (DirInfo. Size, FSize);
  UnpackTime (DirInfo. Time, DateTimeInf);
  WITH DateTimeInf DO
  BEGIN
    Write (TXTfile, RPad (DirInfo. Name, 12), (FSize): 9, #32#32,
    LZero (Month) , '-', LZero (Day)   , '-', Copy (LZero (Year), 3, 2), #32#32);
  END;
END;

PROCEDURE ProcessDesc (VAR TXTfile: TEXT; CONST DescName: STRING);
VAR
  DIZfile: TEXT;
  DIZline: STRING;
  PadLen: BYTE;
  FirstLine: BOOLEAN;
BEGIN
  Assign (DIZFile, DescName);
  Reset (DIZFile); CheckIO;
  Write ('Adding description to output file ... ');

  FirstLine := TRUE;
  DIZline := '';
  PadLen := 0;
  IF NOT EOF (DIZFile) THEN
  REPEAT
    ReadLn (DIZfile, DIZline);
    IF Trim (DIZline) <> '' THEN BEGIN
      WriteLn (TXTfile, RTrim (RPad ('', PadLen) + DIZline));
      IF FirstLine THEN BEGIN
        FirstLine := FALSE;
        PadLen := 33;
      END;
    END;
  UNTIL EoF (DIZfile);
  IF FirstLine THEN WriteLn (TXTfile, 'Description not found');

  WriteLn ('done!');
  Close (DIZFile); CheckIO;
  EraseFile (DescName);
END;

PROCEDURE ProcessFile (CONST FileQuerying, TXTpath: STRING; VAR TXTfile: TEXT; CONST fileinfo: SEARCHREC);
CONST
  DIZfileName = 'FILE_ID.DIZ';
  SDIfileName = 'DESC.SDI';
VAR
  ExCMD,
  iType: STRING;
  iWidth, iHeight: LONGINT;
  iColors, GIFLite: STRING;

BEGIN
  EraseFile (DIZfileName);
  EraseFile (SDIfileName);

  WriteLn ('Processing: ', FileQuerying);
  WriteFileInfo (TXTfile, fileinfo);

  ExCMD := IsArchive (FileQuerying);
  IF (ExCMD <> '') AND
     (ExtractFile (FileQuerying, DIZfileName, ExCMD) OR
      ExtractFile (FileQuerying, SDIfileName, ExCMD))
     THEN BEGIN
       IF IsFile (DIZfileName) THEN ProcessDesc (TXTfile, DIZfileName) ELSE
         IF IsFile (SDIfileName) THEN ProcessDesc (TXTfile, SDIfileName);
     END
     ELSE BEGIN
       iType := IsImage (FileQuerying, iWidth, iHeight, iColors, GIFLite);
       IF (iType <> '') THEN BEGIN
          WriteLn ('Assuming file is a: ', iType);
          Write ('Adding description to output file ... ');
          WriteLn (TXTfile, RPad(iType,6), ' [':2, iWidth:4, iHeight:5, iColors:7, #32#32, GIFLite:6);
          WriteLn ('done!');
       END
       ELSE BEGIN
         WriteLn ('No description available for: ', FileQuerying, '.');
         WriteLn (TXTfile, 'No description available.');
       END;
     END;
  Writeln (Divider);
END;

{===========================================================================}
                          (** Main program **)
{===========================================================================}

CONST
  Hdr = 'Filename       Size      Date    Description of File Contents';
  Bar = '============ ========  ========  =============================================';

VAR
  TXTfile : TEXT;
  fPath,
  TXTPath : PATHSTR;
  fDir,
  TXTDir  : DIRSTR;
  fInfo   : SEARCHREC;

BEGIN
  SavedExitProc := ExitProc;
  ExitProc := @CustomExit;

  WriteLn (progdesc);
  WriteLn (author);
  Writeln (Divider);

  IF ParamCount <> 2 THEN Halt (255);
  InitUnArchivers;
  fPath := GetFilePath (ParamStr (1), fDir);
  FindFirst (fPath, Archive, fInfo);
  IF (DosError <> 0) THEN
    Halt (2);

  TXTPath := GetFilePath (ParamStr (2), TXTDir);
  Assign (TXTfile, TXTpath);
  IF IsFile (TXTpath)
    THEN BEGIN
      Append (TXTfile); CheckIO;
    END
    ELSE BEGIN
      Rewrite (TXTfile); CheckIO;
      WriteLn (TXTfile, Hdr);
      WriteLn (TXTfile, Bar);
    END;

  DosError := 0;
  WHILE (DosError = 0) DO
  BEGIN
    IF fDir+fInfo.Name <> TXTpath THEN
      ProcessFile (fDir+fInfo.Name, TXTpath, TXTfile, fInfo);
    FindNext (fInfo);
  END;
  Close (TXTfile); CheckIO;

  WriteLn ('Mission accomplished!');
END.
