        Appl    "VM for DragonFly", 'vmcd'

code
CodeSegment:
DataRel    equ   0-$7ffe  ;  a5 -           
NAMES      equ   DataRel+0
vTLS       equ   DataRel+4
SYSTRAP_PROC    equ   DataRel+8
vCBPROC    equ   DataRel+16
vCBRSTACK  equ   DataRel+20
SR0        equ   DataRel+24
SS0        equ   DataRel+28
TDP        equ   DataRel+32                      
v4tcd      equ   DataRel+36
MAX_THREADED equ DataRel+40
IMGdbOR    equ   DataRel+44
RES_COMPILE  equ   DataRel+48
IMGdbName  equ   DataRel+52
vAPP       equ   DataRel+64
HTHREADED  equ   DataRel+68
THREADED_SIZE equ DataRel+72
HNAMES      equ   DataRel+76
NAMES_SIZE equ DataRel+80
NDP        equ   DataRel+84
MAX_NAMES  equ DataRel+88
THROW_CFA  equ DataRel+92
SStackLen  equ   4096     ;  
nname      equ   'name'
n4tcd      equ   '4tcd'
nd4th      equ   'd4th'
nappl      equ   'tmpi'

         include "pilot.inc"

proc __Startup__()
local pappi.l
local prevGlobals.l
local globalsPtr.l
beginproc
        systrap SysAppStartup(&pappi(a6), &prevGlobals(a6), &globalsPtr(a6))
        tst.w   d0
        beq.s   _SU1

        systrap SndPlaySystemSound(#sndError.b)
        moveq   #-1,d0
        bra    _SUExit

_SU1:
        movea.l pappi(a6),a0
        tst.w   SysAppInfoType.cmd(a0) ;sysAppLaunchCmdNormalLaunch is 0
        beq.s   PmContinue

;  launch code <> 0
        movem.l d2-d7/a1-a6,-(a7)
        ;   
        systrap MemPtrNew(#SStackLen.l)
        move.l  a0, -(a7)
        lea     SStackLen-12(a0), a2 ; 12   -  DEPTH=0
        move.l  pappi(a6), a0
        move.l  a0, -(a2)
        move.l  prevGlobals(a6), a0
        move.l  a0, -(a2)
        move.l  globalsPtr(a6), a0
        move.l  a0, -(a2)
        movea.l pappi(a6),a0
        clr.l   d7
        move.w  SysAppInfoType.cmd(a0), d7
        bsr     Get4tcdRes
        move.l  a0, -(a7)
        systrap MemHandleLock(a0.l)
        move.l  a0, a6
        move.l  #2, a3
        bra     _NEXT
PmContinue:
        ; !
        
        movem.l d2-d7/a1-a6,-(a7)

;    

        clr.l   SS0(a5)
        move.l  a6,a4 ;  a6,    
        move.l  #0,a6
        clr.l   NAMES(a5)
        clr.l   HNAMES(a5)
        clr.l   HTHREADED(a5)
        
;   ,   

        systrap DmFindDatabase(#0.w,&IMGdbName(a5).l)
        tst.l   d0
        beq.s   _SU2
        systrap DmDeleteDatabase(#0.w,d0.l)
        tst.w   d0
        bne     _SUExit

;  

_SU2:
        systrap MemPtrNew(#SStackLen.l)
        lea     SStackLen-12(a0), a0 ; 12   -  DEPTH=0
        move.l  a0, a2               ; .. d7     
        move.l  a2, d0
        sub.l   a5, d0
        move.l  d0, SS0(a5)   
        
        move.l  pappi(a4), a0

        move.l  a0, -(a2)

        move.l  prevGlobals(a4), a0
        move.l  a0, -(a2)
                  
        move.l  globalsPtr(a4), d7

        ; 
        move.l  a7, d0
        sub.l   a5, d0
        move.l  d0, SR0(a5)

        tst.l   vAPP(a5)
        bne     _SU5
 
;   

_SU3:
        bsr     Get4tcdRes
        move.l  a0,HTHREADED(a5) ;    
        bsr     GetNameRes
        move.l  a0,HNAMES(a5) ;    
        systrap DmCreateDatabase(#0.w,&IMGdbName(a5),#nd4th.l,#nappl.l,#$FF.b)
        systrap DmFindDatabase(#0.w,&IMGdbName(a5).l)
        systrap DmOpenDatabase(#0.w,d0.l,#3.w)
        move.l  a0,IMGdbOR(a5)

        move.l  HTHREADED(a5),a3
        systrap DmNewResource(IMGdbOR(a5).l,#n4tcd.l,#1001,TDP(a5).l)
        move.l  a0,HTHREADED(a5)
        systrap MemHandleLock(a0.l)
        move.l  a0,a6
        systrap MemHandleLock(a3.l)
        systrap DmWrite(a6.l,#0.l,a0.l,TDP(a5).l)
        systrap MemHandleUnlock(a3.l)
        move.l  TDP(a5),THREADED_SIZE(a5)

        move.l  HNAMES(a5),a3
        systrap DmNewResource(IMGdbOR(a5).l,#nname.l,#1001,NDP(a5).l)
        move.l  a0,HNAMES(a5)
        systrap MemHandleLock(a0.l)
        move.l  a0,a4
        move.l  a0,d0
        sub.l   a5,d0
        move.l  d0,NAMES(a5)
        systrap MemHandleLock(a3.l)
        systrap DmWrite(a4.l,#0.l,a0.l,NDP(a5).l)
        systrap MemHandleUnlock(a3.l)
        move.l  NDP(a5),NAMES_SIZE(a5)

        bra     _SU4

;  

_SU5:
        bsr     Get4tcdRes
        move.l  a0,HTHREADED(a5)
        systrap MemHandleLock(a0.l)
        move.l  a0,a6
        ;  name    ,  , 
        bsr     GetNameRes
        move.l  a0,HNAMES(a5)
        move.l  a0, d0
        tst.l   d0
        beq.s   _SU6
        systrap MemHandleLock(a0.l)
        move.l  a0,d0
        sub.l   a5,d0
        move.l  d0,NAMES(a5)
        bra     _SU4

_SU6:
        move.l  a0,NAMES(a5)

_SU4:
        move.l  a6,v4tcd(a5)

        clr.l   d0
        move.l  d0, a3    ; pointer to cfa MAIN
        ;  callback 
        lea.l   _CBSTUB(pc), a0 
        move.l  a0, vCBPROC(a5)
        move.l  a5, vCBRSTACK(a5)

        bra     _NEXT
        ;    

PmReturn1:
        move.l  d7, d0
        movem.l (a7)+, d2-d7/a1-a6
        move.l  d0, -(a7)
PmReturn:
        systrap SysAppExit(pappi(a6).l, prevGlobals(a6).l, globalsPtr(a6).l)
        move.l (a7)+, d0

_SUExit:
endproc

Get4tcdRes:
        systrap DmGetResource(#n4tcd.l, #1000)
        rts

GetNameRes:
        systrap DmGetResource(#nname.l, #1000)
        rts


MOVE: ; (a3 -> a0):d3
        subq.l  #1,d3
_move1:
        move.b  (a3)+, (a0)+
        dbra    d3,_move1
        rts

         include "forth\ai.asm"
         include "forth\stack.asm"
         include "forth\os_forth.asm"
         include "forth\lit.asm"
         include "forth\does.asm"
         include "forth\mem.asm"
         include "forth\arithm.asm"
         include "forth\string.asm"
         include "forth\divmul.asm"
         include "forth\logic.asm"
         include "forth\rstack.asm"
         include "forth\apicall.asm"
         include "forth\immed_loop.asm"
         include "forth\wordlist.asm"
         include "forth\reg.asm"
        
        
        data
        