        code
_plus:
        add.l   (a2)+,d7
        bra     _NEXT

_minus:
        move.l  d7,d1
        move.l  (a2)+,d7
        sub.l   d1,d7
        bra     _NEXT

_min:
        move.l  (a2)+,d1
        cmp.l   d1,d7
        ble     _NEXT
        move.l  d1,d7
        bra     _NEXT

_max:
        move.l  (a2)+,d1
        cmp.l   d1,d7
        bge     _NEXT
        move.l  d1,d7
        bra     _NEXT


_oneplus:
        addq.l  #1,d7
        bra     _NEXT

_twoplus:
        addq.l  #2,d7
        bra     _NEXT

_oneminus:
        subq.l  #1,d7
        bra     _NEXT

_twominus:
        subq.l  #2,d7
        bra     _NEXT

_twomul:
        add.l   d7, d7
        bra     _NEXT

_twoDiv: 
        asr.l  #1, d7
        bra    _NEXT

_CELLplus:
        addq.l  #4,d7
        bra     _NEXT

_CELLminus:
        subq.l  #4,d7
        bra     _NEXT

_oneplusstore:
        move.l  d7,a0
        addq.l  #1,(a5,a0.l)
        move.l  (a2)+,d7
        bra     _NEXT

_zerostore:
        move.l  d7,a0
        move.l  #0,(a5,a0.l)
        move.l  (a2)+,d7
        bra     _NEXT

       
_negate:
        neg.l   d7
        bra     _NEXT

_cells:
        lsl.l  #2, d7
        bra    _NEXT

ret_true:
        move.l  #-1,d7
        bra     _NEXT

_lt:
        cmp.l   (a2)+,d7
        bgt.s   ret_true
        clr.l   d7
        bra     _NEXT

_gt:
        cmp.l   (a2)+,d7
        blt.s   ret_true
        clr.l   d7
        bra     _NEXT

_zerolt:
        tst.l   d7
        bmi     ret_true
        clr.l   d7
        bra     _NEXT

_zerogt:
        tst.l   d7
        bgt     ret_true
        clr.l   d7
        bra     _NEXT

_zerone:
        or.l    d7, d7
        bne.s   ret_true
        clr.l   d7
        bra     _NEXT

_zeroeq:
        or.l    d7, d7
        beq.s   ret_true
        clr.l   d7
        bra     _NEXT

_eq:
        cmp.l   (a2)+,d7
        beq.s   ret_true
        clr.l   d7
        bra     _NEXT
        
_ne:
        cmp.l   (a2)+,d7
        bne.s   ret_true
        clr.l   d7
        bra     _NEXT

_Ult:   
        cmp.l   (a2)+,d7
        bhi.s   ret_true
        clr.l   d7
        bra     _NEXT

_Ugt:   
        cmp.l   (a2)+,d7
        beq.s   ugt1
        bls.s   ret_true
ugt1:
        clr.l   d7
        bra     _NEXT

_abs:    
        or.l   d7, d7
        bpl.s  abs1
        neg.l  d7
abs1:   bra    _NEXT


_Dplus: ; ( d1 d2 -- d3 )
        ;   
        ;    + 
        move.l  (a2)+, d1 ; ld2
        move.l  (a2)+, d2 ; hd1
        clr.l   d3
        add.l   d1, (a2)
        bcc.s   dplus1
        addq.l  #1, d3
dplus1: add.l   d2, d7
        add.l   d3, d7
        bra     _NEXT

_DNEGATE:
        neg.l   d7
        neg.l   (a2)
        bcc.s   dneg1
        subq.l  #1, d7
dneg1:
        bra     _NEXT

_WgtS:  
        ext.l   d7
        bra     _NEXT

_wmul:  
        move.l (a2)+, d0
        muls   d0, d7
        bra     _NEXT

_wdiv:  
        move.l (a2)+, d0
        divs   d7, d0
        move.l d0, d7
        ext.l  d7
        bra    _NEXT