\ Target compiler for Dragon Fly project
\ 14.Feb.2001 ~day

\   colon  ORDER  :
\ Context: THREADED
\ Current: FORTH
\  :
\ Context: TC FORTH

0 maxData - CONSTANT DataRel \     a5

: D-HERE data#0 D-DP @ + ;

31 CONSTANT &NAME \     

VARIABLE TC-USER-OFFS

: TC-USER-OFFS@ TC-USER-OFFS @ ;

0 VALUE EXIT-CODE
0 VALUE BRANCH-CODE
0 VALUE LIT-CODE
0 VALUE LITW-CODE
0 VALUE ?BRANCH-CODE
0 VALUE SLIT-CODE
0 VALUE DO-CODE
0 VALUE LOOP-CODE
0 VALUE ?DO-CODE
0 VALUE +LOOP-CODE
0 VALUE TO-CODE
0 VALUE COMPILE-CFA
0 VALUE ENDCB-CODE

0 VALUE DOES1-CFA \ cfa  DF
0 VALUE TOUSER-CODE

: >abs
   4tcd +
;

: >rel
   4tcd -
;

: TC-W@
   >abs pW@
;
: TC-W!
   >abs pW!
;
: TC-ALIGN
   D-DP @ ALIGNED
   D-DP !
;

: name>rel
   nameRes -
;
: name>abs
   nameRes +
;

: data>rel
   maxData + data#0 -
;
: data>abs
   maxData + data#0 +
;

: FETCH-NAME ( addr -- addr1 u )
\   
   4 + name>abs COUNT &NAME AND
;

VARIABLE tmpLast

: PALM-FIND ( addr u -- xt -1 | xt 1 | addr u 0 )
   2>R TC-LAST @
   BEGIN
     DUP FETCH-NAME
     2R@ COMPARE 0=
     IF 2R> 2DROP 2+ name>abs
        DUP 2+ C@ 0x80 AND
        IF 1 ELSE -1 THEN
        SWAP pW@ SWAP EXIT 
     THEN
     name>abs pW@ DUP 0= \   
   UNTIL DROP 2R> 0
;

: LAST-CFA
    TC-LAST @ 
    name>abs 2+
    pW@
;

0
CELL -- .is
CELL -- .over
CELL -- .swap
CELL -- .tuck
CELL -- .dup>r
CELL -- .dup
CELL -- .>r
CELL -- .@>r
CELL -- .fetch
VALUE /opt-words

CREATE opt-words HERE /opt-words ALLOT /opt-words 0 FILL

: FillOptWords
    opt-words .is @ 0=
    IF
       S" OVER" PALM-FIND DROP opt-words .over !
       S" SWAP" PALM-FIND DROP opt-words .swap !       
       S" TUCK" PALM-FIND DROP opt-words .tuck !       
       S" DUP"  PALM-FIND DROP opt-words .dup !
       S" >R"   PALM-FIND DROP opt-words .>r !
       S" DUP>R" PALM-FIND DROP opt-words .dup>r !
       S" @>R" PALM-FIND DROP opt-words .@>r !       
       S" @" PALM-FIND DROP opt-words .fetch !
        -1 opt-words .is !
    THEN
;

: OptimizeCode
   opt-words .is @ 0= IF EXIT THEN
   
   \   LIT
   HERE 6 - pW@ 
   LITW-CODE = IF EXIT THEN
   HERE 8 - pW@ 
   LIT-CODE = IF EXIT THEN

   \    HEADER
   TC-LAST @ HERE >rel 6 - >
   IF EXIT THEN
   
   HERE 2- pW@
   opt-words .over @ = 
   IF
   \ swap over -> tuck   
      HERE 4 - pW@
      opt-words .swap @  = 
      IF 
         -2 ALLOT
         opt-words .tuck @ HERE 2- pW!
      THEN
   THEN

   HERE 2- pW@
   opt-words .>r @ =
   IF
     \ dup >r -> dup>r
     HERE 4 - pW@
     opt-words .dup @ =
     IF
        -2 ALLOT
        opt-words .dup>r @ HERE 2- pW!
     ELSE
        HERE 4 - pW@
        opt-words .fetch @ =
        IF
 \          -2 ALLOT
 \          opt-words .@>r @ HERE 2- pW!
        THEN
     THEN          
   THEN   
;

: C-W,
   HERE 2 MOD ABORT" Wrong code alignment!"
   HERE pW!
   2 ALLOT
\   OptimizeCode
;

: TC,
   HERE 2 MOD ABORT" Wrong code alignment!"
   HERE p!
   4 ALLOT
;

: D-W,
   D-DP @ 2 MOD ABORT" Wrong data alignment!" 
   D-HERE pW!
   2 D-DP +!
;

: TD,
   D-DP @ 2 MOD ABORT" Wrong data alignment!" 
   D-HERE p!
   4 D-DP +!
;

: TC-COMPILE, ( xt -- )
   C-W,
;

: SHORT? ( n -- f )
  ABS 0x8000 U<
;

: TC-LIT,
  DUP SHORT? 
  IF    LITW-CODE TC-COMPILE, C-W, 
  ELSE  LIT-CODE TC-COMPILE, TC,
  THEN
;

: TC-DLIT,
  SWAP TC-LIT, TC-LIT,
;

: MAKE-FORTH-WL
   TC-LAST @ \ LFA  
   S" FORTH-WORDLIST"
   PALM-FIND IF 2+ >abs pW@ W>S \   data
                data>abs p@
                data>abs p! \  last nfa
             ELSE -1 ABORT" Can't find FORTH-WORDLIST"
             THEN
;

: TC-HEADER ( "name" )
   HERE
   nameResLen @ 
   TC-LAST @ nameResW,      \ LFA
   TC-LAST !
   >rel nameResW,           \ pCFA
   NextWord DUP nameResC,   \ length
   nameResHERE
   OVER nameResLen +!
   SWAP MOVE 0 nameResC,    \ body
   nameResLen @ ALIGNED
   nameResLen !
   WordsCount 1+!

\   TC-LAST @ nameResLen @  OVER -  
\   SWAP name>abs 2+ (  lfa )
\   SWAP 2-  AddSortName
;

VARIABLE ParamsCount
VARIABLE firstParam?

: CompileApiCode ( u w )
   ParamsCount 0! -1 firstParam? !
   2DUP 12 RSHIFT 0
   ?DO
     firstParam? @ 0= 
     IF
     0x201A C-W, \ move.l (a2)+, d0
     ." move.l (a2)+, d0" CR
     THEN
     DUP 3 AND DUP 
     2 = IF DROP 
            firstParam? @
            IF
              0x2F07 C-W,
              ." move.l d7, -(a7)" CR
            ELSE
              0x2F00 C-W, \ move.l d0, -(a7)
              ." move.l d0, -(a7)" CR
            THEN
            4 ParamsCount +!
         ELSE 1 = IF 
                   firstParam? @
                   IF
                     0x3F07 C-W,
                     ." move.w d7, -(a7)" CR
                   ELSE    0x3F00 C-W, \ move.w d0, -(a7)
                           ." move.w d0, -(a7)" CR
                   THEN
                  ELSE 
                   firstParam? @
                   IF 0x1F07 C-W,
                      ." move.b d7, -(a7)" CR
                   ELSE
                     0x1F00 C-W, \ move.b d0, -(a7)
                     ." move.b d0, -(a7)" CR
                   THEN
                  THEN
                  2 ParamsCount +!
         THEN
     2 RSHIFT firstParam? 0!
   LOOP DROP
   OVER 30 RSHIFT 1 = IF 0x4280 C-W, ." clr.l d0" CR THEN
   0xFFF AND 0xA000 OR
   0x4E4F C-W, C-W, \ systrap ...
   ." systrap..." CR
   ParamsCount @
   IF
     0x4FEF C-W, ParamsCount @ C-W, \ lea.l N(a7), a7
     ." lea.l " ParamsCount @ . ." (a7), a7" CR
   THEN
   30 RSHIFT DUP
   0= IF DROP 
         firstParam? @ 0=
         IF
            0x2E1A C-W, \ void
           ." move.l (a2)+, d7" CR
         THEN
      ELSE 1 =
         IF  
            firstParam? @ 
            IF 0x2507 C-W, ." move.l d7, -(a2)" CR THEN 
            0x2E00 C-W, \ d0
            ." move.l  d0, d7" CR
         ELSE 
            firstParam? @ 
            IF 0x2507 C-W, ." move.l d7, -(a2)" CR THEN 
         0x2E08 C-W, \ a0
         ." move.l a0, d7" CR
         THEN
      THEN
   0x4E75 C-W, \ rts
   ." rts" CR CR
;

VARIABLE &SMUDGE
12 &SMUDGE !

: TC-SMUDGE
   &SMUDGE @
   TC-LAST @
   name>abs 5 + DUP C@ &SMUDGE !
   C!
;

: TC-HIDE
   12 &SMUDGE !
   TC-SMUDGE
;

: ID ( "type" -- u )
   SkipDelimiters
   [CHAR] ' SKIP
   [CHAR] ' PARSE
   4 <> ABORT" Wrond DmResType"
   >R 0
   R@ C@ OR 8 LSHIFT
   R@ 1+ C@ OR 8 LSHIFT
   R@ 2+ C@ OR 8 LSHIFT
   R> 3 + C@ OR
;

VOCABULARY THREADED
VOCABULARY TC

: [T] ONLY THREADED  ;

: [I] ONLY FORTH ALSO TC ;


MODULE: TC

: build_num,
    S" version.df" INCLUDED 1+ TC-LIT,
\    0 <# [CHAR] " HOLD # # # # BL HOLD [CHAR] " HOLD [CHAR] S HOLD #>
\    -1 STATE ! [T]
\    EVALUATE
\    0 STATE ! [I]
; IMMEDIATE

: (TO) ( u "name" -- )
   NextWord PALM-FIND
   0= IF 2DROP -123 THROW 
      ELSE 2+ >abs pW@ W>S \   data
           data>abs p!
      THEN
;

: PRIM ( n "name" -- )
    >IN @ NextWord S" primitive " TYPE TYPE
    >IN ! BL EMIT HERE >rel . CR
    TC-HEADER
    TC-COMPILE,
;

: CONSTANT
    DUP SHORT?
    IF  _WCONST_DOES PRIM C-W,
    ELSE _CONST_DOES PRIM TC,
    THEN
;

: VARIABLE
    TC-HEADER
    _CREATE_DOES TC-COMPILE,
    DataRel D-DP @ + \  PalmOS - a5    data
    C-W, 0 TD,
;

: USER-VALUE
    _USER_VALUE_DOES PRIM
    TC-USER-OFFS @ C-W,
    CELL TC-USER-OFFS +!
;

: USER-CREATE
    _USER_DOES PRIM
    TC-USER-OFFS @ C-W,
;

: USER-ALLOT
    TC-USER-OFFS +!
;

: USER
    USER-CREATE
    CELL USER-ALLOT
;

CONTEXT @ PREVIOUS

: ] ] [T] ;

: '
   NextWord PALM-FIND
   0= IF 2DROP -123 THROW THEN
;

: API: ( "name" -- )
    >IN @ NextWord  2DUP TYPE CR
    SEARCH-API
    IF
     ROT >IN !
     TC-HEADER
     _ASM_DOES TC-COMPILE,
     CompileApiCode
    ELSE
     -2003 THROW
    THEN
;

: VECT
    TC-HEADER
    _VECT_DOES TC-COMPILE,
    DataRel D-DP @ + 
    C-W, S" NOOP" PALM-FIND 0= ABORT" Can't find NOOP"
    TD,
;

: ->VARIABLE ( u -- )
    TC-HEADER
    _CREATE_DOES TC-COMPILE,
    DataRel D-DP @ + \  PalmOS - a5    data
    C-W, TD,
;

: VALUE ( n "name" -- )
    TC-HEADER
    _VALUE_DOES TC-COMPILE,
    DataRel D-DP @ + \  PalmOS - a5    data
    C-W, TD,
;

: CREATE
    TC-HEADER
    _CREATE_DOES TC-COMPILE,
    DataRel D-DP @ + 
    C-W,
;

: ALLOT
    D-DP +!
    TC-ALIGN
;

: HERE
   D-DP @ DataRel +
;
: C,
\  !
   D-HERE C!
   D-DP 1+!
;
: ALIGN
   TC-ALIGN
;

: W,  D-W, ;
: ,   TD,  ;
: W@  data>abs pW@  ;
: W!  data>abs pW!  ;
: !   data>abs p!   ;
: @   data>abs p@   ;

: :NONAME ( -- addr )
   [T] HERE >rel
   TC-LAST @
   name>abs 5 + C@ &SMUDGE !
   TC-SMUDGE
   _ENTER TC-COMPILE,
   ]
;

: CALLBACK: ( xt -- )
   TC-HEADER
   _CALLBACK TC-COMPILE,
   \   inline asm     ai
\   0x4E48 C-W, \ trap #8
   \ 
   DataRel D-DP @ + C-W,

   0x203C D-W, HERE >rel TD,  \ move.l  #xxx, d0
   0x206D D-W, 0x8012 D-W,    \ move.l  vCBPROC(a5), a0
   0x4ED0 D-W,                \ jmp     (a0)

   \    

\   0x4280 D-W, \ clr.l d0
\   0x4E75 D-W, \ rts


   TC-COMPILE,
   ENDCB-CODE TC-COMPILE,
;

: IMMEDIATE
   TC-LAST @
   name>abs 4 + DUP C@
   0x80 OR SWAP C!
;

: :: : ;

: : 
   [T]
   TC-HEADER 
   _ENTER TC-COMPILE, \ cfa
   TC-HIDE ]
;

ALSO CONTEXT !
;MODULE

: TC-<MARK ( -- addr )
    HERE >rel
;

: TC-<RESOLVE ( addr -- )
    C-W,
;

: TC->MARK ( -- addr )
    HERE 2 ALLOT
;

: TC->RESOLVE ( addr -- )
    HERE >rel SWAP  pW!    
;

: ?PAIRS ( n1 n2 -- )
    <> ABORT" Branch statement not paired!"
;

MODULE: THREADED

: ( POSTPONE ( ; IMMEDIATE
: \ POSTPONE \ ; IMMEDIATE
: [ POSTPONE [ [I] ; IMMEDIATE
: RECURSE LAST-CFA  TC-COMPILE, ; IMMEDIATE

: BEGIN ( -- dest )
   ?COMP
   TC-<MARK 2
; IMMEDIATE

: AGAIN ( dest -- )
   ?COMP 2 ?PAIRS
   BRANCH-CODE TC-COMPILE,
   TC-<RESOLVE
; IMMEDIATE

: UNTIL
   ?COMP 2 ?PAIRS
   ?BRANCH-CODE TC-COMPILE,
   TC-<RESOLVE
; IMMEDIATE

: S"
\  !
\     data
  SLIT-CODE TC-COMPILE,
  D-DP @ DataRel + C-W,
  [CHAR] " PARSE
  DUP C-W,
  D-HERE OVER D-DP +!
  SWAP MOVE
  0 D-HERE  C!
  D-DP 1+!
  TC-ALIGN
; IMMEDIATE

: [']
   ?COMP
   NextWord PALM-FIND
   IF TC-LIT,
   ELSE -2003 THROW
   THEN
; IMMEDIATE

: LITERAL
   STATE @ IF TC-LIT, THEN
; IMMEDIATE

: ;
   TC-SMUDGE
   EXIT-CODE TC-COMPILE,
   POSTPONE [
   [I]
; IMMEDIATE

CONTEXT @ PREVIOUS

: POSTPONE
   ?COMP
   NextWord PALM-FIND DUP
   1 = IF \ immediate
           DROP TC-COMPILE,
        ELSE
        0= IF -2003 THROW THEN
           TC-LIT,
           COMPILE-CFA
           TC-COMPILE,
        THEN
; IMMEDIATE

: [COMPILE] ( "name" -- )
    NextWord
    PALM-FIND 
    IF TC-COMPILE,
    ELSE -2003 THROW
    THEN
; IMMEDIATE

: [ID]
    ID TC-LIT,
; IMMEDIATE

: TO
    NextWord
    PALM-FIND
    IF
      >abs DUP pW@
      _USER_VALUE_DOES = IF TOUSER-CODE 
                         ELSE TO-CODE
                         THEN
      TC-COMPILE,
      2+ pW@ C-W,
    ELSE
      -2003 THROW
    THEN
; IMMEDIATE


: DO
   DO-CODE TC-COMPILE,
   TC->MARK
   TC-<MARK 4
; IMMEDIATE

: LOOP
   4 ?PAIRS
   LOOP-CODE TC-COMPILE,
   TC-<RESOLVE
   TC->RESOLVE
; IMMEDIATE

: +LOOP
   4 ?PAIRS
   +LOOP-CODE TC-COMPILE,
   TC-<RESOLVE
   TC->RESOLVE
; IMMEDIATE

: ?DO
   ?DO-CODE TC-COMPILE,
   TC->MARK
   TC-<MARK 4
; IMMEDIATE

: IF ( ---> A,1 )  ?BRANCH-CODE TC-COMPILE, TC->MARK  1 ;  IMMEDIATE

: THEN ( A,1 ---> )  1  ?PAIRS  TC->RESOLVE ;  IMMEDIATE

: ELSE ( A1,1 ---> A2,1 )  1  ?PAIRS BRANCH-CODE TC-COMPILE,
                   TC->MARK  SWAP  TC->RESOLVE  1 ;  IMMEDIATE

: WHILE ( C: dest -- orig dest )
  ?COMP
  ?BRANCH-CODE TC-COMPILE, TC->MARK 3
  2SWAP
; IMMEDIATE

: REPEAT ( C: orig dest -- )
  ?COMP
  2 ?PAIRS
  BRANCH-CODE TC-COMPILE,
  TC-<RESOLVE
  3 ?PAIRS
  TC->RESOLVE
; IMMEDIATE

: [CHAR]
   NextWord DROP C@ TC-LIT,
; IMMEDIATE

: NOTFOUND ( addr u -- )
\    DragonFly
\     !
  ?COMP
  SFIND
  IF EXECUTE
  ELSE 
    PALM-FIND
    IF TC-COMPILE, 
    ELSE
       OVER C@ BASE @ DIGIT
       IF DROP
       ELSE DUP 1 = IF 2DROP -2003 THROW THEN
       THEN
       POSTPONE [
       2DUP + 1- C@ [CHAR] . = >R \ double?
       ['] ?SLITERAL CATCH
       IF 2DROP -2003 THROW
       ELSE R@ IF TC-DLIT, ELSE TC-LIT, THEN
       THEN RDROP
       ]
    THEN
  THEN
;

ALSO CONTEXT !
;MODULE

\ 2 ALIGN-BYTES !
\ ALIGN
\ HERE TO 4tcd  
\ 2 ALLOT  \   cfa startup 
\ 2 ALLOT  \    launch codes <>  normalLaunch
\ 2 ALLOT  \   (POOR_EXIT)
\ ALSO TC
\ 0 nameResW, \  PALM-FIND    
\ ( ! )
\ (  HERE, C, W, @ ! ...  Dragon!)