REQUIRE { ~ac\lib\locals.f

WINAPI: _ftime   MSVCRT.DLL
WINAPI: ctime    MSVCRT.DLL
WINAPI: GetTickCount KERNEL32.DLL
\ WINAPI: ntohl    WSOCK32.DLL
\ WINAPI: ntohs    WSOCK32.DLL

 0 \ header of prc
32 -- name
 2 -- attributes
 2 -- version
 4 -- creationDate
 4 -- modificationDate
 4 -- lastBackupDate
 4 -- modificationNumber
 4 -- appInfoID
 4 -- sortInfoID
 4 -- type
 4 -- creator
 4 -- uniqueIDSeed

 4 -- nextRecordListID
 2 -- numRecords
CONSTANT /PRC-HEAD

0
 4 -- resType
 2 -- resID
 4 -- resOffset
CONSTANT /RES-HEAD

: S.R ( addr u n -- )
\   addr u    n
  2DUP 1+ > 
  IF DROP TYPE 
  ELSE OVER - SPACES TYPE 
  THEN
;

0
CELL -- time
   2 -- millitm
   2 -- timezone
   2 -- dstflag
CONSTANT /_timeb

\        - ,  
\       
\    - , ...


2082844800 CONSTANT PTConst

: DATE. { u \ [ /_timeb ] tm -- }
   u 0= IF 0 . EXIT THEN
   tm _ftime 2DROP
   u PTConst - tm time !
   tm ctime NIP 
   ?DUP IF ASCIIZ> 1- TYPE
        ELSE ." Wrong format!"
        THEN
;

: CurrDate { \ [ /_timeb ] tm -- }
    tm _ftime 2DROP
    tm time @ PTConst +
;

20 CONSTANT salign

: PRC-INFO { \ [ /PRC-HEAD ] ph [ /RES-HEAD ] rh file -- }
   R/O OPEN-FILE THROW TO file
   ph /PRC-HEAD file READ-FILE THROW DROP
   S" name: " salign S.R ph 32 TYPE CR
   S" attributes: " salign S.R ph attributes pW@ U. CR
   S" version: " salign S.R ph version pW@ U. CR 
   S" creationDate: " salign S.R ph creationDate p@ DATE. CR
   S" modificationDate: " salign S.R ph modificationDate p@ DATE. CR
   S" lastBackupDate: " salign S.R ph lastBackupDate p@ DATE. CR 
   S" modificationNumber: " salign S.R ph modificationNumber p@ U. CR
   S" appInfoID: " salign S.R ph appInfoID p@ U. CR
   S" sortInfoID: " salign S.R ph sortInfoID p@ U. CR
   S" type: " salign S.R ph type 4 TYPE CR
   S" creator: " salign S.R ph creator 4 TYPE CR
   S" uniqueIDSeed: " salign S.R ph uniqueIDSeed p@ U. CR

   S" recordList: " salign S.R ph nextRecordListID p@ U. CR
   S" numRecords: " salign S.R ph numRecords pW@ DUP U. CR
   0 ?DO
     rh /RES-HEAD file READ-FILE THROW DROP
     S" resType: "    salign S.R rh resType 4 TYPE CR
     S" resID: "      salign S.R rh resID pW@ U. CR
     S" resOffset: "  salign S.R rh resOffset p@ U. CR
   LOOP
   file CLOSE-FILE THROW
;

: D:
   BASE @ HEX
   8 0
   DO
     NextWord EVALUATE C,
   LOOP BASE !
;

CREATE code#0 \ code #0 ,   PalmOS,   
              \   4  CELL -   
HERE              
D: 00 00 00 30 00 00 00 00
D: 00 00 00 08 00 00 00 20
D: 00 00 3F 3C 00 01 A9 F0
HERE SWAP - CONSTANT CODE0_LEN

VARIABLE TC-LAST  \    
                  \   name

VARIABLE D-DP
0x7FFF 1- CONSTANT maxData \   ,  -
                           \ PalmOS      

CREATE data#0 maxData HERE OVER ALLOT SWAP ERASE
0 VALUE 4tcd \   

CREATE nameRes maxData HERE OVER ALLOT SWAP ERASE
\  : LFA+NFA
VARIABLE nameResLen
VARIABLE WordsCount

(
  data#0 \  prc,    html \
 4 -   12  \  Code 1 xrefs
 4 -   = \0    \
 n -   ,  
 2   \hex\: 00 00 00 28 00 \  data 
 24   \ Data 0 xrefs + Code 1 xrefs
)

: ExtractCode#1 ( addr u -- addr1 u1 )
{ \ [ /PRC-HEAD ] ph [ /RES-HEAD ] rh file }
\ addr u -  
\ addr1 u1 -   code#1
\    VM
  R/O OPEN-FILE THROW TO file
  ph /PRC-HEAD file READ-FILE THROW DROP
  ph numRecords pW@ 0
  DO
     rh /RES-HEAD file READ-FILE THROW DROP
     rh resType 4 S" code" COMPARE 0=
     IF
        rh resID pW@ 1 =
        IF  \   
          rh resOffset p@
          rh /RES-HEAD file READ-FILE THROW DROP
          rh resOffset p@ OVER -
          SWAP 0 file REPOSITION-FILE THROW
          DUP ALLOCATE THROW DUP >R OVER >R
          SWAP file READ-FILE THROW DROP
          R> R> SWAP
          file CLOSE-FILE THROW
          UNLOOP EXIT
        THEN
     THEN
  LOOP file CLOSE-FILE THROW
  TRUE ABORT" No code#1"
;

: SAVE-4TCD ( addr u -- )
   W/O CREATE-FILE THROW >R
   4tcd DUP HERE SWAP - R@
   WRITE-FILE THROW
   R> CLOSE-FILE THROW
;

VARIABLE DF-VERSION
VARIABLE DF-BUILD
CREATE CREATOR-ID C" d4th" ",
VARIABLE @numRecords
VARIABLE countRecords
VARIABLE @prc


CREATE RES-HEADERS 1024 ALLOT
VARIABLE ResHere
RES-HEADERS ResHere !
VARIABLE refs
VARIABLE segRefs

: ItemsLen
   ResHere @ RES-HEADERS -
;
: ResolveRefs
   segRefs
   BEGIN
     @ ?DUP
   WHILE
     DUP 2 CELLS + @ >R \  ID
     refs
     BEGIN
       @ DUP 2 CELLS + @ R@ =
     UNTIL RDROP  \ segRef ref
     OVER CELL+ @ @prc @ -
     ItemsLen + \    prc
     OVER CELL+ @ p!
     2 CELLS + -1 SWAP ! \    ID
   REPEAT
;

: AddRef ( addr id )
   12 ALLOCATE THROW >R
   R@ CELL+ CELL+ !
   R@ CELL+ !
   refs @ R@ !
   R> refs !
;

: AddSegRef ( addr id -- )
   12 ALLOCATE THROW >R
   R@ CELL+ CELL+ !
   R@ CELL+ !
   segRefs @ R@ !
   R> segRefs !
;

: ResHead, ( addr u id )
   >R 4 MIN
   ResHere @ SWAP MOVE
   4 ResHere +!
   R@ ResHere @ pW!
   2 ResHere +!
   ResHere @ R> AddRef
   4 ResHere +!
;

: AddRes ( addr u addrType uType id )
   DUP >R ResHead,
   HERE R> AddSegRef
   HERE OVER ALLOT
   SWAP MOVE
\   HERE 1- C@ 0<> IF 0 C, THEN
;

: FileRes ( addr u addrType uType id )
  { addrType uType id \ file mem size }
  R/O OPEN-FILE THROW TO file
  file FILE-SIZE THROW DROP TO size
  size ALLOCATE THROW TO mem
  mem size file READ-FILE THROW DROP
  mem size addrType uType id AddRes
  mem FREE THROW
  file CLOSE-FILE THROW
;

: GEN-CODE0
   HERE
   code#0 CODE0_LEN S" code" 0
   AddRes
   maxData SWAP CELL+ p!
;

: GEN-CODE1
   S" ..\vm\vm.prc" ExtractCode#1
   S" code" 1 AddRes
;

: GEN-NAMES
   nameRes nameResLen @
   S" name" 1000 AddRes
;

: GEN-TVER
   DF-BUILD @ 0
   <# # # # # 2DROP 
      [CHAR] . HOLD  
      DF-VERSION @ 0 # #> 1+
   S" tver" 1000 AddRes
;

: GEN-ICON ( addr u )
\ 22x22
  S" tAIB" 1000 FileRes
;

: GEN-SMALLICON
\ 15x9
  S" tAIB" 1001 FileRes
;

: GEN-DATA0 { \ mem size }
   0xFFFF DUP ALLOCATE THROW TO mem
   mem SWAP ERASE
   data#0 mem 2 CELLS + D-DP @
   CompressRle 2 CELLS + TO size
   0x28000000 mem size + !
   0x28000000 mem size + CELL+ 1+ !
   34 AT size +!
   size 12 - mem p!
   0 maxData - mem CELL+ p!
   mem size S" data" 0
   AddRes
;

: GEN-THREADED
   4tcd @prc @ OVER - \ prc    4tcd
   S" 4tcd" 1000 AddRes
;

: GEN-HEADER ( addr u )
\   PRC  HERE
   31 MIN HERE /PRC-HEAD 
   DUP ALLOT OVER SWAP ERASE
   DUP >R
   SWAP MOVE
   1 R@ attributes pW!
   DF-VERSION @ R@ version pW!
   CurrDate DUP R@ creationDate p!
   R@ modificationDate p!
   S" appl" R@ type SWAP MOVE
   CREATOR-ID COUNT R@ creator SWAP MOVE
   GetTickCount R> uniqueIDSeed p!
;

: (SAVE-PRC)  ( addr u )
  W/O CREATE-FILE THROW >R
  @prc @ /PRC-HEAD R@ WRITE-FILE THROW
  RES-HEADERS ResHere @ OVER - R@ WRITE-FILE THROW
  @prc @ /PRC-HEAD + HERE OVER - R@ WRITE-FILE THROW
  R> CLOSE-FILE THROW
;

: FixResNumber
  ItemsLen /RES-HEAD /
  @prc @ numRecords pW!
;

0 DF-VERSION ! \ Major vesrion


: DF-LOAD-VERSION ( -- n )
  S" VERSION.DF" ['] INCLUDED CATCH IF 0 THEN
;
: DF-SAVE-VERSION ( n -- )
  H-STDOUT >R
  S" VERSION.DF" R/W CREATE-FILE THROW TO H-STDOUT
  . CR
  H-STDOUT CLOSE-FILE THROW
  R> TO H-STDOUT
;

CREATE newNames 1024 CELLS ALLOT
VARIABLE allNames

: nameResHERE
   nameRes nameResLen @ +
;

: nameResW, ( n -- )
   nameResHERE pW!
   2 nameResLen +!
;

: nameResC, ( n -- )
   nameResHERE C!
   nameResLen 1+!
;

: AddSortName ( addr u )
\ 'cfa+nfa
\   DUP . 2DUP DUMP
   DUP CELL+ ALLOCATE THROW >R
   DUP R@ !
   R@ CELL+ SWAP CMOVE
   R>
   newNames allNames @ CELLS + !
   1 allNames +!
;

: ReadAllNames
   TC-LAST @
   BEGIN
     DUP 2+ nameRes +  \ addr
     DUP 2+ C@ 31 AND 4 + AddSortName
     nameRes + pW@ DUP 0=
   UNTIL
;

: WriteSortedNames
\    .
   nameResLen 0!
   TC-LAST 0!
   0 nameResW, \  PALM-FIND    
   0 allNames @ 1-
   DO
     nameResLen @ 
     TC-LAST @ nameResW,      \ LFA
     TC-LAST !
     I CELLS newNames + @ 
     DUP @ SWAP CELL+ SWAP
     nameResHERE SWAP DUP
     nameResLen +!
     MOVE
     nameResLen @ ALIGNED
     nameResLen !
   -1 +LOOP
;

WINAPI: CharLowerA USER32.DLL

: UCOMPARE ( addr1 u1 addr2 u2 -- 0 | -1 )
  ROT OVER <> IF DROP 2DROP -1 EXIT THEN
  0 DO
      2DUP C@ CharLowerA SWAP C@ CharLowerA <>
      IF UNLOOP 2DROP -1 EXIT THEN
      1+ SWAP 1+
    LOOP 2DROP 0
;

: SearchANSName ( addr u -- addr -1 | 0 )
   0 allNames @ 1-
   DO
     2DUP
     I CELLS newNames + @ 
     6 + COUNT 31 AND UCOMPARE 0=
     IF
       2DROP I CELLS newNames + -1 UNLOOP EXIT
     THEN
   -1 +LOOP 2DROP 0
;

: SWAPA ( addr1 addr2 )
   DUP @ >R
   OVER @ SWAP !
   R> SWAP !
;

VARIABLE CurrName

: XT-SORT
  BEGIN
    REFILL
  WHILE
    NextWord SearchANSName
    IF \  tos  CurrName
       CurrName @ newNames +
       SWAPA 
       CELL CurrName +!
    THEN                         
  REPEAT
;

: SORT-NAMES
  ReadAllNames
  S" prc\stat.txt" R/O OPEN-FILE THROW
  FILE>RSTREAM DUP >R ['] XT-SORT RECEIVE-WITH
  R> FREE-RSTREAM CLOSE-FILE THROW
  THROW
  WriteSortedNames
;

: SAVE-PRC ( addr u )
  DF-LOAD-VERSION 1+ 
  DUP DF-BUILD  !
  DF-SAVE-VERSION
  HERE @prc !
  S" Dragon" GEN-HEADER
  GEN-CODE0
  HERE
  GEN-CODE1
  HERE SWAP - 
  ."       VM code size: " . CR
  GEN-DATA0
  HERE
  GEN-THREADED
  HERE SWAP -
  ." Threaded code size: " . CR
  HERE
  GEN-NAMES
  HERE SWAP - 
  ."    Name space size: " . CR
  ."   Actual data size: " D-DP @ . CR
  ."       Words number: " WordsCount @ . CR
  S" ..\res\tAIB03e8.bin" GEN-ICON
  S" ..\res\tAIB03e9.bin" GEN-SMALLICON
  S" ..\res\talt04b0.bin" S" Talt" 1200 FileRes
  S" ..\res\papi.bin" S" papi" 1000 FileRes
  GEN-TVER
  ResolveRefs
  FixResNumber
  (SAVE-PRC)
;