
: (ID)
    NextWord DROP _@
    [COMPILE] LITERAL
; IMMEDIATE

: ?DmERR ( n -- n )
         ( 0 -- )
  ?DUP 0= IF DmGetLastErr THROW  THEN
;

: use-resource ( type creator )
     R/O DmOpenDatabaseByTypeCreator ?DmERR DROP
;

VARIABLE SaveCrID

: OpenTarget ( -- DbRef)
    [ID] 'appl' SaveCrID @ W/O
    DmOpenDatabaseByTypeCreator ?DmERR
;

: CopyRes ( resType resID -- )
    2DUP DmGetResource ?DmERR >R
    OpenTarget
    DUP 2SWAP ( ref ref type id)
    R@ MemHandleSize
    DmNewResource DUP
     MemHandleLock 0 R@ MemHandleLock
     R@ MemHandleSize DmWrite THROW
     R@ MemHandleUnlock THROW
     DUP MemHandleUnlock THROW
    DmReleaseResource THROW
    DmCloseDatabase THROW                 
    R> DmReleaseResource THROW            
;

: CopyData
   OpenTarget DUP 0x7FFE
   DmNewHandle DUP
   MemHandleLock DbPtr !
   0 >abs 0x7FFE - >rel  \ from
   8                     \ to offs
   DP @ 0x7FFE +         \ how many
   CompressRle ALIGNED
   0 0x7FFE - PAD !
   DbPtr @ CELL PAD >abs 4 DmWrite THROW \ xref rel
   DUP 12 - PAD !
   DbPtr @ 0 PAD >abs 4 DmWrite THROW    \ where load to
   OVER SWAP MemHandleResize THROW       \ cut
   DUP MemHandleUnlock THROW
   OVER SWAP [ID] 'data' 0 DmAttachResource THROW
   DmCloseDatabase THROW
;

: Copy4tcd
   OpenTarget DUP THERE
   DmNewHandle DUP MemHandleLock
   0 THREADED >abs THERE DmWrite THROW
   DUP MemHandleUnlock THROW
   OVER SWAP [ID] '4tcd' 1000 DmAttachResource THROW
   DmCloseDatabase THROW
;

: CopyNames
   OpenTarget DUP NHERE
   DmNewHandle DUP MemHandleLock
   0 NAMES @ >abs NHERE DmWrite THROW
   DUP MemHandleUnlock THROW
   OVER SWAP [ID] 'name' 1000 DmAttachResource THROW
   DmCloseDatabase THROW
;

VARIABLE tmpw

: SetDbAttr ( LocalID attr -- )
    tmpw W!
    0 SWAP 0 tmpw >abs 
    0. 0. 0. 0. 0
    DmSetDatabaseInfo THROW
;

: SAVE_KERNEL ( c-addr u CreatorID -- )
    DUP SaveCrID ! >R DROP
    >abs DUP 0 OVER
    DmFindDatabase ?DUP
    IF
      0 SWAP DmDeleteDatabase THROW
    THEN
    0           \ cardNo
    SWAP        \ nameP
    R>          \ CreatorID
    [ID] 'appl' \ type
    1           \ resDB
    DmCreateDatabase THROW
    \ Set backup bit
    0 SWAP DmFindDatabase
    [ 8 1 OR ] LITERAL ( dmHdrAttrBackup | dmHdrAttrResDB) 
    SetDbAttr
    [ID] 'code' 0 CopyRes
    [ID] 'code' 1 CopyRes
    [ID] 'Talt' 1200 CopyRes
    justForth? OFF
    CopyData
    Copy4tcd
;

: SAVE ( addr u crID )
   SAVE_KERNEL
   CopyNames
   [ID] 'papi' 1000 CopyRes
   [ID] 'tAIB' 1000 CopyRes
   [ID] 'tAIB' 1001 CopyRes
   [ID] 'tver' 1000 CopyRes
;

: BUILD ( c-addr u CreatorID -- )
   ?APP ON
   SAVE_KERNEL
   +Names @ IF CopyNames THEN
   ?APP OFF
;

: LAUNCH ( addr u ) 
   OVER + 0 SWAP C!
   0 SWAP >abs DmFindDatabase
   0. AppSwitch
;

: CALLAPP ( addr u -- x )
   OVER + 0 SWAP C!
   0 SWAP >abs DmFindDatabase
   0 SWAP [ 0x2 0x4 0x8 OR OR ] LITERAL
   0. RVAR SysAppLaunch DROP R>
;