
: OpenMemoDB ( mode -- ior )
   memoCount @ 0=
   IF   [ID] 'DATA' [ID] 'memo' ROT
        DmOpenDatabaseByTypeCreator
        DUP TO memoDB 0=
   ELSE DROP 0
   THEN memoCount 1+!
;

: CloseMemoDB ( -- ior )
   -1 memoCount +!
   memoCount @ 0= DUP
   IF DROP memoDB DmCloseDatabase THEN
;

1 CONSTANT R/O
2 CONSTANT W/O
3 CONSTANT R/W

: RVAR ( -- abs-addr )
   R> 0 >R RP@ >abs
   SWAP >R
;

: RecDeleted? ( index -- f )
   RVAR 0. DmRecordInfo DROP
   R> 0x800000 AND
;

: OPEN-MEMO ( addr u mode -- ptr ior )
   OpenMemoDB THROW
   memoDB DmNumRecords 0
   ?DO ( addr u )
     memoDB I RecDeleted? 0=
     IF
       memoDB I DmQueryRecord
       DUP MemHandleSize 2 PICK >
       IF \ long enough?
          DUP MemHandleLock >rel ( addr u handle locked )
          DUP >R 2OVER TUCK COMPARE
          0= IF \ check bl or lf
                OVER R@ + C@ DUP 10 =
                SWAP BL = OR
                IF 2DROP DROP R> 0 I memoIndex ! UNLOOP EXIT THEN
             THEN
          RDROP MemHandleUnlock
       THEN DROP
     THEN
   LOOP 2DROP 0 -258 ( memo not found )
   CloseMemoDB THROW
;

: CLOSE-MEMO ( ptr -- ior )
   >abs MemPtrUnlock
   CloseMemoDB THROW
;

: AppSwitch ( dbID cmd param )
   >R 0 -ROT
   18 ALLOCATE THROW ( GoToParamsPtr)
   DUP >abs 0 MemPtrSetOwner THROW ( Pass parameter block to OS)
   DUP 18 ERASE
   R> OVER 8 + W!
   >abs SysUIAppSwitch THROW
;

