(
Memo   :
- memPtr - SOURCE-ID
-   
  VARIABLE SOURCE-POS 
)

VARIABLE SOURCE-POS \ remaining symbols in a memo
 0 VALUE SOURCE-LEN

: NextString ( -- addr u f )
     SOURCE-POS @ \ there is something
     IF
        SOURCE-ID SOURCE-LEN +
        SOURCE-POS @ TUCK - SWAP OVER >R
        0x0A SCAN 1- 0 MAX
        SOURCE-POS !      
        R@ - R> SWAP TRUE
     ELSE SOURCE-ID 0 FALSE
     THEN
;

: (ABORT") ( f addr u )
   ROT IF ER-U ! ER-A ! -2 THROW ELSE 2DROP THEN
;

: ABORT"
  [COMPILE] S"
  POSTPONE (ABORT")
; IMMEDIATE

VECT ACCEPT
:NONAME S" ACCEPT is not available" ShowDFAlert DROP S" BYE" ROT SWAP MOVE 3 ; (TO) ACCEPT

: REFILL ( -- f )
  CURSTR 1+!
  TIB C/L
  SOURCE-ID 0 > IF \ read memo
                     NextString
                     IF  ( tib c/l addr u )
                       DUP C/L > -18 ?THROW
                       ROT MIN DUP #TIB !
                       ROT SWAP MOVE
                     ELSE 2DROP 2DROP 0 EXIT 
                     THEN
                ELSE SOURCE-ID
                     IF 2DROP FALSE EXIT THEN ( evaluate string )
                     ACCEPT #TIB ! ( user input )
                THEN
  >IN 0! -1
;

: NOTFOUND ( addr u -- ... )
   ?SLITERAL
;

: ?STACK
   SP@ S0 @ SWAP U< -4 ?THROW
;

: INTERPRET
   BEGIN
     NextWord DUP 
   WHILE
     SFIND ?DUP
     IF
       STATE @ =
       IF COMPILE, ELSE EXECUTE THEN
     ELSE
       S" NOTFOUND" SFIND
       IF EXECUTE
       ELSE 2DROP ?SLITERAL
       THEN
     THEN
     ?STACK
   REPEAT 2DROP
;

VECT OK 
' NOOP (TO) OK

: MAIN1
   BEGIN
     REFILL
   WHILE
     INTERPRET OK
   REPEAT
;

: [
   STATE 0!
; IMMEDIATE

: ]
   TRUE STATE !
;

: QUIT
  BEGIN
    CURMEMO 0!
    0 TO SOURCE-ID
    CURSTR 0!
    [COMPILE] [
    ['] MAIN1 CATCH DUP
    -257 = IF BYE THEN
    ['] ERROR CATCH DROP 
  AGAIN
;

: ABORT
   -1 THROW
;

VECT LAST-WORD
' NOOP (TO) LAST-WORD

: \
   SOURCE NIP >IN !
; IMMEDIATE

: .(  \ 94 CORE EXT
\ :   ,  .
\ : ( "ccc<paren>" -- )
\      ccc,    ")".
\ .( -   .
  [CHAR] ) PARSE TYPE
; IMMEDIATE

: (  ( "ccc<paren>" -- ) \ 94 FILE
\   CORE (, :
\    ,     
\ ,    ,     
\   ,  >IN     , 
\     ,        
\    .
  BEGIN
    [CHAR] ) DUP PARSE + C@ = 0=
  WHILE
    REFILL 0= IF EXIT THEN
  REPEAT
; IMMEDIATE

: RemoveNULLs ( addr u -- )
  0 ?DO
    DUP C@ 0= IF
      BL OVER C!
    THEN
    1+
  LOOP
  DROP
;

VECT ERRSTR ( err -- addr u )
:NONAME 0 ; (TO) ERRSTR

: ERRDESC ( n -- addr u )
  BASE @ >R DECIMAL
  ?DUP IF
   >R
    <#
      ?APP @ 0= IF
        CURMEMO @ 0<> IF
          CURSTR @ S>D CURMEMO @ ASCIIZ> HOLDS [CHAR] : HOLD #S 2DROP
          10 HOLD
        THEN
        SOURCE SWAP >IN @ + SWAP >IN @ - 0 MAX HOLDS
        S"  <<< " HOLDS
        SOURCE DROP >IN @ HOLDS
        10 HOLD
      THEN
      R@ -1 = IF
        RDROP S" ABORT" HOLDS
      ELSE R@ -2 = IF
        RDROP ER-A @ ER-U @ HOLDS
      ELSE
        R@ ERRSTR ?DUP IF
          RDROP
        ELSE
          DROP
          R@ ABS S>D #S 2DROP R> SIGN S" Exc#"
        THEN
        HOLDS
      THEN THEN
    0. #>
    2DUP RemoveNULLs
  THEN
  R> BASE !
;

:NONAME ( n -- )
  ?DUP IF
    ERRDESC ShowDFAlert
    ?APP @ 0= IF
      CURMEMO @ 0<> IF
        CURMEMO @ FREE DROP CURMEMO 0!
      THEN
    THEN
  THEN
; (TO) ERROR

: CHAR ( "<spaces>name" -- char ) \ 94
\   .  ,  .
\       .
  NextWord DROP C@
;

: ' ( "<spaces>name" -- xt ) \ 94
\   .  name,  .  name 
\   xt,    name.   , 
\  name  .
\     ' name EXECUTE    name.
  NextWord SFIND 0=
  -13 ?THROW
;

: ['] ( "name" ) ( -- xt )
  ?COMP
  ' [COMPILE] LITERAL
; IMMEDIATE

: EVALUATE-WITH ( ( i*x c-addr u xt -- j*x )
\  c-addr u  ,    xt.
  SOURCE-ID >R TIB >R #TIB @ >R >IN @ >R
  -1 TO SOURCE-ID
  SWAP #TIB ! SWAP TO TIB >IN 0!
  ( ['] INTERPRET) CATCH
  R> >IN ! R> #TIB ! R> TO TIB R> TO SOURCE-ID
  THROW
;

: EVALUATE ( i*x c-addr u -- j*x ) \ 94
\     .
\  -1  SOURCE-ID.  ,  c-addr u,
\     ,  >IN  0
\  .      - 
\    .
\       EVALUATE .
  ['] INTERPRET EVALUATE-WITH
;

: RECEIVE-WITH ( j*x addr u xt -- i*x ior )
\  addr u -  ,  xt  CATCH
\  exception #TIB >IN  CURSTR  !
   TIB >R #TIB @ >R 
   CURSTR @ >R >IN @ >R
   SWAP #TIB ! SWAP TO TIB 
   >IN 0! CURSTR 0!
   CATCH
   DUP IF 12 NRDROP \ RDROP RDROP RDROP
       ELSE R> >IN ! R> CURSTR ! R> #TIB !
       THEN
   R> TO TIB
;

CREATE smallBuf 6 ALLOT

: (INCLUDE)
   BEGIN
     REFILL
     justForth? @
     IF
       allLines 1+!
       allLines @ 7 AND 7 = 
       IF
         smallBuf >abs allLines @ StrIToA >rel
         ASCIIZ> s>abs 0 12 WinDrawChars
       THEN
     THEN
   WHILE
     INTERPRET
   REPEAT
;

: HEAP-COPY ( addr u -- addr1 )
\          
  DUP 1+ ALLOCATE THROW DUP>R
  SWAP DUP >R MOVE
  0 R> R@ + C! R>
;

: INCLUDE-PTR ( i*x ptr u -- j*x ior )
   SOURCE-POS @ >R
   SOURCE-LEN >R
   DUP TO SOURCE-LEN
   SOURCE-POS ! TO SOURCE-ID  
   C/L DUP 2+ ALLOCATE THROW DUP>R
   SWAP ['] (INCLUDE) RECEIVE-WITH
   DUP IF R@ TIB C/L MOVE THEN  \  ERROR  
   R> FREE THROW
   DUP
   IF 2RDROP
   ELSE \  Last error
     R> TO SOURCE-LEN
     R> SOURCE-POS !
   THEN
;            

: CLOSE-STREAM-MEMO SOURCE-ID CLOSE-MEMO ;

: INCLUDED ( i*x c-addr u -- j*x )
   2DUP <# HOLDS BL HOLD [CHAR] ( HOLD 0. #>
   memoIndex @ >R
   R/O OPEN-MEMO THROW 
   -ROT
   CURMEMO @ >R HEAP-COPY CURMEMO !
   DUP >abs MemPtrSize
   SOURCE-ID >R
   INCLUDE-PTR DUP
   SOURCE-ID CLOSE-MEMO THROW
   R> TO SOURCE-ID
   0= IF
        CURMEMO @ FREE THROW
        R@ CURMEMO !
      THEN RDROP
   THROW  R> memoIndex !
;

: NEEDS ( "word" "lib" -- )
  NextWord NextWord 2SWAP SFIND
  IF DROP 2DROP
  ELSE 2DROP INCLUDED
  THEN
;

: \EOF  ( -- )
\    
  BEGIN REFILL 0= UNTIL
  POSTPONE \
;

: [COMPILE]
   ' COMPILE,
; IMMEDIATE

