( multitasking kernel.  ~day 18.Mar.2001 )

CREATE OPERATOR \ main task
CELL ALLOT \ tls
4096    W, \ data stack size
2048    W, \ return stack size
4096    W, \ size of tls

: SET-STOP
   1 TASKSTATE !
;

: SET-WAKE
   TASKSTATE 0!
;

VECT USER-INIT

: ACTIVATE ( tid -- )
\   
\      ,
\      
   TLS @ SWAP
   @ TLS !
   SET-WAKE
   R> TASKIP !
   S0 @ SSTATE !
   R0 @ RSTATE !
   USER-INIT
   TLS !
;

: PAUSE ( -- )
\  ,
\    ,
\    ,
\    .
   R> TASKIP !
   SP@ SSTATE !
   RP@ RSTATE !
   NEXTTASK 
   BEGIN
     @ @ ( tls) DUP 8 + @ ( taskstate)
   WHILE
     12 + ( nexttask)
   REPEAT TLS !
   RSTATE @ RP!
   SSTATE @ SP!
   TASKIP @ >R
;

: SLEEP ( -- )
   SET-STOP
   PAUSE
;

: STOP ( tid -- ) ACTIVATE SLEEP ;


\ semaphores

: VACANT ( sid -- f )
   @ DUP 0= SWAP TASK = OR
;

: GET ( sid -- )
   BEGIN PAUSE VACANT UNTIL TASK SWAP !
;

: RELEASE ( sid -- )
   DUP VACANT IF 0! ELSE DROP THEN
;