\ The Palm Computing Platform entry routine (mainline).

\ @param cmd         a word value specifying the launch code.
\ @param cmdPBP      pointer to a structure associated with the launch code.
\ @param launchFlags additional launch flags.
\ @return zero if launch successful, non zero otherwise.

VECT PilotMain

:NONAME ( cmd cmdPBP launchFlags -- )
   justForth? ON
   28 CurY !
   S" lines compiled" s>abs 30 12 WinDrawChars
   S" Including ( df ) memo..." s>abs
   0. WinDrawChars
   0 25 160 25 WinDrawLine
   2DROP DROP
   S" df" INCLUDED
; (TO) PilotMain

: COLD
  0. SP@ >abs DUP CELL+
  SysCurAppDatabase THROW DROP
  0. AppSwitch
;

: CloseIMGdb
  IMGdbOR DmCloseDatabase THROW
;

: CreateIMG-name ( -- )
\    name
    IMGdbOR [ID] 'name' 1001 NDP @ DUP NAMES-SIZE ! DmNewResource ?DmERR DUP HNAMES !
    MemHandleLock DUP >rel NAMES !
    0
    [ID] 'name' 1000 DmGetResource DUP>R ?DmERR MemHandleLock ?DmERR
    NDP @
    DmWrite THROW 
    R> DUP MemHandleUnlock THROW
    DmReleaseResource THROW
;

:NONAME
   S-O TO CONTEXT FORTH DEFINITIONS
   ATIB TO TIB
   DECIMAL [COMPILE] [
   ['] ?SLITERAL2 TO ?SLITERAL
   WARNING ON
; (TO) USER-INIT

: INIT
\   S" asd" ShowDFAlert
\   ?APP @ 0= IF SaveInts ( SetInts ) THEN
   ['] THROW THROW-CFA !
   [ID] 'psys' 1 OSVER >abs FtrGet DROP 
   OSVER @ MinROM @ < 
   IF S" Incompatible ROM version!" ShowDFAlert HALT
   THEN
   [ID] 'TRG ' 2 _vga >abs FtrGet 0= TO vga?
   0 TO SOURCE-ID
\ init main task
   OSVER @ 0x3000000 <
   IF
     HERE USER-OFFS @ 2048 + ERASE
     HERE DUP OPERATOR ! TLS !
     USER-OFFS @ 2048 + DP +!
   ELSE 
     USER-OFFS @ 2048 + DUP ALLOCATE DROP DUP 
     ROT ERASE DUP OPERATOR ! 
     TLS !
   THEN
   OPERATOR NEXTTASK !
   OPERATOR TO TASK
   RP@ DUP R0 ! RSTATE !
   SP@ 12 + DUP S0 ! SSTATE !
   USER-INIT
   memoIndex ON
   memoCount OFF
   ['] PilotMain CATCH DUP -257 =
   IF DROP 0 THEN
   DUP ERROR
   HALT
; LAST-CFA 4tcd pW!

SORT-NAMES

PREVIOUS nameResLen @ ALSO TC (TO) NDP
PREVIOUS HERE 4tcd - ALSO TC (TO) TDP
63000 (TO) MAX_NAMES
32760 (TO) MAX_THREADED
 0 (TO) ?APP
PREVIOUS TC-LAST @ ALSO TC (TO) LAST

  HERE ' DP 2+ >abs
  pW@ W>S !
  MAKE-FORTH-WL

  TC-USER-OFFS@ (TO) USER-OFFS