_SEARCHWL PRIM SEARCH-WORDLIST

VARIABLE CURRENT

: SET-CURRENT ( wid -- ) \ 94 SEARCH
\     ,  wid.
  CURRENT !
;

: GET-CURRENT ( -- wid ) \ 94 SEARCH
\  wid -   .
  CURRENT @
;

: DEFINITIONS ( -- ) \ 94 SEARCH
\       ,       
\ .        .
\         .
  CONTEXT @ SET-CURRENT
;

: FORTH ( -- ) \ 94 SEARCH EXT
\   ,   widn, ...wid2, wid1 ( wid1 
\  )  widn,... wid2, widFORTH-WORDLIST.
  FORTH-WORDLIST CONTEXT !
;

: ONLY ( -- ) \ 94 SEARCH EXT
\          .
\       FORTH-WORDLIST  SET-ORDER.
  S-O TO CONTEXT
  FORTH
;

: SET-ORDER ( widn ... wid1 n -- ) \ 94 SEARCH
\     ,  widn ... wid1.
\    wid1   ,    widn
\ - .  n  -   .   ,
\         
\ .
\       FORTH-WORDLIST  SET-ORDER.
\     n   8.
   DUP IF DUP -1 = IF DROP ONLY EXIT THEN
          DUP 1- CELLS S-O + TO CONTEXT
          0 DO CONTEXT I CELLS - ! LOOP
       ELSE DROP S-O TO CONTEXT  CONTEXT 0! THEN
;

: GET-ORDER ( -- widn ... wid1 n ) \ 94 SEARCH
\        - n   
\ widn ... wid1,    . wid1 -   
\ ,   ,  widn -  ,  
\ .    .
  CONTEXT 1+ S-O DO I @ CELL +LOOP
  CONTEXT S-O - CELL/ 1+
;

: ALSO ( -- ) \ 94 SEARCH EXT
\   ,   widn, ...wid2, wid1 ( wid1 
\  )  widn,... wid2, wid1, wid1.   
\ ,       .
  GET-ORDER 1+ OVER SWAP SET-ORDER
;

: PREVIOUS ( -- ) \ 94 SEARCH EXT
\   ,   widn, ...wid2, wid1 ( wid1 
\  )  widn,... wid2.   ,
\        PREVIOUS.
  CONTEXT CELL - S-O MAX TO CONTEXT
;

: FIND ( c-addr -- c-addr 0 | xt 1 | xt -1 ) \ 94 SEARCH
  0
  S-O 1- CONTEXT
  DO
   OVER COUNT I @ SEARCH-WORDLIST
   DUP IF 2SWAP 2DROP LEAVE THEN DROP
   I S-O = IF LEAVE THEN
   1 CELLS NEGATE
  +LOOP
;

: SFIND ( addr u -- addr u 0 | xt 1 | xt -1 )
\   CORE FIND :
\    ,   addr u.
\           ,
\  addr u  .   ,  xt.
\    ,    (1);
\      (-1).   , ,
\  FIND   ,    ,
\     .
  S-O 1- CONTEXT
  DO
   2DUP I @ SEARCH-WORDLIST
    DUP IF 2SWAP 2DROP UNLOOP EXIT THEN DROP
   I S-O = IF LEAVE THEN
   CELL NEGATE
  +LOOP
  0
;

: LATEST ( -> NFA )
  CURRENT @ @
;