\ t-addr -  ⭮⥫쭮 4tcd

: THERE ( -- t-addr )
\ gives current pointer of threaded code space
\ It's like HERE but for threaded code space
  TDP @
;

: NHERE ( -- n-addr )
\ gives current pointer of name space
\ It's like HERE name space
  NDP @
;

: T> ( t-addr -- a-addr )
\ translate threaded code address into data space address
\ then you can apply @ W@ C@ on it
  THREADED +
;

: N> ( n-addr -- a-addr )
\ translate name space address into data space address
\ then you can apply @ W@ C@ on it
  NAMES @ +
;

: ALLOT ( n -- )
  DP +!
;

: , ( x -- )
  HERE 1 AND -23 ?THROW
  HERE !
  CELL ALLOT
;

: W, ( x -- )
\ Reserve a half-cell of data space and store x in it. 
  HERE 1 AND -23 ?THROW
  HERE W!
  2 ALLOT
;

: C, ( n -- )
  HERE C!
  1 ALLOT
;

: ?SHORT ( n -- f )
\ Check if n is a half-cell number
  ABS 0x8000 U<
;

: RESSIZE-ALIGN ( n1 -- n2 )
  12 RSHIFT 1+ 12 LSHIFT
;

: >N-MOVE ( addr-from n-addr-to u -- )
\ write an array into name space
  2DUP + MAX_NAMES > IF -261 THROW THEN
  2DUP + NAMES-SIZE @ > 
    IF
      2DUP + RESSIZE-ALIGN
      MAX_NAMES MIN
      HNAMES @ MemHandleUnlock THROW
      HNAMES @ OVER DmResizeResource HNAMES !
      NAMES-SIZE !
      HNAMES @ MemHandleLock >rel NAMES !
    THEN
    >R            \ (names @ >abs) na (a >abs) u
    NAMES @ >abs
    SWAP ROT
    >abs
    R> DmWrite THROW
;
  
: >T-MOVE ( addr-from t-addr-to u -- )
\ write an array into threaded code space
  2DUP + MAX_THREADED > IF -262 THROW THEN
    2DUP + THREADED-SIZE > 
    IF
      2DUP + RESSIZE-ALIGN
      MAX_THREADED MIN
      RESIZE-THREADED
    THEN
    >R
    THREADED >abs
    SWAP ROT
    >abs
    R> DmWrite THROW
;
  
: T-! ( x t-addr -- )
\ Store x at t-addr in threaded code space
  SP@ CELL+ SWAP CELL >T-MOVE DROP
;

: T-W! ( x t-addr -- )
\ Store x at t-addr in threaded code space as a half-cell number
  SP@ CELL+ 2+ SWAP 2 >T-MOVE DROP
;

: N-W! ( n n-addr -- )
\ Store x at t-addr in the name space as a half-cell number
  SP@ CELL+ 2+ SWAP 2 >N-MOVE DROP
;

: N-C! ( char n-addr -- )
\ Store char at n-addr in name space. When character size is smaller than 
\ cell size, only the number of low-order bits corresponding to 
\ character size are transferred. 
  SP@ CELL+ 3 + SWAP 1 >N-MOVE DROP
;

: T-W, ( n -- )
\ Reserve half-cell of threaded code space and store x in the half-cell. 
  THERE 1 AND -23 ?THROW
  THERE T-W!
  2 TDP +!
;

: T-, ( n -- )
\ Reserve one cell of threaded code space and store x in the cell. 
  THERE 1 AND -23 ?THROW
  THERE T-!
  4 TDP +!
;

: N-W, ( n -- )
\ Reserve half-cell of name space and store x in the half-cell. 
  NHERE 1 AND -23 ?THROW
  NHERE N-W!
  2 NDP +!
;

: N-C, ( char -- )
\ Reserve space for one character in the name space and store char in the space. 
  NHERE N-C!
  1 NDP +!
;

: COMPILE, ( xt -- )
  T-W,
; LAST-CFA TO COMPILE-CFA

: BRANCH, ( -- )
\ compile branch token into threaded code,
\ then you are supposed to compile t-addr
  [ BRANCH-CODE ] LITERAL
  COMPILE,
;

: ?BRANCH, ( -- )
\ compile ?branch token into threaded code,
\ then you are supposed to compile t-addr
  [ ?BRANCH-CODE ] LITERAL
  COMPILE,
;

: LIT, ( x -- )
\ Compile cell x as literal
  DUP ?SHORT IF
    [ LITW-CODE ] LITERAL
    COMPILE, T-W,
  ELSE
    [ LIT-CODE ] LITERAL
    COMPILE, T-,
  THEN
;

: DLIT, ( d -- )
\ compile double-cell number as literal
   SWAP LIT, LIT,
;

: S", ( addr u -- )
\ append string (addr u) into data space at current 
\ data pointer as counted string, then append 0 and align.
\ ex: 
\ create qwe S" hello" S",
\ qwe count type
  DUP C,
  HERE OVER ALLOT
  SWAP MOVE
  0 C, ALIGN
;

: testopt
   SWAP OVER
   OVER SWAP
   DUP >R
;
