\ clokz.f
\ peter boardman june 2001
\ using example code by Eugene Zalyubovsky (~ugin) and Dmitry Yakimov ftech@tula.net

"clokworkz"  \ contains the works!

\ standalone prc-file (true) or 
\ run in DragonForth (false)
true value ?make-prc

API: PrefSetAppPreferencesV10
\ stores app preferences in 
\ palm's preferences database
\ Uses HERE for temporary storage

: >store ( -- )
timezone @ here !
\ save preferences with ID pb24
\ version 1 and length 4 bytes 
'pb24' 1 here  >abs cell
PrefSetAppPreferencesV10
;

API: PrefGetAppPreferencesV10
\ retrieves app preferences from 
\ Palm's preferences database
\ if cannot retrieve data from 
\ database, set timezone to 0

: >get ( -- )
'pb24' 1 here >abs cell
PrefGetAppPreferencesV10 
if
here  @
else  0  
then
timezone !
;

: adjust ( n -- n )
\ keep hour valid
dup 0< if 24 + then 
dup 23 > if 24 - then 
;

: times ( -- )
\ display the times in the form
\ do local times first
now \ current time ( -- s m h ) 
3dup showlocal  
3dup 100 metrictime  showmetric
3dup hextime showhex
\ next, global times
\ these are all adjusted by time zone
( -- s m h )  
timezone @ - 
adjust \ now we have gmt
3dup showgmt
3dup 100 metrictime showglobalmetric
3dup 1+ adjust swatchtime 
\ swatch is gmt +1
showswatch 
3dup nettime shownewearth
\ new earth is gmt 0
3dup 8 - adjust owttime 
\ oneworld is 8 hours behind gmt
\ needs day of year, too 
today dayoftheyear 
showoneworld
\ finally. Wrld is 12 behind
( s m h -- )
12 - adjust wrldtime showwrld 
;

: doMenu ( -- ) \ handle menu events
drawing off
event itemid
case
	AboutItem of \ show about info
	AboutForm FrmAlert endof
endcase
drawing on
;

\ handling buttons
: doButton ( -- )
drawing off
event itemID
case 
	MoreButton of inctimezone endof
	LessButton of dectimezone endof
endcase
drawing on
;

: entermainf
event 8 + @
frmgetactiveform = if
drawing on
show-timezone 
then ;

\ application's main event loop
: EventLoop
  begin
    ekey
    case 
	WinEnterEvent of 
	entermainf endof
	winexitevent of
	drawing off endof
        MenuEvent of doMenu endof
        ctlEnterEvent of doButton endof
    endcase
	drawing @ if times then
  again
;

: go
\ show main form 
MainForm FrmGotoForm
>get \ get prefs 
['] EventLoop catch
drop  
>store \ save prefs
;

\ build or run
?make-prc
[if] 
 ' go to PilotMain
\ build standalone app, creator's ID 
 s" clokz" 'pb24'  build

\ use resource with creator's ID 
'rsrc' 'pb25' use-resource

\ copy resources we need
'tFRM' 1000 CopyRes
'MBAR' 1000 CopyRes
'tSTR' 1000 CopyRes
'Talt' 1000 CopyRes
'tAIB' 1000 CopyRes
'tAIB' 1001 CopyRes

\ version of application
'tver' 1000 CopyRes
bye
[else]
\ use resource with creator's ID 
'rsrc'  'pb25' use-resource
\ run GO word and exit
go 
\ bye
[then] 
