\ clokworkz.f
\ support for alternate timesystems
\ used by main clokz file

"events"
"forms"
"fields"
"case"
"ipif"
"facil" \ time&date ( -- sec min hr d m y )

variable timezone
variable drawing

\ User interface constants
1000 constant MainForm
1010 constant PassLabel
1021 constant dataField
1030 constant LessButton
1031 constant MoreButton
1025 constant timezonefield
1000 constant MBAR1000
2001 constant AboutItem
1000 constant AboutForm
3000 constant localfield
3001 constant gmtfield
3002 constant localmetricfield
3003 constant localhexfield
3004 constant metricfield
3005 constant swatchfield
3006 constant newearthfield
3007 constant oneworldfield
3008 constant wrldfield

: thisyear ( -- y )
time&date >r 
drop drop drop drop drop 
r>  ;

: thismonth ( -- m )
time&date swap >r 
drop drop drop drop drop 
r> ;

: thisday ( -- n )
time&date rot >r 
drop drop drop drop drop
r>  ;

: today ( -- d m y )
thisday thismonth thisyear ;

: now ( -- s m h )
time&date drop drop drop
;

: leapyear? ( year  -- bool )
dup 
4 mod 0=
over 100 mod 0=
invert and
swap 400 mod 0= or 
;

: months 
create 
begin nextword dup
while evaluate , 
repeat 2drop 
does> swap 1- cells + @ ;

months monthdays 0 31 59 90 120 151 181 212 243 273 304 334

: dayoftheyear ( d m y -- n )
>r monthdays +  r>   
( -- n y )
leapyear?
	 If 
	dup 59 >  
		if 
		1+ 
		then
	then
 ;

: secondsinday ( s m h -- n )
3600 * swap 60 * + +
;

: hextime ( s m h -- s m h ) 
\ convert to hexadecimal time
\ unformatted!
secondsinday 
5400 /mod  (  --  m h ) swap
256 5400 */mod ( --  h n m ) swap
16 5400 */mod ( --  h m r s ) swap
drop swap rot 
;

: metrictime ( s m h n --"m" "h")
\ returns eg 000 500 (= 12:00)
\ unformatted
\ n = 1000 or 100 to scale
>r secondsinday r> 100 / swap  864 */mod 
;

: swatchtime ( s m h -- beat )
\ unformatted
1000 metrictime  swap drop
;

:  nettime ( s m h --   deg m )
\ returns eg 180 0 (=12:00 )
\ unformatted
secondsinday 
15 m* 3600 um/mod 
( --  r q ) 
swap 60 / 
;

: wrldtime ( s m h -- "m" "h")
\ unformatted
secondsinday 1 swap  864 */mod
;

: owttime ( s m h -- n )
\ unformatted, and will need dayofyear as well
secondsinday 60 /
;

: 3dup 2 pick 2 pick 2 pick ;

: show-timezone ( --  )
\ format and display 
\ current timezone 
timezone @ dup >r abs
s>d <# #s 
r> dup 0= 
if drop 32 hold
else 0< if 45 else 43 then hold \ +-
then
[char] T hold 
[char] M hold 
[char] G hold #>
timezonefield 
( c-addr u fieldID -- )
>field
;

: dectimezone ( -- )
\ decrease timezone and display
\ check for min and max values
timezone @ 1-
-12  max
 timezone !
show-timezone
;

: inctimezone ( -- )
timezone @ 1+
12 min
 timezone !
show-timezone
;

: showlocal ( s m h -- )
\ show the palm's time
swap rot 
<# s>d 
 # # 
[char] : hold 
2drop
s>d # #
[char] : hold 
2drop
s>d #s #>
localfield  >field
;

: showmetric ( "m" "h" -- )
\ show a time in metric
swap 
<# s>d 
 #s 
[char] . hold 
2drop
s>d #s 
 #>
localmetricfield  >field
;

: showhex ( s m h  -- ) 
\ show a time in hex field
swap rot 
hex
<# s>d 
 # # 
[char] _ hold 
2drop
s>d # #
[char] _  hold 
2drop
s>d #s #>
decimal
localhexfield  >field
;

: showgmt ( s m h -- )
\ show a time in gmt field
swap rot 
<# s>d 
 # # 
[char] : hold 
2drop
s>d # #
[char] : hold 
2drop
s>d #s #>
gmtfield  >field
;

: showglobalmetric  ( "m" "h" -- ) 
swap 
<# s>d 
 # # # 
[char] . hold 
2drop
s>d # # 
 #>
metricfield  >field
;

: showswatch  ( beat -- ) 
<# s>d 
 # # # 
[char] @ hold
 #>
 swatchfield  >field
;

: shownewearth  ( "deg" "m" -- ) 
<# s>d 
[char] ' hold
 #s 
32 hold
176 hold \ degree symbol 
2drop
s>d #s 
 #>
newearthfield  >field
;

: showoneworld  ( "n" day -- ) 
<# s>d 
 #s 
32 hold
[char] d hold
32 hold
2drop
s>d #s
[char] @ hold 
 #>
oneworldfield  >field
;

: showwrld  ( "m" "h" -- ) 
swap 10 /
<# s>d  
# #
[char] . hold 
2drop
s>d #s
#>
wrldfield  >field
;
