namespace eval WebServer {

proc HTTP_HTML_Success {} {
  return "HTTP/1.0 200 OK\r\nContent-Type: text/html\r\nServer: TCL/Embedded 0.9\r\n\r\n"
}

proc Redirect {channel url} {
  puts $channel "HTTP/1.0 302 Redirect\r\nLocation: $url\r\n\r\nRedirect!"
  flush $channel
  close $channel
  return
}

proc AuthRequired {channel {realm server}}  {
  puts -nonewline $channel "HTTP/1.0 401 auth required\r\nWWW-Authenticate: Basic Realm=$realm\r\n\r\nAuthorization Required"
  flush $channel
  close $channel
  return
}

proc SetAuthRequired {state {callback {}}} {
  variable AuthRequired
  variable AuthCallback

  if {$state} {
    if {[string length $callback]} {
      set AuthCallback $callback
    } else {
       error "must specify callback"
    }
  }
  set AuthRequired $state
}

proc AuthCheck {name password} {
  variable AuthCallback

  set g "$AuthCallback $name $password"

  if {[catch {set g [eval $g]}]} {
   return 0
  } else {
   return $g
  }
}

proc NoAccess {args} {
  return 0
}

proc RegisterNamespace {args} {
  variable Namespaces

  foreach a $args {
    lappend Namespaces $a
  }
}

proc AddAllowed {args} {
  variable Allowed

  foreach a $args {
    lappend Allowed $a
  }
}

proc Setup {port} {
  variable listenSock

  SetAuthRequired 1 [namespace code NoAccess]
  RegisterDefaultProc DefaultProc
  set listenSock [socket -server [namespace code Incoming] $port]
  set Procedures {}
}

proc Shutdown {} {
  variable listenSock

  close $listenSock
}  


proc TransmitFileCompletion {channel file args} {
  flush $channel
  close $channel
  close $file
}

proc TransmitFile {channel path} {
  variable ContentTypeMap
  puts -nonewline $channel "HTTP/1.0 200 OK\r\n"

  catch {
     puts -nonewline $channel "Content-type: $ContentTypeMap([file extension $path])\r\n"
    }  

  puts -nonewline $channel "Server: TCL-Embedded/0.9\r\n\r\n"

 if {[catch {
    set f [open $path]
    fconfigure $f -translation binary
    fileevent $channel readable {}
    fcopy $f $channel -command [namespace code "TransmitFileCompletion $channel $f"]
  }]} {
    puts $channel "HTTP/1.0 500 Server Error\r\n\r\nServer Error"
    close $channel
  }
}

proc RegisterParameterDecodeInfo {proc args} {
  variable ParameterDecode

  set ParameterDecode($proc) $args
}

proc BuildEvalString {proc klist} {
  variable ParameterDecode

  if {![string length $klist]} {
    return 0
  }
#  puts $proc
  if {[info exists ParameterDecode($proc)]} {
    set paramstr $proc
#    puts $klist
    foreach a $ParameterDecode($proc) {
      lappend paramstr [list [keylget klist $a]]
    }
#    puts $paramstr
    return $paramstr
  }

  return 0
}

proc TransmitFromFS {channel path origpath} {

  if {[file isdirectory $path]} {
    if {[string length $origpath]} {
      if {![string compare [string trimright $origpath /] $origpath]} {
        Redirect $channel "$origpath/"
        return      
      }
    }
    foreach a {index.html index.htm default.html default.htm} {
      if {[file exists $path/$a]} {
        set path $path/$a
        TransmitFile $channel $path
        return
      }
    }
    set flist [glob $path/*]
    puts -nonewline $channel [HTTP_HTML_Success]
    foreach n $flist {
      puts -nonewline $channel "<A HREF=[file tail $n]>[file tail $n]</a><p>"
    }
    flush $channel
    close $channel
    return	
  } else {
    if {[file exists $path]} {
      TransmitFile $channel $path
      return
    }
  }

#  puts "TransmitFromFS: not found ($path)"
  puts $channel "HTTP/1.0 404 Not Found\r\n\r\n$origpath Not Found"
  flush $channel
  close $channel
}  

proc PathMapper {channel command} {
  variable PathTable

#  puts "PathMapper: $command"

  regsub {[\]} $command / command     
  regsub {\.\.} $command {} command

  set path [string trimleft $command /]
  set path [string trimright $path /]
  set endpath {}

  if {[info exists PathTable($path)]} {
    TransmitFromFS $channel "$PathTable($path)$endpath" "$command"
    return
  }

  while {[string length $path]} {
    if {![string compare $path .]} {
      set path ""
    }
    #handles a drive letter in the path
    if {![string compare [file dirname $path] $path]} {
     break
    }

    if {[info exists PathTable($path)]} {
      TransmitFromFS $channel "$PathTable($path)$endpath" "$command"
      return
    }

    set endpath "/[file tail $path]$endpath"
    set path [file dirname $path]
  }

#  puts "PathMapper: not found ($command)"
  puts $channel "HTTP/1.0 404 Not Found\r\n\r\nNot Found"

  flush $channel
  close $channel
}



proc RequestProcessor {channel} {
  variable Namespaces
  variable ChannelStatus 
  variable ChannelBuffer
  variable AuthRequired

  if {[eof $channel]} {
    close $channel
    return
  }

  set buffer [append ChannelBuffer($channel) [read $channel]]

#  puts $buffer
  #
  # check to see if we got the whole HTTP/1.0 header
  #

  if {[string first \r\n\r\n $buffer]!=-1} {

    #
    # got it
    #  

#    puts "$buffer\n-----"
    set command [string range $buffer 0 [set x [expr [string first \r\n $buffer] - 1]]]
#	puts "command=($command)"
	set buffer [string range $buffer [expr $x + 3] end] 
  } else {
    return

  }
#  puts $command

  if {![string length $command]} {
    close $channel
    return
  }

  #
  # we only support HTTP/1.0
  #

  if {[llength $command]!=3} {
    puts $channel "500 Error\r\n\r\nUnsupported protocol (HTTP/0.9)"
	flush $channel
	close $channel
	return
  }

  if {[string first HTTP/1. [lindex $command 2]]!=0} {
    puts $channel "HTTP/1.0 500 Error\r\n\r\nUnsupported protocol!"
	flush $channel
	close $channel
	return
  }

  #
  # we only support GET
  #  
  if {[string compare [string tolower [lindex $command 0]] get]} {
    puts $channel "HTTP/1.0 500 Error\r\n\r\nUnknown method"
	flush $channel
	close $channel
	return
  }

  if {$AuthRequired} {
    if {[set at [string first "authorization: basic " [string tolower $buffer]]]>-1} {
      incr at 21
      set atend [string first \r\n [string range $buffer $at end]]
      incr atend -1
      set authstr [string range $buffer $at [expr $at + $atend]]
      set authstr [Base64Decode $authstr]
      set auth1 [string range $authstr 0 [expr [set delim [string first : $authstr]] - 1]]
      set auth2 [string range $authstr [expr $delim + 1] end]
      if {![AuthCheck $auth1 $auth2]} {
        AuthRequired $channel
        return
      } 
      lappend ChannelStatus($channel) auth
    } else {
      AuthRequired $channel
      return
    }
  }

  regsub -all {[[]} $command {} command
  regsub -all {[]]} $command {} command
  regsub -all {;} $command {} command

  # extract the path portion
  set command [string trimleft [lindex $command 1] /]

  set urlparams ""

  if {[set urlencode [string first ? $command]]>-1} {
    set urlparams [string range $command [expr $urlencode + 1] end]
    set command [string range $command 0 [expr $urlencode - 1]]
    set urlparams [url_encode_to_keyed_list $urlparams]
  }

#  puts "command=($command) [string first proc/ [lindex $command 0]]"

  if {![string first proc/ $command]} {
    set command [lrange [split $command /] 1 end]
    if {[lsearch -exact $Namespaces [lindex $command 0]]==-1} {
      puts $channel "HTTP/1.0 403 no access\r\n\r\nAccess denied"
      flush $channel
      close $channel
      return
    }

    if {[string length $command]} {
      set proc "::[lindex $command 0]::[lindex $command 1]"
      set cmdstr [BuildEvalString $proc $urlparams]
      if {![string compare $cmdstr 0]} {
        set cmdstr "::[lindex $command 0]::[lindex $command 1] [lrange $command 2 end] $urlparams"
      }
      if {[catch {uplevel #0 eval $cmdstr} msg]} {
        puts $channel "HTTP/1.0 500 Error\r\nContent-type: text/html\r\n\r\n"
        LogLine "adsfadfadfadsf"
      }
      puts $channel "$msg"
      flush $channel
      close $channel
      return
    } else {
      puts $channel "HTTP/1.0 403 Access Denied\r\n\r\nAccess Denied"
      flush $channel
      close $channel
      return
    }
  } 
  
#  puts $command

  PathMapper $channel $command    
}

#
# this function is called to handle each incoming connection
#

proc Incoming {chan addr port} {
  variable ChannelBuffer 
  variable IPAccessList

  catch {unset ChannelBuffer($chan)}

  catch {unset ChannelStatus($chan)}

  if {[info exists IPAccessList] && [lsearch -exact $IPAccessList $addr]==-1} {
    puts $chan "HTTP/1.0 403 No Access\r\n\r\nAccess not allowed\r\n"
    flush $chan
    close $chan
    return
  } 

  fconfigure $chan -translation binary
  fconfigure $chan -blocking 0 -buffering line
  fileevent $chan readable [namespace code "RequestProcessor $chan"]
}

proc RegisterDefaultProc {proc} {
  variable DefaultBaseProc

  set DefaultBaseProc $proc
}

proc DefaultProc {} {
  return "Welcome to Chris' embedded TCL based web server!"
}

proc AddPathMap {path local} {
  variable PathTable

  set PathTable($path) $local
}

variable ContentTypeMap

set ContentTypeMap(.log) text/plain
set ContentTypeMap(.txt) text/plain
set ContentTypeMap(.htm) text/html
set ContentTypeMap(.html) text/html
set ContentTypeMap(.gif) image/gif
set ContentTypeMap(.jpg) image/jpeg

variable base64

# base64.tcl

# Emit base64 encoding for a string

set i 0

foreach char {A B C D E F G H I J K L M N O P Q R S T U V W X Y Z \

	      a b c d e f g h i j k l m n o p q r s t u v w x y z \

	      0 1 2 3 4 5 6 7 8 9 + /} {

    set base64($char) $i

    set base64_en($i) $char

    incr i

}

proc Base64Decode {string} {

    variable base64

    set output {}
    set group 0
    set j 18

    foreach char [split $string {}] {
	if [string compare $char "="] {
	    set bits $base64($char)
	    set group [expr {$group | ($bits << $j)}]
	}

	if {[incr j -6] < 0} {
		scan [format %06x $group]] %2x%2x%2x a b c
		append output [format %c%c%c $a $b $c]
		set group 0
		set j 18
	}
    }
    return $output
}

proc url_encode_to_keyed_list {buf} {
  set pairs [split $buf &]
   set pset ""

   foreach a $pairs {
     set var [string range $a 0 [expr [string first = $a] - 1]]
     set value [string range $a [expr [string first = $a] + 1] end]  
     set var [uncgi $var]
     set value [uncgi $value]
     lappend pset [list $var $value]
   }

   return $pset
}

proc uncgi {buf} {

# unescape chars escaped by httpd

regsub -all {\\(.)} $buf {\1} buf ;

# escape dangerous characters ([, $ and ")

regsub -all {([[$"])} $buf {\\\1} buf;

#translate + into space

regsub -all {\+} $buf { } buf

# everything is ready, now the real work :

regsub -all -nocase {%([a-fA-F0-9][a-fA-F0-9])} $buf {[format %c 0x\1]} buf

# And now lets replace all those escaped back, along with excuting of

# the formats :

eval return \"$buf\"

# now everything is in buf, but translated, nice trick no ?

}



# close of namespace eval



} 







