if {[lsearch -exact [namespace children ::] ::WebServer]==-1} {
  namespace inscope :: source "[file dirname [GetConfigString StartupScript]]/websrv.tcl"
}

proc AuthCallback {user password} {
  global users
 
  if {[info exists users($user)]} {
    if {[string compare $password $users($user)]} {
      return 0
    } else {
      return 1
    }
  } else {
    return 0
  }
}

#
#
# Handy function to wrap a line to 60 characters at commas
# 
# not too smart about individual elements that exceed 60 characters at 
# this point :)
#

proc WrapTo60 {text} {
  if {[string length $text]>60} {
    set x 60
    while {([string compare [string index $text $x] ,]) && ($x>-1)} {
      incr x -1
    }
    if {$x==-1} {
      return $text
    }
    set hold [string range $text 0 $x]
    append hold "\n"
    append hold [WrapTo60 [string range $text [expr $x + 1] [string length $text]]]
    return $hold
  }
  return $text
}

proc CleanFeedSpec {value} {

        regsub -all "\r\n" $value "," value
        regsub -all \{ $value "" value
        regsub -all \} $value "" value
        regsub -all " " $value "" value
        while {[regsub -all ",," $value "," value]} {}

    return $value  
}

catch {

namespace eval ::Maintenance {

proc UpdateRunning {filename namespace} {
  source "[file dirname [GetConfigString StartupScript]]/$filename"
}

proc UpdateScripts {} {
  namespace inscope :: source "[file dirname [GetConfigString StartupScript]]/websrv.tcl"
  namespace inscope :: source "[file dirname [GetConfigString StartupScript]]/tweb.tcl"
  return "[::WebServer::HTTP_HTML_Success]<H3>Scripts successfully reloaded</H3>"
}

# end namespace eval Maintenance
}

#end catch
} 


namespace eval ::Tortoise {

#
# proc for getting a site's name from its number
#

proc GetSiteByNumber {number} {
  set sl [::GetSiteList]
  foreach a $sl {
    if {![string compare $number [lindex $a 1]]} {
      return [lindex $a 0]
    }
  }
  return $number
}

#
# base procedure for creating a new site
#
proc CreateSite {site template} {
  if {[catch {::TConfig::CreateSite $site} msg]} {
    return "[WebServer::HTTP_HTML_Success] Creation failed: $msg"
  } else {
    if {![string compare $template none]} {
      return "[EditSite $site]"
    } else {
      return "[EditSite $site $template]"
    }
  }
}

#
# creates the HTML form that calls the CreateSite function
#
proc CreateSiteFrame {} {
  append html [::WebServer::HTTP_HTML_Success]
  append html {<form action="/proc/Tortoise/CreateSite"><TABLE>}
  append html {<TR><TD>Host Label:</TD><TD><INPUT TYPE="TEXT" NAME="site"></TD></TR>}

           set sl [::GetSiteList]
           set sl "{none none} $sl"
           append html "<TR><TD>Copy configuration from:</TD><TD><SELECT name=\"template\">"
           foreach lst $sl {
               set site [lindex $lst 0]
               append html "<option value=\"$site\">$site"
           }
           append html "</SELECT></TD></TR>"


  append html {</TABLE><INPUT type="submit" value="Create it!"></form>}
  return $html
}

#
# guts function to add an incoming feed entry
#
proc AddIncoming {site index} {
  if {[catch {::TConfig::AddIncoming $site $index} msg]} {
    return "[WebServer::HTTP_HTML_Success] Creation failed: $msg"
  } else {
    return "[EditIncoming $site]"
  }
}

#
# creates the HTML form that calls the AddIncoming function
#
proc AddIncomingFrame {} {
  append html [::WebServer::HTTP_HTML_Success]
  append html {<form action="/proc/Tortoise/AddIncoming"><TABLE>}
  append html {<TR><TD>Hostname:</TD><TD><INPUT TYPE="TEXT" NAME="site"></TD></TR><TR><TD>Index:</TD><TD><INPUT TYPE="TEXT" NAME="index"></TD></TR>}
  append html {</TABLE><INPUT type="submit" value="Create it!"></form>}
  return $html
}

#
# guts SetSite function
#
proc SetSite {site option data args} {
  if {[catch {::TConfig::SetSite $site $option $data} msg]} {
    return "[WebServer::HTTP_HTML_Success]Set failed: $msg"
  } else {
    if {[string length $args]>2} {
      return "[WebServer::HTTP_HTML_Success]<HEAD><META HTTP-EQUIV=\"REFRESH\" CONTENT=\"2; URL=$args\">Successful"
    }  else {
      return "[WebServer::HTTP_HTML_Success]Successful"
    }
  }
}

#
# guts SetIncoming function
#
proc SetIncoming {site option data} {
  if {[catch {::TConfig::SetIncoming $site $option $data} msg]} {
    return "[WebServer::HTTP_HTML_Success]Set failed: $msg"
  } else {
    return "[WebServer::HTTP_HTML_Success]Successful"
  }
}

#
# Creates a frame for an interface into the raw SetSite function
#
proc SetSiteFrame {site} {
  set str [::GetSiteList]
  
  append html {<FORM action="/proc/Tortoise/SetSite">}
  append html "SetSite "
  append html "<INPUT TYPE=\"hidden\" name=\"site\" value=\"$site\">$site"
  foreach a $str {
    append html "<option value=\"[lindex $a 0]\">[lindex $a 0]"
  }
  append html {</SELECT> }

  append html {<SELECT name="option" size="1">}
  foreach a {feedspec connections maxqfiles hostname port} {
    append html "<option value=\"[lindex $a 0]\">[lindex $a 0]"
  }
  append html {</SELECT> }
  append html {<INPUT Type="text" name="data">}
  append html {<INPUT Type="Submit" value="Do it!">}
  append html "</FORM>"

}

#
# processes the form from the EditSite function
#
proc UpdateSiteConfig {site args} {
  
  if {[expr [set count [llength $args]] & 1]} {
    return "Whoa -- Invalid arguements!"
  }
  
  foreach {option value} $args {
    switch -exact [string tolower $option] {
      feedspec {
        regsub -all "\r\n" $value "," value
        regsub -all \{ $value "" value
        regsub -all \} $value "" value
        regsub -all " " $value "" value
        while {[regsub -all ",," $value "," value]} {}
      }
    }
    if {[catch {::TConfig::SetSite $site $option $value} msg]} {
      return "[::WebServer::HTTP_HTML_Success]setting $option to $value failed: $msg"
    }
  }

  return [EditSite $site]
}


#
# processes the form from the EditIncoming function
#
proc UpdateIncomingConfig {site args} {
  
  if {[expr [set count [llength $args]] & 1]} {
    return "Whoa -- Invalid arguements!"
  }
  
  foreach {option value} $args {
    switch -exact [string tolower $option] {
      pathmatch {
        regsub -all "\r\n" $value "," value
        regsub -all \{ $value "" value
        regsub -all \} $value "" value
        regsub -all " " $value "" value
        while {[regsub -all ",," $value "," value]} {}
      }
      rights {
        set rights 0
        if {[lsearch -exact $value transfer]>-1} {
          set rights [expr $rights | 1]
        }
        if {[lsearch -exact $value read]>-1} {
          set rights [expr $rights | 2]
        }
        if {[lsearch -exact $value post]>-1} {
          set rights [expr $rights | 4]
        }
        set value $rights
      }
    }
    if {[catch {::TConfig::SetIncoming $site $option $value} msg]} {
      return "[::WebServer::HTTP_HTML_Success]setting $option to $value failed: $msg"
    }
  }

  return [EditIncoming $site]

}

#
# presents an HTML form to allow editing of Site parameters
#
proc EditSite {site {template {}}} {
  set html [WebServer::HTTP_HTML_Success]

  append html "<H3>Configuration for $site (outgoing)</H3><TABLE  Border=0 cellpadding=1>"

    if {[string length $template]} {
      set cfg [::GetSiteConfig $template]
      set cfg [keylget cfg $template]
    } else {
      set cfg [::GetSiteConfig $site]
      set cfg [keylget cfg $site]
    }
#    puts "$cfg = [keylkeys cfg]"
    foreach a parameters {
      set line "<B>$a</B><FORM action=\"/proc/Tortoise/UpdateSiteConfig/$site\"><TABLE>"
      set section [keylget cfg $a]
      foreach b [keylkeys section] {       
        switch -exact [string tolower $b] {
          port -
          maxqfiles {append line "<TR><TD>$b</TD><TD><INPUT TYPE=\"text\" name=\"$b\" value=\"[keylget section $b]\"></TD></TR>"}
          streaming -
          forcenocheck -
          cancelbypass -
          realtime -
	  requeuesallowed {
           if {[keylget section $b]} {
             append line "<TR><TD>$b</TD><TD><SELECT name=\"$b\"><option value=\"1\" SELECTED>On<option value=\"0\">Off</SELECT></TD></TR>"
           } else {
             append line "<TR><TD>$b</TD><TD><SELECT name=\"$b\"><option value=\"1\">On<option value=\"0\" SELECTED>Off</SELECT></TD></TR>"
           }
         }
         feedspec {
           append line "<TR><TD>$b</TD><TD><TEXTAREA name=\"$b\" cols=60 rows=3>[WrapTo60 [keylget section $b]]</TEXTAREA></TD></TR>"
         }
         dequeue {
           set il [::ListIncoming]
           append il "(none)"
           set curr [keylget section $b]
           append line "<TR><TD>$b</TD><TD><SELECT name=\"$b\">"
           foreach lst $il {
               if {![string compare $curr $lst]} {
                 append line "<option value=\"$lst\" SELECTED>$lst"
               } else {
                 append line "<option value=\"$lst\">$lst"
               }
           }
           append line "</SELECT></TD></TR>"
         }
         default {append line "<TR><TD>$b</TD><TD><INPUT TYPE=\"text\" name=\"$b\" value=\"[keylget section $b]\"></TD></TR>"}
        }
      }
      append html $line
      append html "</TABLE><P>"
      append html "<INPUT Type=\"submit\" value=\"Update Configuration\"></FORM>"
    }   

    set cfg [::GetSiteConfig $site]
    set cfg [keylget cfg $site]

  return $html
}  

#
# presents a form to allow editing of incoming feed parameters
#
proc EditIncoming {site} {
  set html [WebServer::HTTP_HTML_Success]

  append html "<H3>Configuration for $site (Incoming)</H3><TABLE  Border=0 cellpadding=1>"

    set cfg [::GetIncomingConfig $site]
#    puts $cfg
    set cfg [keylget cfg $site]
#    puts "$cfg = [keylkeys cfg]"
    foreach a parameters {
      set line "<B>$a</B><FORM action=\"/proc/Tortoise/UpdateIncomingConfig/$site\"><TABLE>"
      set section [keylget cfg $a]
      foreach b [keylkeys section] {       
        switch -exact [string tolower $b] {
          max_connections {append line "<TR><TD>$b</TD><TD><INPUT TYPE=\"text\" name=\"$b\" value=\"[keylget section $b]\"></TD></TR>"}
          streaming -
          allowssp -
          compress {
           if {[keylget section $b]} {
             append line "<TR><TD>$b</TD><TD><SELECT name=\"$b\"><option value=\"1\" SELECTED>On<option value=\"0\">Off</SELECT></TD></TR>"
           } else {
             append line "<TR><TD>$b</TD><TD><SELECT name=\"$b\"><option value=\"1\">On<option value=\"0\" SELECTED>Off</SELECT></TD></TR>"
           }
         }
         matchdequeue {
           set sl [::GetSiteList]
           set sl "{(None) 4294967295} $sl"
           set curr [keylget section $b]
           append line "<TR><TD>$b</TD><TD><SELECT name=\"$b\">"
           foreach lst $sl {
               set site [lindex $lst 0]
               set num [lindex $lst 1]
               if {![string compare $curr $num]} {
                 append line "<option value=\"$num\" SELECTED>$site"
               } else {
                 append line "<option value=\"$num\">$site"
               }
           }
           append line "</SELECT></TD></TR>"
         } 
         pathmatch {
           append line "<TR><TD>$b</TD><TD><TEXTAREA name=\"$b\" cols=60 rows=3>[keylget section $b]</TEXTAREA></TD></TR>"
         }
         rights {
           set rl {}
           set x [keylget section $b]
           if {[expr $x & 1]} {
             lappend rl transfer
           }
           if {[expr $x & 2]} {
             lappend rl read
           }
           if {[expr $x & 4]} {
             lappend rl post
           }
           append line "<TR><TD>$b</TD><TD><INPUT TYPE=\"text\" name=\"$b\" value=\"$rl\"></TD></TR>"
         }
         default {append line "<TR><TD>$b</TD><TD><INPUT TYPE=\"text\" name=\"$b\" value=\"[keylget section $b]\"></TD></TR>"}
        }
      }
      append html $line
      append html "</TABLE><P>"
      append html "<INPUT Type=\"submit\" value=\"Update Configuration\"></FORM>"
    }   

  return $html
}  


#
# produce an HTMLized store list
#

proc ShowStores {{sort number}} {
  set str [::TConfig::GetStoreList]
  
  set html [WebServer::HTTP_HTML_Success]

  append html "<H3>Currently configured stores</H3><TABLE  Border=1 cellpadding=1>"
  set header "number"

  foreach a $str {
    set cfg [::TConfig::GetStoreConfig $a]
    set cfg [keylget cfg $a]
    set cfg "[keylget cfg parameters]"
    set line "<TR><TD><A HREF=\"/proc/Tortoise/EditStore/$a\">$a</A></TD>"
    foreach b [keylkeys cfg] {	
      append line "<TD>[keylget cfg $b]</TD>"
    }
    append list([keylget cfg $sort]) "$line</TR>"
  }
 
  append header " [keylkeys cfg]"
 
  append html "<TR>"
  foreach a $header {
    append html "<TD><A HREF=\"/proc/Tortoise/ShowStores/$a\">$a</A></TD>"
  }
  append html "</TR>"
  
  set l [lsort -dictionary -decreasing [array names list]]
  
  
  foreach a $l {
    append html $list($a)
  }
  
  append html "</TABLE>"
  
  return $html
}

#
# processes the form from the EditStore function
#
proc UpdateStoreConfig {store args} {
  
  if {[expr [set count [llength $args]] & 1]} {
    return "Whoa -- Invalid arguements!"
  }
  
  foreach {option value} $args {
    switch -exact [string tolower $option] {
      matchstring {
        regsub -all "\r\n" $value "," value
        regsub -all \{ $value "" value
        regsub -all \} $value "" value
        regsub -all " " $value "" value
        while {[regsub -all ",," $value "," value]} {}
      }
    }
    if {[catch {::TConfig::SetStore $store $option $value} msg]} {
      return "setting $option to $value failed: $msg"
    }
  }

  return [EditStore $store]
}


#
# presents a form to allow editing of incoming feed parameters
#
proc EditStore {store} {
  set html [WebServer::HTTP_HTML_Success]

  append html "<H3>Configuration for store $store</H3><TABLE  Border=0 cellpadding=1>"

    set cfg [::TConfig::GetStoreConfig $store]
    set cfg [keylget cfg $store]
    foreach a parameters {
      set line "<B>$a</B><FORM action=\"/proc/Tortoise/UpdateStoreConfig/$store\"><TABLE>"
      set section [keylget cfg $a]
      foreach b [keylkeys section] {       
        switch -exact [string tolower $b] {
         matchstring {
           append line "<TR><TD>$b</TD><TD><TEXTAREA name=\"$b\" cols=60 rows=3>[WrapTo60 [keylget section $b]]</TEXTAREA></TD></TR>"
         }
         default {append line "<TR><TD>$b</TD><TD><INPUT TYPE=\"text\" name=\"$b\" value=\"[keylget section $b]\"></TD></TR>"}
        }
      }
      append html $line
      append html "</TABLE><P>"
      append html "<INPUT Type=\"submit\" value=\"Update Configuration\"></FORM>"
    }   

  return $html
}  


#
#
#

proc CreateStore {number directory matchstring mbytes expirationpriority} {
  catch {::TConfig::CreateStore $number $directory $matchstring $mbytes $expirationpriority} msg
  
  return "[WebServer::HTTP_HTML_Success]$msg"
}

#
# presents a form to allow the creation of a store
#
proc CreateStoreFrame {} {
  set html [WebServer::HTTP_HTML_Success]


  set line "<B>Create a store:</B><P><FORM action=\"/proc/Tortoise/CreateStore\"><TABLE>"
  foreach b {number directory matchstring mbytes expirationpriority} {
        switch -exact [string tolower $b] {
         matchstring {
           append line "<TR><TD>$b</TD><TD><TEXTAREA name=\"$b\" cols=60 rows=3></TEXTAREA></TD></TR>"
         }
         default {append line "<TR><TD>$b</TD><TD><INPUT TYPE=\"text\" name=\"$b\" value=\"\"></TD></TR>"}
        }
  }
  append html $line
  append html "</TABLE><P>"
  append html "<INPUT Type=\"submit\" value=\"Create Store\"></FORM>"

  return $html
}  

#
# produces an HTMLized GetBaseStats
#

proc GetBaseStats {} {
  set str [::GetBaseStats]
    
  set html [::WebServer::HTTP_HTML_Success]
  append html "<H3>Base statistics</H3><TABLE Border=2 cellpadding=1>"
  foreach a [keylkeys str] {
    append html "<TR><TD>$a</TD><TD>[keylget str $a]</TD></TR>"
  }
  append html "</TABLE>"

  set uptime [keylget str uptime]

  if {$uptime==0} {
    set uptime 1
  }

  append html "<H3>Base statistics per second</H3><TABLE Border=2 cellpadding=1>"
  foreach a [keylkeys str] {
    append html "<TR><TD>$a</TD><TD>[expr [keylget str $a] / $uptime]</TD></TR>"
  }
  append html "</TABLE>"
  
}

#
# produces an HTML table with a dump of all incoming feeds, stats, and parameters
#
proc GetIncomingStatus {{sort {connected}}} {
  set str [::ListIncoming]
  
  set html [WebServer::HTTP_HTML_Success]

  append html "<H3>Incoming Feed Status</H3><TABLE  Border=1 cellpadding=1>"
  set header "name"

  foreach a $str {
    set cfg [::GetIncomingConfig $a]
    set cfg [keylget cfg $a]
    set cfg "[keylget cfg statistics] [keylget cfg parameters]"
    set line "<TR><TD><A HREF=\"/proc/Tortoise/GetIncomingConfig/$a\">$a</A></TD>"
    foreach a [keylkeys cfg] {
      append line "<TD>[keylget cfg $a]</TD>"
    }
    append list([keylget cfg $sort]) "$line</TR>"
  }
 
  append header " [keylkeys cfg]"
 
  append html "<TR>"
  foreach a $header {
    append html "<TD><A HREF=\"/proc/Tortoise/GetIncomingStatus/$a\">$a</A></TD>"
  }
  append html "</TR>"
  
  set l [lsort -dictionary -decreasing [array names list]] 
  
  foreach a $l {
    append html $list($a)
  }
  
  append html "</TABLE>"
  
  return $html
}

#
# produces an HTML select box with a list of all incoming feeds for modification
#
proc GetIncomingList {{sort {connected}}} {
  set str [::ListIncoming]
  
  set html [WebServer::HTTP_HTML_Success]

  append html "<H3>Incoming Feeds</H3> <FORM action=\"/proc/Tortoise/EditIncoming\"><SELECT name=\"site\">"

  foreach a $str {
   append html "<OPTION>$a"
  }
 
  append html "</SELECT><INPUT Type=\"submit\" value=\"Edit Configuration\"></FORM>"
  
  return $html
}

#
# produces an HTML table with a dump of all outgoing feeds, stats, and parameters
#

proc GetOutgoingStatus {{sort {accepts}}} {
  set str [::GetSiteList]
  
  set html [WebServer::HTTP_HTML_Success]

  append html "<H3>Outgoing Feed Status</H3><TABLE  Border=1 cellpadding=1>"
  set header "name"

  foreach a $str {
    set cfg [::GetSiteConfig $a]
    set cfg [keylget cfg $a]
    set cfg "[keylget cfg statistics] [keylget cfg parameters]"
    set line "<TR><TD><A HREF=\"/proc/Tortoise/GetSiteConfig/$a\">$a</A></TD>"
    foreach a [keylkeys cfg] {
      append line "<TD>[keylget cfg $a]</TD>"
    }
    append list([keylget cfg $sort]) "$line</TR>"
  }
 
  append header " [keylkeys cfg]"
 
  append html "<TR>"
  foreach a $header {
    append html "<TD><A HREF=\"/proc/Tortoise/GetOutgoingStatus/$a\">$a</A></TD>"
  }
  append html "</TR>"
  
  set l [lsort -dictionary -decreasing [array names list]]
  
  
  foreach a $l {
    append html $list($a)
  }
  
  append html "</TABLE>"
  
  return $html
}

#
# produces an HTML table with a list of all outgoing feeds for configuration editing
#

proc GetOutgoingList {{sort {accepts}}} {
  set str [::GetSiteList]
  
  set html [WebServer::HTTP_HTML_Success]

  set html [WebServer::HTTP_HTML_Success]

  append html "<H3>Outgoing Feeds</H3> <FORM action=\"/proc/Tortoise/EditSite\"><SELECT name=\"site\">"

  foreach a $str {
   append html "<OPTION>[lindex $a 0]"
  }
 
  append html "</SELECT><INPUT Type=\"submit\" value=\"Edit Configuration\"></FORM>"
  
  return $html
}

#
# dumps the parameters and stats of a single incoming feed
#
proc GetIncomingConfig {sitename} {
  
  set html [WebServer::HTTP_HTML_Success]

  append html "<H3>Configuration for $sitename (incoming)</H3>"
  append html "<A HREF=/proc/Tortoise/EditIncoming/$sitename>\[Reconfigure\]</A> "
#  append html "<A HREF=/proc/Tortoise/RenameIncomingFrame/$sitename>\[Change Hostname\]</A>"
  append html "<A HREF=/proc/Tortoise/ResetIncomingCounters/$sitename>\[Reset Statistics\]</A>"
  append html "<A HREF=/proc/Tortoise/DeleteIncomingFrame/$sitename>\[Delete this entry\]</A>"
  append html "<A HREF=/proc/Tortoise/GetIncomingConfig/$sitename>\[Reload\]</A>"
  append html "<P><TABLE  Border=0 cellpadding=0>"

    set cfg [::GetIncomingConfig $sitename]
    set cfg [keylget cfg $sitename]
#    puts "$cfg = [keylkeys cfg]"
    foreach a [keylkeys cfg] {
      set line "<B>$a</B><TABLE>"
      set section [keylget cfg $a]
      foreach b [keylkeys section] {       
        append line "<TR><TD>$b</TD><TD>[keylget section $b]</TD></TR>"
      }
      append html $line
      append html "</TABLE><P>"
    }
  
  append html "<A HREF=/proc/Tortoise/EditIncoming/$sitename>\[Reconfigure\]</A> "
#  append html "<A HREF=/proc/Tortoise/RenameIncomingFrame/$sitename>\[Change Hostname\]</A>"
  append html "<A HREF=/proc/Tortoise/ResetIncomingCounters/$sitename>\[Reset Statistics\]</A>"
  append html "<A HREF=/proc/Tortoise/DeleteIncomingFrame/$sitename>\[Delete this entry\]</A>"
  append html "<A HREF=/proc/Tortoise/GetIncomingConfig/$sitename>\[Reload\]</A><P><TABLE  Border=2 cellpadding=1>"
  
  return $html
}

#
# dumps the parameters and stats for a site
#
proc GetSiteConfig {sitename} {
  
  set html [WebServer::HTTP_HTML_Success]

  append html "<H3>Configuration for $sitename (outgoing)</H3>"
  append html "<A HREF=/proc/Tortoise/EditSite/$sitename>\[Reconfigure\]</A> "
#  append html "<A HREF=/proc/Tortoise/RenameSiteFrame/$sitename>\[Change Hostname\]</A>"
  append html "<A HREF=/proc/Tortoise/ResetSiteCounters/$sitename>\[Reset Statistics\]</A>"
  append html "<A HREF=/proc/Tortoise/DeleteSiteFrame/$sitename>\[Delete this site\]</A>"
  append html "<A HREF=/proc/Tortoise/GetSiteConfig/$sitename>\[Reload\]</A>"
  append html "<P><TABLE  Border=0 cellpadding=0>"

    set cfg [::GetSiteConfig $sitename]
    set cfg [keylget cfg $sitename]
#    puts "$cfg = [keylkeys cfg]"
    foreach a [keylkeys cfg] {
      set line "<B>$a</B><TABLE>"
      set section [keylget cfg $a]
      foreach b [keylkeys section] {       
        append line "<TR><TD>$b</TD><TD>[keylget section $b]</TD></TR>"
      }
      append html $line
      append html "</TABLE><P>"
    }
  
  append html "<A HREF=/proc/Tortoise/EditSite/$sitename>\[Reconfigure\]</A> "
#  append html "<A HREF=/proc/Tortoise/RenameSiteFrame/$sitename>\[Change Hostname\]</A>"
  append html "<A HREF=/proc/Tortoise/ResetSiteCounters/$sitename>\[Reset Statistics\]</A>"
  append html "<A HREF=/proc/Tortoise/DeleteSiteFrame/$sitename>\[Delete this site\]</A>"
  append html "<A HREF=/proc/Tortoise/GetSiteConfig/$sitename>\[Reload\]</A>"
  return $html
}

#
# produces a frame to drive RenameSite
#
proc RenameSiteFrame {site} {
  set html [::WebServer::HTTP_HTML_Success]
  
  append html "<form action=\"/proc/Tortoise/RenameSite\">"
  append html "Rename <input type=\"hidden\" name=\"oldsite\" value=\"$site\">$site to <input type=\"text\" value=\"$site\" name=\"site\">"
  append html "<input type=\"submit\" value=\"Execute rename\"></form><P>"
  append html "This new hostname will be resolved on the next feeder reconnect."

  return $html
}

#
# reset outgoing statistics for a site
#
proc ResetSiteCounters {site} {
  ::ResetSiteCounters $site
  return [GetSiteConfig $site]
}

#
# reset outgoing statistics for an incoming feed
#
proc ResetIncomingCounters {site} {
  ::ResetIncomingCounters $site
  return [GetIncomingConfig $site]
}


#
# actually handles renaming a site based on the RenameSiteFrame form
#
proc RenameSite {oldsite site} {
  if {[catch {::TConfig::SetSite $oldsite hostname $site} msg]} {
    return "[::WebServer::HTTP_HTML_Success]Renaming failed: $msg"
  } else {
    return "[GetSiteConfig $site]"
  }
}

#
# produces a frame to drive DeleteIncoming
#

proc DeleteIncomingFrame {site} {
  set html [::WebServer::HTTP_HTML_Success]
  
  append html "<form action=\"/proc/Tortoise/DeleteIncoming\">"
  append html "Delete <input type=\"hidden\" name=\"site\" value=\"$site\">$site?"
  append html "<input type=\"submit\" value=\"Confirm\"></form><P>"
  append html "This entry will be deleted if you click \"Confirm\"--use the \"back\" button of your browser to return to the previous screen"

  return $html
}

#
# actually handles deleteing an incoming entry based on the DeleteIncomingFrame form
#
proc DeleteIncoming {site} {
  if {[catch {::TConfig::DelIncoming $site} msg]} {
    return "[::WebServer::HTTP_HTML_Success]Deletion failed: $msg"
  } else {
    return "[::WebServer::HTTP_HTML_Success]<H3>$site was deleted</H3>"
  }
}

#
# produces a frame to drive DeleteSite
#

proc DeleteSiteFrame {site} {
  set html [::WebServer::HTTP_HTML_Success]
  
  append html "<form action=\"/proc/Tortoise/DeleteSite\">"
  append html "Delete <input type=\"hidden\" name=\"site\" value=\"$site\">$site?"
  append html "<input type=\"submit\" value=\"Confirm\"></form><P>"
  append html "This entry will be deleted if you click \"Confirm\"--use the \"back\" button of your browser to return to the previous screen"

  return $html
}

#
# actually handles deleteing a site based on the DeleteSiteFrame form
#
proc DeleteSite {site} {
  if {[catch {::TConfig::DeleteSite $site} msg]} {
    return "[::WebServer::HTTP_HTML_Success]Deletion failed: $msg"
  } else {
    return "[::WebServer::HTTP_HTML_Success]<H3>$site was deleted</H3>"
  }
}


#
# produces a frame to drive RenameIncoming
#

proc RenameIncomingFrame {site} {
  set html [::WebServer::HTTP_HTML_Success]
  
  append html "<form action=\"/proc/Tortoise/RenameIncoming\">"
  append html "Rename <input type=\"hidden\" name=\"oldsite\" value=\"$site\">$site to <input type=\"text\" value=\"$site\" name=\"site\">"
  append html "<input type=\"submit\" value=\"Execute rename\"></form><P>"
  append html "This new hostname will be resolved on the next incoming update (within one hour), if incoming updates are enabled (UpdateIncomingEntries=1 in config.txt)."

  return $html
}

#
# actually handles renaming a incoming entry based on the RenameIncomingFrame form
#
proc RenameIncoming {oldsite site} {
  if {[catch {::TConfig::SetIncoming $oldsite hostname $site} msg]} {
    return "[::WebServer::HTTP_HTML_Success]Renaming failed: $msg"
  } else {
    return "[GetIncomingConfig $site]"
  }
}

proc GlobalConfigFrame {} {
  set html "[::WebServer::HTTP_HTML_Success]"

  #
  # to get the current max connections
  #

  append html "<form action=\"/proc/Tortoise/GlobalConfig\"><table>"

  append html "<TR><TD>MaxConnections</TD><TD><INPUT TYPE=\"text\" name=\"MaxConnections\" value=\"[::TConfig::GetGlobal MaxConnections]\"></TD></TR>"
  
  append html "<TR><TD>IncomingFilter</TD><TD><TEXTAREA name=\"IncomingFilter\" cols=60 rows=3>[WrapTo60 [::TConfig::GetGlobal IncomingFilter]]</TEXTAREA></TD></TR>"
  append html "</table>"
  append html {<input type="submit" value="Update configuration"></form>}

  return $html
}

proc GlobalConfig {args} {

  foreach {n v} $args {
    switch [string tolower $n] {
      internalfilter { set v [CleanFeedSpec $v] }
    } 
    if {[string compare [::TConfig::GetGlobal $n] $v]} {
      ::TConfig::SetGlobal $n $v
    }
  }

  return "[::WebServer::HTTP_HTML_Success]<H3>Successful</H3>"

}


proc ForceArchive {} {
  ::Tortoise_Config::ForceArchive
  return "[::WebServer::HTTP_HTML_Success]<H3>Configuration saved</H3>"
}

proc Commands {} {
  return "[::WebServer::HTTP_HTML_Success][info commands]"
}

#namespace eval Tortoise

}

catch {
WebServer::Setup 2001
WebServer::RegisterNamespace Tortoise Maintenance
} msgstartup
#puts "web server: $msgstartup"
WebServer::SetAuthRequired 1 AuthCallback
catch {
WebServer::AddPathMap logs [GetConfigString LogDirectory]
WebServer::AddPathMap "" [file dirname [GetConfigString StartupScript]]/web
WebServer::AddPathMap docs [file dirname [GetConfigString StartupScript]]/docs
WebServer::RegisterParameterDecodeInfo ::Tortoise::SetSite site option data redirect
WebServer::RegisterParameterDecodeInfo ::Tortoise::CreateSite site template
WebServer::RegisterParameterDecodeInfo ::Tortoise::AddIncoming site index
WebServer::RegisterParameterDecodeInfo ::Tortoise::EditIncoming site
WebServer::RegisterParameterDecodeInfo ::Tortoise::DeleteIncoming site
WebServer::RegisterParameterDecodeInfo ::Tortoise::DeleteSite site
WebServer::RegisterParameterDecodeInfo ::Tortoise::EditSite site
WebServer::RegisterParameterDecodeInfo ::Tortoise::RenameSite oldsite site
WebServer::RegisterParameterDecodeInfo ::Tortoise::RenameIncoming oldsite site
WebServer::RegisterParameterDecodeInfo ::Tortoise::CreateStore number directory matchstring mbytes expirationpriority
} msg2

#puts "web server: $msg2"
