namespace eval ArtPost {
  
proc GetPostFiles {} {
  variable postdirectory

  set list [glob -nocomplain $postdirectory/*.post]

#  puts $list
  return $list
}

proc FilterPosts {posts} {
  variable max_posts_per_conn


  foreach a $posts {
    if {![catch {set f [open $a r]}]} {
	  set nntp_posting_host [gets $f]
	  set connection_post_count [gets $f]
	  close $f
	  if {$connection_post_count>$max_posts_per_conn} {
	    set filter($nntp_posting_host) 1
		LogLine "too many per conn"
	  }
	  if {[info exists nph($nntp_posting_host)]} {
	    incr nph($nntp_posting_host)
	  } else {
	    set nph($nntp_posting_host) 1
	  }
	  if {$nph($nntp_posting_host)>20} {
	    set filter($nntp_posting_host) 1
		LogLine "too many for host"
	  } 
	  lappend nphl($nntp_posting_host) $a 
	}
  }

  set ok ""

  foreach a [array names nphl] {
    if {![info exists filter($a)]} {
	  append ok " $nphl($a)"
	} else {
	  foreach b $nphl($a) {
	    file delete $b
	  }
	}
  }
 
  return $ok
}

proc ProcessPosts {postlist} {
  variable outqueue
  variable mid_domain 

  set l a
  foreach pfile $postlist {
    set invalid 0
    set f [open $pfile r]
    set nph [gets $f]
	set ctr [gets $f]
	catch {unset headers}
	set hdr ""
	while {1} {
	  set l [gets $f]

      #
	  # blank line indicates end of header
	  #

	  if {![string length $l]} {
	    break
	  }

      #
      # is it a continuation line?
      #

	  if {[string index $l 0]==" "} {
	    if {[string length $hdr]} {
		  append $hdr "\n$l"
		  continue
		} else {
		  set invalid 1
		  break;
		}
	  }

	  #
	  # find the colon space
	  #
	  
	  set x [string first ": " $l]
	  
	  #
	  # did we find it?
      #

      if {$x} {
	    #
		# yes: split off the header and value and
		# stick them in the headers array
		#
	    set hdr [string range $l 0 $x]
#        puts "$hdr"

  	    if {[regexp ": .*" $l val]} {
		  set val [string range $val 2 end]
  		  set headers($hdr) $val
#		  puts $val
		} 
	  }
	}

	  if {$invalid} {
	    close $f
		continue
	  }

      #
	  # check for required headers
      #

	  foreach a {Subject: From: Newsgroups:} {
	    if {![info exists headers($a)]} {
          set invalid 1
		}
	  }

 	  if {$invalid} {
	    close $f
		continue
	  }

      # 
	  # check for headers we can generate and
	  # make them up if not present
	  #

     
      foreach a {Date: Message-ID:} {
	    if {![info exists headers($a)]} {
#		  puts "did not find $a"
		  switch $a {
		    Date: { set headers($a) [clock format [clock seconds] -format "%a, %d %b %Y %H:%M:%S GMT" -gmt 1]}
			Message-ID: {set headers($a) "<[clock seconds][clock clicks]-$ctr@$mid_domain>"}
		  }
		}
      }
  
     set headers(NNTP-Posting-Host:) $nph
     set headers(Path:) "[set mid_domain].POSTED!$nph"

      #
      # open a file to put the processed post in
      #
      set oq [open $outqueue/[clock seconds].[clock clicks] w]

	  #
	  # write the outgoing message-id first
	  # by itself for the feeder stuff to read in 
	  # (avoids reparsing)
	  #

	  puts $oq "takethis $headers(Message-ID:)"

      #
	  # we write these headers first for optimal 
	  # transport performance
	  #
	  foreach a {Path: Date: Message-ID: Newsgroups:} {
	     puts $oq "$a $headers($a)"
		 unset headers($a)
	  }
	  
      #
	  # now write the rest of them
      #

	  foreach a [array names headers] {
	    puts $oq "$a $headers($a)"
	  }

      #
      # reproduce the blank line to end the header
	  # 
      puts $oq ""

      #
	  # copy the rest of the post in binary mode
	  #

	  fconfigure $f -translation binary
	  fconfigure $oq -translation binary

      #
	  # copy the body of the post
	  #
      fcopy $f $oq

      #
	  # put a \r\n.\r\n at the end of the file to 
	  # terminate the post and make it a complete 
	  # takethis command
      #

	  puts -nonewline $oq "\r\n.\r\n"

	  #
	  # close everything up
	  #
	  close $f
	  close $oq

	  #
	  # delete the incoming file
	  #
	  file delete $pfile
	}
}

proc UploadDone {chan args} {
  set l [gets $chan]
  if {[fblocked $chan]} {
    return
  }
#  puts $l
  close $chan
#  if {[lindex $l 0]==239} {
    #delete it
    if {[catch {file delete [lindex $args 0]} msg]} {
      LogLine "delete failed: $msg"
    }
#  }
     
}

proc CopyDone {chan1 chan2 args} {
  close $chan1
  fileevent $chan2 readable [namespace code "UploadDone $chan2 $args"]
}

proc UpstreamReady {chan filename} {

  if {[eof $chan]} {
    close $chan
	return
  }

  set banner [gets $chan]

  if {[fblocked $chan]} {
    LogLine "blocked"
	return
  }

  if {[lindex $banner 0]!="200"} {
    close $chan
	return
  }    

  fileevent $chan readable {}

  if {![catch {set f [open $filename r]}]} {
    fcopy $f $chan -command [namespace code "CopyDone $f $chan $filename"]
  } else {
    close $chan
  }
}
  

proc SendPost {} {
  variable outqueue
  variable outgoing_peers
  variable outgoing_post_files  

  set flist [lindex $outgoing_post_files 0]
  set outgoing_post_files [lrange $outgoing_post_files 1 end]

  if {![file exists $flist]} {
    return
  }

  foreach a $outgoing_peers {
    if {![catch {set s [socket -async $a 119]} msg]} {
	  set conns($a) $s
	  fconfigure $s -blocking 0
      fileevent $s readable [namespace code "UpstreamReady $s $flist"]
    } else {
      LogLine $msg
    }
  }

}   

proc SendPosts {} {
  variable outqueue
  variable outgoing_post_files

  if {[llength $outgoing_post_files]==0} {
    set outgoing_post_files [glob -nocomplain $outqueue/*]
  }
  
#  puts "trying to send [lindex $outgoing_post_files 0]"

  if {[llength $outgoing_post_files]} {
    if {[catch {SendPost} msg]} {
      LogLine $msg
    }
  }

  after 3000 [namespace code SendPosts]
}

proc Periodic {} {
  variable goodposts

  set list [FilterPosts [GetPostFiles]]
  ProcessPosts $list

  after 60000 [namespace code Periodic]

}

proc Init {} {
  variable outqueue
  variable postdirectory
  variable max_posts_per_conn
  variable mid_domain
  variable outgoing_peers
  variable outgoing_post_files {}

  set outgoing_peers {127.0.0.1}

  set mid_domain [GetConfigString HostPathIdentifier]

  set max_posts_per_conn 20

  set outqueue [GetConfigString OutgoingPostQueueDirectory]
  set postdirectory [GetConfigString PostQueueDirectory]


  LogLine $outqueue
  LogLine $postdirectory

  after 30000 [namespace code Periodic]
  after 3000 [namespace code SendPosts]
}

}
  
::ArtPost::Init
