
namespace eval ::TGroups { 

#
# read our group.num file
# 
# format is:
# [group name] [slot number] [number of slots]
#
catch {
if {[file exists [GetConfigString GroupFile]]} {
  set f [open [GetConfigString GroupFile]]
  while {![eof $f]} {
     set l [gets $f]
     # skip blanks
     # skip lines that start with #
     if {![string length $l]} { continue }  
     if {![string compare [string index $l 0] #]} { continue }

     InsertGroup [lindex $l 0] [lindex $l 1]
  }

  close $f
}

#
# format for groups.imp is
# [group name] [start slot] [number of slots] [posting/moderated flag y/n/m] [start number]
#
if {[file exists [file dirname [GetConfigString GroupFile]]/groups.imp]} {
  set f [open [file dirname [GetConfigString GroupFile]]/groups.imp]
  set g [open [GetConfigString GroupFile] a]
  
  while {![eof $f]} {
    set l [gets $f]
    # skip blanks
    # skip lines that start with #
    if {![string length $l]} { continue }  
    if {![string compare [string index $l 0] {#}]} { continue } 

    if {[llength $l]==5} {
        CreateGroup [lindex $l 0] [lindex $l 1] [lindex $l 2] [lindex $l 3] [lindex $l 4]
        puts $g "[lindex $l 0] [lindex $l 1] [lindex $l 2]"
    } else {
        LogLine "strange line ($l) in groups.imp ignored"
    }
  }
  close $f
  close $g
  file delete [file dirname [GetConfigString GroupFile]]/groups.imp
}


} msg

LogLine "group: $msg"


}

