
if {[catch {load tclreg80.dll registry}]} {
  LogLine "could not load registry extension"
}

foreach a {Feeds Incoming Users Stores Globals} {
  catch {
    registry set HKEY_LOCAL_MACHINE\\System\\CurrentControlSet\\Services\\Tortoise\\Parameters\\$a
  } msg
}

namespace eval TConfig  {

proc GetGlobal {name} {
  
  set val {}

  if {[catch {set val [registry get HKEY_LOCAL_MACHINE\\System\\CurrentControlSet\\Services\\Tortoise\\Parameters\\Globals $name]}]} {
    set val [GetConfigString $name]
  }

  return $val
}

proc SetGlobal {name value} {
  registry set HKEY_LOCAL_MACHINE\\System\\CurrentControlSet\\Services\\Tortoise\\Parameters\\Globals $name $value
  ::SetGlobal $name $value
}

proc LoadGlobals {} {
  set plist [registry values HKEY_LOCAL_MACHINE\\System\\CurrentControlSet\\Services\\Tortoise\\Parameters\\Globals]

  foreach p $plist {
    ::SetGlobal $p [registry get HKEY_LOCAL_MACHINE\\System\\CurrentControlSet\\Services\\Tortoise\\Parameters\\Globals $p]
  }
}

LoadGlobals

proc CreateSite {name} {
  registry set HKEY_LOCAL_MACHINE\\System\\CurrentControlSet\\Services\\Tortoise\\Parameters\\Feeds\\$name
  ::CreateSite $name
}

proc SetSite {name parameter value} {
  registry set HKEY_LOCAL_MACHINE\\System\\CurrentControlSet\\Services\\Tortoise\\Parameters\\Feeds\\$name $parameter $value
  ::SetSite $name $parameter $value
}

proc DeleteSite {name} {
  registry delete HKEY_LOCAL_MACHINE\\System\\CurrentControlSet\\Services\\Tortoise\\Parameters\\Feeds\\$name
  ::DeleteSite $name
}

proc AddIncoming {name index} {
  registry set HKEY_LOCAL_MACHINE\\System\\CurrentControlSet\\Services\\Tortoise\\Parameters\\Incoming\\$name
  registry set HKEY_LOCAL_MACHINE\\System\\CurrentControlSet\\Services\\Tortoise\\Parameters\\Incoming\\$name index $index
  ::AddIncoming $name $index
}

proc SetIncoming {name parameter value} {
  registry set HKEY_LOCAL_MACHINE\\System\\CurrentControlSet\\Services\\Tortoise\\Parameters\\Incoming\\$name $parameter $value
  ::SetIncoming $name $parameter $value
}

proc DelIncoming {name} {
  registry delete HKEY_LOCAL_MACHINE\\System\\CurrentControlSet\\Services\\Tortoise\\Parameters\\Incoming\\$name
  ::DelIncoming $name
}

proc InstantiateSites {} {
  set list [registry keys HKEY_LOCAL_MACHINE\\System\\CurrentControlSet\\Services\\Tortoise\\Parameters\\Feeds]

  foreach l $list {
    set plist [registry values HKEY_LOCAL_MACHINE\\System\\CurrentControlSet\\Services\\Tortoise\\Parameters\\Feeds\\$l]
    ::CreateSite $l
    foreach p $plist {
      if {[catch {
        ::SetSite $l $p [registry get HKEY_LOCAL_MACHINE\\System\\CurrentControlSet\\Services\\Tortoise\\Parameters\\Feeds\\$l $p]
         }]} {
         LogLine "Error setting $p for $l (outgoing)"
      }
    }
  }
}

proc InstantiateIncoming {} {
  set list [registry keys HKEY_LOCAL_MACHINE\\System\\CurrentControlSet\\Services\\Tortoise\\Parameters\\Incoming]

  foreach l $list {
    set plist [registry values HKEY_LOCAL_MACHINE\\System\\CurrentControlSet\\Services\\Tortoise\\Parameters\\Incoming\\$l]
    set index [registry get HKEY_LOCAL_MACHINE\\System\\CurrentControlSet\\Services\\Tortoise\\Parameters\\Incoming\\$l index]
    ::AddIncoming $l $index
    foreach p $plist {
      if {![string compare $p index]} {
        continue
      }
      if {[catch {
        ::SetIncoming $l $p [registry get HKEY_LOCAL_MACHINE\\System\\CurrentControlSet\\Services\\Tortoise\\Parameters\\Incoming\\$l $p]
         }]} {
         LogLine "Error setting $p for $l (incoming)"
      }
    }
  }
}

InstantiateIncoming
InstantiateSites

proc CreateUser {user pwd} {
  registry set HKEY_LOCAL_MACHINE\\System\\CurrentControlSet\\Services\\Tortoise\\Parameters\\Users $user $pwd
}

proc DelUser {user} {
  registry delete HKEY_LOCAL_MACHINE\\System\\CurrentControlSet\\Services\\Tortoise\\Parameters\\Users $user
}

proc LoadUsers {} {
    set ulist [registry values HKEY_LOCAL_MACHINE\\System\\CurrentControlSet\\Services\\Tortoise\\Parameters\\Users]
    foreach u $ulist {
      set ::users($u) [registry get HKEY_LOCAL_MACHINE\\System\\CurrentControlSet\\Services\\Tortoise\\Parameters\\Users $u]
    }
}

LoadUsers

proc GetStoreConfig {store} {
      set plist [registry values HKEY_LOCAL_MACHINE\\System\\CurrentControlSet\\Services\\Tortoise\\Parameters\\Stores\\$store]
      set kplist ""
      foreach p $plist {         
        lappend kplist [list $p [registry get HKEY_LOCAL_MACHINE\\System\\CurrentControlSet\\Services\\Tortoise\\Parameters\\Stores\\$store $p]]
      }
      set c "{$store {{parameters {$kplist}}}}"
      return $c
}

proc GetStoreList {} {
    set storelist {}
    set slist [registry keys HKEY_LOCAL_MACHINE\\System\\CurrentControlSet\\Services\\Tortoise\\Parameters\\Stores]

  return $slist
}


proc CreateStore {number directory matchstring mbytes expirationpriority} {

   if {![file isdirectory $directory]} {
     return "Creation of store $number failed: $directory is not a directory"
   }

   if {![catch {registry values HKEY_LOCAL_MACHINE\\System\\CurrentControlSet\\Services\\Tortoise\\Parameters\\Stores\\$number}]} {
     return "Creation of store $number failed: $number already exists"
   }

   if {[catch {
     registry set HKEY_LOCAL_MACHINE\\System\\CurrentControlSet\\Services\\Tortoise\\Parameters\\Stores\\$number
     foreach val {directory matchstring mbytes expirationpriority} {
       registry set HKEY_LOCAL_MACHINE\\System\\CurrentControlSet\\Services\\Tortoise\\Parameters\\Stores\\$number $val [set $val]
     }
     ::CreateArtStore $number $directory $matchstring $mbytes $expirationpriority
   } msg]} {
     catch {DeleteStore $number}
     return "Creation of store $number failed: $msg"
   }
   
   return "Creation of store $number completed successfully."
}

proc SetStore {number param value} {
     registry set HKEY_LOCAL_MACHINE\\System\\CurrentControlSet\\Services\\Tortoise\\Parameters\\Stores\\$number $param $value
}

proc DeleteStore {number} {
   registry delete HKEY_LOCAL_MACHINE\\System\\CurrentControlSet\\Services\\Tortoise\\Parameters\\Stores\\$number
}

proc MakeStores {} {
    set slist [registry keys HKEY_LOCAL_MACHINE\\System\\CurrentControlSet\\Services\\Tortoise\\Parameters\\Stores]
    foreach s $slist {
      set plist [registry values HKEY_LOCAL_MACHINE\\System\\CurrentControlSet\\Services\\Tortoise\\Parameters\\Stores\\$s]
      foreach val {directory matchstring mbytes expirationpriority} {
        set $val [registry get HKEY_LOCAL_MACHINE\\System\\CurrentControlSet\\Services\\Tortoise\\Parameters\\Stores\\$s $val]
      }
      ::CreateArtStore $s $directory $matchstring $mbytes $expirationpriority
      
    }
}

MakeStores

}

 