
load tclreg80.dll registry

catch {
  registry set HKEY_LOCAL_MACHINE\\System\\CurrentControlSet\\Services\\Tortoise\\Parameters\\Feeds
  registry set HKEY_LOCAL_MACHINE\\System\\CurrentControlSet\\Services\\Tortoise\\Parameters\\Incoming
  registry set HKEY_LOCAL_MACHINE\\System\\CurrentControlSet\\Services\\Tortoise\\Parameters\\Users
} msg

fconfigure stdout -buffering none

puts stdout "You need to set an administrative username and password.  These values"
puts stdout "are stored in clear text in the registry, so do not use anything too secret!\n" 
puts -nonewline stdout "Admin username:"
set uname [gets stdin]
puts -nonewline "Admin password:"
set pwd [gets stdin]

registry set HKEY_LOCAL_MACHINE\\System\\CurrentControlSet\\Services\\Tortoise\\Parameters\\Users $uname $pwd

puts stdout ""
puts stdout "Please enter the path to config.txt."
puts stdout "Please use / instead of \\ for path names."
puts stdout "Examples: c:/news/config.txt or f:/tortoise/config.txt"
puts stdout ""
puts -nonewline stdout "Config.txt path (default [pwd]/config.txt):"
set configpath [gets stdin]

if {![string length $configpath]} {
  set configpath [pwd]/config.txt
}

registry set HKEY_LOCAL_MACHINE\\System\\CurrentControlSet\\Services\\Tortoise\\Parameters ConfigFile $configpath

puts stdout ""
puts stdout "ConfigPath set to $configpath in the registry."
puts stdout ""

puts ""
puts "You can now complete the configuration by editing the config.txt file.\nOnce you are satisfied with config.txt, use control panel/services or:"
puts "\nnet start tortoise\n"
puts "at the command prompt to start tortoise.\n"
puts "Once the service is started, you can complete incoming, outgoing, and "
puts "article stores by connecting your browser to http://[info hostname]:2001"

