proc DetermineSlots {line} {
  set high_number [string trimleft [lindex $line 1] 0]
  set low_number [string trimleft [lindex $line 2] 0]
  set group_name [lindex $line 0]

  set posts_avail [expr $high_number - $low_number]
  set slots [expr 1 + ($posts_avail / 500)]

# This switch command controls the number of slots per group set listed below.
# You can change the defaults below or add a new group set definiton.
# Ex: 
# 
# fido.* {set slots 1}
#
#  switch -glob -- [lindex $line 0] {
#     news.* {set slots 3}
#     rec.* {set slots 3}
#     comp.* {set slots 3}
#     microsoft.* {set slots 3}
#     misc.jobs.offered {set slots 2}
#     alt.bin* {set slots 10}
#     alt.* {set slots 3}
#     misc.* {set slots 3}
#     default {set slots 2}
#   }

  return $slots
}

proc pull_from_host {} {

  fconfigure stdout -buffering none

  puts stdout ""
  puts -nonewline stdout "Host to pull active file from (hostname or IP OK): "
  set host [gets stdin]
  if {![string compare $host ""]} {
    exit
  }

  set sock [socket $host 119]

  fconfigure $sock -buffersize 1000000

  set g [gets $sock]
  puts "Server responded:"
  puts $g

  if {[string compare [string index $g 0] 2]} {
   error "You do not appear to have permission--please try another host, or contact\nthe administrator of that server to obtain access."
  }

  puts $sock "list"
  flush $sock
  gets $sock
  puts $sock "quit"
  flush $sock

  pull_from_channel $sock
}

proc use_existing_active {} {

  fconfigure stdout -buffering none

  puts stdout "\n"
  puts -nonewline stdout "Enter full path to file:"
  set pfile [gets stdin]
  if {![string compare $pfile ""]} {
    exit
  }

  set efile [open $pfile r]

  pull_from_channel $efile

  close $efile
}

proc pull_from_channel {chan} {

  set group_num [open groups.imp w]

  set totals 0
  set u 0
  set group_name ""
  set high_number ""
  set slots 0
  set group_tot 0


  while {[eof $chan] == 0} {
    set g [gets $chan]
    if {((![string compare $g .]) || ([string length $g]<8) || ([llength $g]!=4))} {
      continue
    }

    set high_number [string trimleft [lindex $g 1] 0]
    set low_number [string trimleft [lindex $g 2] 0]
    set group_name [lindex $g 0]

    set slots [DetermineSlots $g]

    puts $group_num "$group_name $totals $slots y $high_number "
    incr totals $slots
    incr group_tot
  }

  puts  ""
  puts "Total number of groups: $group_tot"
  puts ""
  puts ""
  puts "Slots needed: $totals"
  puts "You will need to put this number (plus 1000-5000 slots for expansion) into"
  puts "config.txt under the config entry.  The line should look like this:"
  puts ""
  puts "GroupArraySize=$totals"
  puts ""
  puts ""
 
  close $group_num
}


proc menu {} {

fconfigure stdout -buffering none
puts stdout ""
puts stdout "This step allows you to create a groups.imp from an existing server, or from"
puts stdout "an INN-format active file.  The groups.imp file will be imported by Tortoise"
puts stdout "when it starts."
puts stdout ""
puts stdout "To create a groups.imp file you can pull an active from another host,"
puts stdout "or use an existing active on your hard disk.  This will create a\ngroups.imp file.\n" 
puts stdout "1. Pull from another host"
puts stdout "2. Use an existing INN active file on disk"
puts stdout "3. I've got a groups.imp"
puts stdout ""
puts -nonewline stdout "Choice: "
set choice [gets stdin]

if {[string compare $choice "1"] == 0} {
 pull_from_host
}

if {[string compare $choice "2"] == 0} {
 use_existing_active
} else {
  exit
}

}

while {[catch menu]} {}